# 📚 Wegent English Documentation

Welcome to the Wegent English Documentation!

Wegent is an open-source AI native operating system that enables you to define, organize, and run intelligent agents at scale.

---

## 📖 Table of Contents

### 🚀 Getting Started

Your first steps with Wegent:

- [Quick Start](./getting-started/quick-start.md) - Get up and running in 5 minutes
- [Installation Guide](./getting-started/installation.md) - Complete installation and configuration

### 🧠 Core Concepts

Deep dive into Wegent's design:

- [Architecture Overview](./concepts/architecture.md) - Wegent's overall architecture and tech stack
- [Core Concepts](./concepts/core-concepts.md) - Detailed explanation of Ghost, Bot, Team, Workspace, and more
- [Collaboration Models](./concepts/collaboration-models.md) - Four collaboration patterns: Pipeline, Route, Coordinate, and Collaborate

### 📖 Guides

#### 👤 User Guides

Guides for Wegent platform users:

- [Creating Ghosts](./guides/user/creating-ghosts.md) - Define the "soul" of your agents
- [Creating Bots](./guides/user/creating-bots.md) - Assemble complete agent instances
- [Managing Skills](./guides/user/managing-skills.md) - Upload and use Claude Code Skills
- [Creating Teams](./guides/user/creating-teams.md) - Build collaborative agent teams
- [Managing Tasks](./guides/user/managing-tasks.md) - Create and manage work tasks
- [Spec Clarification Mode](./guides/user/spec-clarification-guide.md) - Interactive requirement specification clarification guide

#### 💻 Developer Guides

Technical documentation for Wegent developers:

- [Development Setup](./guides/developer/setup.md) - Local development environment configuration
- [Testing](./guides/developer/testing.md) - Unit and integration testing
- [Database Migrations](./guides/developer/database-migrations.md) - Alembic database migration management

### 📋 Reference

Detailed technical references:

- [YAML Specification](./reference/yaml-specification.md) - Complete YAML configuration format

### 📝 Configuration Examples

- [Team Configuration Example](../examples/team-example.yaml) - Complete Team YAML configuration example

### 🤝 Contributing

- [Contribution Guide](../../../CONTRIBUTING.md) - How to participate in Wegent project contributions

### 🔧 Help & Support

- [FAQ](./faq.md) - Frequently asked questions
- [Troubleshooting](./troubleshooting.md) - Problem diagnosis and solutions

---

## 🌟 Key Features at a Glance

### 🎨 Configuration-Driven Agent Teams
Define and run personalized agent teams through YAML configuration with web UI - no secondary development required.

### ⚙️ Multi-Engine Architecture
Built on Agno and Claude Code agent engines, supporting both dialogue and coding modes.

### 🔒 Isolated Sandbox Environments
Each agent team runs in an independent sandbox, enabling multiple teams to execute simultaneously.

### 🤝 Advanced Collaboration Modes
Dialogue mode supports parallel, leader-based, and other agent collaboration patterns for complex workflows.

### 💻 AI Coding Integration
Coding mode integrates with GitHub/GitLab and other code services to implement AI-driven development and code review workflows.

---

## 🔗 Related Links

- [中文文档](../zh/README.md) - Chinese Documentation
- [GitHub Repository](https://github.com/wecode-ai/wegent) - Source code repository
- [GitHub Issues](https://github.com/wecode-ai/wegent/issues) - Issue tracker

---

## 💡 Documentation Conventions

Icon meanings used throughout this documentation:

- 📘 Basic content
- 🔧 Practical operations
- ⚠️ Important notes
- 💡 Best practices
- 📝 Code examples
- 🚀 Advanced topics

---

<p align="center">Made with ❤️ by WeCode-AI Team</p>
