# 📚 Wegent Documentation

Welcome to the Wegent documentation! / 欢迎来到 Wegent 文档中心！

Wegent is an open-source AI native operating system that enables you to define, organize, and run intelligent agents at scale.

Wegent 是一个开源的 AI 原生操作系统，使您能够大规模定义、组织和运行智能代理。

---

## 📖 Choose Your Language / 选择语言

<table>
  <tr>
    <td width="50%" valign="top">
      <h3>🇬🇧 English Documentation</h3>
      <p>Comprehensive guides and references in English.</p>
      <p><strong><a href="./en/README.md">→ Go to English Docs</a></strong></p>
    </td>
    <td width="50%" valign="top">
      <h3>🇨🇳 中文文档</h3>
      <p>完整的中文指南和参考文档。</p>
      <p><strong><a href="./zh/README.md">→ 前往中文文档</a></strong></p>
    </td>
  </tr>
</table>

---

## 🚀 Quick Links / 快速链接

### English
- [Quick Start](./en/getting-started/quick-start.md) - Get up and running in 5 minutes
- [Architecture Overview](./en/concepts/architecture.md) - Understand how Wegent works
- [YAML Specification](./en/reference/yaml-specification.md) - Complete configuration reference

### 中文
- [快速开始](./zh/getting-started/quick-start.md) - 5 分钟快速上手
- [架构概览](./zh/concepts/architecture.md) - 了解 Wegent 工作原理
- [YAML 规范](./zh/reference/yaml-specification.md) - 完整配置参考

---

## 💡 What's in the Docs? / 文档内容

<table>
  <tr>
    <td width="50%">
      <h4>📘 Getting Started</h4>
      <ul>
        <li>Installation guides</li>
        <li>Quick start tutorials</li>
        <li>First steps with Wegent</li>
      </ul>
    </td>
    <td width="50%">
      <h4>📘 快速开始</h4>
      <ul>
        <li>安装指南</li>
        <li>快速上手教程</li>
        <li>Wegent 入门步骤</li>
      </ul>
    </td>
  </tr>
  <tr>
    <td width="50%">
      <h4>🧠 Core Concepts</h4>
      <ul>
        <li>Architecture design</li>
        <li>Agent concepts (Ghost, Bot, Team)</li>
        <li>Collaboration models</li>
      </ul>
    </td>
    <td width="50%">
      <h4>🧠 核心概念</h4>
      <ul>
        <li>架构设计</li>
        <li>智能体概念（Ghost、Bot、Team）</li>
        <li>协作模式</li>
      </ul>
    </td>
  </tr>
  <tr>
    <td width="50%">
      <h4>📖 User & Developer Guides</h4>
      <ul>
        <li>Creating and managing agents</li>
        <li>Building teams</li>
        <li>Development setup</li>
      </ul>
    </td>
    <td width="50%">
      <h4>📖 用户与开发指南</h4>
      <ul>
        <li>创建和管理智能体</li>
        <li>构建团队</li>
        <li>开发环境设置</li>
      </ul>
    </td>
  </tr>
  <tr>
    <td width="50%">
      <h4>🚀 Deployment & Operations</h4>
      <ul>
        <li>Production deployment</li>
        <li>Docker configuration</li>
        <li>Environment setup</li>
      </ul>
    </td>
    <td width="50%">
      <h4>🚀 部署与运维</h4>
      <ul>
        <li>生产环境部署</li>
        <li>Docker 配置</li>
        <li>环境设置</li>
      </ul>
    </td>
  </tr>
</table>

---

## 🤝 Contributing / 贡献

Found an issue in the documentation? We welcome contributions!

发现文档问题？欢迎贡献！

---

<p align="center">Made with ❤️ by WeCode-AI Team</p>
