# 版本管理策略

## 分支策略

### 主分支 (main)
- **用途**: 稳定的生产版本
- **文件**: `auto_course_grabber.js`
- **版本**: v1.x.x
- **特点**: 已经过验证，推荐用户使用

### 开发分支 (develop)
- **用途**: 所有v2.x.x版本的开发
- **文件**: `auto_course_grabber2.0.js`
- **版本策略**: 
  - v2.1.0 (增强版本 - 多教学班支持、时间冲突检测)
  - v2.2.0 (计划版本 - 定时开始抢课功能)
  - v2.3.0 (计划版本 - 待定功能)

## 版本号规则

### 格式: MAJOR.MINOR.PATCH

- **MAJOR**: 主要版本更新 (1 → 2)
- **MINOR**: 新功能添加 (2.1 → 2.2)
- **PATCH**: 错误修复 (2.1.0 → 2.1.1)

### 当前版本规划
- **v2.1.0** - 增强版本
  - 增强了多教学班支持和处理逻辑
  - 优化了时间冲突检测算法
  - 改进了容量信息解析和匹配
  - 增加了详细的调试功能和信息
  - 完善了错误处理和重试机制
  - 添加了智能的选课元素识别
  - 增强了成功验证和通知系统
  - 优化了选课流程和用户体验

- **v2.2.0** - 多课程同时抢课版本 (当前版本)
  - 支持同时抢多门课程
  - 支持按教师和时间筛选每门课程
  - 自动跟踪已选课程状态
  - 所有课程选完后自动停止
  - 优化了多课程管理逻辑
  - 增强了成功选课的验证机制

- **v2.3.0** - 计划版本 (待定功能)
  - 可能添加定时开始功能
  - 可能添加更多智能化功能

## 工作流程

1. **开发新功能**: 在 `develop` 分支上工作
2. **版本发布**: 使用 Git 标签标记版本
3. **稳定后**: 合并到 `main` 分支
4. **紧急修复**: 从 `main` 创建 `hotfix` 分支

## Git 工作流

````bash
# 创建并切换到开发分支
git checkout -b develop

# 提交当前版本 v2.2.0
git add .
git commit -m "feat: v2.2.0 多课程同时抢课版本

- 支持同时抢多门课程
- 支持按教师和时间筛选每门课程
- 自动跟踪已选课程状态
- 所有课程选完后自动停止
- 优化了多课程管理逻辑
- 增强了成功选课的验证机制"

# 推送到远程分支
git push origin develop

# 创建版本标签
git tag v2.2.0
git push origin v2.2.0

```bash
# 创建开发分支
git checkout -b develop

# 提交测试版本
git add .
git commit -m "feat: 添加增强功能 v2.0.0-beta.1"
git tag v2.0.0-beta.1
git push origin develop --tags

# 后续版本更新
git commit -m "fix: 修复容量检测问题 v2.0.0-beta.2"
git tag v2.0.0-beta.2
git push origin develop --tags
```
