# 教务系统自动抢课脚本

演示：[ 抢课脚本视频演示 ](https://www.bilibili.com/video/BV15q3xz5EzY/?spm_id_from=333.1387.0.0&vd_source=629ab680411f61e4c3248ff4ac043913)

## 功能特性

- 🎯 **智能识别**: 自动识别同一课程的多个教学班
- ⚡ **实时监控**: 持续监控课程余量变化
- 🛡️ **冲突处理**: 自动处理时间冲突，尝试其他教学班
- 📊 **状态反馈**: 实时显示抢课状态和进度
- 🔔 **成功通知**: 选课成功后立即通知
- 🎨 **彩色日志**: 清晰的彩色控制台输出

## 使用方法

1. **登录教务系统**
   - 访问教务系统
   - 完成登录并进入选课页面

2. **配置脚本**
   - 在脚本中填入目标课程号 `TARGET_COURSE_CODE`
   - 可根据需要调整检查间隔等参数

3. **执行脚本**
   - 按F12打开浏览器控制台
   - 复制粘贴整个脚本代码并执行

4. **开始抢课**
   ```javascript
   courseGrabber.start()  // 开始抢课
   courseGrabber.stop()   // 停止抢课
   courseGrabber.status() // 查看状态
   courseGrabber.debug()  // 调试信息
   ```

## 配置参数

```javascript
const TARGET_COURSE_CODE = '';      // 目标课程号
const CHECK_INTERVAL = 2000;        // 检查间隔(毫秒)
const MAX_ATTEMPTS = 1000;          // 最大尝试次数
const MAX_FAILED_ATTEMPTS = 5;      // 最大连续失败次数
const RETRY_DELAY = 3000;           // 重试延迟(毫秒)
```

## 智能保护机制

- **时间冲突检测**: 自动检测并跳过时间冲突的教学班
- **重复尝试控制**: 避免对同一教学班重复操作
- **失败重试限制**: 连续失败达到阈值后自动停止
- **全冲突保护**: 所有教学班都冲突时自动停止并提醒

## 注意事项

⚠️ **重要提醒**:
- 请确保在正确的选课页面使用
- 建议在选课开放时间使用
- 使用前请确认目标课程号正确
- 脚本仅用于学习交流，请遵守学校相关规定

## 更新日志

- v1.0: 基础抢课功能
- v1.1: 增加多教学班支持
- v1.2: 优化时间冲突处理
- v1.3: 完善错误处理和用户体验

## 免责声明

本脚本仅供学习和研究使用，使用者需遵守学校相关规定。作者不承担因使用本脚本而产生的任何后果。

---

**祝您选课顺利！🎓**
