/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.sentinel.dashboard.repository.rule;

import com.alibaba.csp.sentinel.dashboard.datasource.entity.rule.RuleEntity;
import com.alibaba.csp.sentinel.dashboard.discovery.MachineInfo;
import com.alibaba.csp.sentinel.dashboard.repository.rule.RuleRepository;
import com.alibaba.csp.sentinel.util.AssertUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public abstract class InMemoryRuleRepositoryAdapter<T extends RuleEntity>
implements RuleRepository<T, Long> {
    private Map<MachineInfo, Map<Long, T>> machineRules = new ConcurrentHashMap(16);
    private Map<Long, T> allRules = new ConcurrentHashMap(16);
    private Map<String, Map<Long, T>> appRules = new ConcurrentHashMap(16);
    private static final int MAX_RULES_SIZE = 10000;

    public T save(T entity) {
        RuleEntity processedEntity;
        if (entity.getId() == null) {
            entity.setId(Long.valueOf(this.nextId()));
        }
        if ((processedEntity = this.preProcess(entity)) != null) {
            this.allRules.put(processedEntity.getId(), processedEntity);
            this.machineRules.computeIfAbsent(MachineInfo.of((String)processedEntity.getApp(), (String)processedEntity.getIp(), (Integer)processedEntity.getPort()), e -> new ConcurrentHashMap(32)).put(processedEntity.getId(), processedEntity);
            this.appRules.computeIfAbsent(processedEntity.getApp(), v -> new ConcurrentHashMap(32)).put(processedEntity.getId(), processedEntity);
        }
        return (T)processedEntity;
    }

    public List<T> saveAll(List<T> rules) {
        this.allRules.clear();
        this.machineRules.clear();
        this.appRules.clear();
        if (rules == null) {
            return null;
        }
        ArrayList<RuleEntity> savedRules = new ArrayList<RuleEntity>(rules.size());
        for (RuleEntity rule : rules) {
            savedRules.add(this.save(rule));
        }
        return savedRules;
    }

    public T delete(Long id) {
        RuleEntity entity = (RuleEntity)this.allRules.remove(id);
        if (entity != null) {
            if (this.appRules.get(entity.getApp()) != null) {
                ((Map)this.appRules.get(entity.getApp())).remove(id);
            }
            ((Map)this.machineRules.get(MachineInfo.of((String)entity.getApp(), (String)entity.getIp(), (Integer)entity.getPort()))).remove(id);
        }
        return (T)entity;
    }

    public T findById(Long id) {
        return (T)((RuleEntity)this.allRules.get(id));
    }

    public List<T> findAllByMachine(MachineInfo machineInfo) {
        Map entities = (Map)this.machineRules.get(machineInfo);
        if (entities == null) {
            return new ArrayList();
        }
        return new ArrayList(entities.values());
    }

    public List<T> findAllByApp(String appName) {
        AssertUtil.notEmpty((String)appName, (String)"appName cannot be empty");
        Map entities = (Map)this.appRules.get(appName);
        if (entities == null) {
            return new ArrayList();
        }
        return new ArrayList(entities.values());
    }

    public void clearAll() {
        this.allRules.clear();
        this.machineRules.clear();
        this.appRules.clear();
    }

    protected T preProcess(T entity) {
        return entity;
    }

    protected abstract long nextId();
}

