/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.sentinel.dashboard.metric;

import com.alibaba.csp.sentinel.concurrent.NamedThreadFactory;
import com.alibaba.csp.sentinel.config.SentinelConfig;
import com.alibaba.csp.sentinel.dashboard.datasource.entity.MetricEntity;
import com.alibaba.csp.sentinel.dashboard.discovery.AppInfo;
import com.alibaba.csp.sentinel.dashboard.discovery.AppManagement;
import com.alibaba.csp.sentinel.dashboard.discovery.MachineInfo;
import com.alibaba.csp.sentinel.dashboard.repository.metric.MetricsRepository;
import com.alibaba.csp.sentinel.node.metric.MetricNode;
import com.alibaba.csp.sentinel.util.StringUtil;
import java.nio.charset.Charset;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.RedirectStrategy;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.concurrent.FutureCallback;
import org.apache.http.entity.ContentType;
import org.apache.http.impl.nio.client.CloseableHttpAsyncClient;
import org.apache.http.impl.nio.client.HttpAsyncClients;
import org.apache.http.impl.nio.reactor.IOReactorConfig;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class MetricFetcher {
    public static final String NO_METRICS = "No metrics";
    private static final int HTTP_OK = 200;
    private static final long MAX_LAST_FETCH_INTERVAL_MS = 15000L;
    private static final long FETCH_INTERVAL_SECOND = 6L;
    private static final Charset DEFAULT_CHARSET = Charset.forName(SentinelConfig.charset());
    private static final String METRIC_URL_PATH = "metric";
    private static Logger logger = LoggerFactory.getLogger(MetricFetcher.class);
    private final long intervalSecond = 1L;
    private Map<String, AtomicLong> appLastFetchTime = new ConcurrentHashMap();
    @Autowired
    private MetricsRepository<MetricEntity> metricStore;
    @Autowired
    private AppManagement appManagement;
    private CloseableHttpAsyncClient httpclient;
    private ScheduledExecutorService fetchScheduleService = Executors.newScheduledThreadPool(1, (ThreadFactory)new NamedThreadFactory("sentinel-dashboard-metrics-fetch-task", true));
    private ExecutorService fetchService;
    private ExecutorService fetchWorker;
    private static final Set<String> RES_EXCLUSION_SET = new /* Unavailable Anonymous Inner Class!! */;

    public MetricFetcher() {
        int cores = Runtime.getRuntime().availableProcessors() * 2;
        long keepAliveTime = 0L;
        int queueSize = 2048;
        ThreadPoolExecutor.DiscardPolicy handler = new ThreadPoolExecutor.DiscardPolicy();
        this.fetchService = new ThreadPoolExecutor(cores, cores, keepAliveTime, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(queueSize), (ThreadFactory)new NamedThreadFactory("sentinel-dashboard-metrics-fetchService", true), handler);
        this.fetchWorker = new ThreadPoolExecutor(cores, cores, keepAliveTime, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(queueSize), (ThreadFactory)new NamedThreadFactory("sentinel-dashboard-metrics-fetchWorker", true), handler);
        IOReactorConfig ioConfig = IOReactorConfig.custom().setConnectTimeout(3000).setSoTimeout(3000).setIoThreadCount(Runtime.getRuntime().availableProcessors() * 2).build();
        this.httpclient = HttpAsyncClients.custom().setRedirectStrategy((RedirectStrategy)new /* Unavailable Anonymous Inner Class!! */).setMaxConnTotal(4000).setMaxConnPerRoute(1000).setDefaultIOReactorConfig(ioConfig).build();
        this.httpclient.start();
        this.start();
    }

    private void start() {
        this.fetchScheduleService.scheduleAtFixedRate(() -> {
            try {
                this.fetchAllApp();
            }
            catch (Exception e) {
                logger.info("fetchAllApp error:", (Throwable)e);
            }
        }, 10L, 1L, TimeUnit.SECONDS);
    }

    private void writeMetric(Map<String, MetricEntity> map) {
        if (map.isEmpty()) {
            return;
        }
        Date date = new Date();
        for (MetricEntity entity : map.values()) {
            entity.setGmtCreate(date);
            entity.setGmtModified(date);
        }
        this.metricStore.saveAll(map.values());
    }

    private void fetchAllApp() {
        List apps = this.appManagement.getAppNames();
        if (apps == null) {
            return;
        }
        for (String app : apps) {
            this.fetchService.submit(() -> {
                try {
                    this.doFetchAppMetric(app);
                }
                catch (Exception e) {
                    logger.error("fetchAppMetric error", (Throwable)e);
                }
            });
        }
    }

    private void fetchOnce(String app, long startTime, long endTime, int maxWaitSeconds) {
        if (maxWaitSeconds <= 0) {
            throw new IllegalArgumentException("maxWaitSeconds must > 0, but " + maxWaitSeconds);
        }
        AppInfo appInfo = this.appManagement.getDetailApp(app);
        if (appInfo.isDead()) {
            logger.info("Dead app removed: {}", (Object)app);
            this.appManagement.removeApp(app);
            return;
        }
        Set machines = appInfo.getMachines();
        logger.debug("enter fetchOnce(" + app + "), machines.size()=" + machines.size() + ", time intervalMs [" + startTime + ", " + endTime + "]");
        if (machines.isEmpty()) {
            return;
        }
        String msg = "fetch";
        AtomicLong unhealthy = new AtomicLong();
        AtomicLong success = new AtomicLong();
        AtomicLong fail = new AtomicLong();
        long start = System.currentTimeMillis();
        ConcurrentHashMap metricMap = new ConcurrentHashMap(16);
        CountDownLatch latch = new CountDownLatch(machines.size());
        for (MachineInfo machine : machines) {
            if (machine.isDead()) {
                latch.countDown();
                this.appManagement.getDetailApp(app).removeMachine(machine.getIp(), machine.getPort().intValue());
                logger.info("Dead machine removed: {}:{} of {}", new Object[]{machine.getIp(), machine.getPort(), app});
                continue;
            }
            if (!machine.isHealthy()) {
                latch.countDown();
                unhealthy.incrementAndGet();
                continue;
            }
            String url = "http://" + machine.getIp() + ":" + machine.getPort() + "/" + METRIC_URL_PATH + "?startTime=" + startTime + "&endTime=" + endTime + "&refetch=" + false;
            HttpGet httpGet = new HttpGet(url);
            httpGet.setHeader("Connection", "Close");
            this.httpclient.execute((HttpUriRequest)httpGet, (FutureCallback)new /* Unavailable Anonymous Inner Class!! */);
        }
        try {
            latch.await(maxWaitSeconds, TimeUnit.SECONDS);
        }
        catch (Exception e) {
            logger.info("fetch metric, wait http client error:", (Throwable)e);
        }
        this.writeMetric(metricMap);
    }

    private void doFetchAppMetric(String app) {
        long endTime;
        long now = System.currentTimeMillis();
        long lastFetchMs = now - 15000L;
        if (this.appLastFetchTime.containsKey(app)) {
            lastFetchMs = Math.max(lastFetchMs, ((AtomicLong)this.appLastFetchTime.get(app)).get() + 1000L);
        }
        if ((endTime = (lastFetchMs = lastFetchMs / 1000L * 1000L) + 6000L) > now - 2000L) {
            return;
        }
        this.appLastFetchTime.computeIfAbsent(app, a -> new AtomicLong()).set(endTime);
        long finalLastFetchMs = lastFetchMs;
        long finalEndTime = endTime;
        try {
            this.fetchWorker.submit(() -> {
                try {
                    this.fetchOnce(app, finalLastFetchMs, finalEndTime, 5);
                }
                catch (Exception e) {
                    logger.info("fetchOnce(" + app + ") error", (Throwable)e);
                }
            });
        }
        catch (Exception e) {
            logger.info("submit fetchOnce(" + app + ") fail, intervalMs [" + lastFetchMs + ", " + endTime + "]", (Throwable)e);
        }
    }

    private void handleResponse(HttpResponse response, MachineInfo machine, Map<String, MetricEntity> metricMap) throws Exception {
        int code = response.getStatusLine().getStatusCode();
        if (code != 200) {
            return;
        }
        Charset charset = null;
        try {
            String contentTypeStr = response.getFirstHeader("Content-type").getValue();
            if (StringUtil.isNotEmpty((String)contentTypeStr)) {
                ContentType contentType = ContentType.parse((String)contentTypeStr);
                charset = contentType.getCharset();
            }
        }
        catch (Exception contentTypeStr) {
            // empty catch block
        }
        String body = EntityUtils.toString((HttpEntity)response.getEntity(), (Charset)(charset != null ? charset : DEFAULT_CHARSET));
        if (StringUtil.isEmpty((String)body) || body.startsWith(NO_METRICS)) {
            return;
        }
        String[] lines = body.split("\n");
        this.handleBody(lines, machine, metricMap);
    }

    private void handleBody(String[] lines, MachineInfo machine, Map<String, MetricEntity> map) {
        if (lines.length < 1) {
            return;
        }
        for (String line : lines) {
            try {
                MetricNode node = MetricNode.fromThinString((String)line);
                if (this.shouldFilterOut(node.getResource())) continue;
                String key = this.buildMetricKey(machine.getApp(), node.getResource(), node.getTimestamp());
                MetricEntity metricEntity = map.computeIfAbsent(key, s -> {
                    MetricEntity initMetricEntity = new MetricEntity();
                    initMetricEntity.setApp(machine.getApp());
                    initMetricEntity.setTimestamp(new Date(node.getTimestamp()));
                    initMetricEntity.setPassQps(Long.valueOf(0L));
                    initMetricEntity.setBlockQps(Long.valueOf(0L));
                    initMetricEntity.setRtAndSuccessQps(0.0, Long.valueOf(0L));
                    initMetricEntity.setExceptionQps(Long.valueOf(0L));
                    initMetricEntity.setCount(0);
                    initMetricEntity.setResource(node.getResource());
                    return initMetricEntity;
                });
                metricEntity.addPassQps(Long.valueOf(node.getPassQps()));
                metricEntity.addBlockQps(Long.valueOf(node.getBlockQps()));
                metricEntity.addRtAndSuccessQps((double)node.getRt(), Long.valueOf(node.getSuccessQps()));
                metricEntity.addExceptionQps(Long.valueOf(node.getExceptionQps()));
                metricEntity.addCount(1);
            }
            catch (Exception e) {
                logger.warn("handleBody line exception, machine: {}, line: {}", (Object)machine.toLogString(), (Object)line);
            }
        }
    }

    private String buildMetricKey(String app, String resource, long timestamp) {
        return app + "__" + resource + "__" + timestamp / 1000L;
    }

    private boolean shouldFilterOut(String resource) {
        return RES_EXCLUSION_SET.contains(resource);
    }

    static /* synthetic */ void access$000(MetricFetcher x0, HttpResponse x1, MachineInfo x2, Map x3) throws Exception {
        x0.handleResponse(x1, x2, x3);
    }

    static /* synthetic */ Logger access$100() {
        return logger;
    }
}

