/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.sentinel.dashboard.datasource.entity.gateway;

import com.alibaba.csp.sentinel.adapter.gateway.common.rule.GatewayFlowRule;
import com.alibaba.csp.sentinel.adapter.gateway.common.rule.GatewayParamFlowItem;
import com.alibaba.csp.sentinel.dashboard.datasource.entity.gateway.GatewayParamFlowItemEntity;
import com.alibaba.csp.sentinel.dashboard.datasource.entity.rule.RuleEntity;
import com.alibaba.csp.sentinel.slots.block.Rule;
import java.util.Date;
import java.util.Objects;

/*
 * Exception performing whole class analysis ignored.
 */
public class GatewayFlowRuleEntity
implements RuleEntity {
    public static final int INTERVAL_UNIT_SECOND = 0;
    public static final int INTERVAL_UNIT_MINUTE = 1;
    public static final int INTERVAL_UNIT_HOUR = 2;
    public static final int INTERVAL_UNIT_DAY = 3;
    private Long id;
    private String app;
    private String ip;
    private Integer port;
    private Date gmtCreate;
    private Date gmtModified;
    private String resource;
    private Integer resourceMode;
    private Integer grade;
    private Double count;
    private Long interval;
    private Integer intervalUnit;
    private Integer controlBehavior;
    private Integer burst;
    private Integer maxQueueingTimeoutMs;
    private GatewayParamFlowItemEntity paramItem;

    public static Long calIntervalSec(Long interval, Integer intervalUnit) {
        switch (intervalUnit) {
            case 0: {
                return interval;
            }
            case 1: {
                return interval * 60L;
            }
            case 2: {
                return interval * 60L * 60L;
            }
            case 3: {
                return interval * 60L * 60L * 24L;
            }
        }
        throw new IllegalArgumentException("Invalid intervalUnit: " + intervalUnit);
    }

    public static Object[] parseIntervalSec(Long intervalSec) {
        if (intervalSec % 86400L == 0L) {
            return new Object[]{intervalSec / 86400L, 3};
        }
        if (intervalSec % 3600L == 0L) {
            return new Object[]{intervalSec / 3600L, 2};
        }
        if (intervalSec % 60L == 0L) {
            return new Object[]{intervalSec / 60L, 1};
        }
        return new Object[]{intervalSec, 0};
    }

    public GatewayFlowRule toGatewayFlowRule() {
        GatewayFlowRule rule = new GatewayFlowRule();
        rule.setResource(this.resource);
        rule.setResourceMode(this.resourceMode.intValue());
        rule.setGrade(this.grade.intValue());
        rule.setCount(this.count.doubleValue());
        rule.setIntervalSec(GatewayFlowRuleEntity.calIntervalSec((Long)this.interval, (Integer)this.intervalUnit).longValue());
        rule.setControlBehavior(this.controlBehavior.intValue());
        if (this.burst != null) {
            rule.setBurst(this.burst.intValue());
        }
        if (this.maxQueueingTimeoutMs != null) {
            rule.setMaxQueueingTimeoutMs(this.maxQueueingTimeoutMs.intValue());
        }
        if (this.paramItem != null) {
            GatewayParamFlowItem ruleItem = new GatewayParamFlowItem();
            rule.setParamItem(ruleItem);
            ruleItem.setParseStrategy(this.paramItem.getParseStrategy().intValue());
            ruleItem.setFieldName(this.paramItem.getFieldName());
            ruleItem.setPattern(this.paramItem.getPattern());
            if (this.paramItem.getMatchStrategy() != null) {
                ruleItem.setMatchStrategy(this.paramItem.getMatchStrategy().intValue());
            }
        }
        return rule;
    }

    public static GatewayFlowRuleEntity fromGatewayFlowRule(String app, String ip, Integer port, GatewayFlowRule rule) {
        GatewayFlowRuleEntity entity = new GatewayFlowRuleEntity();
        entity.setApp(app);
        entity.setIp(ip);
        entity.setPort(port);
        entity.setResource(rule.getResource());
        entity.setResourceMode(Integer.valueOf(rule.getResourceMode()));
        entity.setGrade(Integer.valueOf(rule.getGrade()));
        entity.setCount(Double.valueOf(rule.getCount()));
        Object[] intervalSecResult = GatewayFlowRuleEntity.parseIntervalSec((Long)rule.getIntervalSec());
        entity.setInterval((Long)intervalSecResult[0]);
        entity.setIntervalUnit((Integer)intervalSecResult[1]);
        entity.setControlBehavior(Integer.valueOf(rule.getControlBehavior()));
        entity.setBurst(Integer.valueOf(rule.getBurst()));
        entity.setMaxQueueingTimeoutMs(Integer.valueOf(rule.getMaxQueueingTimeoutMs()));
        GatewayParamFlowItem paramItem = rule.getParamItem();
        if (paramItem != null) {
            GatewayParamFlowItemEntity itemEntity = new GatewayParamFlowItemEntity();
            entity.setParamItem(itemEntity);
            itemEntity.setParseStrategy(Integer.valueOf(paramItem.getParseStrategy()));
            itemEntity.setFieldName(paramItem.getFieldName());
            itemEntity.setPattern(paramItem.getPattern());
            itemEntity.setMatchStrategy(Integer.valueOf(paramItem.getMatchStrategy()));
        }
        return entity;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getApp() {
        return this.app;
    }

    public void setApp(String app) {
        this.app = app;
    }

    public String getIp() {
        return this.ip;
    }

    public void setIp(String ip) {
        this.ip = ip;
    }

    public Integer getPort() {
        return this.port;
    }

    public void setPort(Integer port) {
        this.port = port;
    }

    public Date getGmtCreate() {
        return this.gmtCreate;
    }

    public void setGmtCreate(Date gmtCreate) {
        this.gmtCreate = gmtCreate;
    }

    public Rule toRule() {
        return null;
    }

    public Date getGmtModified() {
        return this.gmtModified;
    }

    public void setGmtModified(Date gmtModified) {
        this.gmtModified = gmtModified;
    }

    public GatewayParamFlowItemEntity getParamItem() {
        return this.paramItem;
    }

    public void setParamItem(GatewayParamFlowItemEntity paramItem) {
        this.paramItem = paramItem;
    }

    public String getResource() {
        return this.resource;
    }

    public void setResource(String resource) {
        this.resource = resource;
    }

    public Integer getResourceMode() {
        return this.resourceMode;
    }

    public void setResourceMode(Integer resourceMode) {
        this.resourceMode = resourceMode;
    }

    public Integer getGrade() {
        return this.grade;
    }

    public void setGrade(Integer grade) {
        this.grade = grade;
    }

    public Double getCount() {
        return this.count;
    }

    public void setCount(Double count) {
        this.count = count;
    }

    public Long getInterval() {
        return this.interval;
    }

    public void setInterval(Long interval) {
        this.interval = interval;
    }

    public Integer getIntervalUnit() {
        return this.intervalUnit;
    }

    public void setIntervalUnit(Integer intervalUnit) {
        this.intervalUnit = intervalUnit;
    }

    public Integer getControlBehavior() {
        return this.controlBehavior;
    }

    public void setControlBehavior(Integer controlBehavior) {
        this.controlBehavior = controlBehavior;
    }

    public Integer getBurst() {
        return this.burst;
    }

    public void setBurst(Integer burst) {
        this.burst = burst;
    }

    public Integer getMaxQueueingTimeoutMs() {
        return this.maxQueueingTimeoutMs;
    }

    public void setMaxQueueingTimeoutMs(Integer maxQueueingTimeoutMs) {
        this.maxQueueingTimeoutMs = maxQueueingTimeoutMs;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GatewayFlowRuleEntity that = (GatewayFlowRuleEntity)o;
        return Objects.equals(this.id, that.id) && Objects.equals(this.app, that.app) && Objects.equals(this.ip, that.ip) && Objects.equals(this.port, that.port) && Objects.equals(this.gmtCreate, that.gmtCreate) && Objects.equals(this.gmtModified, that.gmtModified) && Objects.equals(this.resource, that.resource) && Objects.equals(this.resourceMode, that.resourceMode) && Objects.equals(this.grade, that.grade) && Objects.equals(this.count, that.count) && Objects.equals(this.interval, that.interval) && Objects.equals(this.intervalUnit, that.intervalUnit) && Objects.equals(this.controlBehavior, that.controlBehavior) && Objects.equals(this.burst, that.burst) && Objects.equals(this.maxQueueingTimeoutMs, that.maxQueueingTimeoutMs) && Objects.equals(this.paramItem, that.paramItem);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.app, this.ip, this.port, this.gmtCreate, this.gmtModified, this.resource, this.resourceMode, this.grade, this.count, this.interval, this.intervalUnit, this.controlBehavior, this.burst, this.maxQueueingTimeoutMs, this.paramItem);
    }

    public String toString() {
        return "GatewayFlowRuleEntity{id=" + this.id + ", app='" + this.app + '\'' + ", ip='" + this.ip + '\'' + ", port=" + this.port + ", gmtCreate=" + this.gmtCreate + ", gmtModified=" + this.gmtModified + ", resource='" + this.resource + '\'' + ", resourceMode=" + this.resourceMode + ", grade=" + this.grade + ", count=" + this.count + ", interval=" + this.interval + ", intervalUnit=" + this.intervalUnit + ", controlBehavior=" + this.controlBehavior + ", burst=" + this.burst + ", maxQueueingTimeoutMs=" + this.maxQueueingTimeoutMs + ", paramItem=" + this.paramItem + '}';
    }
}

