/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.sentinel.dashboard.controller.cluster;

import com.alibaba.csp.sentinel.dashboard.domain.Result;
import com.alibaba.csp.sentinel.dashboard.domain.cluster.ClusterAppAssignResultVO;
import com.alibaba.csp.sentinel.dashboard.domain.cluster.ClusterAppFullAssignRequest;
import com.alibaba.csp.sentinel.dashboard.domain.cluster.ClusterAppSingleServerAssignRequest;
import com.alibaba.csp.sentinel.dashboard.service.ClusterAssignService;
import com.alibaba.csp.sentinel.util.StringUtil;
import java.util.Collections;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/cluster/assign"})
public class ClusterAssignController {
    private final Logger logger = LoggerFactory.getLogger(ClusterAssignController.class);
    @Autowired
    private ClusterAssignService clusterAssignService;

    @PostMapping(value={"/all_server/{app}"})
    public Result<ClusterAppAssignResultVO> apiAssignAllClusterServersOfApp(@PathVariable String app, @RequestBody ClusterAppFullAssignRequest assignRequest) {
        if (StringUtil.isEmpty((String)app)) {
            return Result.ofFail((int)-1, (String)"app cannot be null or empty");
        }
        if (assignRequest == null || assignRequest.getClusterMap() == null || assignRequest.getRemainingList() == null) {
            return Result.ofFail((int)-1, (String)"bad request body");
        }
        try {
            return Result.ofSuccess((Object)this.clusterAssignService.applyAssignToApp(app, assignRequest.getClusterMap(), assignRequest.getRemainingList()));
        }
        catch (Throwable throwable) {
            this.logger.error("Error when assigning full cluster servers for app: " + app, throwable);
            return Result.ofFail((int)-1, (String)throwable.getMessage());
        }
    }

    @PostMapping(value={"/single_server/{app}"})
    public Result<ClusterAppAssignResultVO> apiAssignSingleClusterServersOfApp(@PathVariable String app, @RequestBody ClusterAppSingleServerAssignRequest assignRequest) {
        if (StringUtil.isEmpty((String)app)) {
            return Result.ofFail((int)-1, (String)"app cannot be null or empty");
        }
        if (assignRequest == null || assignRequest.getClusterMap() == null) {
            return Result.ofFail((int)-1, (String)"bad request body");
        }
        try {
            return Result.ofSuccess((Object)this.clusterAssignService.applyAssignToApp(app, Collections.singletonList(assignRequest.getClusterMap()), assignRequest.getRemainingList()));
        }
        catch (Throwable throwable) {
            this.logger.error("Error when assigning single cluster servers for app: " + app, throwable);
            return Result.ofFail((int)-1, (String)throwable.getMessage());
        }
    }

    @PostMapping(value={"/unbind_server/{app}"})
    public Result<ClusterAppAssignResultVO> apiUnbindClusterServersOfApp(@PathVariable String app, @RequestBody Set<String> machineIds) {
        if (StringUtil.isEmpty((String)app)) {
            return Result.ofFail((int)-1, (String)"app cannot be null or empty");
        }
        if (machineIds == null || machineIds.isEmpty()) {
            return Result.ofFail((int)-1, (String)"bad request body");
        }
        try {
            return Result.ofSuccess((Object)this.clusterAssignService.unbindClusterServers(app, machineIds));
        }
        catch (Throwable throwable) {
            this.logger.error("Error when unbinding cluster server {} for app <{}>", new Object[]{machineIds, app, throwable});
            return Result.ofFail((int)-1, (String)throwable.getMessage());
        }
    }
}

