/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.sentinel.dashboard.controller;

import com.alibaba.csp.sentinel.dashboard.auth.AuthAction;
import com.alibaba.csp.sentinel.dashboard.auth.AuthService;
import com.alibaba.csp.sentinel.dashboard.client.CommandNotFoundException;
import com.alibaba.csp.sentinel.dashboard.client.SentinelApiClient;
import com.alibaba.csp.sentinel.dashboard.datasource.entity.SentinelVersion;
import com.alibaba.csp.sentinel.dashboard.datasource.entity.rule.ParamFlowRuleEntity;
import com.alibaba.csp.sentinel.dashboard.discovery.AppManagement;
import com.alibaba.csp.sentinel.dashboard.discovery.MachineInfo;
import com.alibaba.csp.sentinel.dashboard.domain.Result;
import com.alibaba.csp.sentinel.dashboard.repository.rule.RuleRepository;
import com.alibaba.csp.sentinel.dashboard.util.VersionUtils;
import com.alibaba.csp.sentinel.slots.block.flow.param.ParamFlowRule;
import com.alibaba.csp.sentinel.util.StringUtil;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/paramFlow"})
public class ParamFlowRuleController {
    private final Logger logger = LoggerFactory.getLogger(ParamFlowRuleController.class);
    @Autowired
    private SentinelApiClient sentinelApiClient;
    @Autowired
    private AppManagement appManagement;
    @Autowired
    private RuleRepository<ParamFlowRuleEntity, Long> repository;
    private final SentinelVersion version020 = new SentinelVersion().setMinorVersion(2);

    private boolean checkIfSupported(String app, String ip, int port) {
        try {
            return Optional.ofNullable(this.appManagement.getDetailApp(app)).flatMap(e -> e.getMachine(ip, port)).flatMap(m -> VersionUtils.parseVersion((String)m.getVersion()).map(v -> v.greaterOrEqual(this.version020))).orElse(true);
        }
        catch (Exception ex) {
            return true;
        }
    }

    @GetMapping(value={"/rules"})
    @AuthAction(value=AuthService.PrivilegeType.READ_RULE)
    public Result<List<ParamFlowRuleEntity>> apiQueryAllRulesForMachine(@RequestParam String app, @RequestParam String ip, @RequestParam Integer port) {
        if (StringUtil.isEmpty((String)app)) {
            return Result.ofFail((int)-1, (String)"app cannot be null or empty");
        }
        if (StringUtil.isEmpty((String)ip)) {
            return Result.ofFail((int)-1, (String)"ip cannot be null or empty");
        }
        if (port == null || port <= 0) {
            return Result.ofFail((int)-1, (String)"Invalid parameter: port");
        }
        if (!this.appManagement.isValidMachineOfApp(app, ip)) {
            return Result.ofFail((int)-1, (String)"given ip does not belong to given app");
        }
        if (!this.checkIfSupported(app, ip, port.intValue())) {
            return this.unsupportedVersion();
        }
        try {
            return (Result)((CompletableFuture)((CompletableFuture)this.sentinelApiClient.fetchParamFlowRulesOfMachine(app, ip, port.intValue()).thenApply(arg_0 -> ((RuleRepository)this.repository).saveAll(arg_0))).thenApply(Result::ofSuccess)).get();
        }
        catch (ExecutionException ex) {
            this.logger.error("Error when querying parameter flow rules", ex.getCause());
            if (this.isNotSupported(ex.getCause())) {
                return this.unsupportedVersion();
            }
            return Result.ofThrowable((int)-1, (Throwable)ex.getCause());
        }
        catch (Throwable throwable) {
            this.logger.error("Error when querying parameter flow rules", throwable);
            return Result.ofFail((int)-1, (String)throwable.getMessage());
        }
    }

    private boolean isNotSupported(Throwable ex) {
        return ex instanceof CommandNotFoundException;
    }

    @PostMapping(value={"/rule"})
    @AuthAction(value=AuthService.PrivilegeType.WRITE_RULE)
    public Result<ParamFlowRuleEntity> apiAddParamFlowRule(@RequestBody ParamFlowRuleEntity entity) {
        Result checkResult = this.checkEntityInternal(entity);
        if (checkResult != null) {
            return checkResult;
        }
        if (!this.checkIfSupported(entity.getApp(), entity.getIp(), entity.getPort().intValue())) {
            return this.unsupportedVersion();
        }
        entity.setId(null);
        ((ParamFlowRule)entity.getRule()).setResource(entity.getResource().trim());
        Date date = new Date();
        entity.setGmtCreate(date);
        entity.setGmtModified(date);
        try {
            entity = (ParamFlowRuleEntity)this.repository.save((Object)entity);
            this.publishRules(entity.getApp(), entity.getIp(), entity.getPort()).get();
            return Result.ofSuccess((Object)entity);
        }
        catch (ExecutionException ex) {
            this.logger.error("Error when adding new parameter flow rules", ex.getCause());
            if (this.isNotSupported(ex.getCause())) {
                return this.unsupportedVersion();
            }
            return Result.ofThrowable((int)-1, (Throwable)ex.getCause());
        }
        catch (Throwable throwable) {
            this.logger.error("Error when adding new parameter flow rules", throwable);
            return Result.ofFail((int)-1, (String)throwable.getMessage());
        }
    }

    private <R> Result<R> checkEntityInternal(ParamFlowRuleEntity entity) {
        if (entity == null) {
            return Result.ofFail((int)-1, (String)"bad rule body");
        }
        if (StringUtil.isBlank((String)entity.getApp())) {
            return Result.ofFail((int)-1, (String)"app can't be null or empty");
        }
        if (StringUtil.isBlank((String)entity.getIp())) {
            return Result.ofFail((int)-1, (String)"ip can't be null or empty");
        }
        if (entity.getPort() == null || entity.getPort() <= 0) {
            return Result.ofFail((int)-1, (String)"port can't be null");
        }
        if (entity.getRule() == null) {
            return Result.ofFail((int)-1, (String)"rule can't be null");
        }
        if (StringUtil.isBlank((String)entity.getResource())) {
            return Result.ofFail((int)-1, (String)"resource name cannot be null or empty");
        }
        if (entity.getCount() < 0.0) {
            return Result.ofFail((int)-1, (String)"count should be valid");
        }
        if (entity.getGrade() != 1) {
            return Result.ofFail((int)-1, (String)"Unknown mode (blockGrade) for parameter flow control");
        }
        if (entity.getParamIdx() == null || entity.getParamIdx() < 0) {
            return Result.ofFail((int)-1, (String)"paramIdx should be valid");
        }
        if (entity.getDurationInSec() <= 0L) {
            return Result.ofFail((int)-1, (String)"durationInSec should be valid");
        }
        if (entity.getControlBehavior() < 0) {
            return Result.ofFail((int)-1, (String)"controlBehavior should be valid");
        }
        return null;
    }

    @PutMapping(value={"/rule/{id}"})
    @AuthAction(value=AuthService.PrivilegeType.WRITE_RULE)
    public Result<ParamFlowRuleEntity> apiUpdateParamFlowRule(@PathVariable(value="id") Long id, @RequestBody ParamFlowRuleEntity entity) {
        if (id == null || id <= 0L) {
            return Result.ofFail((int)-1, (String)"Invalid id");
        }
        ParamFlowRuleEntity oldEntity = (ParamFlowRuleEntity)this.repository.findById((Object)id);
        if (oldEntity == null) {
            return Result.ofFail((int)-1, (String)("id " + id + " does not exist"));
        }
        Result checkResult = this.checkEntityInternal(entity);
        if (checkResult != null) {
            return checkResult;
        }
        if (!this.checkIfSupported(entity.getApp(), entity.getIp(), entity.getPort().intValue())) {
            return this.unsupportedVersion();
        }
        entity.setId(id);
        Date date = new Date();
        entity.setGmtCreate(oldEntity.getGmtCreate());
        entity.setGmtModified(date);
        try {
            entity = (ParamFlowRuleEntity)this.repository.save((Object)entity);
            this.publishRules(entity.getApp(), entity.getIp(), entity.getPort()).get();
            return Result.ofSuccess((Object)entity);
        }
        catch (ExecutionException ex) {
            this.logger.error("Error when updating parameter flow rules, id=" + id, ex.getCause());
            if (this.isNotSupported(ex.getCause())) {
                return this.unsupportedVersion();
            }
            return Result.ofThrowable((int)-1, (Throwable)ex.getCause());
        }
        catch (Throwable throwable) {
            this.logger.error("Error when updating parameter flow rules, id=" + id, throwable);
            return Result.ofFail((int)-1, (String)throwable.getMessage());
        }
    }

    @DeleteMapping(value={"/rule/{id}"})
    @AuthAction(value=AuthService.PrivilegeType.DELETE_RULE)
    public Result<Long> apiDeleteRule(@PathVariable(value="id") Long id) {
        if (id == null) {
            return Result.ofFail((int)-1, (String)"id cannot be null");
        }
        ParamFlowRuleEntity oldEntity = (ParamFlowRuleEntity)this.repository.findById((Object)id);
        if (oldEntity == null) {
            return Result.ofSuccess(null);
        }
        try {
            this.repository.delete((Object)id);
            this.publishRules(oldEntity.getApp(), oldEntity.getIp(), oldEntity.getPort()).get();
            return Result.ofSuccess((Object)id);
        }
        catch (ExecutionException ex) {
            this.logger.error("Error when deleting parameter flow rules", ex.getCause());
            if (this.isNotSupported(ex.getCause())) {
                return this.unsupportedVersion();
            }
            return Result.ofThrowable((int)-1, (Throwable)ex.getCause());
        }
        catch (Throwable throwable) {
            this.logger.error("Error when deleting parameter flow rules", throwable);
            return Result.ofFail((int)-1, (String)throwable.getMessage());
        }
    }

    private CompletableFuture<Void> publishRules(String app, String ip, Integer port) {
        List rules = this.repository.findAllByMachine(MachineInfo.of((String)app, (String)ip, (Integer)port));
        return this.sentinelApiClient.setParamFlowRuleOfMachine(app, ip, port.intValue(), rules);
    }

    private <R> Result<R> unsupportedVersion() {
        return Result.ofFail((int)4041, (String)"Sentinel client not supported for parameter flow control (unsupported version or dependency absent)");
    }
}

