/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.sentinel.dashboard.auth;

import com.alibaba.csp.sentinel.dashboard.auth.AuthAction;
import com.alibaba.csp.sentinel.dashboard.auth.AuthService;
import com.alibaba.csp.sentinel.dashboard.auth.AuthorizationInterceptor;
import com.alibaba.csp.sentinel.dashboard.domain.Result;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import java.io.IOException;
import java.lang.reflect.Method;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.web.method.HandlerMethod;

public class DefaultAuthorizationInterceptor
implements AuthorizationInterceptor {
    private final AuthService<HttpServletRequest> authService;

    public DefaultAuthorizationInterceptor(AuthService<HttpServletRequest> authService) {
        this.authService = authService;
    }

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        Method method;
        AuthAction authAction;
        if (handler.getClass().isAssignableFrom(HandlerMethod.class) && (authAction = (method = ((HandlerMethod)handler).getMethod()).getAnnotation(AuthAction.class)) != null) {
            AuthService.AuthUser authUser = this.authService.getAuthUser((Object)request);
            if (authUser == null) {
                this.responseNoPrivilegeMsg(response, authAction.message());
                return false;
            }
            String target = request.getParameter(authAction.targetName());
            if (!authUser.authTarget(target, authAction.value())) {
                this.responseNoPrivilegeMsg(response, authAction.message());
                return false;
            }
        }
        return true;
    }

    private void responseNoPrivilegeMsg(HttpServletResponse response, String message) throws IOException {
        Result result = Result.ofFail((int)-1, (String)message);
        response.addHeader("Content-Type", "application/json;charset=UTF-8");
        response.getOutputStream().write(JSON.toJSONBytes((Object)result, (SerializerFeature[])new SerializerFeature[0]));
    }
}

