/*
 * Decompiled with CFR 0.152.
 */
package com.mcf.davidee.nbtedit.packets;

import com.mcf.davidee.nbtedit.NBTEdit;
import com.mcf.davidee.nbtedit.NBTHelper;
import com.mcf.davidee.nbtedit.packets.AbstractPacket;
import com.mcf.davidee.nbtedit.packets.TileNBTUpdatePacket;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufInputStream;
import io.netty.buffer.ByteBufOutputStream;
import io.netty.channel.ChannelHandlerContext;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Level;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;

public class TileNBTPacket
extends AbstractPacket {
    protected int x;
    protected int y;
    protected int z;
    protected NBTTagCompound tag;

    public TileNBTPacket() {
    }

    public TileNBTPacket(int x, int y, int z, NBTTagCompound tag) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.tag = tag;
    }

    @Override
    public void encodeInto(ChannelHandlerContext ctx, ByteBuf buffer) throws IOException {
        ByteBufOutputStream bos = new ByteBufOutputStream(buffer);
        bos.writeInt(this.x);
        bos.writeInt(this.y);
        bos.writeInt(this.z);
        NBTHelper.nbtWrite(this.tag, (DataOutput)bos);
    }

    @Override
    public void decodeInto(ChannelHandlerContext ctx, ByteBuf buffer) throws IOException {
        ByteBufInputStream bis = new ByteBufInputStream(buffer);
        DataInputStream nbt = new DataInputStream((InputStream)bis);
        this.x = bis.readInt();
        this.y = bis.readInt();
        this.z = bis.readInt();
        this.tag = NBTHelper.nbtRead(nbt);
    }

    @Override
    public void handleClientSide(EntityPlayer player) {
        NBTEdit.proxy.openEditGUI(this.x, this.y, this.z, this.tag);
    }

    @Override
    public void handleServerSide(EntityPlayerMP player) {
        TileEntity te = player.field_70170_p.func_147438_o(this.x, this.y, this.z);
        if (te != null) {
            try {
                te.func_145839_a(this.tag);
                NBTEdit.DISPATCHER.sendToDimension(new TileNBTUpdatePacket(this.x, this.y, this.z, this.tag), player.field_71093_bK);
                NBTEdit.log(Level.FINE, player.func_70005_c_() + " edited a tag -- Tile Entity at (" + this.x + "," + this.y + "," + this.z + ")");
                NBTEdit.logTag(this.tag);
                this.sendMessageToPlayer((EntityPlayer)player, "Your changes have been saved");
            }
            catch (Throwable t) {
                this.sendMessageToPlayer((EntityPlayer)player, "\u00a7cSave Failed - Invalid NBT format for Tile Entity");
                NBTEdit.log(Level.WARNING, player.func_70005_c_() + " edited a tag and caused an exception");
                NBTEdit.logTag(this.tag);
                NBTEdit.throwing("TileNBTPacket", "handleServerSide", t);
            }
        } else {
            NBTEdit.log(Level.WARNING, player.func_70005_c_() + " tried to edit a non-existant TileEntity at (" + this.x + "," + this.y + "," + this.z + ")");
            this.sendMessageToPlayer((EntityPlayer)player, "\u00a7cSave Failed - There is no TileEntity at (" + this.x + "," + this.y + "," + this.z + ")");
        }
    }
}

