/*
 * Decompiled with CFR 0.152.
 */
package com.mcf.davidee.nbtedit.gui;

import com.mcf.davidee.nbtedit.NBTStringHelper;
import com.mcf.davidee.nbtedit.gui.GuiNBTTree;
import com.mcf.davidee.nbtedit.nbt.NamedNBT;
import com.mcf.davidee.nbtedit.nbt.Node;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;

public class GuiNBTNode
extends Gui {
    public static final ResourceLocation WIDGET_TEXTURE = new ResourceLocation("nbtedit", "textures/gui/widgets.png");
    private Minecraft mc = Minecraft.func_71410_x();
    private Node<NamedNBT> node;
    private GuiNBTTree tree;
    protected int width;
    protected int height;
    protected int x;
    protected int y;
    private String displayString;

    public GuiNBTNode(GuiNBTTree tree, Node<NamedNBT> node, int x, int y) {
        this.tree = tree;
        this.node = node;
        this.x = x;
        this.y = y;
        this.height = this.mc.field_71466_p.field_78288_b;
        this.updateDisplay();
    }

    private boolean inBounds(int mx, int my) {
        return mx >= this.x && my >= this.y && mx < this.width + this.x && my < this.height + this.y;
    }

    private boolean inHideShowBounds(int mx, int my) {
        return mx >= this.x - 9 && my >= this.y && mx < this.x && my < this.y + this.height;
    }

    public boolean shouldDrawChildren() {
        return this.node.shouldDrawChildren();
    }

    public boolean clicked(int mx, int my) {
        return this.inBounds(mx, my);
    }

    public boolean hideShowClicked(int mx, int my) {
        if (this.node.hasChildren() && this.inHideShowBounds(mx, my)) {
            this.node.setDrawChildren(!this.node.shouldDrawChildren());
            return true;
        }
        return false;
    }

    public Node<NamedNBT> getNode() {
        return this.node;
    }

    public void shift(int dy) {
        this.y += dy;
    }

    public void updateDisplay() {
        this.displayString = NBTStringHelper.getNBTNameSpecial(this.node.getObject());
        this.width = this.mc.field_71466_p.func_78256_a(this.displayString) + 12;
    }

    public void draw(int mx, int my) {
        boolean selected = this.tree.getFocused() == this.node;
        boolean hover = this.inBounds(mx, my);
        boolean chHover = this.inHideShowBounds(mx, my);
        int color = selected ? 255 : (hover ? 0xFFFFA0 : (this.node.hasParent() ? 0xE0E0E0 : -6250336));
        this.mc.field_71446_o.func_110577_a(WIDGET_TEXTURE);
        if (selected) {
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            Gui.func_73734_a((int)(this.x + 11), (int)this.y, (int)(this.x + this.width), (int)(this.y + this.height), (int)Integer.MIN_VALUE);
        }
        if (this.node.hasChildren()) {
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            this.func_73729_b(this.x - 9, this.y, this.node.shouldDrawChildren() ? 9 : 0, chHover ? this.height : 0, 9, this.height);
        }
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.func_73729_b(this.x + 1, this.y, (this.node.getObject().getNBT().func_74732_a() - 1) * 9, 18, 9, 9);
        this.func_73731_b(this.mc.field_71466_p, this.displayString, this.x + 11, this.y + (this.height - 8) / 2, color);
    }

    public boolean shouldDraw(int top, int bottom) {
        return this.y + this.height >= top && this.y <= bottom;
    }
}

