/*
 * Decompiled with CFR 0.152.
 */
package com.mcf.davidee.nbtedit.gui;

import com.mcf.davidee.nbtedit.NBTEdit;
import com.mcf.davidee.nbtedit.gui.GuiEditNBT;
import com.mcf.davidee.nbtedit.gui.GuiNBTTree;
import com.mcf.davidee.nbtedit.nbt.NBTTree;
import com.mcf.davidee.nbtedit.packets.EntityNBTPacket;
import com.mcf.davidee.nbtedit.packets.TileNBTPacket;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTTagCompound;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;

public class GuiEditNBTTree
extends GuiScreen {
    public final int entityOrX;
    public final int y;
    public final int z;
    private boolean entity;
    protected String screenTitle;
    private GuiNBTTree guiTree;

    public GuiEditNBTTree(int entity, NBTTagCompound tag) {
        this.entity = true;
        this.entityOrX = entity;
        this.y = 0;
        this.z = 0;
        this.screenTitle = "NBTEdit -- EntityId #" + this.entityOrX;
        this.guiTree = new GuiNBTTree(new NBTTree(tag));
    }

    public GuiEditNBTTree(int x, int y, int z, NBTTagCompound tag) {
        this.entity = false;
        this.entityOrX = x;
        this.y = y;
        this.z = z;
        this.screenTitle = "NBTEdit -- TileEntity at (" + x + "," + y + "," + z + ")";
        this.guiTree = new GuiNBTTree(new NBTTree(tag));
    }

    public void func_73866_w_() {
        Keyboard.enableRepeatEvents((boolean)true);
        this.field_146292_n.clear();
        this.guiTree.initGUI(this.field_146294_l, this.field_146295_m, this.field_146295_m - 35);
        this.field_146292_n.add(new GuiButton(1, this.field_146294_l / 4 - 100, this.field_146295_m - 27, "Save"));
        this.field_146292_n.add(new GuiButton(0, this.field_146294_l * 3 / 4 - 100, this.field_146295_m - 27, "Quit"));
    }

    public void func_146281_b() {
        Keyboard.enableRepeatEvents((boolean)false);
    }

    protected void func_73869_a(char par1, int key) {
        GuiEditNBT window = this.guiTree.getWindow();
        if (window != null) {
            window.keyTyped(par1, key);
        } else if (key == 1) {
            if (this.guiTree.isEditingSlot()) {
                this.guiTree.stopEditingSlot();
            } else {
                this.quitWithoutSaving();
            }
        } else if (key == 211) {
            this.guiTree.deleteSelected();
        } else if (key == 28) {
            this.guiTree.editSelected();
        } else if (key == 200) {
            this.guiTree.arrowKeyPressed(true);
        } else if (key == 208) {
            this.guiTree.arrowKeyPressed(false);
        } else {
            this.guiTree.keyTyped(par1, key);
        }
    }

    protected void func_73864_a(int x, int y, int t) {
        if (this.guiTree.getWindow() == null) {
            super.func_73864_a(x, y, t);
        }
        if (t == 0) {
            this.guiTree.mouseClicked(x, y);
        }
        if (t == 1) {
            this.guiTree.rightClick(x, y);
        }
    }

    public void func_146274_d() {
        super.func_146274_d();
        int ofs = Mouse.getEventDWheel();
        if (ofs != 0) {
            this.guiTree.shift(ofs >= 1 ? 6 : -6);
        }
    }

    protected void func_146284_a(GuiButton b) {
        if (b.field_146124_l) {
            switch (b.field_146127_k) {
                case 1: {
                    this.quitWithSave();
                    break;
                }
                default: {
                    this.quitWithoutSaving();
                }
            }
        }
    }

    public void func_73876_c() {
        if (!this.field_146297_k.field_71439_g.func_70089_S()) {
            this.quitWithoutSaving();
        } else {
            this.guiTree.updateScreen();
        }
    }

    private void quitWithSave() {
        if (this.entity) {
            NBTEdit.DISPATCHER.sendToServer(new EntityNBTPacket(this.entityOrX, this.guiTree.getNBTTree().toNBTTagCompound()));
        } else {
            NBTEdit.DISPATCHER.sendToServer(new TileNBTPacket(this.entityOrX, this.y, this.z, this.guiTree.getNBTTree().toNBTTagCompound()));
        }
        this.field_146297_k.func_147108_a(null);
        this.field_146297_k.func_71381_h();
    }

    private void quitWithoutSaving() {
        this.field_146297_k.func_147108_a(null);
    }

    public void func_73863_a(int x, int y, float par3) {
        this.func_146276_q_();
        this.guiTree.draw(x, y);
        this.func_73732_a(this.field_146297_k.field_71466_p, this.screenTitle, this.field_146294_l / 2, 5, 0xFFFFFF);
        if (this.guiTree.getWindow() == null) {
            super.func_73863_a(x, y, par3);
        } else {
            super.func_73863_a(-1, -1, par3);
        }
    }

    public boolean func_73868_f() {
        return true;
    }

    public Entity getEntity() {
        return this.entity ? this.field_146297_k.field_71441_e.func_73045_a(this.entityOrX) : null;
    }

    public boolean isTileEntity() {
        return !this.entity;
    }

    public int getBlockX() {
        return this.entity ? 0 : this.entityOrX;
    }
}

