# eICU Collaborative Research Database Code Repository [![DOI](https://zenodo.org/badge/DOI/10.5281/zenodo.1249016.svg)](https://doi.org/10.5281/zenodo.1249016)

This is a repository of code shared by the research community. The repository is intended to be a central hub for sharing, refining, and reusing code used for analysis of the [eICU Collaborative Research Database](http://eicu-crd.mit.edu). To find out more about database, please see: http://eicu-crd.mit.edu

## How to contribute

Our team has worked hard to create and share the eICU Collaborative Research Database. We encourage you to share the code that you use for data processing and analysis. Sharing code helps to make studies reproducible and promotes collaborative research. To contribute, please:

- Fork the repository using the following link: https://github.com/mit-lcp/eicu-code/fork. For a background on GitHub forks, see: https://help.github.com/articles/fork-a-repo/
- Commit your changes to the forked repository.
- Submit a pull request to the [eICU code repository](https://github.com/mit-lcp/eicu-code), using the method described at: https://help.github.com/articles/using-pull-requests/

We encourage users to share concepts they have extracted by writing code which generates a materialized view. These materialized views can then be used by researchers around the world to speed up data extraction.

## License

By committing your code to the [eICU Code Repository](https://github.com/mit-lcp/eicu-code) you agree to release the code under the [MIT License attached to the repository](https://github.com/mit-lcp/eicu-code/blob/master/LICENSE).

## Coding style

Please refer to the [style guide](https://github.com/mit-lcp/eicu-code/blob/master/styleguide.md) for guidelines on formatting your code for the repository.
