This is the main ethernet example. 
For the most part, this example shows the following:

1) Hierarchical Sequence.
2) Registers in a sequence.
3) Interrupt Sequence
4) uvm_barrier example
5) UVM event example




*************************************************************
STEPS TO COMPILE AND RUN EXAMPLE
*************************************************************

Note: 
  1) To include the UVM1.2 inbuilt source from VCS installation:
     Inclusion of UVM_HOME can be replaced by -ntb_opts uvm command in Makefile
  2) To use the UVM source other than VCS installation directory:
     Set environment variable VCS_UVM_HOME to the uvm-1.2 installation directory

*************************************************************
Directory Structure of environment generated by UVMGEN
*************************************************************
-EXAMPLE
  	|
       -README.md ( This file)
       |
       -hdl/        ---> includes top module and inclusion of all environment files.
       |
       | - wb_env_top.sv  -- Top level file that instantiates everything
       | - dut.v     -- Dummy DUT
       |
       -env/        ---> includes environment related files (environment, ralenv)
       |  
       | - wb_slave_agent.sv  -- top level slave agent file
       | - wb_master_agent.sv -- top level master agent file
       | - wb_env_env.sv      -- the complete environment
       |
       -include/
       |
       -tests/      ---> includes testbench module and testcases 
       |
       | - wb_env_tb_mod.sv 
       | - wb_env_test.sv
       | - wb_env_test_phase_cb.sv   --- This is the actual test you need to look at 
       |
       -run/        ---> Makefile
	| - Makefile   
	| - simv.log -- run log file
	| - vcs.log  -- compile log file
       -src/        ---> includes Transaction, configurations, driver, monitor, master/slave subenv, scoreboard, coverage related files.
        |common_if.sv
        |eth_base_pkt.sv
        |eth_blk_env_cfg.sv
        |eth_blk_env_cov.sv
        |eth_env_cfg.sv
        |eth_env_cov.sv
        |eth_phy_defines.v
        |eth_test_cfg.sv
        |eth_wrap_top.sv
        |layering  -> see readme. these files are an exercise for you.
        |mac_transaction.sv
        |mii_if.sv   --> MII interface
        |mii_rx_agent.sv  -> ALL MII FILES SEE note below.
        |mii_rx_drv.sv
        |mii_rx_mon.sv
        |mii_rx_seqr.sv
        |mii_scbd.sv
        |mii_transaction.sv
        |mii_tx_agent_sequence_library.sv
        |mii_tx_agent.sv
        |mii_tx_drv.sv
        |mii_tx_mon.sv
        |mii_tx_seqr.sv
        |mon_2cov.sv
        |ral_single.sv
        |reg_bus_adapters.sv
        |wb_config.sv
        |wb_env_cfg.sv
        |wb_env_cov.sv
        |wb_ethernet_mac_sequencer.sv
        |wb_ethernet_mac_sequence.sv
        |wb_eth_mac_hierarchical_seq.sv
        |wb_eth_scoreboard.sv
        |wb_eth_tx_library.sv
        |wb_eth_virt_seqr.sv
        |wb_master_agent_sequence_library.sv
        |wb_master_agent.sv
        |wb_master_behavioral.v
        |wb_master_if.sv
        |wb_master_mon.sv
        |wb_master_seqr.sv
        |wb_master.sv
        |wb_mii_sequence_library.sv
        |wb_model_defines.v
        |wb_package.sv
        |wb_slave_agent_sequence_library.sv
        |wb_slave_agent.sv
        |wb_slave_behavioral.v
        |wb_slave_if.sv
        |wb_slave_mem_mam.sv
        |wb_slave_mon.sv
        |wb_slave.my.sv
        |wb_slave_seqr.sv
        |wb_slave.sv
        |wb_transaction.sv
        |wb_virt_sequence.sv

* All the MII files are basically templates. I am expecting that readers will make a complete environment from
these files
