/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.grid.distributor;

import java.io.UncheckedIOException;
import java.util.Collections;
import java.util.Map;
import org.openqa.selenium.SessionNotCreatedException;
import org.openqa.selenium.grid.data.CreateSessionResponse;
import org.openqa.selenium.grid.data.SessionRequest;
import org.openqa.selenium.grid.distributor.Distributor;
import org.openqa.selenium.internal.Either;
import org.openqa.selenium.internal.Require;
import org.openqa.selenium.remote.http.Contents;
import org.openqa.selenium.remote.http.HttpHandler;
import org.openqa.selenium.remote.http.HttpRequest;
import org.openqa.selenium.remote.http.HttpResponse;

class CreateSession
implements HttpHandler {
    private final Distributor distributor;

    CreateSession(Distributor distributor) {
        this.distributor = Require.nonNull("Distributor", distributor);
    }

    @Override
    public HttpResponse execute(HttpRequest req) throws UncheckedIOException {
        Map<String, Object> value;
        SessionRequest request = (SessionRequest)Contents.fromJson(req, SessionRequest.class);
        Either<SessionNotCreatedException, CreateSessionResponse> result = this.distributor.newSession(request);
        HttpResponse res = new HttpResponse();
        if (result.isLeft()) {
            res.setStatus(500);
            value = Collections.singletonMap("value", result.left());
        } else {
            value = Collections.singletonMap("value", result.right());
        }
        res.setContent(Contents.asJson(value));
        return res;
    }
}

