/*
 * Decompiled with CFR 0.152.
 */
package graphql.execution.directives;

import graphql.Assert;
import graphql.GraphQLContext;
import graphql.Internal;
import graphql.collect.ImmutableKit;
import graphql.com.google.common.collect.BiMap;
import graphql.com.google.common.collect.HashBiMap;
import graphql.com.google.common.collect.ImmutableList;
import graphql.com.google.common.collect.ImmutableMap;
import graphql.execution.CoercedVariables;
import graphql.execution.MergedField;
import graphql.execution.NormalizedVariables;
import graphql.execution.ValuesResolver;
import graphql.execution.directives.DirectivesResolver;
import graphql.execution.directives.QueryAppliedDirective;
import graphql.execution.directives.QueryAppliedDirectiveArgument;
import graphql.execution.directives.QueryDirectives;
import graphql.language.Directive;
import graphql.language.Field;
import graphql.normalized.NormalizedInputValue;
import graphql.schema.GraphQLArgument;
import graphql.schema.GraphQLDirective;
import graphql.schema.GraphQLSchema;
import graphql.util.LockKit;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Supplier;

@Internal
public class QueryDirectivesImpl
implements QueryDirectives {
    private final DirectivesResolver directivesResolver = new DirectivesResolver();
    private final MergedField mergedField;
    private final GraphQLSchema schema;
    private final CoercedVariables coercedVariables;
    private final Supplier<NormalizedVariables> normalizedVariableValues;
    private final GraphQLContext graphQLContext;
    private final Locale locale;
    private final LockKit.ComputedOnce computedOnce = new LockKit.ComputedOnce();
    private volatile ImmutableMap<Field, List<GraphQLDirective>> fieldDirectivesByField;
    private volatile ImmutableMap<String, List<GraphQLDirective>> fieldDirectivesByName;
    private volatile ImmutableMap<Field, List<QueryAppliedDirective>> fieldAppliedDirectivesByField;
    private volatile ImmutableMap<String, List<QueryAppliedDirective>> fieldAppliedDirectivesByName;
    private volatile ImmutableMap<QueryAppliedDirective, Map<String, NormalizedInputValue>> normalizedValuesByAppliedDirective;

    public QueryDirectivesImpl(MergedField mergedField, GraphQLSchema schema, CoercedVariables coercedVariables, Supplier<NormalizedVariables> normalizedVariableValues, GraphQLContext graphQLContext, Locale locale) {
        this.mergedField = Assert.assertNotNull(mergedField);
        this.schema = Assert.assertNotNull(schema);
        this.coercedVariables = Assert.assertNotNull(coercedVariables);
        this.normalizedVariableValues = Assert.assertNotNull(normalizedVariableValues);
        this.graphQLContext = Assert.assertNotNull(graphQLContext);
        this.locale = Assert.assertNotNull(locale);
    }

    private void computeValuesLazily() {
        this.computedOnce.runOnce(() -> {
            LinkedHashMap<Field, List> byField = new LinkedHashMap<Field, List>();
            LinkedHashMap byFieldApplied = new LinkedHashMap();
            HashBiMap directiveCounterParts = HashBiMap.create();
            HashBiMap gqlDirectiveCounterParts = HashBiMap.create();
            BiMap gqlDirectiveCounterPartsInverse = gqlDirectiveCounterParts.inverse();
            this.mergedField.getFields().forEach(field -> {
                List<Directive> directives = field.getDirectives();
                BiMap<GraphQLDirective, Directive> directivesMap = this.directivesResolver.resolveDirectives(directives, this.schema, this.coercedVariables, this.graphQLContext, this.locale);
                directiveCounterParts.putAll(directivesMap);
                ImmutableList<GraphQLDirective> resolvedDirectives = ImmutableList.copyOf(directivesMap.keySet());
                ImmutableList.Builder appliedDirectiveBuilder = ImmutableList.builder();
                for (GraphQLDirective resolvedDirective : resolvedDirectives) {
                    QueryAppliedDirective appliedDirective = this.toAppliedDirective(resolvedDirective);
                    appliedDirectiveBuilder.add(appliedDirective);
                    gqlDirectiveCounterParts.put(resolvedDirective, appliedDirective);
                }
                byField.put((Field)field, resolvedDirectives);
                byFieldApplied.put(field, appliedDirectiveBuilder.build());
            });
            LinkedHashMap byName = new LinkedHashMap();
            LinkedHashMap byNameApplied = new LinkedHashMap();
            byField.forEach((field, directiveList) -> directiveList.forEach(directive -> {
                String name = directive.getName();
                byName.computeIfAbsent(name, k -> new ArrayList()).add(directive);
                QueryAppliedDirective appliedDirective = (QueryAppliedDirective)gqlDirectiveCounterParts.get(directive);
                byNameApplied.computeIfAbsent(name, k -> new ArrayList()).add(appliedDirective);
            }));
            LinkedHashMap normalizedValuesByAppliedDirective = new LinkedHashMap();
            NormalizedVariables normalizedVariableValues = this.normalizedVariableValues.get();
            if (normalizedVariableValues != null) {
                byNameApplied.values().forEach(directiveList -> {
                    for (QueryAppliedDirective queryAppliedDirective : directiveList) {
                        GraphQLDirective graphQLDirective = (GraphQLDirective)gqlDirectiveCounterPartsInverse.get(queryAppliedDirective);
                        Directive directive = (Directive)directiveCounterParts.get(graphQLDirective);
                        if (directive == null) continue;
                        Map<String, NormalizedInputValue> normalizedVariables = normalizedVariableValues.toMap();
                        Map<String, NormalizedInputValue> normalizedArgumentValues = ValuesResolver.getNormalizedArgumentValues(graphQLDirective.getArguments(), directive.getArguments(), normalizedVariables);
                        normalizedValuesByAppliedDirective.put(queryAppliedDirective, normalizedArgumentValues);
                    }
                });
            }
            this.fieldDirectivesByName = ImmutableMap.copyOf(byName);
            this.fieldDirectivesByField = ImmutableMap.copyOf(byField);
            this.fieldAppliedDirectivesByName = ImmutableMap.copyOf(byNameApplied);
            this.fieldAppliedDirectivesByField = ImmutableMap.copyOf(byFieldApplied);
            this.normalizedValuesByAppliedDirective = ImmutableMap.copyOf(normalizedValuesByAppliedDirective);
        });
    }

    private QueryAppliedDirective toAppliedDirective(GraphQLDirective directive) {
        QueryAppliedDirective.Builder builder = QueryAppliedDirective.newDirective();
        builder.name(directive.getName());
        for (GraphQLArgument argument : directive.getArguments()) {
            builder.argument(this.toAppliedArgument(argument));
        }
        return builder.build();
    }

    private QueryAppliedDirectiveArgument toAppliedArgument(GraphQLArgument argument) {
        return ((QueryAppliedDirectiveArgument.Builder)QueryAppliedDirectiveArgument.newArgument().name(argument.getName())).type(argument.getType()).inputValueWithState(argument.getArgumentValue()).build();
    }

    @Override
    public Map<Field, List<GraphQLDirective>> getImmediateDirectivesByField() {
        this.computeValuesLazily();
        return this.fieldDirectivesByField;
    }

    @Override
    public Map<Field, List<QueryAppliedDirective>> getImmediateAppliedDirectivesByField() {
        this.computeValuesLazily();
        return this.fieldAppliedDirectivesByField;
    }

    @Override
    public Map<QueryAppliedDirective, Map<String, NormalizedInputValue>> getNormalizedInputValueByImmediateAppliedDirectives() {
        this.computeValuesLazily();
        return this.normalizedValuesByAppliedDirective;
    }

    @Override
    public Map<String, List<GraphQLDirective>> getImmediateDirectivesByName() {
        this.computeValuesLazily();
        return this.fieldDirectivesByName;
    }

    @Override
    public Map<String, List<QueryAppliedDirective>> getImmediateAppliedDirectivesByName() {
        this.computeValuesLazily();
        return this.fieldAppliedDirectivesByName;
    }

    @Override
    public List<GraphQLDirective> getImmediateDirective(String directiveName) {
        this.computeValuesLazily();
        return this.getImmediateDirectivesByName().getOrDefault(directiveName, ImmutableKit.emptyList());
    }

    @Override
    public List<QueryAppliedDirective> getImmediateAppliedDirective(String directiveName) {
        this.computeValuesLazily();
        return this.getImmediateAppliedDirectivesByName().getOrDefault(directiveName, ImmutableKit.emptyList());
    }
}

