set(program_name ninja)
set(program_version 1.13.1)
set(version_command --version)
if(CMAKE_HOST_WIN32)
    if(DEFINED ENV{PROCESSOR_ARCHITEW6432})
        set(build_arch $ENV{PROCESSOR_ARCHITEW6432})
    else()
        set(build_arch $ENV{PROCESSOR_ARCHITECTURE})
    endif()
    if(build_arch MATCHES "^(ARM|arm)64$")
        set(download_filename "ninja-winarm64-${program_version}.zip")
        set(tool_subdirectory "${program_version}-windows-arm64")
        set(download_urls "https://github.com/ninja-build/ninja/releases/download/v${program_version}/ninja-winarm64.zip")
        set(download_sha512 6a3873522b3397a4d68c6a6c3e389085b81ba5ff20d4f5c289b3974c8bf7169de9cf2c8d9482c2b06846783492620008f486db44c2c651f007b3c335022a472d)
    else()
        set(download_filename "ninja-win-${program_version}.zip")
        set(tool_subdirectory "${program_version}-windows")
        set(download_urls "https://github.com/ninja-build/ninja/releases/download/v${program_version}/ninja-win.zip")
        set(download_sha512 44955ef9e0053036dc316de3693523ce280338c816b445c27fcbe7dd219543b815812662c9082c409b17d823284506faa5b5c3c5f6d3721242dfc73e56d4ec34)
    endif()
elseif(CMAKE_HOST_SYSTEM_NAME STREQUAL "Darwin")
    set(download_filename "ninja-mac-${program_version}.zip")
    set(download_urls "https://github.com/ninja-build/ninja/releases/download/v${program_version}/ninja-mac.zip")
    set(tool_subdirectory "${program_version}-osx")
    set(paths_to_search "${DOWNLOADS}/tools/ninja-${program_version}-osx")
    set(download_sha512 72ce74b57d21bcd50c1d457a304a3f4f88d960631a945f754180153a7e747950bc2e34195d0490d2c298bba2c02f96d5a5925b4096ddb7c86b67d35f7579641f)
elseif(CMAKE_HOST_SYSTEM_NAME STREQUAL "FreeBSD")
    set(paths_to_search "${DOWNLOADS}/tools/${tool_subdirectory}-freebsd")
    set(version_command "")
else()
    vcpkg_execute_in_download_mode(COMMAND "uname" "-m" OUTPUT_VARIABLE HOST_ARCH OUTPUT_STRIP_TRAILING_WHITESPACE)
    if(HOST_ARCH MATCHES "x86_64|amd64|AMD64")
        set(download_filename "ninja-linux-${program_version}.zip")
        set(download_urls "https://github.com/ninja-build/ninja/releases/download/v${program_version}/ninja-linux.zip")
        set(tool_subdirectory "${program_version}-linux")
        set(paths_to_search "${DOWNLOADS}/tools/ninja-${program_version}-linux")
        set(download_sha512 ca4e424c46c12f4e120ab2030edcff8e34cf5db9d05b4364f2d4be10f46e1a29eef64f7b4bf65fb33cd629b3bc3bcb9292341f92953968ef226f44b52959d916)
    elseif(HOST_ARCH MATCHES "arm64|aarch64|ARM64|AARCH64")
        set(download_filename "ninja-linux-aarch64-${program_version}.zip")
        set(download_urls "https://github.com/ninja-build/ninja/releases/download/v${program_version}/ninja-linux-aarch64.zip")
        set(tool_subdirectory "${program_version}-linux-aarch64")
        set(paths_to_search "${DOWNLOADS}/tools/ninja-${program_version}-linux-aarch64")
        set(download_sha512 7cd841409fd2a4f35566ab2f0add75d89d94cfaa5952bc550cf263878469ab8109e36553b66e6422018012a4e9af4c7eaf79c84af1733d061231ce3511e3c98e)
    else()
        set(version_command "") # somewhat hacky way to skip version check and use system binary
    endif()
endif()
