; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; RUN: opt -passes=constraint-elimination -S %s | FileCheck %s

declare void @may_unwind()

define i1 @test_switch_in_block_with_assume(i32 %x) {
; CHECK-LABEL: @test_switch_in_block_with_assume(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    call void @may_unwind()
; CHECK-NEXT:    [[C_1:%.*]] = icmp ult i32 [[X:%.*]], 10
; CHECK-NEXT:    call void @llvm.assume(i1 [[C_1]])
; CHECK-NEXT:    switch i32 0, label [[EXIT_1:%.*]] [
; CHECK-NEXT:    i32 1, label [[EXIT_2:%.*]]
; CHECK-NEXT:    ]
; CHECK:       exit.1:
; CHECK-NEXT:    [[T_1:%.*]] = icmp ult i32 [[X]], 10
; CHECK-NEXT:    [[C_2:%.*]] = icmp ult i32 [[X]], 9
; CHECK-NEXT:    [[RES_1:%.*]] = xor i1 true, [[C_2]]
; CHECK-NEXT:    ret i1 [[RES_1]]
; CHECK:       exit.2:
; CHECK-NEXT:    [[T_2:%.*]] = icmp ult i32 [[X]], 10
; CHECK-NEXT:    [[C_3:%.*]] = icmp ult i32 [[X]], 9
; CHECK-NEXT:    [[RES_2:%.*]] = xor i1 true, [[C_3]]
; CHECK-NEXT:    ret i1 [[RES_2]]
;
entry:
  call void @may_unwind()
  %c.1 = icmp ult i32 %x, 10
  call void @llvm.assume(i1 %c.1)
  switch i32 0, label %exit.1 [
  i32 1, label %exit.2
  ]

exit.1:
  %t.1 = icmp ult i32 %x, 10
  %c.2 = icmp ult i32 %x, 9
  %res.1 = xor i1 %t.1, %c.2
  ret i1 %res.1

exit.2:
  %t.2 = icmp ult i32 %x, 10
  %c.3 = icmp ult i32 %x, 9
  %res.2 = xor i1 %t.2, %c.3
  ret i1 %res.2
}

declare void @llvm.assume(i1)
