// RUN: llvm-mc -arch=amdgcn -mcpu=gfx1100 -show-encoding %s | FileCheck %s --check-prefix=GFX11

image_atomic_add v[1:2], v2, s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_1D unorm
// GFX11: [0x80,0x03,0x30,0xf0,0x02,0x01,0x03,0x00]

image_atomic_add v[1:2], v255, s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_1D unorm
// GFX11: [0x80,0x03,0x30,0xf0,0xff,0x01,0x03,0x00]

image_atomic_add v[1:2], v2, s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_1D unorm a16
// GFX11: [0x80,0x03,0x31,0xf0,0x02,0x01,0x03,0x00]

image_atomic_add v[1:2], v255, s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_1D unorm a16
// GFX11: [0x80,0x03,0x31,0xf0,0xff,0x01,0x03,0x00]

image_atomic_add v[1:2], v[2:4], s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_3D unorm
// GFX11: [0x88,0x03,0x30,0xf0,0x02,0x01,0x03,0x00]

image_atomic_add v[1:2], v[253:255], s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_3D unorm
// GFX11: [0x88,0x03,0x30,0xf0,0xfd,0x01,0x03,0x00]

image_atomic_add v[1:2], v[2:3], s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_3D unorm a16
// GFX11: [0x88,0x03,0x31,0xf0,0x02,0x01,0x03,0x00]

image_atomic_add v[1:2], v[254:255], s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_3D unorm a16
// GFX11: [0x88,0x03,0x31,0xf0,0xfe,0x01,0x03,0x00]

image_atomic_add v[1:2], v[2:5], s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_2D_MSAA_ARRAY unorm
// GFX11: [0x9c,0x03,0x30,0xf0,0x02,0x01,0x03,0x00]

image_atomic_add v[1:2], v[252:255], s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_2D_MSAA_ARRAY unorm
// GFX11: [0x9c,0x03,0x30,0xf0,0xfc,0x01,0x03,0x00]

image_atomic_add v[1:2], v[2:3], s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_2D_MSAA_ARRAY unorm a16
// GFX11: [0x9c,0x03,0x31,0xf0,0x02,0x01,0x03,0x00]

image_atomic_add v[1:2], v[254:255], s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_2D_MSAA_ARRAY unorm a16
// GFX11: [0x9c,0x03,0x31,0xf0,0xfe,0x01,0x03,0x00]

image_atomic_add v[1:2], v[2:3], s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_2D unorm
// GFX11: [0x84,0x03,0x30,0xf0,0x02,0x01,0x03,0x00]

image_atomic_add v[1:2], v[254:255], s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_2D unorm
// GFX11: [0x84,0x03,0x30,0xf0,0xfe,0x01,0x03,0x00]

image_atomic_add v[1:2], v2, s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_2D unorm a16
// GFX11: [0x84,0x03,0x31,0xf0,0x02,0x01,0x03,0x00]

image_atomic_add v[1:2], v255, s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_2D unorm a16
// GFX11: [0x84,0x03,0x31,0xf0,0xff,0x01,0x03,0x00]

image_atomic_add v[1:2], v[2:4], s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_CUBE unorm
// GFX11: [0x8c,0x03,0x30,0xf0,0x02,0x01,0x03,0x00]

image_atomic_add v[1:2], v[253:255], s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_CUBE unorm
// GFX11: [0x8c,0x03,0x30,0xf0,0xfd,0x01,0x03,0x00]

image_atomic_add v[1:2], v[2:3], s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_CUBE unorm a16
// GFX11: [0x8c,0x03,0x31,0xf0,0x02,0x01,0x03,0x00]

image_atomic_add v[1:2], v[254:255], s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_CUBE unorm a16
// GFX11: [0x8c,0x03,0x31,0xf0,0xfe,0x01,0x03,0x00]

image_atomic_add v[1:2], v[2:3], s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_1D_ARRAY unorm
// GFX11: [0x90,0x03,0x30,0xf0,0x02,0x01,0x03,0x00]

image_atomic_add v[1:2], v[254:255], s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_1D_ARRAY unorm
// GFX11: [0x90,0x03,0x30,0xf0,0xfe,0x01,0x03,0x00]

image_atomic_add v[1:2], v2, s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_1D_ARRAY unorm a16
// GFX11: [0x90,0x03,0x31,0xf0,0x02,0x01,0x03,0x00]

image_atomic_add v[1:2], v255, s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_1D_ARRAY unorm a16
// GFX11: [0x90,0x03,0x31,0xf0,0xff,0x01,0x03,0x00]

image_atomic_add v[1:2], v[2:4], s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_2D_ARRAY unorm
// GFX11: [0x94,0x03,0x30,0xf0,0x02,0x01,0x03,0x00]

image_atomic_add v[1:2], v[253:255], s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_2D_ARRAY unorm
// GFX11: [0x94,0x03,0x30,0xf0,0xfd,0x01,0x03,0x00]

image_atomic_add v[1:2], v[2:3], s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_2D_ARRAY unorm a16
// GFX11: [0x94,0x03,0x31,0xf0,0x02,0x01,0x03,0x00]

image_atomic_add v[1:2], v[254:255], s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_2D_ARRAY unorm a16
// GFX11: [0x94,0x03,0x31,0xf0,0xfe,0x01,0x03,0x00]

image_atomic_add v[1:2], v[2:4], s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_2D_MSAA unorm
// GFX11: [0x98,0x03,0x30,0xf0,0x02,0x01,0x03,0x00]

image_atomic_add v[1:2], v[253:255], s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_2D_MSAA unorm
// GFX11: [0x98,0x03,0x30,0xf0,0xfd,0x01,0x03,0x00]

image_atomic_add v[1:2], v[2:3], s[96:103] dmask:0x3 dim:SQ_RSRC_IMG_2D_MSAA unorm a16
// GFX11: [0x98,0x03,0x31,0xf0,0x02,0x01,0x18,0x00]

image_atomic_add v[254:255], v[254:255], ttmp[8:15] dmask:0x3 dim:SQ_RSRC_IMG_2D_MSAA unorm glc slc dlc a16 lwe
// GFX11: [0x98,0x73,0x31,0xf0,0xfe,0xfe,0x5d,0x00]

image_atomic_and v[1:2], v2, s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_1D unorm
// GFX11: [0x80,0x03,0x48,0xf0,0x02,0x01,0x03,0x00]

image_atomic_and v[1:2], v255, s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_1D unorm
// GFX11: [0x80,0x03,0x48,0xf0,0xff,0x01,0x03,0x00]

image_atomic_and v[1:2], v2, s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_1D unorm a16
// GFX11: [0x80,0x03,0x49,0xf0,0x02,0x01,0x03,0x00]

image_atomic_and v[1:2], v255, s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_1D unorm a16
// GFX11: [0x80,0x03,0x49,0xf0,0xff,0x01,0x03,0x00]

image_atomic_and v[1:2], v[2:4], s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_3D unorm
// GFX11: [0x88,0x03,0x48,0xf0,0x02,0x01,0x03,0x00]

image_atomic_and v[1:2], v[253:255], s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_3D unorm
// GFX11: [0x88,0x03,0x48,0xf0,0xfd,0x01,0x03,0x00]

image_atomic_and v[1:2], v[2:3], s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_3D unorm a16
// GFX11: [0x88,0x03,0x49,0xf0,0x02,0x01,0x03,0x00]

image_atomic_and v[1:2], v[254:255], s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_3D unorm a16
// GFX11: [0x88,0x03,0x49,0xf0,0xfe,0x01,0x03,0x00]

image_atomic_and v[1:2], v[2:5], s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_2D_MSAA_ARRAY unorm
// GFX11: [0x9c,0x03,0x48,0xf0,0x02,0x01,0x03,0x00]

image_atomic_and v[1:2], v[252:255], s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_2D_MSAA_ARRAY unorm
// GFX11: [0x9c,0x03,0x48,0xf0,0xfc,0x01,0x03,0x00]

image_atomic_and v[1:2], v[2:3], s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_2D_MSAA_ARRAY unorm a16
// GFX11: [0x9c,0x03,0x49,0xf0,0x02,0x01,0x03,0x00]

image_atomic_and v[1:2], v[254:255], s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_2D_MSAA_ARRAY unorm a16
// GFX11: [0x9c,0x03,0x49,0xf0,0xfe,0x01,0x03,0x00]

image_atomic_and v[1:2], v[2:3], s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_2D unorm
// GFX11: [0x84,0x03,0x48,0xf0,0x02,0x01,0x03,0x00]

image_atomic_and v[1:2], v[254:255], s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_2D unorm
// GFX11: [0x84,0x03,0x48,0xf0,0xfe,0x01,0x03,0x00]

image_atomic_and v[1:2], v2, s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_2D unorm a16
// GFX11: [0x84,0x03,0x49,0xf0,0x02,0x01,0x03,0x00]

image_atomic_and v[1:2], v255, s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_2D unorm a16
// GFX11: [0x84,0x03,0x49,0xf0,0xff,0x01,0x03,0x00]

image_atomic_and v[1:2], v[2:4], s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_CUBE unorm
// GFX11: [0x8c,0x03,0x48,0xf0,0x02,0x01,0x03,0x00]

image_atomic_and v[1:2], v[253:255], s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_CUBE unorm
// GFX11: [0x8c,0x03,0x48,0xf0,0xfd,0x01,0x03,0x00]

image_atomic_and v[1:2], v[2:3], s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_CUBE unorm a16
// GFX11: [0x8c,0x03,0x49,0xf0,0x02,0x01,0x03,0x00]

image_atomic_and v[1:2], v[254:255], s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_CUBE unorm a16
// GFX11: [0x8c,0x03,0x49,0xf0,0xfe,0x01,0x03,0x00]

image_atomic_and v[1:2], v[2:3], s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_1D_ARRAY unorm
// GFX11: [0x90,0x03,0x48,0xf0,0x02,0x01,0x03,0x00]

image_atomic_and v[1:2], v[254:255], s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_1D_ARRAY unorm
// GFX11: [0x90,0x03,0x48,0xf0,0xfe,0x01,0x03,0x00]

image_atomic_and v[1:2], v2, s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_1D_ARRAY unorm a16
// GFX11: [0x90,0x03,0x49,0xf0,0x02,0x01,0x03,0x00]

image_atomic_and v[1:2], v255, s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_1D_ARRAY unorm a16
// GFX11: [0x90,0x03,0x49,0xf0,0xff,0x01,0x03,0x00]

image_atomic_and v[1:2], v[2:4], s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_2D_ARRAY unorm
// GFX11: [0x94,0x03,0x48,0xf0,0x02,0x01,0x03,0x00]

image_atomic_and v[1:2], v[253:255], s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_2D_ARRAY unorm
// GFX11: [0x94,0x03,0x48,0xf0,0xfd,0x01,0x03,0x00]

image_atomic_and v[1:2], v[2:3], s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_2D_ARRAY unorm a16
// GFX11: [0x94,0x03,0x49,0xf0,0x02,0x01,0x03,0x00]

image_atomic_and v[1:2], v[254:255], s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_2D_ARRAY unorm a16
// GFX11: [0x94,0x03,0x49,0xf0,0xfe,0x01,0x03,0x00]

image_atomic_and v[1:2], v[2:4], s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_2D_MSAA unorm
// GFX11: [0x98,0x03,0x48,0xf0,0x02,0x01,0x03,0x00]

image_atomic_and v[1:2], v[253:255], s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_2D_MSAA unorm
// GFX11: [0x98,0x03,0x48,0xf0,0xfd,0x01,0x03,0x00]

image_atomic_and v[1:2], v[2:3], s[96:103] dmask:0x3 dim:SQ_RSRC_IMG_2D_MSAA unorm a16
// GFX11: [0x98,0x03,0x49,0xf0,0x02,0x01,0x18,0x00]

image_atomic_and v[254:255], v[254:255], ttmp[8:15] dmask:0x3 dim:SQ_RSRC_IMG_2D_MSAA unorm glc slc dlc a16 lwe
// GFX11: [0x98,0x73,0x49,0xf0,0xfe,0xfe,0x5d,0x00]

image_atomic_cmpswap v[1:2], v2, s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_1D unorm
// GFX11: [0x80,0x03,0x2c,0xf0,0x02,0x01,0x03,0x00]

image_atomic_cmpswap v[1:2], v255, s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_1D unorm
// GFX11: [0x80,0x03,0x2c,0xf0,0xff,0x01,0x03,0x00]

image_atomic_cmpswap v[1:2], v2, s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_1D unorm a16
// GFX11: [0x80,0x03,0x2d,0xf0,0x02,0x01,0x03,0x00]

image_atomic_cmpswap v[1:2], v255, s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_1D unorm a16
// GFX11: [0x80,0x03,0x2d,0xf0,0xff,0x01,0x03,0x00]

image_atomic_cmpswap v[1:2], v[2:4], s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_3D unorm
// GFX11: [0x88,0x03,0x2c,0xf0,0x02,0x01,0x03,0x00]

image_atomic_cmpswap v[1:2], v[253:255], s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_3D unorm
// GFX11: [0x88,0x03,0x2c,0xf0,0xfd,0x01,0x03,0x00]

image_atomic_cmpswap v[1:2], v[2:3], s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_3D unorm a16
// GFX11: [0x88,0x03,0x2d,0xf0,0x02,0x01,0x03,0x00]

image_atomic_cmpswap v[1:2], v[254:255], s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_3D unorm a16
// GFX11: [0x88,0x03,0x2d,0xf0,0xfe,0x01,0x03,0x00]

image_atomic_cmpswap v[1:2], v[2:5], s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_2D_MSAA_ARRAY unorm
// GFX11: [0x9c,0x03,0x2c,0xf0,0x02,0x01,0x03,0x00]

image_atomic_cmpswap v[1:2], v[252:255], s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_2D_MSAA_ARRAY unorm
// GFX11: [0x9c,0x03,0x2c,0xf0,0xfc,0x01,0x03,0x00]

image_atomic_cmpswap v[1:2], v[2:3], s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_2D_MSAA_ARRAY unorm a16
// GFX11: [0x9c,0x03,0x2d,0xf0,0x02,0x01,0x03,0x00]

image_atomic_cmpswap v[1:2], v[254:255], s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_2D_MSAA_ARRAY unorm a16
// GFX11: [0x9c,0x03,0x2d,0xf0,0xfe,0x01,0x03,0x00]

image_atomic_cmpswap v[1:2], v[2:3], s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_2D unorm
// GFX11: [0x84,0x03,0x2c,0xf0,0x02,0x01,0x03,0x00]

image_atomic_cmpswap v[1:2], v[254:255], s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_2D unorm
// GFX11: [0x84,0x03,0x2c,0xf0,0xfe,0x01,0x03,0x00]

image_atomic_cmpswap v[1:2], v2, s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_2D unorm a16
// GFX11: [0x84,0x03,0x2d,0xf0,0x02,0x01,0x03,0x00]

image_atomic_cmpswap v[1:2], v255, s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_2D unorm a16
// GFX11: [0x84,0x03,0x2d,0xf0,0xff,0x01,0x03,0x00]

image_atomic_cmpswap v[1:2], v[2:4], s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_CUBE unorm
// GFX11: [0x8c,0x03,0x2c,0xf0,0x02,0x01,0x03,0x00]

image_atomic_cmpswap v[1:2], v[253:255], s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_CUBE unorm
// GFX11: [0x8c,0x03,0x2c,0xf0,0xfd,0x01,0x03,0x00]

image_atomic_cmpswap v[1:2], v[2:3], s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_CUBE unorm a16
// GFX11: [0x8c,0x03,0x2d,0xf0,0x02,0x01,0x03,0x00]

image_atomic_cmpswap v[1:2], v[254:255], s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_CUBE unorm a16
// GFX11: [0x8c,0x03,0x2d,0xf0,0xfe,0x01,0x03,0x00]

image_atomic_cmpswap v[1:2], v[2:3], s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_1D_ARRAY unorm
// GFX11: [0x90,0x03,0x2c,0xf0,0x02,0x01,0x03,0x00]

image_atomic_cmpswap v[1:2], v[254:255], s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_1D_ARRAY unorm
// GFX11: [0x90,0x03,0x2c,0xf0,0xfe,0x01,0x03,0x00]

image_atomic_cmpswap v[1:2], v2, s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_1D_ARRAY unorm a16
// GFX11: [0x90,0x03,0x2d,0xf0,0x02,0x01,0x03,0x00]

image_atomic_cmpswap v[1:2], v255, s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_1D_ARRAY unorm a16
// GFX11: [0x90,0x03,0x2d,0xf0,0xff,0x01,0x03,0x00]

image_atomic_cmpswap v[1:2], v[2:4], s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_2D_ARRAY unorm
// GFX11: [0x94,0x03,0x2c,0xf0,0x02,0x01,0x03,0x00]

image_atomic_cmpswap v[1:2], v[253:255], s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_2D_ARRAY unorm
// GFX11: [0x94,0x03,0x2c,0xf0,0xfd,0x01,0x03,0x00]

image_atomic_cmpswap v[1:2], v[2:3], s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_2D_ARRAY unorm a16
// GFX11: [0x94,0x03,0x2d,0xf0,0x02,0x01,0x03,0x00]

image_atomic_cmpswap v[1:2], v[254:255], s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_2D_ARRAY unorm a16
// GFX11: [0x94,0x03,0x2d,0xf0,0xfe,0x01,0x03,0x00]

image_atomic_cmpswap v[1:2], v[2:4], s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_2D_MSAA unorm
// GFX11: [0x98,0x03,0x2c,0xf0,0x02,0x01,0x03,0x00]

image_atomic_cmpswap v[1:2], v[253:255], s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_2D_MSAA unorm
// GFX11: [0x98,0x03,0x2c,0xf0,0xfd,0x01,0x03,0x00]

image_atomic_cmpswap v[1:2], v[2:3], s[96:103] dmask:0x3 dim:SQ_RSRC_IMG_2D_MSAA unorm a16
// GFX11: [0x98,0x03,0x2d,0xf0,0x02,0x01,0x18,0x00]

image_atomic_cmpswap v[254:255], v[254:255], ttmp[8:15] dmask:0x3 dim:SQ_RSRC_IMG_2D_MSAA unorm glc slc dlc a16 lwe
// GFX11: [0x98,0x73,0x2d,0xf0,0xfe,0xfe,0x5d,0x00]

image_atomic_dec v[1:2], v2, s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_1D unorm
// GFX11: [0x80,0x03,0x58,0xf0,0x02,0x01,0x03,0x00]

image_atomic_dec v[1:2], v255, s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_1D unorm
// GFX11: [0x80,0x03,0x58,0xf0,0xff,0x01,0x03,0x00]

image_atomic_dec v[1:2], v2, s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_1D unorm a16
// GFX11: [0x80,0x03,0x59,0xf0,0x02,0x01,0x03,0x00]

image_atomic_dec v[1:2], v255, s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_1D unorm a16
// GFX11: [0x80,0x03,0x59,0xf0,0xff,0x01,0x03,0x00]

image_atomic_dec v[1:2], v[2:4], s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_3D unorm
// GFX11: [0x88,0x03,0x58,0xf0,0x02,0x01,0x03,0x00]

image_atomic_dec v[1:2], v[253:255], s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_3D unorm
// GFX11: [0x88,0x03,0x58,0xf0,0xfd,0x01,0x03,0x00]

image_atomic_dec v[1:2], v[2:3], s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_3D unorm a16
// GFX11: [0x88,0x03,0x59,0xf0,0x02,0x01,0x03,0x00]

image_atomic_dec v[1:2], v[254:255], s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_3D unorm a16
// GFX11: [0x88,0x03,0x59,0xf0,0xfe,0x01,0x03,0x00]

image_atomic_dec v[1:2], v[2:5], s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_2D_MSAA_ARRAY unorm
// GFX11: [0x9c,0x03,0x58,0xf0,0x02,0x01,0x03,0x00]

image_atomic_dec v[1:2], v[252:255], s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_2D_MSAA_ARRAY unorm
// GFX11: [0x9c,0x03,0x58,0xf0,0xfc,0x01,0x03,0x00]

image_atomic_dec v[1:2], v[2:3], s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_2D_MSAA_ARRAY unorm a16
// GFX11: [0x9c,0x03,0x59,0xf0,0x02,0x01,0x03,0x00]

image_atomic_dec v[1:2], v[254:255], s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_2D_MSAA_ARRAY unorm a16
// GFX11: [0x9c,0x03,0x59,0xf0,0xfe,0x01,0x03,0x00]

image_atomic_dec v[1:2], v[2:3], s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_2D unorm
// GFX11: [0x84,0x03,0x58,0xf0,0x02,0x01,0x03,0x00]

image_atomic_dec v[1:2], v[254:255], s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_2D unorm
// GFX11: [0x84,0x03,0x58,0xf0,0xfe,0x01,0x03,0x00]

image_atomic_dec v[1:2], v2, s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_2D unorm a16
// GFX11: [0x84,0x03,0x59,0xf0,0x02,0x01,0x03,0x00]

image_atomic_dec v[1:2], v255, s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_2D unorm a16
// GFX11: [0x84,0x03,0x59,0xf0,0xff,0x01,0x03,0x00]

image_atomic_dec v[1:2], v[2:4], s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_CUBE unorm
// GFX11: [0x8c,0x03,0x58,0xf0,0x02,0x01,0x03,0x00]

image_atomic_dec v[1:2], v[253:255], s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_CUBE unorm
// GFX11: [0x8c,0x03,0x58,0xf0,0xfd,0x01,0x03,0x00]

image_atomic_dec v[1:2], v[2:3], s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_CUBE unorm a16
// GFX11: [0x8c,0x03,0x59,0xf0,0x02,0x01,0x03,0x00]

image_atomic_dec v[1:2], v[254:255], s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_CUBE unorm a16
// GFX11: [0x8c,0x03,0x59,0xf0,0xfe,0x01,0x03,0x00]

image_atomic_dec v[1:2], v[2:3], s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_1D_ARRAY unorm
// GFX11: [0x90,0x03,0x58,0xf0,0x02,0x01,0x03,0x00]

image_atomic_dec v[1:2], v[254:255], s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_1D_ARRAY unorm
// GFX11: [0x90,0x03,0x58,0xf0,0xfe,0x01,0x03,0x00]

image_atomic_dec v[1:2], v2, s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_1D_ARRAY unorm a16
// GFX11: [0x90,0x03,0x59,0xf0,0x02,0x01,0x03,0x00]

image_atomic_dec v[1:2], v255, s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_1D_ARRAY unorm a16
// GFX11: [0x90,0x03,0x59,0xf0,0xff,0x01,0x03,0x00]

image_atomic_dec v[1:2], v[2:4], s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_2D_ARRAY unorm
// GFX11: [0x94,0x03,0x58,0xf0,0x02,0x01,0x03,0x00]

image_atomic_dec v[1:2], v[253:255], s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_2D_ARRAY unorm
// GFX11: [0x94,0x03,0x58,0xf0,0xfd,0x01,0x03,0x00]

image_atomic_dec v[1:2], v[2:3], s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_2D_ARRAY unorm a16
// GFX11: [0x94,0x03,0x59,0xf0,0x02,0x01,0x03,0x00]

image_atomic_dec v[1:2], v[254:255], s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_2D_ARRAY unorm a16
// GFX11: [0x94,0x03,0x59,0xf0,0xfe,0x01,0x03,0x00]

image_atomic_dec v[1:2], v[2:4], s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_2D_MSAA unorm
// GFX11: [0x98,0x03,0x58,0xf0,0x02,0x01,0x03,0x00]

image_atomic_dec v[1:2], v[253:255], s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_2D_MSAA unorm
// GFX11: [0x98,0x03,0x58,0xf0,0xfd,0x01,0x03,0x00]

image_atomic_dec v[1:2], v[2:3], s[96:103] dmask:0x3 dim:SQ_RSRC_IMG_2D_MSAA unorm a16
// GFX11: [0x98,0x03,0x59,0xf0,0x02,0x01,0x18,0x00]

image_atomic_dec v[254:255], v[254:255], ttmp[8:15] dmask:0x3 dim:SQ_RSRC_IMG_2D_MSAA unorm glc slc dlc a16 lwe
// GFX11: [0x98,0x73,0x59,0xf0,0xfe,0xfe,0x5d,0x00]

image_atomic_inc v[1:2], v2, s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_1D unorm
// GFX11: [0x80,0x03,0x54,0xf0,0x02,0x01,0x03,0x00]

image_atomic_inc v[1:2], v255, s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_1D unorm
// GFX11: [0x80,0x03,0x54,0xf0,0xff,0x01,0x03,0x00]

image_atomic_inc v[1:2], v2, s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_1D unorm a16
// GFX11: [0x80,0x03,0x55,0xf0,0x02,0x01,0x03,0x00]

image_atomic_inc v[1:2], v255, s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_1D unorm a16
// GFX11: [0x80,0x03,0x55,0xf0,0xff,0x01,0x03,0x00]

image_atomic_inc v[1:2], v[2:4], s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_3D unorm
// GFX11: [0x88,0x03,0x54,0xf0,0x02,0x01,0x03,0x00]

image_atomic_inc v[1:2], v[253:255], s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_3D unorm
// GFX11: [0x88,0x03,0x54,0xf0,0xfd,0x01,0x03,0x00]

image_atomic_inc v[1:2], v[2:3], s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_3D unorm a16
// GFX11: [0x88,0x03,0x55,0xf0,0x02,0x01,0x03,0x00]

image_atomic_inc v[1:2], v[254:255], s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_3D unorm a16
// GFX11: [0x88,0x03,0x55,0xf0,0xfe,0x01,0x03,0x00]

image_atomic_inc v[1:2], v[2:5], s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_2D_MSAA_ARRAY unorm
// GFX11: [0x9c,0x03,0x54,0xf0,0x02,0x01,0x03,0x00]

image_atomic_inc v[1:2], v[252:255], s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_2D_MSAA_ARRAY unorm
// GFX11: [0x9c,0x03,0x54,0xf0,0xfc,0x01,0x03,0x00]

image_atomic_inc v[1:2], v[2:3], s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_2D_MSAA_ARRAY unorm a16
// GFX11: [0x9c,0x03,0x55,0xf0,0x02,0x01,0x03,0x00]

image_atomic_inc v[1:2], v[254:255], s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_2D_MSAA_ARRAY unorm a16
// GFX11: [0x9c,0x03,0x55,0xf0,0xfe,0x01,0x03,0x00]

image_atomic_inc v[1:2], v[2:3], s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_2D unorm
// GFX11: [0x84,0x03,0x54,0xf0,0x02,0x01,0x03,0x00]

image_atomic_inc v[1:2], v[254:255], s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_2D unorm
// GFX11: [0x84,0x03,0x54,0xf0,0xfe,0x01,0x03,0x00]

image_atomic_inc v[1:2], v2, s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_2D unorm a16
// GFX11: [0x84,0x03,0x55,0xf0,0x02,0x01,0x03,0x00]

image_atomic_inc v[1:2], v255, s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_2D unorm a16
// GFX11: [0x84,0x03,0x55,0xf0,0xff,0x01,0x03,0x00]

image_atomic_inc v[1:2], v[2:4], s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_CUBE unorm
// GFX11: [0x8c,0x03,0x54,0xf0,0x02,0x01,0x03,0x00]

image_atomic_inc v[1:2], v[253:255], s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_CUBE unorm
// GFX11: [0x8c,0x03,0x54,0xf0,0xfd,0x01,0x03,0x00]

image_atomic_inc v[1:2], v[2:3], s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_CUBE unorm a16
// GFX11: [0x8c,0x03,0x55,0xf0,0x02,0x01,0x03,0x00]

image_atomic_inc v[1:2], v[254:255], s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_CUBE unorm a16
// GFX11: [0x8c,0x03,0x55,0xf0,0xfe,0x01,0x03,0x00]

image_atomic_inc v[1:2], v[2:3], s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_1D_ARRAY unorm
// GFX11: [0x90,0x03,0x54,0xf0,0x02,0x01,0x03,0x00]

image_atomic_inc v[1:2], v[254:255], s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_1D_ARRAY unorm
// GFX11: [0x90,0x03,0x54,0xf0,0xfe,0x01,0x03,0x00]

image_atomic_inc v[1:2], v2, s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_1D_ARRAY unorm a16
// GFX11: [0x90,0x03,0x55,0xf0,0x02,0x01,0x03,0x00]

image_atomic_inc v[1:2], v255, s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_1D_ARRAY unorm a16
// GFX11: [0x90,0x03,0x55,0xf0,0xff,0x01,0x03,0x00]

image_atomic_inc v[1:2], v[2:4], s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_2D_ARRAY unorm
// GFX11: [0x94,0x03,0x54,0xf0,0x02,0x01,0x03,0x00]

image_atomic_inc v[1:2], v[253:255], s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_2D_ARRAY unorm
// GFX11: [0x94,0x03,0x54,0xf0,0xfd,0x01,0x03,0x00]

image_atomic_inc v[1:2], v[2:3], s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_2D_ARRAY unorm a16
// GFX11: [0x94,0x03,0x55,0xf0,0x02,0x01,0x03,0x00]

image_atomic_inc v[1:2], v[254:255], s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_2D_ARRAY unorm a16
// GFX11: [0x94,0x03,0x55,0xf0,0xfe,0x01,0x03,0x00]

image_atomic_inc v[1:2], v[2:4], s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_2D_MSAA unorm
// GFX11: [0x98,0x03,0x54,0xf0,0x02,0x01,0x03,0x00]

image_atomic_inc v[1:2], v[253:255], s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_2D_MSAA unorm
// GFX11: [0x98,0x03,0x54,0xf0,0xfd,0x01,0x03,0x00]

image_atomic_inc v[1:2], v[2:3], s[96:103] dmask:0x3 dim:SQ_RSRC_IMG_2D_MSAA unorm a16
// GFX11: [0x98,0x03,0x55,0xf0,0x02,0x01,0x18,0x00]

image_atomic_inc v[254:255], v[254:255], ttmp[8:15] dmask:0x3 dim:SQ_RSRC_IMG_2D_MSAA unorm glc slc dlc a16 lwe
// GFX11: [0x98,0x73,0x55,0xf0,0xfe,0xfe,0x5d,0x00]

image_atomic_or v[1:2], v2, s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_1D unorm
// GFX11: [0x80,0x03,0x4c,0xf0,0x02,0x01,0x03,0x00]

image_atomic_or v[1:2], v255, s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_1D unorm
// GFX11: [0x80,0x03,0x4c,0xf0,0xff,0x01,0x03,0x00]

image_atomic_or v[1:2], v2, s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_1D unorm a16
// GFX11: [0x80,0x03,0x4d,0xf0,0x02,0x01,0x03,0x00]

image_atomic_or v[1:2], v255, s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_1D unorm a16
// GFX11: [0x80,0x03,0x4d,0xf0,0xff,0x01,0x03,0x00]

image_atomic_or v[1:2], v[2:4], s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_3D unorm
// GFX11: [0x88,0x03,0x4c,0xf0,0x02,0x01,0x03,0x00]

image_atomic_or v[1:2], v[253:255], s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_3D unorm
// GFX11: [0x88,0x03,0x4c,0xf0,0xfd,0x01,0x03,0x00]

image_atomic_or v[1:2], v[2:3], s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_3D unorm a16
// GFX11: [0x88,0x03,0x4d,0xf0,0x02,0x01,0x03,0x00]

image_atomic_or v[1:2], v[254:255], s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_3D unorm a16
// GFX11: [0x88,0x03,0x4d,0xf0,0xfe,0x01,0x03,0x00]

image_atomic_or v[1:2], v[2:5], s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_2D_MSAA_ARRAY unorm
// GFX11: [0x9c,0x03,0x4c,0xf0,0x02,0x01,0x03,0x00]

image_atomic_or v[1:2], v[252:255], s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_2D_MSAA_ARRAY unorm
// GFX11: [0x9c,0x03,0x4c,0xf0,0xfc,0x01,0x03,0x00]

image_atomic_or v[1:2], v[2:3], s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_2D_MSAA_ARRAY unorm a16
// GFX11: [0x9c,0x03,0x4d,0xf0,0x02,0x01,0x03,0x00]

image_atomic_or v[1:2], v[254:255], s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_2D_MSAA_ARRAY unorm a16
// GFX11: [0x9c,0x03,0x4d,0xf0,0xfe,0x01,0x03,0x00]

image_atomic_or v[1:2], v[2:3], s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_2D unorm
// GFX11: [0x84,0x03,0x4c,0xf0,0x02,0x01,0x03,0x00]

image_atomic_or v[1:2], v[254:255], s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_2D unorm
// GFX11: [0x84,0x03,0x4c,0xf0,0xfe,0x01,0x03,0x00]

image_atomic_or v[1:2], v2, s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_2D unorm a16
// GFX11: [0x84,0x03,0x4d,0xf0,0x02,0x01,0x03,0x00]

image_atomic_or v[1:2], v255, s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_2D unorm a16
// GFX11: [0x84,0x03,0x4d,0xf0,0xff,0x01,0x03,0x00]

image_atomic_or v[1:2], v[2:4], s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_CUBE unorm
// GFX11: [0x8c,0x03,0x4c,0xf0,0x02,0x01,0x03,0x00]

image_atomic_or v[1:2], v[253:255], s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_CUBE unorm
// GFX11: [0x8c,0x03,0x4c,0xf0,0xfd,0x01,0x03,0x00]

image_atomic_or v[1:2], v[2:3], s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_CUBE unorm a16
// GFX11: [0x8c,0x03,0x4d,0xf0,0x02,0x01,0x03,0x00]

image_atomic_or v[1:2], v[254:255], s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_CUBE unorm a16
// GFX11: [0x8c,0x03,0x4d,0xf0,0xfe,0x01,0x03,0x00]

image_atomic_or v[1:2], v[2:3], s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_1D_ARRAY unorm
// GFX11: [0x90,0x03,0x4c,0xf0,0x02,0x01,0x03,0x00]

image_atomic_or v[1:2], v[254:255], s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_1D_ARRAY unorm
// GFX11: [0x90,0x03,0x4c,0xf0,0xfe,0x01,0x03,0x00]

image_atomic_or v[1:2], v2, s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_1D_ARRAY unorm a16
// GFX11: [0x90,0x03,0x4d,0xf0,0x02,0x01,0x03,0x00]

image_atomic_or v[1:2], v255, s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_1D_ARRAY unorm a16
// GFX11: [0x90,0x03,0x4d,0xf0,0xff,0x01,0x03,0x00]

image_atomic_or v[1:2], v[2:4], s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_2D_ARRAY unorm
// GFX11: [0x94,0x03,0x4c,0xf0,0x02,0x01,0x03,0x00]

image_atomic_or v[1:2], v[253:255], s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_2D_ARRAY unorm
// GFX11: [0x94,0x03,0x4c,0xf0,0xfd,0x01,0x03,0x00]

image_atomic_or v[1:2], v[2:3], s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_2D_ARRAY unorm a16
// GFX11: [0x94,0x03,0x4d,0xf0,0x02,0x01,0x03,0x00]

image_atomic_or v[1:2], v[254:255], s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_2D_ARRAY unorm a16
// GFX11: [0x94,0x03,0x4d,0xf0,0xfe,0x01,0x03,0x00]

image_atomic_or v[1:2], v[2:4], s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_2D_MSAA unorm
// GFX11: [0x98,0x03,0x4c,0xf0,0x02,0x01,0x03,0x00]

image_atomic_or v[1:2], v[253:255], s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_2D_MSAA unorm
// GFX11: [0x98,0x03,0x4c,0xf0,0xfd,0x01,0x03,0x00]

image_atomic_or v[1:2], v[2:3], s[96:103] dmask:0x3 dim:SQ_RSRC_IMG_2D_MSAA unorm a16
// GFX11: [0x98,0x03,0x4d,0xf0,0x02,0x01,0x18,0x00]

image_atomic_or v[254:255], v[254:255], ttmp[8:15] dmask:0x3 dim:SQ_RSRC_IMG_2D_MSAA unorm glc slc dlc a16 lwe
// GFX11: [0x98,0x73,0x4d,0xf0,0xfe,0xfe,0x5d,0x00]

image_atomic_smax v[1:2], v2, s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_1D unorm
// GFX11: [0x80,0x03,0x40,0xf0,0x02,0x01,0x03,0x00]

image_atomic_smax v[1:2], v255, s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_1D unorm
// GFX11: [0x80,0x03,0x40,0xf0,0xff,0x01,0x03,0x00]

image_atomic_smax v[1:2], v2, s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_1D unorm a16
// GFX11: [0x80,0x03,0x41,0xf0,0x02,0x01,0x03,0x00]

image_atomic_smax v[1:2], v255, s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_1D unorm a16
// GFX11: [0x80,0x03,0x41,0xf0,0xff,0x01,0x03,0x00]

image_atomic_smax v[1:2], v[2:4], s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_3D unorm
// GFX11: [0x88,0x03,0x40,0xf0,0x02,0x01,0x03,0x00]

image_atomic_smax v[1:2], v[253:255], s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_3D unorm
// GFX11: [0x88,0x03,0x40,0xf0,0xfd,0x01,0x03,0x00]

image_atomic_smax v[1:2], v[2:3], s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_3D unorm a16
// GFX11: [0x88,0x03,0x41,0xf0,0x02,0x01,0x03,0x00]

image_atomic_smax v[1:2], v[254:255], s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_3D unorm a16
// GFX11: [0x88,0x03,0x41,0xf0,0xfe,0x01,0x03,0x00]

image_atomic_smax v[1:2], v[2:5], s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_2D_MSAA_ARRAY unorm
// GFX11: [0x9c,0x03,0x40,0xf0,0x02,0x01,0x03,0x00]

image_atomic_smax v[1:2], v[252:255], s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_2D_MSAA_ARRAY unorm
// GFX11: [0x9c,0x03,0x40,0xf0,0xfc,0x01,0x03,0x00]

image_atomic_smax v[1:2], v[2:3], s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_2D_MSAA_ARRAY unorm a16
// GFX11: [0x9c,0x03,0x41,0xf0,0x02,0x01,0x03,0x00]

image_atomic_smax v[1:2], v[254:255], s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_2D_MSAA_ARRAY unorm a16
// GFX11: [0x9c,0x03,0x41,0xf0,0xfe,0x01,0x03,0x00]

image_atomic_smax v[1:2], v[2:3], s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_2D unorm
// GFX11: [0x84,0x03,0x40,0xf0,0x02,0x01,0x03,0x00]

image_atomic_smax v[1:2], v[254:255], s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_2D unorm
// GFX11: [0x84,0x03,0x40,0xf0,0xfe,0x01,0x03,0x00]

image_atomic_smax v[1:2], v2, s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_2D unorm a16
// GFX11: [0x84,0x03,0x41,0xf0,0x02,0x01,0x03,0x00]

image_atomic_smax v[1:2], v255, s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_2D unorm a16
// GFX11: [0x84,0x03,0x41,0xf0,0xff,0x01,0x03,0x00]

image_atomic_smax v[1:2], v[2:4], s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_CUBE unorm
// GFX11: [0x8c,0x03,0x40,0xf0,0x02,0x01,0x03,0x00]

image_atomic_smax v[1:2], v[253:255], s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_CUBE unorm
// GFX11: [0x8c,0x03,0x40,0xf0,0xfd,0x01,0x03,0x00]

image_atomic_smax v[1:2], v[2:3], s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_CUBE unorm a16
// GFX11: [0x8c,0x03,0x41,0xf0,0x02,0x01,0x03,0x00]

image_atomic_smax v[1:2], v[254:255], s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_CUBE unorm a16
// GFX11: [0x8c,0x03,0x41,0xf0,0xfe,0x01,0x03,0x00]

image_atomic_smax v[1:2], v[2:3], s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_1D_ARRAY unorm
// GFX11: [0x90,0x03,0x40,0xf0,0x02,0x01,0x03,0x00]

image_atomic_smax v[1:2], v[254:255], s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_1D_ARRAY unorm
// GFX11: [0x90,0x03,0x40,0xf0,0xfe,0x01,0x03,0x00]

image_atomic_smax v[1:2], v2, s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_1D_ARRAY unorm a16
// GFX11: [0x90,0x03,0x41,0xf0,0x02,0x01,0x03,0x00]

image_atomic_smax v[1:2], v255, s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_1D_ARRAY unorm a16
// GFX11: [0x90,0x03,0x41,0xf0,0xff,0x01,0x03,0x00]

image_atomic_smax v[1:2], v[2:4], s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_2D_ARRAY unorm
// GFX11: [0x94,0x03,0x40,0xf0,0x02,0x01,0x03,0x00]

image_atomic_smax v[1:2], v[253:255], s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_2D_ARRAY unorm
// GFX11: [0x94,0x03,0x40,0xf0,0xfd,0x01,0x03,0x00]

image_atomic_smax v[1:2], v[2:3], s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_2D_ARRAY unorm a16
// GFX11: [0x94,0x03,0x41,0xf0,0x02,0x01,0x03,0x00]

image_atomic_smax v[1:2], v[254:255], s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_2D_ARRAY unorm a16
// GFX11: [0x94,0x03,0x41,0xf0,0xfe,0x01,0x03,0x00]

image_atomic_smax v[1:2], v[2:4], s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_2D_MSAA unorm
// GFX11: [0x98,0x03,0x40,0xf0,0x02,0x01,0x03,0x00]

image_atomic_smax v[1:2], v[253:255], s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_2D_MSAA unorm
// GFX11: [0x98,0x03,0x40,0xf0,0xfd,0x01,0x03,0x00]

image_atomic_smax v[1:2], v[2:3], s[96:103] dmask:0x3 dim:SQ_RSRC_IMG_2D_MSAA unorm a16
// GFX11: [0x98,0x03,0x41,0xf0,0x02,0x01,0x18,0x00]

image_atomic_smax v[254:255], v[254:255], ttmp[8:15] dmask:0x3 dim:SQ_RSRC_IMG_2D_MSAA unorm glc slc dlc a16 lwe
// GFX11: [0x98,0x73,0x41,0xf0,0xfe,0xfe,0x5d,0x00]

image_atomic_smin v[1:2], v2, s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_1D unorm
// GFX11: [0x80,0x03,0x38,0xf0,0x02,0x01,0x03,0x00]

image_atomic_smin v[1:2], v255, s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_1D unorm
// GFX11: [0x80,0x03,0x38,0xf0,0xff,0x01,0x03,0x00]

image_atomic_smin v[1:2], v2, s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_1D unorm a16
// GFX11: [0x80,0x03,0x39,0xf0,0x02,0x01,0x03,0x00]

image_atomic_smin v[1:2], v255, s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_1D unorm a16
// GFX11: [0x80,0x03,0x39,0xf0,0xff,0x01,0x03,0x00]

image_atomic_smin v[1:2], v[2:4], s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_3D unorm
// GFX11: [0x88,0x03,0x38,0xf0,0x02,0x01,0x03,0x00]

image_atomic_smin v[1:2], v[253:255], s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_3D unorm
// GFX11: [0x88,0x03,0x38,0xf0,0xfd,0x01,0x03,0x00]

image_atomic_smin v[1:2], v[2:3], s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_3D unorm a16
// GFX11: [0x88,0x03,0x39,0xf0,0x02,0x01,0x03,0x00]

image_atomic_smin v[1:2], v[254:255], s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_3D unorm a16
// GFX11: [0x88,0x03,0x39,0xf0,0xfe,0x01,0x03,0x00]

image_atomic_smin v[1:2], v[2:5], s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_2D_MSAA_ARRAY unorm
// GFX11: [0x9c,0x03,0x38,0xf0,0x02,0x01,0x03,0x00]

image_atomic_smin v[1:2], v[252:255], s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_2D_MSAA_ARRAY unorm
// GFX11: [0x9c,0x03,0x38,0xf0,0xfc,0x01,0x03,0x00]

image_atomic_smin v[1:2], v[2:3], s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_2D_MSAA_ARRAY unorm a16
// GFX11: [0x9c,0x03,0x39,0xf0,0x02,0x01,0x03,0x00]

image_atomic_smin v[1:2], v[254:255], s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_2D_MSAA_ARRAY unorm a16
// GFX11: [0x9c,0x03,0x39,0xf0,0xfe,0x01,0x03,0x00]

image_atomic_smin v[1:2], v[2:3], s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_2D unorm
// GFX11: [0x84,0x03,0x38,0xf0,0x02,0x01,0x03,0x00]

image_atomic_smin v[1:2], v[254:255], s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_2D unorm
// GFX11: [0x84,0x03,0x38,0xf0,0xfe,0x01,0x03,0x00]

image_atomic_smin v[1:2], v2, s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_2D unorm a16
// GFX11: [0x84,0x03,0x39,0xf0,0x02,0x01,0x03,0x00]

image_atomic_smin v[1:2], v255, s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_2D unorm a16
// GFX11: [0x84,0x03,0x39,0xf0,0xff,0x01,0x03,0x00]

image_atomic_smin v[1:2], v[2:4], s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_CUBE unorm
// GFX11: [0x8c,0x03,0x38,0xf0,0x02,0x01,0x03,0x00]

image_atomic_smin v[1:2], v[253:255], s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_CUBE unorm
// GFX11: [0x8c,0x03,0x38,0xf0,0xfd,0x01,0x03,0x00]

image_atomic_smin v[1:2], v[2:3], s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_CUBE unorm a16
// GFX11: [0x8c,0x03,0x39,0xf0,0x02,0x01,0x03,0x00]

image_atomic_smin v[1:2], v[254:255], s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_CUBE unorm a16
// GFX11: [0x8c,0x03,0x39,0xf0,0xfe,0x01,0x03,0x00]

image_atomic_smin v[1:2], v[2:3], s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_1D_ARRAY unorm
// GFX11: [0x90,0x03,0x38,0xf0,0x02,0x01,0x03,0x00]

image_atomic_smin v[1:2], v[254:255], s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_1D_ARRAY unorm
// GFX11: [0x90,0x03,0x38,0xf0,0xfe,0x01,0x03,0x00]

image_atomic_smin v[1:2], v2, s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_1D_ARRAY unorm a16
// GFX11: [0x90,0x03,0x39,0xf0,0x02,0x01,0x03,0x00]

image_atomic_smin v[1:2], v255, s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_1D_ARRAY unorm a16
// GFX11: [0x90,0x03,0x39,0xf0,0xff,0x01,0x03,0x00]

image_atomic_smin v[1:2], v[2:4], s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_2D_ARRAY unorm
// GFX11: [0x94,0x03,0x38,0xf0,0x02,0x01,0x03,0x00]

image_atomic_smin v[1:2], v[253:255], s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_2D_ARRAY unorm
// GFX11: [0x94,0x03,0x38,0xf0,0xfd,0x01,0x03,0x00]

image_atomic_smin v[1:2], v[2:3], s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_2D_ARRAY unorm a16
// GFX11: [0x94,0x03,0x39,0xf0,0x02,0x01,0x03,0x00]

image_atomic_smin v[1:2], v[254:255], s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_2D_ARRAY unorm a16
// GFX11: [0x94,0x03,0x39,0xf0,0xfe,0x01,0x03,0x00]

image_atomic_smin v[1:2], v[2:4], s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_2D_MSAA unorm
// GFX11: [0x98,0x03,0x38,0xf0,0x02,0x01,0x03,0x00]

image_atomic_smin v[1:2], v[253:255], s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_2D_MSAA unorm
// GFX11: [0x98,0x03,0x38,0xf0,0xfd,0x01,0x03,0x00]

image_atomic_smin v[1:2], v[2:3], s[96:103] dmask:0x3 dim:SQ_RSRC_IMG_2D_MSAA unorm a16
// GFX11: [0x98,0x03,0x39,0xf0,0x02,0x01,0x18,0x00]

image_atomic_smin v[254:255], v[254:255], ttmp[8:15] dmask:0x3 dim:SQ_RSRC_IMG_2D_MSAA unorm glc slc dlc a16 lwe
// GFX11: [0x98,0x73,0x39,0xf0,0xfe,0xfe,0x5d,0x00]

image_atomic_sub v[1:2], v2, s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_1D unorm
// GFX11: [0x80,0x03,0x34,0xf0,0x02,0x01,0x03,0x00]

image_atomic_sub v[1:2], v255, s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_1D unorm
// GFX11: [0x80,0x03,0x34,0xf0,0xff,0x01,0x03,0x00]

image_atomic_sub v[1:2], v2, s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_1D unorm a16
// GFX11: [0x80,0x03,0x35,0xf0,0x02,0x01,0x03,0x00]

image_atomic_sub v[1:2], v255, s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_1D unorm a16
// GFX11: [0x80,0x03,0x35,0xf0,0xff,0x01,0x03,0x00]

image_atomic_sub v[1:2], v[2:4], s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_3D unorm
// GFX11: [0x88,0x03,0x34,0xf0,0x02,0x01,0x03,0x00]

image_atomic_sub v[1:2], v[253:255], s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_3D unorm
// GFX11: [0x88,0x03,0x34,0xf0,0xfd,0x01,0x03,0x00]

image_atomic_sub v[1:2], v[2:3], s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_3D unorm a16
// GFX11: [0x88,0x03,0x35,0xf0,0x02,0x01,0x03,0x00]

image_atomic_sub v[1:2], v[254:255], s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_3D unorm a16
// GFX11: [0x88,0x03,0x35,0xf0,0xfe,0x01,0x03,0x00]

image_atomic_sub v[1:2], v[2:5], s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_2D_MSAA_ARRAY unorm
// GFX11: [0x9c,0x03,0x34,0xf0,0x02,0x01,0x03,0x00]

image_atomic_sub v[1:2], v[252:255], s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_2D_MSAA_ARRAY unorm
// GFX11: [0x9c,0x03,0x34,0xf0,0xfc,0x01,0x03,0x00]

image_atomic_sub v[1:2], v[2:3], s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_2D_MSAA_ARRAY unorm a16
// GFX11: [0x9c,0x03,0x35,0xf0,0x02,0x01,0x03,0x00]

image_atomic_sub v[1:2], v[254:255], s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_2D_MSAA_ARRAY unorm a16
// GFX11: [0x9c,0x03,0x35,0xf0,0xfe,0x01,0x03,0x00]

image_atomic_sub v[1:2], v[2:3], s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_2D unorm
// GFX11: [0x84,0x03,0x34,0xf0,0x02,0x01,0x03,0x00]

image_atomic_sub v[1:2], v[254:255], s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_2D unorm
// GFX11: [0x84,0x03,0x34,0xf0,0xfe,0x01,0x03,0x00]

image_atomic_sub v[1:2], v2, s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_2D unorm a16
// GFX11: [0x84,0x03,0x35,0xf0,0x02,0x01,0x03,0x00]

image_atomic_sub v[1:2], v255, s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_2D unorm a16
// GFX11: [0x84,0x03,0x35,0xf0,0xff,0x01,0x03,0x00]

image_atomic_sub v[1:2], v[2:4], s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_CUBE unorm
// GFX11: [0x8c,0x03,0x34,0xf0,0x02,0x01,0x03,0x00]

image_atomic_sub v[1:2], v[253:255], s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_CUBE unorm
// GFX11: [0x8c,0x03,0x34,0xf0,0xfd,0x01,0x03,0x00]

image_atomic_sub v[1:2], v[2:3], s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_CUBE unorm a16
// GFX11: [0x8c,0x03,0x35,0xf0,0x02,0x01,0x03,0x00]

image_atomic_sub v[1:2], v[254:255], s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_CUBE unorm a16
// GFX11: [0x8c,0x03,0x35,0xf0,0xfe,0x01,0x03,0x00]

image_atomic_sub v[1:2], v[2:3], s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_1D_ARRAY unorm
// GFX11: [0x90,0x03,0x34,0xf0,0x02,0x01,0x03,0x00]

image_atomic_sub v[1:2], v[254:255], s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_1D_ARRAY unorm
// GFX11: [0x90,0x03,0x34,0xf0,0xfe,0x01,0x03,0x00]

image_atomic_sub v[1:2], v2, s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_1D_ARRAY unorm a16
// GFX11: [0x90,0x03,0x35,0xf0,0x02,0x01,0x03,0x00]

image_atomic_sub v[1:2], v255, s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_1D_ARRAY unorm a16
// GFX11: [0x90,0x03,0x35,0xf0,0xff,0x01,0x03,0x00]

image_atomic_sub v[1:2], v[2:4], s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_2D_ARRAY unorm
// GFX11: [0x94,0x03,0x34,0xf0,0x02,0x01,0x03,0x00]

image_atomic_sub v[1:2], v[253:255], s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_2D_ARRAY unorm
// GFX11: [0x94,0x03,0x34,0xf0,0xfd,0x01,0x03,0x00]

image_atomic_sub v[1:2], v[2:3], s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_2D_ARRAY unorm a16
// GFX11: [0x94,0x03,0x35,0xf0,0x02,0x01,0x03,0x00]

image_atomic_sub v[1:2], v[254:255], s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_2D_ARRAY unorm a16
// GFX11: [0x94,0x03,0x35,0xf0,0xfe,0x01,0x03,0x00]

image_atomic_sub v[1:2], v[2:4], s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_2D_MSAA unorm
// GFX11: [0x98,0x03,0x34,0xf0,0x02,0x01,0x03,0x00]

image_atomic_sub v[1:2], v[253:255], s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_2D_MSAA unorm
// GFX11: [0x98,0x03,0x34,0xf0,0xfd,0x01,0x03,0x00]

image_atomic_sub v[1:2], v[2:3], s[96:103] dmask:0x3 dim:SQ_RSRC_IMG_2D_MSAA unorm a16
// GFX11: [0x98,0x03,0x35,0xf0,0x02,0x01,0x18,0x00]

image_atomic_sub v[254:255], v[254:255], ttmp[8:15] dmask:0x3 dim:SQ_RSRC_IMG_2D_MSAA unorm glc slc dlc a16 lwe
// GFX11: [0x98,0x73,0x35,0xf0,0xfe,0xfe,0x5d,0x00]

image_atomic_swap v[1:2], v2, s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_1D unorm
// GFX11: [0x80,0x03,0x28,0xf0,0x02,0x01,0x03,0x00]

image_atomic_swap v[1:2], v255, s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_1D unorm
// GFX11: [0x80,0x03,0x28,0xf0,0xff,0x01,0x03,0x00]

image_atomic_swap v[1:2], v2, s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_1D unorm a16
// GFX11: [0x80,0x03,0x29,0xf0,0x02,0x01,0x03,0x00]

image_atomic_swap v[1:2], v255, s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_1D unorm a16
// GFX11: [0x80,0x03,0x29,0xf0,0xff,0x01,0x03,0x00]

image_atomic_swap v[1:2], v[2:4], s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_3D unorm
// GFX11: [0x88,0x03,0x28,0xf0,0x02,0x01,0x03,0x00]

image_atomic_swap v[1:2], v[253:255], s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_3D unorm
// GFX11: [0x88,0x03,0x28,0xf0,0xfd,0x01,0x03,0x00]

image_atomic_swap v[1:2], v[2:3], s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_3D unorm a16
// GFX11: [0x88,0x03,0x29,0xf0,0x02,0x01,0x03,0x00]

image_atomic_swap v[1:2], v[254:255], s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_3D unorm a16
// GFX11: [0x88,0x03,0x29,0xf0,0xfe,0x01,0x03,0x00]

image_atomic_swap v[1:2], v[2:5], s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_2D_MSAA_ARRAY unorm
// GFX11: [0x9c,0x03,0x28,0xf0,0x02,0x01,0x03,0x00]

image_atomic_swap v[1:2], v[252:255], s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_2D_MSAA_ARRAY unorm
// GFX11: [0x9c,0x03,0x28,0xf0,0xfc,0x01,0x03,0x00]

image_atomic_swap v[1:2], v[2:3], s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_2D_MSAA_ARRAY unorm a16
// GFX11: [0x9c,0x03,0x29,0xf0,0x02,0x01,0x03,0x00]

image_atomic_swap v[1:2], v[254:255], s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_2D_MSAA_ARRAY unorm a16
// GFX11: [0x9c,0x03,0x29,0xf0,0xfe,0x01,0x03,0x00]

image_atomic_swap v[1:2], v[2:3], s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_2D unorm
// GFX11: [0x84,0x03,0x28,0xf0,0x02,0x01,0x03,0x00]

image_atomic_swap v[1:2], v[254:255], s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_2D unorm
// GFX11: [0x84,0x03,0x28,0xf0,0xfe,0x01,0x03,0x00]

image_atomic_swap v[1:2], v2, s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_2D unorm a16
// GFX11: [0x84,0x03,0x29,0xf0,0x02,0x01,0x03,0x00]

image_atomic_swap v[1:2], v255, s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_2D unorm a16
// GFX11: [0x84,0x03,0x29,0xf0,0xff,0x01,0x03,0x00]

image_atomic_swap v[1:2], v[2:4], s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_CUBE unorm
// GFX11: [0x8c,0x03,0x28,0xf0,0x02,0x01,0x03,0x00]

image_atomic_swap v[1:2], v[253:255], s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_CUBE unorm
// GFX11: [0x8c,0x03,0x28,0xf0,0xfd,0x01,0x03,0x00]

image_atomic_swap v[1:2], v[2:3], s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_CUBE unorm a16
// GFX11: [0x8c,0x03,0x29,0xf0,0x02,0x01,0x03,0x00]

image_atomic_swap v[1:2], v[254:255], s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_CUBE unorm a16
// GFX11: [0x8c,0x03,0x29,0xf0,0xfe,0x01,0x03,0x00]

image_atomic_swap v[1:2], v[2:3], s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_1D_ARRAY unorm
// GFX11: [0x90,0x03,0x28,0xf0,0x02,0x01,0x03,0x00]

image_atomic_swap v[1:2], v[254:255], s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_1D_ARRAY unorm
// GFX11: [0x90,0x03,0x28,0xf0,0xfe,0x01,0x03,0x00]

image_atomic_swap v[1:2], v2, s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_1D_ARRAY unorm a16
// GFX11: [0x90,0x03,0x29,0xf0,0x02,0x01,0x03,0x00]

image_atomic_swap v[1:2], v255, s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_1D_ARRAY unorm a16
// GFX11: [0x90,0x03,0x29,0xf0,0xff,0x01,0x03,0x00]

image_atomic_swap v[1:2], v[2:4], s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_2D_ARRAY unorm
// GFX11: [0x94,0x03,0x28,0xf0,0x02,0x01,0x03,0x00]

image_atomic_swap v[1:2], v[253:255], s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_2D_ARRAY unorm
// GFX11: [0x94,0x03,0x28,0xf0,0xfd,0x01,0x03,0x00]

image_atomic_swap v[1:2], v[2:3], s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_2D_ARRAY unorm a16
// GFX11: [0x94,0x03,0x29,0xf0,0x02,0x01,0x03,0x00]

image_atomic_swap v[1:2], v[254:255], s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_2D_ARRAY unorm a16
// GFX11: [0x94,0x03,0x29,0xf0,0xfe,0x01,0x03,0x00]

image_atomic_swap v[1:2], v[2:4], s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_2D_MSAA unorm
// GFX11: [0x98,0x03,0x28,0xf0,0x02,0x01,0x03,0x00]

image_atomic_swap v[1:2], v[253:255], s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_2D_MSAA unorm
// GFX11: [0x98,0x03,0x28,0xf0,0xfd,0x01,0x03,0x00]

image_atomic_swap v[1:2], v[2:3], s[96:103] dmask:0x3 dim:SQ_RSRC_IMG_2D_MSAA unorm a16
// GFX11: [0x98,0x03,0x29,0xf0,0x02,0x01,0x18,0x00]

image_atomic_swap v[254:255], v[254:255], ttmp[8:15] dmask:0x3 dim:SQ_RSRC_IMG_2D_MSAA unorm glc slc dlc a16 lwe
// GFX11: [0x98,0x73,0x29,0xf0,0xfe,0xfe,0x5d,0x00]

image_atomic_umax v[1:2], v2, s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_1D unorm
// GFX11: [0x80,0x03,0x44,0xf0,0x02,0x01,0x03,0x00]

image_atomic_umax v[1:2], v255, s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_1D unorm
// GFX11: [0x80,0x03,0x44,0xf0,0xff,0x01,0x03,0x00]

image_atomic_umax v[1:2], v2, s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_1D unorm a16
// GFX11: [0x80,0x03,0x45,0xf0,0x02,0x01,0x03,0x00]

image_atomic_umax v[1:2], v255, s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_1D unorm a16
// GFX11: [0x80,0x03,0x45,0xf0,0xff,0x01,0x03,0x00]

image_atomic_umax v[1:2], v[2:4], s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_3D unorm
// GFX11: [0x88,0x03,0x44,0xf0,0x02,0x01,0x03,0x00]

image_atomic_umax v[1:2], v[253:255], s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_3D unorm
// GFX11: [0x88,0x03,0x44,0xf0,0xfd,0x01,0x03,0x00]

image_atomic_umax v[1:2], v[2:3], s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_3D unorm a16
// GFX11: [0x88,0x03,0x45,0xf0,0x02,0x01,0x03,0x00]

image_atomic_umax v[1:2], v[254:255], s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_3D unorm a16
// GFX11: [0x88,0x03,0x45,0xf0,0xfe,0x01,0x03,0x00]

image_atomic_umax v[1:2], v[2:5], s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_2D_MSAA_ARRAY unorm
// GFX11: [0x9c,0x03,0x44,0xf0,0x02,0x01,0x03,0x00]

image_atomic_umax v[1:2], v[252:255], s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_2D_MSAA_ARRAY unorm
// GFX11: [0x9c,0x03,0x44,0xf0,0xfc,0x01,0x03,0x00]

image_atomic_umax v[1:2], v[2:3], s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_2D_MSAA_ARRAY unorm a16
// GFX11: [0x9c,0x03,0x45,0xf0,0x02,0x01,0x03,0x00]

image_atomic_umax v[1:2], v[254:255], s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_2D_MSAA_ARRAY unorm a16
// GFX11: [0x9c,0x03,0x45,0xf0,0xfe,0x01,0x03,0x00]

image_atomic_umax v[1:2], v[2:3], s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_2D unorm
// GFX11: [0x84,0x03,0x44,0xf0,0x02,0x01,0x03,0x00]

image_atomic_umax v[1:2], v[254:255], s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_2D unorm
// GFX11: [0x84,0x03,0x44,0xf0,0xfe,0x01,0x03,0x00]

image_atomic_umax v[1:2], v2, s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_2D unorm a16
// GFX11: [0x84,0x03,0x45,0xf0,0x02,0x01,0x03,0x00]

image_atomic_umax v[1:2], v255, s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_2D unorm a16
// GFX11: [0x84,0x03,0x45,0xf0,0xff,0x01,0x03,0x00]

image_atomic_umax v[1:2], v[2:4], s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_CUBE unorm
// GFX11: [0x8c,0x03,0x44,0xf0,0x02,0x01,0x03,0x00]

image_atomic_umax v[1:2], v[253:255], s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_CUBE unorm
// GFX11: [0x8c,0x03,0x44,0xf0,0xfd,0x01,0x03,0x00]

image_atomic_umax v[1:2], v[2:3], s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_CUBE unorm a16
// GFX11: [0x8c,0x03,0x45,0xf0,0x02,0x01,0x03,0x00]

image_atomic_umax v[1:2], v[254:255], s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_CUBE unorm a16
// GFX11: [0x8c,0x03,0x45,0xf0,0xfe,0x01,0x03,0x00]

image_atomic_umax v[1:2], v[2:3], s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_1D_ARRAY unorm
// GFX11: [0x90,0x03,0x44,0xf0,0x02,0x01,0x03,0x00]

image_atomic_umax v[1:2], v[254:255], s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_1D_ARRAY unorm
// GFX11: [0x90,0x03,0x44,0xf0,0xfe,0x01,0x03,0x00]

image_atomic_umax v[1:2], v2, s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_1D_ARRAY unorm a16
// GFX11: [0x90,0x03,0x45,0xf0,0x02,0x01,0x03,0x00]

image_atomic_umax v[1:2], v255, s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_1D_ARRAY unorm a16
// GFX11: [0x90,0x03,0x45,0xf0,0xff,0x01,0x03,0x00]

image_atomic_umax v[1:2], v[2:4], s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_2D_ARRAY unorm
// GFX11: [0x94,0x03,0x44,0xf0,0x02,0x01,0x03,0x00]

image_atomic_umax v[1:2], v[253:255], s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_2D_ARRAY unorm
// GFX11: [0x94,0x03,0x44,0xf0,0xfd,0x01,0x03,0x00]

image_atomic_umax v[1:2], v[2:3], s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_2D_ARRAY unorm a16
// GFX11: [0x94,0x03,0x45,0xf0,0x02,0x01,0x03,0x00]

image_atomic_umax v[1:2], v[254:255], s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_2D_ARRAY unorm a16
// GFX11: [0x94,0x03,0x45,0xf0,0xfe,0x01,0x03,0x00]

image_atomic_umax v[1:2], v[2:4], s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_2D_MSAA unorm
// GFX11: [0x98,0x03,0x44,0xf0,0x02,0x01,0x03,0x00]

image_atomic_umax v[1:2], v[253:255], s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_2D_MSAA unorm
// GFX11: [0x98,0x03,0x44,0xf0,0xfd,0x01,0x03,0x00]

image_atomic_umax v[1:2], v[2:3], s[96:103] dmask:0x3 dim:SQ_RSRC_IMG_2D_MSAA unorm a16
// GFX11: [0x98,0x03,0x45,0xf0,0x02,0x01,0x18,0x00]

image_atomic_umax v[254:255], v[254:255], ttmp[8:15] dmask:0x3 dim:SQ_RSRC_IMG_2D_MSAA unorm glc slc dlc a16 lwe
// GFX11: [0x98,0x73,0x45,0xf0,0xfe,0xfe,0x5d,0x00]

image_atomic_umin v[1:2], v2, s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_1D unorm
// GFX11: [0x80,0x03,0x3c,0xf0,0x02,0x01,0x03,0x00]

image_atomic_umin v[1:2], v255, s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_1D unorm
// GFX11: [0x80,0x03,0x3c,0xf0,0xff,0x01,0x03,0x00]

image_atomic_umin v[1:2], v2, s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_1D unorm a16
// GFX11: [0x80,0x03,0x3d,0xf0,0x02,0x01,0x03,0x00]

image_atomic_umin v[1:2], v255, s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_1D unorm a16
// GFX11: [0x80,0x03,0x3d,0xf0,0xff,0x01,0x03,0x00]

image_atomic_umin v[1:2], v[2:4], s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_3D unorm
// GFX11: [0x88,0x03,0x3c,0xf0,0x02,0x01,0x03,0x00]

image_atomic_umin v[1:2], v[253:255], s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_3D unorm
// GFX11: [0x88,0x03,0x3c,0xf0,0xfd,0x01,0x03,0x00]

image_atomic_umin v[1:2], v[2:3], s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_3D unorm a16
// GFX11: [0x88,0x03,0x3d,0xf0,0x02,0x01,0x03,0x00]

image_atomic_umin v[1:2], v[254:255], s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_3D unorm a16
// GFX11: [0x88,0x03,0x3d,0xf0,0xfe,0x01,0x03,0x00]

image_atomic_umin v[1:2], v[2:5], s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_2D_MSAA_ARRAY unorm
// GFX11: [0x9c,0x03,0x3c,0xf0,0x02,0x01,0x03,0x00]

image_atomic_umin v[1:2], v[252:255], s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_2D_MSAA_ARRAY unorm
// GFX11: [0x9c,0x03,0x3c,0xf0,0xfc,0x01,0x03,0x00]

image_atomic_umin v[1:2], v[2:3], s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_2D_MSAA_ARRAY unorm a16
// GFX11: [0x9c,0x03,0x3d,0xf0,0x02,0x01,0x03,0x00]

image_atomic_umin v[1:2], v[254:255], s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_2D_MSAA_ARRAY unorm a16
// GFX11: [0x9c,0x03,0x3d,0xf0,0xfe,0x01,0x03,0x00]

image_atomic_umin v[1:2], v[2:3], s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_2D unorm
// GFX11: [0x84,0x03,0x3c,0xf0,0x02,0x01,0x03,0x00]

image_atomic_umin v[1:2], v[254:255], s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_2D unorm
// GFX11: [0x84,0x03,0x3c,0xf0,0xfe,0x01,0x03,0x00]

image_atomic_umin v[1:2], v2, s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_2D unorm a16
// GFX11: [0x84,0x03,0x3d,0xf0,0x02,0x01,0x03,0x00]

image_atomic_umin v[1:2], v255, s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_2D unorm a16
// GFX11: [0x84,0x03,0x3d,0xf0,0xff,0x01,0x03,0x00]

image_atomic_umin v[1:2], v[2:4], s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_CUBE unorm
// GFX11: [0x8c,0x03,0x3c,0xf0,0x02,0x01,0x03,0x00]

image_atomic_umin v[1:2], v[253:255], s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_CUBE unorm
// GFX11: [0x8c,0x03,0x3c,0xf0,0xfd,0x01,0x03,0x00]

image_atomic_umin v[1:2], v[2:3], s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_CUBE unorm a16
// GFX11: [0x8c,0x03,0x3d,0xf0,0x02,0x01,0x03,0x00]

image_atomic_umin v[1:2], v[254:255], s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_CUBE unorm a16
// GFX11: [0x8c,0x03,0x3d,0xf0,0xfe,0x01,0x03,0x00]

image_atomic_umin v[1:2], v[2:3], s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_1D_ARRAY unorm
// GFX11: [0x90,0x03,0x3c,0xf0,0x02,0x01,0x03,0x00]

image_atomic_umin v[1:2], v[254:255], s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_1D_ARRAY unorm
// GFX11: [0x90,0x03,0x3c,0xf0,0xfe,0x01,0x03,0x00]

image_atomic_umin v[1:2], v2, s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_1D_ARRAY unorm a16
// GFX11: [0x90,0x03,0x3d,0xf0,0x02,0x01,0x03,0x00]

image_atomic_umin v[1:2], v255, s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_1D_ARRAY unorm a16
// GFX11: [0x90,0x03,0x3d,0xf0,0xff,0x01,0x03,0x00]

image_atomic_umin v[1:2], v[2:4], s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_2D_ARRAY unorm
// GFX11: [0x94,0x03,0x3c,0xf0,0x02,0x01,0x03,0x00]

image_atomic_umin v[1:2], v[253:255], s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_2D_ARRAY unorm
// GFX11: [0x94,0x03,0x3c,0xf0,0xfd,0x01,0x03,0x00]

image_atomic_umin v[1:2], v[2:3], s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_2D_ARRAY unorm a16
// GFX11: [0x94,0x03,0x3d,0xf0,0x02,0x01,0x03,0x00]

image_atomic_umin v[1:2], v[254:255], s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_2D_ARRAY unorm a16
// GFX11: [0x94,0x03,0x3d,0xf0,0xfe,0x01,0x03,0x00]

image_atomic_umin v[1:2], v[2:4], s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_2D_MSAA unorm
// GFX11: [0x98,0x03,0x3c,0xf0,0x02,0x01,0x03,0x00]

image_atomic_umin v[1:2], v[253:255], s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_2D_MSAA unorm
// GFX11: [0x98,0x03,0x3c,0xf0,0xfd,0x01,0x03,0x00]

image_atomic_umin v[1:2], v[2:3], s[96:103] dmask:0x3 dim:SQ_RSRC_IMG_2D_MSAA unorm a16
// GFX11: [0x98,0x03,0x3d,0xf0,0x02,0x01,0x18,0x00]

image_atomic_umin v[254:255], v[254:255], ttmp[8:15] dmask:0x3 dim:SQ_RSRC_IMG_2D_MSAA unorm glc slc dlc a16 lwe
// GFX11: [0x98,0x73,0x3d,0xf0,0xfe,0xfe,0x5d,0x00]

image_atomic_xor v[1:2], v2, s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_1D unorm
// GFX11: [0x80,0x03,0x50,0xf0,0x02,0x01,0x03,0x00]

image_atomic_xor v[1:2], v255, s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_1D unorm
// GFX11: [0x80,0x03,0x50,0xf0,0xff,0x01,0x03,0x00]

image_atomic_xor v[1:2], v2, s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_1D unorm a16
// GFX11: [0x80,0x03,0x51,0xf0,0x02,0x01,0x03,0x00]

image_atomic_xor v[1:2], v255, s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_1D unorm a16
// GFX11: [0x80,0x03,0x51,0xf0,0xff,0x01,0x03,0x00]

image_atomic_xor v[1:2], v[2:4], s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_3D unorm
// GFX11: [0x88,0x03,0x50,0xf0,0x02,0x01,0x03,0x00]

image_atomic_xor v[1:2], v[253:255], s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_3D unorm
// GFX11: [0x88,0x03,0x50,0xf0,0xfd,0x01,0x03,0x00]

image_atomic_xor v[1:2], v[2:3], s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_3D unorm a16
// GFX11: [0x88,0x03,0x51,0xf0,0x02,0x01,0x03,0x00]

image_atomic_xor v[1:2], v[254:255], s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_3D unorm a16
// GFX11: [0x88,0x03,0x51,0xf0,0xfe,0x01,0x03,0x00]

image_atomic_xor v[1:2], v[2:5], s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_2D_MSAA_ARRAY unorm
// GFX11: [0x9c,0x03,0x50,0xf0,0x02,0x01,0x03,0x00]

image_atomic_xor v[1:2], v[252:255], s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_2D_MSAA_ARRAY unorm
// GFX11: [0x9c,0x03,0x50,0xf0,0xfc,0x01,0x03,0x00]

image_atomic_xor v[1:2], v[2:3], s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_2D_MSAA_ARRAY unorm a16
// GFX11: [0x9c,0x03,0x51,0xf0,0x02,0x01,0x03,0x00]

image_atomic_xor v[1:2], v[254:255], s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_2D_MSAA_ARRAY unorm a16
// GFX11: [0x9c,0x03,0x51,0xf0,0xfe,0x01,0x03,0x00]

image_atomic_xor v[1:2], v[2:3], s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_2D unorm
// GFX11: [0x84,0x03,0x50,0xf0,0x02,0x01,0x03,0x00]

image_atomic_xor v[1:2], v[254:255], s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_2D unorm
// GFX11: [0x84,0x03,0x50,0xf0,0xfe,0x01,0x03,0x00]

image_atomic_xor v[1:2], v2, s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_2D unorm a16
// GFX11: [0x84,0x03,0x51,0xf0,0x02,0x01,0x03,0x00]

image_atomic_xor v[1:2], v255, s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_2D unorm a16
// GFX11: [0x84,0x03,0x51,0xf0,0xff,0x01,0x03,0x00]

image_atomic_xor v[1:2], v[2:4], s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_CUBE unorm
// GFX11: [0x8c,0x03,0x50,0xf0,0x02,0x01,0x03,0x00]

image_atomic_xor v[1:2], v[253:255], s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_CUBE unorm
// GFX11: [0x8c,0x03,0x50,0xf0,0xfd,0x01,0x03,0x00]

image_atomic_xor v[1:2], v[2:3], s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_CUBE unorm a16
// GFX11: [0x8c,0x03,0x51,0xf0,0x02,0x01,0x03,0x00]

image_atomic_xor v[1:2], v[254:255], s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_CUBE unorm a16
// GFX11: [0x8c,0x03,0x51,0xf0,0xfe,0x01,0x03,0x00]

image_atomic_xor v[1:2], v[2:3], s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_1D_ARRAY unorm
// GFX11: [0x90,0x03,0x50,0xf0,0x02,0x01,0x03,0x00]

image_atomic_xor v[1:2], v[254:255], s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_1D_ARRAY unorm
// GFX11: [0x90,0x03,0x50,0xf0,0xfe,0x01,0x03,0x00]

image_atomic_xor v[1:2], v2, s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_1D_ARRAY unorm a16
// GFX11: [0x90,0x03,0x51,0xf0,0x02,0x01,0x03,0x00]

image_atomic_xor v[1:2], v255, s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_1D_ARRAY unorm a16
// GFX11: [0x90,0x03,0x51,0xf0,0xff,0x01,0x03,0x00]

image_atomic_xor v[1:2], v[2:4], s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_2D_ARRAY unorm
// GFX11: [0x94,0x03,0x50,0xf0,0x02,0x01,0x03,0x00]

image_atomic_xor v[1:2], v[253:255], s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_2D_ARRAY unorm
// GFX11: [0x94,0x03,0x50,0xf0,0xfd,0x01,0x03,0x00]

image_atomic_xor v[1:2], v[2:3], s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_2D_ARRAY unorm a16
// GFX11: [0x94,0x03,0x51,0xf0,0x02,0x01,0x03,0x00]

image_atomic_xor v[1:2], v[254:255], s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_2D_ARRAY unorm a16
// GFX11: [0x94,0x03,0x51,0xf0,0xfe,0x01,0x03,0x00]

image_atomic_xor v[1:2], v[2:4], s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_2D_MSAA unorm
// GFX11: [0x98,0x03,0x50,0xf0,0x02,0x01,0x03,0x00]

image_atomic_xor v[1:2], v[253:255], s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_2D_MSAA unorm
// GFX11: [0x98,0x03,0x50,0xf0,0xfd,0x01,0x03,0x00]

image_atomic_xor v[1:2], v[2:3], s[96:103] dmask:0x3 dim:SQ_RSRC_IMG_2D_MSAA unorm a16
// GFX11: [0x98,0x03,0x51,0xf0,0x02,0x01,0x18,0x00]

image_atomic_xor v[254:255], v[254:255], ttmp[8:15] dmask:0x3 dim:SQ_RSRC_IMG_2D_MSAA unorm glc slc dlc a16 lwe
// GFX11: [0x98,0x73,0x51,0xf0,0xfe,0xfe,0x5d,0x00]

image_bvh64_intersect_ray v[5:8], v[1:12], s[8:11]
// GFX11: [0x80,0x8f,0x68,0xf0,0x01,0x05,0x02,0x00]

image_bvh64_intersect_ray v[5:8], v[244:255], s[8:11]
// GFX11: [0x80,0x8f,0x68,0xf0,0xf4,0x05,0x02,0x00]

image_bvh64_intersect_ray v[5:8], v[1:9], s[100:103] a16
// GFX11: [0x80,0x8f,0x69,0xf0,0x01,0x05,0x19,0x00]

image_bvh64_intersect_ray v[252:255], v[247:255], ttmp[12:15] a16
// GFX11: [0x80,0x8f,0x69,0xf0,0xf7,0xfc,0x1e,0x00]

image_bvh_intersect_ray v[5:8], v[1:11], s[8:11]
// GFX11: [0x80,0x8f,0x64,0xf0,0x01,0x05,0x02,0x00]

image_bvh_intersect_ray v[5:8], v[245:255], s[8:11]
// GFX11: [0x80,0x8f,0x64,0xf0,0xf5,0x05,0x02,0x00]

image_bvh_intersect_ray v[5:8], v[1:8], s[100:103] a16
// GFX11: [0x80,0x8f,0x65,0xf0,0x01,0x05,0x19,0x00]

image_bvh_intersect_ray v[252:255], v[248:255], ttmp[12:15] a16
// GFX11: [0x80,0x8f,0x65,0xf0,0xf8,0xfc,0x1e,0x00]

image_gather4 v[5:8], v[1:2], s[8:15], s[12:15] dmask:0x4 dim:SQ_RSRC_IMG_2D
// GFX11: [0x04,0x04,0xbc,0xf0,0x01,0x05,0x02,0x0c]

image_gather4 v[5:8], v[254:255], s[8:15], s[12:15] dmask:0x4 dim:SQ_RSRC_IMG_2D
// GFX11: [0x04,0x04,0xbc,0xf0,0xfe,0x05,0x02,0x0c]

image_gather4 v[5:8], v1, s[8:15], s[12:15] dmask:0x4 dim:SQ_RSRC_IMG_2D a16
// GFX11: [0x04,0x04,0xbd,0xf0,0x01,0x05,0x02,0x0c]

image_gather4 v[5:8], v255, s[8:15], s[12:15] dmask:0x4 dim:SQ_RSRC_IMG_2D a16
// GFX11: [0x04,0x04,0xbd,0xf0,0xff,0x05,0x02,0x0c]

image_gather4 v[5:8], v[1:3], s[8:15], s[12:15] dmask:0x4 dim:SQ_RSRC_IMG_CUBE
// GFX11: [0x0c,0x04,0xbc,0xf0,0x01,0x05,0x02,0x0c]

image_gather4 v[5:8], v[253:255], s[8:15], s[12:15] dmask:0x4 dim:SQ_RSRC_IMG_CUBE
// GFX11: [0x0c,0x04,0xbc,0xf0,0xfd,0x05,0x02,0x0c]

image_gather4 v[5:8], v[1:2], s[8:15], s[12:15] dmask:0x4 dim:SQ_RSRC_IMG_CUBE a16
// GFX11: [0x0c,0x04,0xbd,0xf0,0x01,0x05,0x02,0x0c]

image_gather4 v[5:8], v[254:255], s[8:15], s[12:15] dmask:0x4 dim:SQ_RSRC_IMG_CUBE a16
// GFX11: [0x0c,0x04,0xbd,0xf0,0xfe,0x05,0x02,0x0c]

image_gather4 v[5:8], v[1:3], s[8:15], s[12:15] dmask:0x4 dim:SQ_RSRC_IMG_2D_ARRAY
// GFX11: [0x14,0x04,0xbc,0xf0,0x01,0x05,0x02,0x0c]

image_gather4 v[252:255], v[253:255], s[8:15], s[12:15] dmask:0x4 dim:SQ_RSRC_IMG_2D_ARRAY
// GFX11: [0x14,0x04,0xbc,0xf0,0xfd,0xfc,0x02,0x0c]

image_gather4 v[5:6], v[1:2], s[96:103], s[100:103] dmask:0x4 dim:SQ_RSRC_IMG_2D_ARRAY a16 d16
// GFX11: [0x14,0x04,0xbf,0xf0,0x01,0x05,0x18,0x64]

image_gather4 v[254:255], v[254:255], ttmp[8:15], ttmp[12:15] dmask:0x4 dim:SQ_RSRC_IMG_2D_ARRAY unorm glc slc dlc a16 lwe d16
// GFX11: [0x94,0x74,0xbf,0xf0,0xfe,0xfe,0x5d,0x78]

image_gather4_b v[5:8], v[1:3], s[8:15], s[12:15] dmask:0x4 dim:SQ_RSRC_IMG_2D
// GFX11: [0x04,0x04,0xc4,0xf0,0x01,0x05,0x02,0x0c]

image_gather4_b v[5:8], v[253:255], s[8:15], s[12:15] dmask:0x4 dim:SQ_RSRC_IMG_2D
// GFX11: [0x04,0x04,0xc4,0xf0,0xfd,0x05,0x02,0x0c]

image_gather4_b v[5:8], v[1:4], s[8:15], s[12:15] dmask:0x4 dim:SQ_RSRC_IMG_CUBE
// GFX11: [0x0c,0x04,0xc4,0xf0,0x01,0x05,0x02,0x0c]

image_gather4_b v[252:255], v[252:255], s[8:15], s[12:15] dmask:0x4 dim:SQ_RSRC_IMG_CUBE
// GFX11: [0x0c,0x04,0xc4,0xf0,0xfc,0xfc,0x02,0x0c]

image_gather4_b v[5:6], v[1:4], s[96:103], s[100:103] dmask:0x4 dim:SQ_RSRC_IMG_2D_ARRAY d16
// GFX11: [0x14,0x04,0xc6,0xf0,0x01,0x05,0x18,0x64]

image_gather4_b v[254:255], v[252:255], ttmp[8:15], ttmp[12:15] dmask:0x4 dim:SQ_RSRC_IMG_2D_ARRAY unorm glc slc dlc lwe d16
// GFX11: [0x94,0x74,0xc6,0xf0,0xfc,0xfe,0x5d,0x78]

image_gather4_b_cl v[5:8], v[1:4], s[8:15], s[12:15] dmask:0x4 dim:SQ_RSRC_IMG_2D
// GFX11: [0x04,0x04,0x84,0xf1,0x01,0x05,0x02,0x0c]

image_gather4_b_cl v[5:8], v[252:255], s[8:15], s[12:15] dmask:0x4 dim:SQ_RSRC_IMG_2D
// GFX11: [0x04,0x04,0x84,0xf1,0xfc,0x05,0x02,0x0c]

image_gather4_b_cl v[5:8], v[1:5], s[8:15], s[12:15] dmask:0x4 dim:SQ_RSRC_IMG_CUBE
// GFX11: [0x0c,0x04,0x84,0xf1,0x01,0x05,0x02,0x0c]

image_gather4_b_cl v[252:255], v[251:255], s[8:15], s[12:15] dmask:0x4 dim:SQ_RSRC_IMG_CUBE
// GFX11: [0x0c,0x04,0x84,0xf1,0xfb,0xfc,0x02,0x0c]

image_gather4_b_cl v[5:6], v[1:5], s[96:103], s[100:103] dmask:0x4 dim:SQ_RSRC_IMG_2D_ARRAY d16
// GFX11: [0x14,0x04,0x86,0xf1,0x01,0x05,0x18,0x64]

image_gather4_b_cl v[254:255], v[251:255], ttmp[8:15], ttmp[12:15] dmask:0x4 dim:SQ_RSRC_IMG_2D_ARRAY unorm glc slc dlc lwe d16
// GFX11: [0x94,0x74,0x86,0xf1,0xfb,0xfe,0x5d,0x78]

image_gather4_c v[5:8], v[1:3], s[8:15], s[12:15] dmask:0x4 dim:SQ_RSRC_IMG_2D
// GFX11: [0x04,0x04,0xcc,0xf0,0x01,0x05,0x02,0x0c]

image_gather4_c v[5:8], v[253:255], s[8:15], s[12:15] dmask:0x4 dim:SQ_RSRC_IMG_2D
// GFX11: [0x04,0x04,0xcc,0xf0,0xfd,0x05,0x02,0x0c]

image_gather4_c v[5:8], v[1:2], s[8:15], s[12:15] dmask:0x4 dim:SQ_RSRC_IMG_2D a16
// GFX11: [0x04,0x04,0xcd,0xf0,0x01,0x05,0x02,0x0c]

image_gather4_c v[5:8], v[254:255], s[8:15], s[12:15] dmask:0x4 dim:SQ_RSRC_IMG_2D a16
// GFX11: [0x04,0x04,0xcd,0xf0,0xfe,0x05,0x02,0x0c]

image_gather4_c v[5:8], v[1:4], s[8:15], s[12:15] dmask:0x4 dim:SQ_RSRC_IMG_CUBE
// GFX11: [0x0c,0x04,0xcc,0xf0,0x01,0x05,0x02,0x0c]

image_gather4_c v[5:8], v[252:255], s[8:15], s[12:15] dmask:0x4 dim:SQ_RSRC_IMG_CUBE
// GFX11: [0x0c,0x04,0xcc,0xf0,0xfc,0x05,0x02,0x0c]

image_gather4_c v[5:8], v[1:3], s[8:15], s[12:15] dmask:0x4 dim:SQ_RSRC_IMG_CUBE a16
// GFX11: [0x0c,0x04,0xcd,0xf0,0x01,0x05,0x02,0x0c]

image_gather4_c v[5:8], v[253:255], s[8:15], s[12:15] dmask:0x4 dim:SQ_RSRC_IMG_CUBE a16
// GFX11: [0x0c,0x04,0xcd,0xf0,0xfd,0x05,0x02,0x0c]

image_gather4_c v[5:8], v[1:4], s[8:15], s[12:15] dmask:0x4 dim:SQ_RSRC_IMG_2D_ARRAY
// GFX11: [0x14,0x04,0xcc,0xf0,0x01,0x05,0x02,0x0c]

image_gather4_c v[252:255], v[252:255], s[8:15], s[12:15] dmask:0x4 dim:SQ_RSRC_IMG_2D_ARRAY
// GFX11: [0x14,0x04,0xcc,0xf0,0xfc,0xfc,0x02,0x0c]

image_gather4_c v[5:6], v[1:3], s[96:103], s[100:103] dmask:0x4 dim:SQ_RSRC_IMG_2D_ARRAY a16 d16
// GFX11: [0x14,0x04,0xcf,0xf0,0x01,0x05,0x18,0x64]

image_gather4_c v[254:255], v[253:255], ttmp[8:15], ttmp[12:15] dmask:0x4 dim:SQ_RSRC_IMG_2D_ARRAY unorm glc slc dlc a16 lwe d16
// GFX11: [0x94,0x74,0xcf,0xf0,0xfd,0xfe,0x5d,0x78]

image_gather4_c_b v[5:8], v[1:4], s[8:15], s[12:15] dmask:0x4 dim:SQ_RSRC_IMG_2D
// GFX11: [0x04,0x04,0x90,0xf1,0x01,0x05,0x02,0x0c]

image_gather4_c_b v[5:8], v[252:255], s[8:15], s[12:15] dmask:0x4 dim:SQ_RSRC_IMG_2D
// GFX11: [0x04,0x04,0x90,0xf1,0xfc,0x05,0x02,0x0c]

image_gather4_c_b v[5:8], v[1:3], s[8:15], s[12:15] dmask:0x4 dim:SQ_RSRC_IMG_2D a16
// GFX11: [0x04,0x04,0x91,0xf1,0x01,0x05,0x02,0x0c]

image_gather4_c_b v[5:8], v[253:255], s[8:15], s[12:15] dmask:0x4 dim:SQ_RSRC_IMG_2D a16
// GFX11: [0x04,0x04,0x91,0xf1,0xfd,0x05,0x02,0x0c]

image_gather4_c_b v[5:8], v[1:5], s[8:15], s[12:15] dmask:0x4 dim:SQ_RSRC_IMG_CUBE
// GFX11: [0x0c,0x04,0x90,0xf1,0x01,0x05,0x02,0x0c]

image_gather4_c_b v[5:8], v[251:255], s[8:15], s[12:15] dmask:0x4 dim:SQ_RSRC_IMG_CUBE
// GFX11: [0x0c,0x04,0x90,0xf1,0xfb,0x05,0x02,0x0c]

image_gather4_c_b v[5:8], v[1:4], s[8:15], s[12:15] dmask:0x4 dim:SQ_RSRC_IMG_CUBE a16
// GFX11: [0x0c,0x04,0x91,0xf1,0x01,0x05,0x02,0x0c]

image_gather4_c_b v[5:8], v[252:255], s[8:15], s[12:15] dmask:0x4 dim:SQ_RSRC_IMG_CUBE a16
// GFX11: [0x0c,0x04,0x91,0xf1,0xfc,0x05,0x02,0x0c]

image_gather4_c_b v[5:8], v[1:5], s[8:15], s[12:15] dmask:0x4 dim:SQ_RSRC_IMG_2D_ARRAY
// GFX11: [0x14,0x04,0x90,0xf1,0x01,0x05,0x02,0x0c]

image_gather4_c_b v[252:255], v[251:255], s[8:15], s[12:15] dmask:0x4 dim:SQ_RSRC_IMG_2D_ARRAY
// GFX11: [0x14,0x04,0x90,0xf1,0xfb,0xfc,0x02,0x0c]

image_gather4_c_b v[5:6], v[1:4], s[96:103], s[100:103] dmask:0x4 dim:SQ_RSRC_IMG_2D_ARRAY a16 d16
// GFX11: [0x14,0x04,0x93,0xf1,0x01,0x05,0x18,0x64]

image_gather4_c_b v[254:255], v[252:255], ttmp[8:15], ttmp[12:15] dmask:0x4 dim:SQ_RSRC_IMG_2D_ARRAY unorm glc slc dlc a16 lwe d16
// GFX11: [0x94,0x74,0x93,0xf1,0xfc,0xfe,0x5d,0x78]

image_gather4_c_b_cl v[5:8], v[1:5], s[8:15], s[12:15] dmask:0x4 dim:SQ_RSRC_IMG_2D
// GFX11: [0x04,0x04,0x94,0xf1,0x01,0x05,0x02,0x0c]

image_gather4_c_b_cl v[5:8], v[251:255], s[8:15], s[12:15] dmask:0x4 dim:SQ_RSRC_IMG_2D
// GFX11: [0x04,0x04,0x94,0xf1,0xfb,0x05,0x02,0x0c]

image_gather4_c_b_cl v[5:8], v[1:4], s[8:15], s[12:15] dmask:0x4 dim:SQ_RSRC_IMG_2D a16
// GFX11: [0x04,0x04,0x95,0xf1,0x01,0x05,0x02,0x0c]

image_gather4_c_b_cl v[5:8], v[252:255], s[8:15], s[12:15] dmask:0x4 dim:SQ_RSRC_IMG_2D a16
// GFX11: [0x04,0x04,0x95,0xf1,0xfc,0x05,0x02,0x0c]

image_gather4_c_b_cl v[5:8], v[1:6], s[8:15], s[12:15] dmask:0x4 dim:SQ_RSRC_IMG_CUBE
// GFX11: [0x0c,0x04,0x94,0xf1,0x01,0x05,0x02,0x0c]

image_gather4_c_b_cl v[5:8], v[250:255], s[8:15], s[12:15] dmask:0x4 dim:SQ_RSRC_IMG_CUBE
// GFX11: [0x0c,0x04,0x94,0xf1,0xfa,0x05,0x02,0x0c]

image_gather4_c_b_cl v[5:8], v[1:4], s[8:15], s[12:15] dmask:0x4 dim:SQ_RSRC_IMG_CUBE a16
// GFX11: [0x0c,0x04,0x95,0xf1,0x01,0x05,0x02,0x0c]

image_gather4_c_b_cl v[5:8], v[252:255], s[8:15], s[12:15] dmask:0x4 dim:SQ_RSRC_IMG_CUBE a16
// GFX11: [0x0c,0x04,0x95,0xf1,0xfc,0x05,0x02,0x0c]

image_gather4_c_b_cl v[5:8], v[1:6], s[8:15], s[12:15] dmask:0x4 dim:SQ_RSRC_IMG_2D_ARRAY
// GFX11: [0x14,0x04,0x94,0xf1,0x01,0x05,0x02,0x0c]

image_gather4_c_b_cl v[252:255], v[250:255], s[8:15], s[12:15] dmask:0x4 dim:SQ_RSRC_IMG_2D_ARRAY
// GFX11: [0x14,0x04,0x94,0xf1,0xfa,0xfc,0x02,0x0c]

image_gather4_c_b_cl v[5:6], v[1:4], s[96:103], s[100:103] dmask:0x4 dim:SQ_RSRC_IMG_2D_ARRAY a16 d16
// GFX11: [0x14,0x04,0x97,0xf1,0x01,0x05,0x18,0x64]

image_gather4_c_b_cl v[254:255], v[252:255], ttmp[8:15], ttmp[12:15] dmask:0x4 dim:SQ_RSRC_IMG_2D_ARRAY unorm glc slc dlc a16 lwe d16
// GFX11: [0x94,0x74,0x97,0xf1,0xfc,0xfe,0x5d,0x78]

image_gather4_c_cl v[5:8], v[1:4], s[8:15], s[12:15] dmask:0x4 dim:SQ_RSRC_IMG_2D
// GFX11: [0x04,0x04,0x88,0xf1,0x01,0x05,0x02,0x0c]

image_gather4_c_cl v[5:8], v[252:255], s[8:15], s[12:15] dmask:0x4 dim:SQ_RSRC_IMG_2D
// GFX11: [0x04,0x04,0x88,0xf1,0xfc,0x05,0x02,0x0c]

image_gather4_c_cl v[5:8], v[1:3], s[8:15], s[12:15] dmask:0x4 dim:SQ_RSRC_IMG_2D a16
// GFX11: [0x04,0x04,0x89,0xf1,0x01,0x05,0x02,0x0c]

image_gather4_c_cl v[5:8], v[253:255], s[8:15], s[12:15] dmask:0x4 dim:SQ_RSRC_IMG_2D a16
// GFX11: [0x04,0x04,0x89,0xf1,0xfd,0x05,0x02,0x0c]

image_gather4_c_cl v[5:8], v[1:5], s[8:15], s[12:15] dmask:0x4 dim:SQ_RSRC_IMG_CUBE
// GFX11: [0x0c,0x04,0x88,0xf1,0x01,0x05,0x02,0x0c]

image_gather4_c_cl v[5:8], v[251:255], s[8:15], s[12:15] dmask:0x4 dim:SQ_RSRC_IMG_CUBE
// GFX11: [0x0c,0x04,0x88,0xf1,0xfb,0x05,0x02,0x0c]

image_gather4_c_cl v[5:8], v[1:3], s[8:15], s[12:15] dmask:0x4 dim:SQ_RSRC_IMG_CUBE a16
// GFX11: [0x0c,0x04,0x89,0xf1,0x01,0x05,0x02,0x0c]

image_gather4_c_cl v[5:8], v[253:255], s[8:15], s[12:15] dmask:0x4 dim:SQ_RSRC_IMG_CUBE a16
// GFX11: [0x0c,0x04,0x89,0xf1,0xfd,0x05,0x02,0x0c]

image_gather4_c_cl v[5:8], v[1:5], s[8:15], s[12:15] dmask:0x4 dim:SQ_RSRC_IMG_2D_ARRAY
// GFX11: [0x14,0x04,0x88,0xf1,0x01,0x05,0x02,0x0c]

image_gather4_c_cl v[252:255], v[251:255], s[8:15], s[12:15] dmask:0x4 dim:SQ_RSRC_IMG_2D_ARRAY
// GFX11: [0x14,0x04,0x88,0xf1,0xfb,0xfc,0x02,0x0c]

image_gather4_c_cl v[5:6], v[1:3], s[96:103], s[100:103] dmask:0x4 dim:SQ_RSRC_IMG_2D_ARRAY a16 d16
// GFX11: [0x14,0x04,0x8b,0xf1,0x01,0x05,0x18,0x64]

image_gather4_c_cl v[254:255], v[253:255], ttmp[8:15], ttmp[12:15] dmask:0x4 dim:SQ_RSRC_IMG_2D_ARRAY unorm glc slc dlc a16 lwe d16
// GFX11: [0x94,0x74,0x8b,0xf1,0xfd,0xfe,0x5d,0x78]

image_gather4_c_l v[5:8], v[1:4], s[8:15], s[12:15] dmask:0x4 dim:SQ_RSRC_IMG_2D
// GFX11: [0x04,0x04,0x8c,0xf1,0x01,0x05,0x02,0x0c]

image_gather4_c_l v[5:8], v[252:255], s[8:15], s[12:15] dmask:0x4 dim:SQ_RSRC_IMG_2D
// GFX11: [0x04,0x04,0x8c,0xf1,0xfc,0x05,0x02,0x0c]

image_gather4_c_l v[5:8], v[1:3], s[8:15], s[12:15] dmask:0x4 dim:SQ_RSRC_IMG_2D a16
// GFX11: [0x04,0x04,0x8d,0xf1,0x01,0x05,0x02,0x0c]

image_gather4_c_l v[5:8], v[253:255], s[8:15], s[12:15] dmask:0x4 dim:SQ_RSRC_IMG_2D a16
// GFX11: [0x04,0x04,0x8d,0xf1,0xfd,0x05,0x02,0x0c]

image_gather4_c_l v[5:8], v[1:5], s[8:15], s[12:15] dmask:0x4 dim:SQ_RSRC_IMG_CUBE
// GFX11: [0x0c,0x04,0x8c,0xf1,0x01,0x05,0x02,0x0c]

image_gather4_c_l v[5:8], v[251:255], s[8:15], s[12:15] dmask:0x4 dim:SQ_RSRC_IMG_CUBE
// GFX11: [0x0c,0x04,0x8c,0xf1,0xfb,0x05,0x02,0x0c]

image_gather4_c_l v[5:8], v[1:3], s[8:15], s[12:15] dmask:0x4 dim:SQ_RSRC_IMG_CUBE a16
// GFX11: [0x0c,0x04,0x8d,0xf1,0x01,0x05,0x02,0x0c]

image_gather4_c_l v[5:8], v[253:255], s[8:15], s[12:15] dmask:0x4 dim:SQ_RSRC_IMG_CUBE a16
// GFX11: [0x0c,0x04,0x8d,0xf1,0xfd,0x05,0x02,0x0c]

image_gather4_c_l v[5:8], v[1:5], s[8:15], s[12:15] dmask:0x4 dim:SQ_RSRC_IMG_2D_ARRAY
// GFX11: [0x14,0x04,0x8c,0xf1,0x01,0x05,0x02,0x0c]

image_gather4_c_l v[252:255], v[251:255], s[8:15], s[12:15] dmask:0x4 dim:SQ_RSRC_IMG_2D_ARRAY
// GFX11: [0x14,0x04,0x8c,0xf1,0xfb,0xfc,0x02,0x0c]

image_gather4_c_l v[5:6], v[1:3], s[96:103], s[100:103] dmask:0x4 dim:SQ_RSRC_IMG_2D_ARRAY a16 d16
// GFX11: [0x14,0x04,0x8f,0xf1,0x01,0x05,0x18,0x64]

image_gather4_c_l v[254:255], v[253:255], ttmp[8:15], ttmp[12:15] dmask:0x4 dim:SQ_RSRC_IMG_2D_ARRAY unorm glc slc dlc a16 lwe d16
// GFX11: [0x94,0x74,0x8f,0xf1,0xfd,0xfe,0x5d,0x78]

image_gather4_c_lz v[5:8], v[1:3], s[8:15], s[12:15] dmask:0x4 dim:SQ_RSRC_IMG_2D
// GFX11: [0x04,0x04,0xd0,0xf0,0x01,0x05,0x02,0x0c]

image_gather4_c_lz v[5:8], v[253:255], s[8:15], s[12:15] dmask:0x4 dim:SQ_RSRC_IMG_2D
// GFX11: [0x04,0x04,0xd0,0xf0,0xfd,0x05,0x02,0x0c]

image_gather4_c_lz v[5:8], v[1:2], s[8:15], s[12:15] dmask:0x4 dim:SQ_RSRC_IMG_2D a16
// GFX11: [0x04,0x04,0xd1,0xf0,0x01,0x05,0x02,0x0c]

image_gather4_c_lz v[5:8], v[254:255], s[8:15], s[12:15] dmask:0x4 dim:SQ_RSRC_IMG_2D a16
// GFX11: [0x04,0x04,0xd1,0xf0,0xfe,0x05,0x02,0x0c]

image_gather4_c_lz v[5:8], v[1:4], s[8:15], s[12:15] dmask:0x4 dim:SQ_RSRC_IMG_CUBE
// GFX11: [0x0c,0x04,0xd0,0xf0,0x01,0x05,0x02,0x0c]

image_gather4_c_lz v[5:8], v[252:255], s[8:15], s[12:15] dmask:0x4 dim:SQ_RSRC_IMG_CUBE
// GFX11: [0x0c,0x04,0xd0,0xf0,0xfc,0x05,0x02,0x0c]

image_gather4_c_lz v[5:8], v[1:3], s[8:15], s[12:15] dmask:0x4 dim:SQ_RSRC_IMG_CUBE a16
// GFX11: [0x0c,0x04,0xd1,0xf0,0x01,0x05,0x02,0x0c]

image_gather4_c_lz v[5:8], v[253:255], s[8:15], s[12:15] dmask:0x4 dim:SQ_RSRC_IMG_CUBE a16
// GFX11: [0x0c,0x04,0xd1,0xf0,0xfd,0x05,0x02,0x0c]

image_gather4_c_lz v[5:8], v[1:4], s[8:15], s[12:15] dmask:0x4 dim:SQ_RSRC_IMG_2D_ARRAY
// GFX11: [0x14,0x04,0xd0,0xf0,0x01,0x05,0x02,0x0c]

image_gather4_c_lz v[252:255], v[252:255], s[8:15], s[12:15] dmask:0x4 dim:SQ_RSRC_IMG_2D_ARRAY
// GFX11: [0x14,0x04,0xd0,0xf0,0xfc,0xfc,0x02,0x0c]

image_gather4_c_lz v[5:6], v[1:3], s[96:103], s[100:103] dmask:0x4 dim:SQ_RSRC_IMG_2D_ARRAY a16 d16
// GFX11: [0x14,0x04,0xd3,0xf0,0x01,0x05,0x18,0x64]

image_gather4_c_lz v[254:255], v[253:255], ttmp[8:15], ttmp[12:15] dmask:0x4 dim:SQ_RSRC_IMG_2D_ARRAY unorm glc slc dlc a16 lwe d16
// GFX11: [0x94,0x74,0xd3,0xf0,0xfd,0xfe,0x5d,0x78]

image_gather4_c_lz_o v[5:8], v[1:4], s[8:15], s[12:15] dmask:0x4 dim:SQ_RSRC_IMG_2D
// GFX11: [0x04,0x04,0xdc,0xf0,0x01,0x05,0x02,0x0c]

image_gather4_c_lz_o v[5:8], v[252:255], s[8:15], s[12:15] dmask:0x4 dim:SQ_RSRC_IMG_2D
// GFX11: [0x04,0x04,0xdc,0xf0,0xfc,0x05,0x02,0x0c]

image_gather4_c_lz_o v[5:8], v[1:3], s[8:15], s[12:15] dmask:0x4 dim:SQ_RSRC_IMG_2D a16
// GFX11: [0x04,0x04,0xdd,0xf0,0x01,0x05,0x02,0x0c]

image_gather4_c_lz_o v[5:8], v[253:255], s[8:15], s[12:15] dmask:0x4 dim:SQ_RSRC_IMG_2D a16
// GFX11: [0x04,0x04,0xdd,0xf0,0xfd,0x05,0x02,0x0c]

image_gather4_c_lz_o v[5:8], v[1:5], s[8:15], s[12:15] dmask:0x4 dim:SQ_RSRC_IMG_CUBE
// GFX11: [0x0c,0x04,0xdc,0xf0,0x01,0x05,0x02,0x0c]

image_gather4_c_lz_o v[5:8], v[251:255], s[8:15], s[12:15] dmask:0x4 dim:SQ_RSRC_IMG_CUBE
// GFX11: [0x0c,0x04,0xdc,0xf0,0xfb,0x05,0x02,0x0c]

image_gather4_c_lz_o v[5:8], v[1:4], s[8:15], s[12:15] dmask:0x4 dim:SQ_RSRC_IMG_CUBE a16
// GFX11: [0x0c,0x04,0xdd,0xf0,0x01,0x05,0x02,0x0c]

image_gather4_c_lz_o v[5:8], v[252:255], s[8:15], s[12:15] dmask:0x4 dim:SQ_RSRC_IMG_CUBE a16
// GFX11: [0x0c,0x04,0xdd,0xf0,0xfc,0x05,0x02,0x0c]

image_gather4_c_lz_o v[5:8], v[1:5], s[8:15], s[12:15] dmask:0x4 dim:SQ_RSRC_IMG_2D_ARRAY
// GFX11: [0x14,0x04,0xdc,0xf0,0x01,0x05,0x02,0x0c]

image_gather4_c_lz_o v[252:255], v[251:255], s[8:15], s[12:15] dmask:0x4 dim:SQ_RSRC_IMG_2D_ARRAY
// GFX11: [0x14,0x04,0xdc,0xf0,0xfb,0xfc,0x02,0x0c]

image_gather4_c_lz_o v[5:6], v[1:4], s[96:103], s[100:103] dmask:0x4 dim:SQ_RSRC_IMG_2D_ARRAY a16 d16
// GFX11: [0x14,0x04,0xdf,0xf0,0x01,0x05,0x18,0x64]

image_gather4_c_lz_o v[254:255], v[252:255], ttmp[8:15], ttmp[12:15] dmask:0x4 dim:SQ_RSRC_IMG_2D_ARRAY unorm glc slc dlc a16 lwe d16
// GFX11: [0x94,0x74,0xdf,0xf0,0xfc,0xfe,0x5d,0x78]

image_gather4_cl v[5:8], v[1:3], s[8:15], s[12:15] dmask:0x4 dim:SQ_RSRC_IMG_2D
// GFX11: [0x04,0x04,0x80,0xf1,0x01,0x05,0x02,0x0c]

image_gather4_cl v[5:8], v[253:255], s[8:15], s[12:15] dmask:0x4 dim:SQ_RSRC_IMG_2D
// GFX11: [0x04,0x04,0x80,0xf1,0xfd,0x05,0x02,0x0c]

image_gather4_cl v[5:8], v[1:2], s[8:15], s[12:15] dmask:0x4 dim:SQ_RSRC_IMG_2D a16
// GFX11: [0x04,0x04,0x81,0xf1,0x01,0x05,0x02,0x0c]

image_gather4_cl v[5:8], v[254:255], s[8:15], s[12:15] dmask:0x4 dim:SQ_RSRC_IMG_2D a16
// GFX11: [0x04,0x04,0x81,0xf1,0xfe,0x05,0x02,0x0c]

image_gather4_cl v[5:8], v[1:4], s[8:15], s[12:15] dmask:0x4 dim:SQ_RSRC_IMG_CUBE
// GFX11: [0x0c,0x04,0x80,0xf1,0x01,0x05,0x02,0x0c]

image_gather4_cl v[5:8], v[252:255], s[8:15], s[12:15] dmask:0x4 dim:SQ_RSRC_IMG_CUBE
// GFX11: [0x0c,0x04,0x80,0xf1,0xfc,0x05,0x02,0x0c]

image_gather4_cl v[5:8], v[1:2], s[8:15], s[12:15] dmask:0x4 dim:SQ_RSRC_IMG_CUBE a16
// GFX11: [0x0c,0x04,0x81,0xf1,0x01,0x05,0x02,0x0c]

image_gather4_cl v[5:8], v[254:255], s[8:15], s[12:15] dmask:0x4 dim:SQ_RSRC_IMG_CUBE a16
// GFX11: [0x0c,0x04,0x81,0xf1,0xfe,0x05,0x02,0x0c]

image_gather4_cl v[5:8], v[1:4], s[8:15], s[12:15] dmask:0x4 dim:SQ_RSRC_IMG_2D_ARRAY
// GFX11: [0x14,0x04,0x80,0xf1,0x01,0x05,0x02,0x0c]

image_gather4_cl v[252:255], v[252:255], s[8:15], s[12:15] dmask:0x4 dim:SQ_RSRC_IMG_2D_ARRAY
// GFX11: [0x14,0x04,0x80,0xf1,0xfc,0xfc,0x02,0x0c]

image_gather4_cl v[5:6], v[1:2], s[96:103], s[100:103] dmask:0x4 dim:SQ_RSRC_IMG_2D_ARRAY a16 d16
// GFX11: [0x14,0x04,0x83,0xf1,0x01,0x05,0x18,0x64]

image_gather4_cl v[254:255], v[254:255], ttmp[8:15], ttmp[12:15] dmask:0x4 dim:SQ_RSRC_IMG_2D_ARRAY unorm glc slc dlc a16 lwe d16
// GFX11: [0x94,0x74,0x83,0xf1,0xfe,0xfe,0x5d,0x78]

image_gather4_l v[5:8], v[1:3], s[8:15], s[12:15] dmask:0x4 dim:SQ_RSRC_IMG_2D
// GFX11: [0x04,0x04,0xc0,0xf0,0x01,0x05,0x02,0x0c]

image_gather4_l v[5:8], v[253:255], s[8:15], s[12:15] dmask:0x4 dim:SQ_RSRC_IMG_2D
// GFX11: [0x04,0x04,0xc0,0xf0,0xfd,0x05,0x02,0x0c]

image_gather4_l v[5:8], v[1:2], s[8:15], s[12:15] dmask:0x4 dim:SQ_RSRC_IMG_2D a16
// GFX11: [0x04,0x04,0xc1,0xf0,0x01,0x05,0x02,0x0c]

image_gather4_l v[5:8], v[254:255], s[8:15], s[12:15] dmask:0x4 dim:SQ_RSRC_IMG_2D a16
// GFX11: [0x04,0x04,0xc1,0xf0,0xfe,0x05,0x02,0x0c]

image_gather4_l v[5:8], v[1:4], s[8:15], s[12:15] dmask:0x4 dim:SQ_RSRC_IMG_CUBE
// GFX11: [0x0c,0x04,0xc0,0xf0,0x01,0x05,0x02,0x0c]

image_gather4_l v[5:8], v[252:255], s[8:15], s[12:15] dmask:0x4 dim:SQ_RSRC_IMG_CUBE
// GFX11: [0x0c,0x04,0xc0,0xf0,0xfc,0x05,0x02,0x0c]

image_gather4_l v[5:8], v[1:2], s[8:15], s[12:15] dmask:0x4 dim:SQ_RSRC_IMG_CUBE a16
// GFX11: [0x0c,0x04,0xc1,0xf0,0x01,0x05,0x02,0x0c]

image_gather4_l v[5:8], v[254:255], s[8:15], s[12:15] dmask:0x4 dim:SQ_RSRC_IMG_CUBE a16
// GFX11: [0x0c,0x04,0xc1,0xf0,0xfe,0x05,0x02,0x0c]

image_gather4_l v[5:8], v[1:4], s[8:15], s[12:15] dmask:0x4 dim:SQ_RSRC_IMG_2D_ARRAY
// GFX11: [0x14,0x04,0xc0,0xf0,0x01,0x05,0x02,0x0c]

image_gather4_l v[252:255], v[252:255], s[8:15], s[12:15] dmask:0x4 dim:SQ_RSRC_IMG_2D_ARRAY
// GFX11: [0x14,0x04,0xc0,0xf0,0xfc,0xfc,0x02,0x0c]

image_gather4_l v[5:6], v[1:2], s[96:103], s[100:103] dmask:0x4 dim:SQ_RSRC_IMG_2D_ARRAY a16 d16
// GFX11: [0x14,0x04,0xc3,0xf0,0x01,0x05,0x18,0x64]

image_gather4_l v[254:255], v[254:255], ttmp[8:15], ttmp[12:15] dmask:0x4 dim:SQ_RSRC_IMG_2D_ARRAY unorm glc slc dlc a16 lwe d16
// GFX11: [0x94,0x74,0xc3,0xf0,0xfe,0xfe,0x5d,0x78]

image_gather4_lz v[5:8], v[1:2], s[8:15], s[12:15] dmask:0x4 dim:SQ_RSRC_IMG_2D
// GFX11: [0x04,0x04,0xc8,0xf0,0x01,0x05,0x02,0x0c]

image_gather4_lz v[5:8], v[254:255], s[8:15], s[12:15] dmask:0x4 dim:SQ_RSRC_IMG_2D
// GFX11: [0x04,0x04,0xc8,0xf0,0xfe,0x05,0x02,0x0c]

image_gather4_lz v[5:8], v1, s[8:15], s[12:15] dmask:0x4 dim:SQ_RSRC_IMG_2D a16
// GFX11: [0x04,0x04,0xc9,0xf0,0x01,0x05,0x02,0x0c]

image_gather4_lz v[5:8], v255, s[8:15], s[12:15] dmask:0x4 dim:SQ_RSRC_IMG_2D a16
// GFX11: [0x04,0x04,0xc9,0xf0,0xff,0x05,0x02,0x0c]

image_gather4_lz v[5:8], v[1:3], s[8:15], s[12:15] dmask:0x4 dim:SQ_RSRC_IMG_CUBE
// GFX11: [0x0c,0x04,0xc8,0xf0,0x01,0x05,0x02,0x0c]

image_gather4_lz v[5:8], v[253:255], s[8:15], s[12:15] dmask:0x4 dim:SQ_RSRC_IMG_CUBE
// GFX11: [0x0c,0x04,0xc8,0xf0,0xfd,0x05,0x02,0x0c]

image_gather4_lz v[5:8], v[1:2], s[8:15], s[12:15] dmask:0x4 dim:SQ_RSRC_IMG_CUBE a16
// GFX11: [0x0c,0x04,0xc9,0xf0,0x01,0x05,0x02,0x0c]

image_gather4_lz v[5:8], v[254:255], s[8:15], s[12:15] dmask:0x4 dim:SQ_RSRC_IMG_CUBE a16
// GFX11: [0x0c,0x04,0xc9,0xf0,0xfe,0x05,0x02,0x0c]

image_gather4_lz v[5:8], v[1:3], s[8:15], s[12:15] dmask:0x4 dim:SQ_RSRC_IMG_2D_ARRAY
// GFX11: [0x14,0x04,0xc8,0xf0,0x01,0x05,0x02,0x0c]

image_gather4_lz v[252:255], v[253:255], s[8:15], s[12:15] dmask:0x4 dim:SQ_RSRC_IMG_2D_ARRAY
// GFX11: [0x14,0x04,0xc8,0xf0,0xfd,0xfc,0x02,0x0c]

image_gather4_lz v[5:6], v[1:2], s[96:103], s[100:103] dmask:0x4 dim:SQ_RSRC_IMG_2D_ARRAY a16 d16
// GFX11: [0x14,0x04,0xcb,0xf0,0x01,0x05,0x18,0x64]

image_gather4_lz v[254:255], v[254:255], ttmp[8:15], ttmp[12:15] dmask:0x4 dim:SQ_RSRC_IMG_2D_ARRAY unorm glc slc dlc a16 lwe d16
// GFX11: [0x94,0x74,0xcb,0xf0,0xfe,0xfe,0x5d,0x78]

image_gather4_lz_o v[5:8], v[1:3], s[8:15], s[12:15] dmask:0x4 dim:SQ_RSRC_IMG_2D
// GFX11: [0x04,0x04,0xd8,0xf0,0x01,0x05,0x02,0x0c]

image_gather4_lz_o v[5:8], v[253:255], s[8:15], s[12:15] dmask:0x4 dim:SQ_RSRC_IMG_2D
// GFX11: [0x04,0x04,0xd8,0xf0,0xfd,0x05,0x02,0x0c]

image_gather4_lz_o v[5:8], v[1:2], s[8:15], s[12:15] dmask:0x4 dim:SQ_RSRC_IMG_2D a16
// GFX11: [0x04,0x04,0xd9,0xf0,0x01,0x05,0x02,0x0c]

image_gather4_lz_o v[5:8], v[254:255], s[8:15], s[12:15] dmask:0x4 dim:SQ_RSRC_IMG_2D a16
// GFX11: [0x04,0x04,0xd9,0xf0,0xfe,0x05,0x02,0x0c]

image_gather4_lz_o v[5:8], v[1:4], s[8:15], s[12:15] dmask:0x4 dim:SQ_RSRC_IMG_CUBE
// GFX11: [0x0c,0x04,0xd8,0xf0,0x01,0x05,0x02,0x0c]

image_gather4_lz_o v[5:8], v[252:255], s[8:15], s[12:15] dmask:0x4 dim:SQ_RSRC_IMG_CUBE
// GFX11: [0x0c,0x04,0xd8,0xf0,0xfc,0x05,0x02,0x0c]

image_gather4_lz_o v[5:8], v[1:3], s[8:15], s[12:15] dmask:0x4 dim:SQ_RSRC_IMG_CUBE a16
// GFX11: [0x0c,0x04,0xd9,0xf0,0x01,0x05,0x02,0x0c]

image_gather4_lz_o v[5:8], v[253:255], s[8:15], s[12:15] dmask:0x4 dim:SQ_RSRC_IMG_CUBE a16
// GFX11: [0x0c,0x04,0xd9,0xf0,0xfd,0x05,0x02,0x0c]

image_gather4_lz_o v[5:8], v[1:4], s[8:15], s[12:15] dmask:0x4 dim:SQ_RSRC_IMG_2D_ARRAY
// GFX11: [0x14,0x04,0xd8,0xf0,0x01,0x05,0x02,0x0c]

image_gather4_lz_o v[252:255], v[252:255], s[8:15], s[12:15] dmask:0x4 dim:SQ_RSRC_IMG_2D_ARRAY
// GFX11: [0x14,0x04,0xd8,0xf0,0xfc,0xfc,0x02,0x0c]

image_gather4_lz_o v[5:6], v[1:3], s[96:103], s[100:103] dmask:0x4 dim:SQ_RSRC_IMG_2D_ARRAY a16 d16
// GFX11: [0x14,0x04,0xdb,0xf0,0x01,0x05,0x18,0x64]

image_gather4_lz_o v[254:255], v[253:255], ttmp[8:15], ttmp[12:15] dmask:0x4 dim:SQ_RSRC_IMG_2D_ARRAY unorm glc slc dlc a16 lwe d16
// GFX11: [0x94,0x74,0xdb,0xf0,0xfd,0xfe,0x5d,0x78]

image_gather4_o v[5:8], v[1:3], s[8:15], s[12:15] dmask:0x4 dim:SQ_RSRC_IMG_2D
// GFX11: [0x04,0x04,0xd4,0xf0,0x01,0x05,0x02,0x0c]

image_gather4_o v[5:8], v[253:255], s[8:15], s[12:15] dmask:0x4 dim:SQ_RSRC_IMG_2D
// GFX11: [0x04,0x04,0xd4,0xf0,0xfd,0x05,0x02,0x0c]

image_gather4_o v[5:8], v[1:2], s[8:15], s[12:15] dmask:0x4 dim:SQ_RSRC_IMG_2D a16
// GFX11: [0x04,0x04,0xd5,0xf0,0x01,0x05,0x02,0x0c]

image_gather4_o v[5:8], v[254:255], s[8:15], s[12:15] dmask:0x4 dim:SQ_RSRC_IMG_2D a16
// GFX11: [0x04,0x04,0xd5,0xf0,0xfe,0x05,0x02,0x0c]

image_gather4_o v[5:8], v[1:4], s[8:15], s[12:15] dmask:0x4 dim:SQ_RSRC_IMG_CUBE
// GFX11: [0x0c,0x04,0xd4,0xf0,0x01,0x05,0x02,0x0c]

image_gather4_o v[5:8], v[252:255], s[8:15], s[12:15] dmask:0x4 dim:SQ_RSRC_IMG_CUBE
// GFX11: [0x0c,0x04,0xd4,0xf0,0xfc,0x05,0x02,0x0c]

image_gather4_o v[5:8], v[1:3], s[8:15], s[12:15] dmask:0x4 dim:SQ_RSRC_IMG_CUBE a16
// GFX11: [0x0c,0x04,0xd5,0xf0,0x01,0x05,0x02,0x0c]

image_gather4_o v[5:8], v[253:255], s[8:15], s[12:15] dmask:0x4 dim:SQ_RSRC_IMG_CUBE a16
// GFX11: [0x0c,0x04,0xd5,0xf0,0xfd,0x05,0x02,0x0c]

image_gather4_o v[5:8], v[1:4], s[8:15], s[12:15] dmask:0x4 dim:SQ_RSRC_IMG_2D_ARRAY
// GFX11: [0x14,0x04,0xd4,0xf0,0x01,0x05,0x02,0x0c]

image_gather4_o v[252:255], v[252:255], s[8:15], s[12:15] dmask:0x4 dim:SQ_RSRC_IMG_2D_ARRAY
// GFX11: [0x14,0x04,0xd4,0xf0,0xfc,0xfc,0x02,0x0c]

image_gather4_o v[5:6], v[1:3], s[96:103], s[100:103] dmask:0x4 dim:SQ_RSRC_IMG_2D_ARRAY a16 d16
// GFX11: [0x14,0x04,0xd7,0xf0,0x01,0x05,0x18,0x64]

image_gather4_o v[254:255], v[253:255], ttmp[8:15], ttmp[12:15] dmask:0x4 dim:SQ_RSRC_IMG_2D_ARRAY unorm glc slc dlc a16 lwe d16
// GFX11: [0x94,0x74,0xd7,0xf0,0xfd,0xfe,0x5d,0x78]

image_gather4h v[5:8], v[1:2], s[8:15], s[12:15] dmask:0x4 dim:SQ_RSRC_IMG_2D
// GFX11: [0x04,0x04,0x40,0xf2,0x01,0x05,0x02,0x0c]

image_gather4h v[5:8], v[254:255], s[8:15], s[12:15] dmask:0x4 dim:SQ_RSRC_IMG_2D
// GFX11: [0x04,0x04,0x40,0xf2,0xfe,0x05,0x02,0x0c]

image_gather4h v[5:8], v1, s[8:15], s[12:15] dmask:0x4 dim:SQ_RSRC_IMG_2D a16
// GFX11: [0x04,0x04,0x41,0xf2,0x01,0x05,0x02,0x0c]

image_gather4h v[5:8], v255, s[8:15], s[12:15] dmask:0x4 dim:SQ_RSRC_IMG_2D a16
// GFX11: [0x04,0x04,0x41,0xf2,0xff,0x05,0x02,0x0c]

image_gather4h v[5:8], v[1:3], s[8:15], s[12:15] dmask:0x4 dim:SQ_RSRC_IMG_CUBE
// GFX11: [0x0c,0x04,0x40,0xf2,0x01,0x05,0x02,0x0c]

image_gather4h v[5:8], v[253:255], s[8:15], s[12:15] dmask:0x4 dim:SQ_RSRC_IMG_CUBE
// GFX11: [0x0c,0x04,0x40,0xf2,0xfd,0x05,0x02,0x0c]

image_gather4h v[5:8], v[1:2], s[8:15], s[12:15] dmask:0x4 dim:SQ_RSRC_IMG_CUBE a16
// GFX11: [0x0c,0x04,0x41,0xf2,0x01,0x05,0x02,0x0c]

image_gather4h v[5:8], v[254:255], s[8:15], s[12:15] dmask:0x4 dim:SQ_RSRC_IMG_CUBE a16
// GFX11: [0x0c,0x04,0x41,0xf2,0xfe,0x05,0x02,0x0c]

image_gather4h v[5:8], v[1:3], s[8:15], s[12:15] dmask:0x4 dim:SQ_RSRC_IMG_2D_ARRAY
// GFX11: [0x14,0x04,0x40,0xf2,0x01,0x05,0x02,0x0c]

image_gather4h v[252:255], v[253:255], s[8:15], s[12:15] dmask:0x4 dim:SQ_RSRC_IMG_2D_ARRAY
// GFX11: [0x14,0x04,0x40,0xf2,0xfd,0xfc,0x02,0x0c]

image_gather4h v[5:6], v[1:2], s[96:103], s[100:103] dmask:0x4 dim:SQ_RSRC_IMG_2D_ARRAY a16 d16
// GFX11: [0x14,0x04,0x43,0xf2,0x01,0x05,0x18,0x64]

image_gather4h v[254:255], v[254:255], ttmp[8:15], ttmp[12:15] dmask:0x4 dim:SQ_RSRC_IMG_2D_ARRAY unorm glc slc dlc a16 lwe d16
// GFX11: [0x94,0x74,0x43,0xf2,0xfe,0xfe,0x5d,0x78]

image_get_lod v[5:6], v1, s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_1D
// GFX11: [0x00,0x03,0xe0,0xf0,0x01,0x05,0x02,0x0c]

image_get_lod v[5:6], v255, s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_1D
// GFX11: [0x00,0x03,0xe0,0xf0,0xff,0x05,0x02,0x0c]

image_get_lod v[5:6], v1, s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_1D a16
// GFX11: [0x00,0x03,0xe1,0xf0,0x01,0x05,0x02,0x0c]

image_get_lod v[5:6], v255, s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_1D a16
// GFX11: [0x00,0x03,0xe1,0xf0,0xff,0x05,0x02,0x0c]

image_get_lod v[5:6], v[1:3], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_3D
// GFX11: [0x08,0x03,0xe0,0xf0,0x01,0x05,0x02,0x0c]

image_get_lod v[5:6], v[253:255], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_3D
// GFX11: [0x08,0x03,0xe0,0xf0,0xfd,0x05,0x02,0x0c]

image_get_lod v[5:6], v[1:2], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_3D a16
// GFX11: [0x08,0x03,0xe1,0xf0,0x01,0x05,0x02,0x0c]

image_get_lod v[5:6], v[254:255], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_3D a16
// GFX11: [0x08,0x03,0xe1,0xf0,0xfe,0x05,0x02,0x0c]

image_get_lod v[5:6], v[1:2], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_2D
// GFX11: [0x04,0x03,0xe0,0xf0,0x01,0x05,0x02,0x0c]

image_get_lod v[5:6], v[254:255], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_2D
// GFX11: [0x04,0x03,0xe0,0xf0,0xfe,0x05,0x02,0x0c]

image_get_lod v[5:6], v1, s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_2D a16
// GFX11: [0x04,0x03,0xe1,0xf0,0x01,0x05,0x02,0x0c]

image_get_lod v[5:6], v255, s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_2D a16
// GFX11: [0x04,0x03,0xe1,0xf0,0xff,0x05,0x02,0x0c]

image_get_lod v[5:6], v[1:3], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_CUBE
// GFX11: [0x0c,0x03,0xe0,0xf0,0x01,0x05,0x02,0x0c]

image_get_lod v[5:6], v[253:255], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_CUBE
// GFX11: [0x0c,0x03,0xe0,0xf0,0xfd,0x05,0x02,0x0c]

image_get_lod v[5:6], v[1:2], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_CUBE a16
// GFX11: [0x0c,0x03,0xe1,0xf0,0x01,0x05,0x02,0x0c]

image_get_lod v[5:6], v[254:255], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_CUBE a16
// GFX11: [0x0c,0x03,0xe1,0xf0,0xfe,0x05,0x02,0x0c]

image_get_lod v[5:6], v[1:2], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_1D_ARRAY
// GFX11: [0x10,0x03,0xe0,0xf0,0x01,0x05,0x02,0x0c]

image_get_lod v[254:255], v[254:255], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_1D_ARRAY
// GFX11: [0x10,0x03,0xe0,0xf0,0xfe,0xfe,0x02,0x0c]

image_get_lod v[5:7], v1, s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_1D_ARRAY a16 tfe
// GFX11: [0x10,0x03,0xe1,0xf0,0x01,0x05,0x22,0x0c]

image_get_lod v[253:255], v255, s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_1D_ARRAY a16 tfe
// GFX11: [0x10,0x03,0xe1,0xf0,0xff,0xfd,0x22,0x0c]

image_get_lod v5, v[1:3], s[8:15], s[12:15] dmask:0x4 dim:SQ_RSRC_IMG_2D_ARRAY
// GFX11: [0x14,0x04,0xe0,0xf0,0x01,0x05,0x02,0x0c]

image_get_lod v255, v[253:255], s[8:15], s[12:15] dmask:0x4 dim:SQ_RSRC_IMG_2D_ARRAY
// GFX11: [0x14,0x04,0xe0,0xf0,0xfd,0xff,0x02,0x0c]

image_get_lod v[5:6], v[1:2], s[96:103], s[100:103] dmask:0x4 dim:SQ_RSRC_IMG_2D_ARRAY a16 tfe
// GFX11: [0x14,0x04,0xe1,0xf0,0x01,0x05,0x38,0x64]

image_get_lod v[254:255], v[254:255], ttmp[8:15], ttmp[12:15] dmask:0x4 dim:SQ_RSRC_IMG_2D_ARRAY unorm glc slc dlc a16 tfe lwe
// GFX11: [0x94,0x74,0xe1,0xf0,0xfe,0xfe,0x7d,0x78]

image_get_resinfo v[5:6], v1, s[8:15] dmask:0x3 dim:SQ_RSRC_IMG_1D
// GFX11: [0x00,0x03,0x5c,0xf0,0x01,0x05,0x02,0x00]

image_get_resinfo v[5:6], v255, s[8:15] dmask:0x3 dim:SQ_RSRC_IMG_1D
// GFX11: [0x00,0x03,0x5c,0xf0,0xff,0x05,0x02,0x00]

image_get_resinfo v[5:6], v1, s[8:15] dmask:0x3 dim:SQ_RSRC_IMG_1D a16
// GFX11: [0x00,0x03,0x5d,0xf0,0x01,0x05,0x02,0x00]

image_get_resinfo v[5:6], v255, s[8:15] dmask:0x3 dim:SQ_RSRC_IMG_1D a16
// GFX11: [0x00,0x03,0x5d,0xf0,0xff,0x05,0x02,0x00]

image_get_resinfo v[5:6], v1, s[8:15] dmask:0x3 dim:SQ_RSRC_IMG_3D
// GFX11: [0x08,0x03,0x5c,0xf0,0x01,0x05,0x02,0x00]

image_get_resinfo v[5:6], v255, s[8:15] dmask:0x3 dim:SQ_RSRC_IMG_3D
// GFX11: [0x08,0x03,0x5c,0xf0,0xff,0x05,0x02,0x00]

image_get_resinfo v[5:6], v1, s[8:15] dmask:0x3 dim:SQ_RSRC_IMG_3D a16
// GFX11: [0x08,0x03,0x5d,0xf0,0x01,0x05,0x02,0x00]

image_get_resinfo v[5:6], v255, s[8:15] dmask:0x3 dim:SQ_RSRC_IMG_3D a16
// GFX11: [0x08,0x03,0x5d,0xf0,0xff,0x05,0x02,0x00]

image_get_resinfo v[5:6], v1, s[8:15] dmask:0x3 dim:SQ_RSRC_IMG_2D
// GFX11: [0x04,0x03,0x5c,0xf0,0x01,0x05,0x02,0x00]

image_get_resinfo v[5:6], v255, s[8:15] dmask:0x3 dim:SQ_RSRC_IMG_2D
// GFX11: [0x04,0x03,0x5c,0xf0,0xff,0x05,0x02,0x00]

image_get_resinfo v[5:6], v1, s[8:15] dmask:0x3 dim:SQ_RSRC_IMG_2D a16
// GFX11: [0x04,0x03,0x5d,0xf0,0x01,0x05,0x02,0x00]

image_get_resinfo v[5:6], v255, s[8:15] dmask:0x3 dim:SQ_RSRC_IMG_2D a16
// GFX11: [0x04,0x03,0x5d,0xf0,0xff,0x05,0x02,0x00]

image_get_resinfo v[5:6], v1, s[8:15] dmask:0x3 dim:SQ_RSRC_IMG_CUBE
// GFX11: [0x0c,0x03,0x5c,0xf0,0x01,0x05,0x02,0x00]

image_get_resinfo v[5:6], v255, s[8:15] dmask:0x3 dim:SQ_RSRC_IMG_CUBE
// GFX11: [0x0c,0x03,0x5c,0xf0,0xff,0x05,0x02,0x00]

image_get_resinfo v[5:6], v1, s[8:15] dmask:0x3 dim:SQ_RSRC_IMG_CUBE a16
// GFX11: [0x0c,0x03,0x5d,0xf0,0x01,0x05,0x02,0x00]

image_get_resinfo v[5:6], v255, s[8:15] dmask:0x3 dim:SQ_RSRC_IMG_CUBE a16
// GFX11: [0x0c,0x03,0x5d,0xf0,0xff,0x05,0x02,0x00]

image_get_resinfo v[5:6], v1, s[8:15] dmask:0x3 dim:SQ_RSRC_IMG_1D_ARRAY
// GFX11: [0x10,0x03,0x5c,0xf0,0x01,0x05,0x02,0x00]

image_get_resinfo v[254:255], v255, s[8:15] dmask:0x3 dim:SQ_RSRC_IMG_1D_ARRAY
// GFX11: [0x10,0x03,0x5c,0xf0,0xff,0xfe,0x02,0x00]

image_get_resinfo v[5:7], v1, s[8:15] dmask:0x3 dim:SQ_RSRC_IMG_1D_ARRAY a16 tfe
// GFX11: [0x10,0x03,0x5d,0xf0,0x01,0x05,0x22,0x00]

image_get_resinfo v[253:255], v255, s[8:15] dmask:0x3 dim:SQ_RSRC_IMG_1D_ARRAY a16 tfe
// GFX11: [0x10,0x03,0x5d,0xf0,0xff,0xfd,0x22,0x00]

image_get_resinfo v5, v1, s[8:15] dmask:0x4 dim:SQ_RSRC_IMG_2D_ARRAY
// GFX11: [0x14,0x04,0x5c,0xf0,0x01,0x05,0x02,0x00]

image_get_resinfo v255, v255, s[8:15] dmask:0x4 dim:SQ_RSRC_IMG_2D_ARRAY
// GFX11: [0x14,0x04,0x5c,0xf0,0xff,0xff,0x02,0x00]

image_get_resinfo v[5:6], v1, s[96:103] dmask:0x4 dim:SQ_RSRC_IMG_2D_ARRAY a16 tfe
// GFX11: [0x14,0x04,0x5d,0xf0,0x01,0x05,0x38,0x00]

image_get_resinfo v[254:255], v255, ttmp[8:15] dmask:0x4 dim:SQ_RSRC_IMG_2D_ARRAY unorm glc slc dlc a16 tfe lwe
// GFX11: [0x94,0x74,0x5d,0xf0,0xff,0xfe,0x7d,0x00]

image_load v[5:6], v1, s[8:15] dmask:0x3 dim:SQ_RSRC_IMG_1D
// GFX11: [0x00,0x03,0x00,0xf0,0x01,0x05,0x02,0x00]

image_load v[5:6], v255, s[8:15] dmask:0x3 dim:SQ_RSRC_IMG_1D
// GFX11: [0x00,0x03,0x00,0xf0,0xff,0x05,0x02,0x00]

image_load v[5:6], v1, s[8:15] dmask:0x3 dim:SQ_RSRC_IMG_1D a16
// GFX11: [0x00,0x03,0x01,0xf0,0x01,0x05,0x02,0x00]

image_load v[5:6], v255, s[8:15] dmask:0x3 dim:SQ_RSRC_IMG_1D a16
// GFX11: [0x00,0x03,0x01,0xf0,0xff,0x05,0x02,0x00]

image_load v[5:6], v[1:3], s[8:15] dmask:0x3 dim:SQ_RSRC_IMG_3D
// GFX11: [0x08,0x03,0x00,0xf0,0x01,0x05,0x02,0x00]

image_load v[5:6], v[253:255], s[8:15] dmask:0x3 dim:SQ_RSRC_IMG_3D
// GFX11: [0x08,0x03,0x00,0xf0,0xfd,0x05,0x02,0x00]

image_load v[5:6], v[1:2], s[8:15] dmask:0x3 dim:SQ_RSRC_IMG_3D a16
// GFX11: [0x08,0x03,0x01,0xf0,0x01,0x05,0x02,0x00]

image_load v[5:6], v[254:255], s[8:15] dmask:0x3 dim:SQ_RSRC_IMG_3D a16
// GFX11: [0x08,0x03,0x01,0xf0,0xfe,0x05,0x02,0x00]

image_load v[5:6], v[1:4], s[8:15] dmask:0x3 dim:SQ_RSRC_IMG_2D_MSAA_ARRAY
// GFX11: [0x1c,0x03,0x00,0xf0,0x01,0x05,0x02,0x00]

image_load v[5:6], v[252:255], s[8:15] dmask:0x3 dim:SQ_RSRC_IMG_2D_MSAA_ARRAY
// GFX11: [0x1c,0x03,0x00,0xf0,0xfc,0x05,0x02,0x00]

image_load v[5:6], v[1:2], s[8:15] dmask:0x3 dim:SQ_RSRC_IMG_2D_MSAA_ARRAY a16
// GFX11: [0x1c,0x03,0x01,0xf0,0x01,0x05,0x02,0x00]

image_load v[5:6], v[254:255], s[8:15] dmask:0x3 dim:SQ_RSRC_IMG_2D_MSAA_ARRAY a16
// GFX11: [0x1c,0x03,0x01,0xf0,0xfe,0x05,0x02,0x00]

image_load v[5:6], v[1:2], s[8:15] dmask:0x3 dim:SQ_RSRC_IMG_2D
// GFX11: [0x04,0x03,0x00,0xf0,0x01,0x05,0x02,0x00]

image_load v[5:6], v[254:255], s[8:15] dmask:0x3 dim:SQ_RSRC_IMG_2D
// GFX11: [0x04,0x03,0x00,0xf0,0xfe,0x05,0x02,0x00]

image_load v[5:6], v1, s[8:15] dmask:0x3 dim:SQ_RSRC_IMG_2D a16
// GFX11: [0x04,0x03,0x01,0xf0,0x01,0x05,0x02,0x00]

image_load v[5:6], v255, s[8:15] dmask:0x3 dim:SQ_RSRC_IMG_2D a16
// GFX11: [0x04,0x03,0x01,0xf0,0xff,0x05,0x02,0x00]

image_load v[5:6], v[1:3], s[8:15] dmask:0x3 dim:SQ_RSRC_IMG_CUBE
// GFX11: [0x0c,0x03,0x00,0xf0,0x01,0x05,0x02,0x00]

image_load v[254:255], v[253:255], s[8:15] dmask:0x3 dim:SQ_RSRC_IMG_CUBE
// GFX11: [0x0c,0x03,0x00,0xf0,0xfd,0xfe,0x02,0x00]

image_load v[5:7], v[1:2], s[8:15] dmask:0x3 dim:SQ_RSRC_IMG_CUBE a16 tfe
// GFX11: [0x0c,0x03,0x01,0xf0,0x01,0x05,0x22,0x00]

image_load v[253:255], v[254:255], s[8:15] dmask:0x3 dim:SQ_RSRC_IMG_CUBE a16 tfe
// GFX11: [0x0c,0x03,0x01,0xf0,0xfe,0xfd,0x22,0x00]

image_load v5, v[1:2], s[8:15] dmask:0x3 dim:SQ_RSRC_IMG_1D_ARRAY d16
// GFX11: [0x10,0x03,0x02,0xf0,0x01,0x05,0x02,0x00]

image_load v255, v[254:255], s[8:15] dmask:0x3 dim:SQ_RSRC_IMG_1D_ARRAY d16
// GFX11: [0x10,0x03,0x02,0xf0,0xfe,0xff,0x02,0x00]

image_load v[5:6], v1, s[8:15] dmask:0x3 dim:SQ_RSRC_IMG_1D_ARRAY a16 tfe d16
// GFX11: [0x10,0x03,0x03,0xf0,0x01,0x05,0x22,0x00]

image_load v[254:255], v255, s[8:15] dmask:0x3 dim:SQ_RSRC_IMG_1D_ARRAY a16 tfe d16
// GFX11: [0x10,0x03,0x03,0xf0,0xff,0xfe,0x22,0x00]

image_load v5, v[1:3], s[8:15] dmask:0x4 dim:SQ_RSRC_IMG_2D_ARRAY
// GFX11: [0x14,0x04,0x00,0xf0,0x01,0x05,0x02,0x00]

image_load v255, v[253:255], s[8:15] dmask:0x4 dim:SQ_RSRC_IMG_2D_ARRAY
// GFX11: [0x14,0x04,0x00,0xf0,0xfd,0xff,0x02,0x00]

image_load v[5:6], v[1:2], s[8:15] dmask:0x4 dim:SQ_RSRC_IMG_2D_ARRAY a16 tfe
// GFX11: [0x14,0x04,0x01,0xf0,0x01,0x05,0x22,0x00]

image_load v[254:255], v[254:255], s[8:15] dmask:0x4 dim:SQ_RSRC_IMG_2D_ARRAY a16 tfe
// GFX11: [0x14,0x04,0x01,0xf0,0xfe,0xfe,0x22,0x00]

image_load v5, v[1:3], s[8:15] dmask:0x4 dim:SQ_RSRC_IMG_2D_MSAA d16
// GFX11: [0x18,0x04,0x02,0xf0,0x01,0x05,0x02,0x00]

image_load v255, v[253:255], s[8:15] dmask:0x4 dim:SQ_RSRC_IMG_2D_MSAA d16
// GFX11: [0x18,0x04,0x02,0xf0,0xfd,0xff,0x02,0x00]

image_load v[5:6], v[1:2], s[96:103] dmask:0x4 dim:SQ_RSRC_IMG_2D_MSAA a16 tfe d16
// GFX11: [0x18,0x04,0x03,0xf0,0x01,0x05,0x38,0x00]

image_load v[254:255], v[254:255], ttmp[8:15] dmask:0x4 dim:SQ_RSRC_IMG_2D_MSAA unorm glc slc dlc a16 tfe lwe d16
// GFX11: [0x98,0x74,0x03,0xf0,0xfe,0xfe,0x7d,0x00]

image_load_mip v[5:6], v[1:2], s[8:15] dmask:0x3 dim:SQ_RSRC_IMG_1D
// GFX11: [0x00,0x03,0x04,0xf0,0x01,0x05,0x02,0x00]

image_load_mip v[5:6], v[254:255], s[8:15] dmask:0x3 dim:SQ_RSRC_IMG_1D
// GFX11: [0x00,0x03,0x04,0xf0,0xfe,0x05,0x02,0x00]

image_load_mip v[5:6], v1, s[8:15] dmask:0x3 dim:SQ_RSRC_IMG_1D a16
// GFX11: [0x00,0x03,0x05,0xf0,0x01,0x05,0x02,0x00]

image_load_mip v[5:6], v255, s[8:15] dmask:0x3 dim:SQ_RSRC_IMG_1D a16
// GFX11: [0x00,0x03,0x05,0xf0,0xff,0x05,0x02,0x00]

image_load_mip v[5:6], v[1:4], s[8:15] dmask:0x3 dim:SQ_RSRC_IMG_3D
// GFX11: [0x08,0x03,0x04,0xf0,0x01,0x05,0x02,0x00]

image_load_mip v[5:6], v[252:255], s[8:15] dmask:0x3 dim:SQ_RSRC_IMG_3D
// GFX11: [0x08,0x03,0x04,0xf0,0xfc,0x05,0x02,0x00]

image_load_mip v[5:6], v[1:2], s[8:15] dmask:0x3 dim:SQ_RSRC_IMG_3D a16
// GFX11: [0x08,0x03,0x05,0xf0,0x01,0x05,0x02,0x00]

image_load_mip v[5:6], v[254:255], s[8:15] dmask:0x3 dim:SQ_RSRC_IMG_3D a16
// GFX11: [0x08,0x03,0x05,0xf0,0xfe,0x05,0x02,0x00]

image_load_mip v[5:6], v[1:3], s[8:15] dmask:0x3 dim:SQ_RSRC_IMG_2D
// GFX11: [0x04,0x03,0x04,0xf0,0x01,0x05,0x02,0x00]

image_load_mip v[254:255], v[253:255], s[8:15] dmask:0x3 dim:SQ_RSRC_IMG_2D
// GFX11: [0x04,0x03,0x04,0xf0,0xfd,0xfe,0x02,0x00]

image_load_mip v[5:7], v[1:2], s[8:15] dmask:0x3 dim:SQ_RSRC_IMG_2D a16 tfe
// GFX11: [0x04,0x03,0x05,0xf0,0x01,0x05,0x22,0x00]

image_load_mip v[253:255], v[254:255], s[8:15] dmask:0x3 dim:SQ_RSRC_IMG_2D a16 tfe
// GFX11: [0x04,0x03,0x05,0xf0,0xfe,0xfd,0x22,0x00]

image_load_mip v5, v[1:4], s[8:15] dmask:0x3 dim:SQ_RSRC_IMG_CUBE d16
// GFX11: [0x0c,0x03,0x06,0xf0,0x01,0x05,0x02,0x00]

image_load_mip v255, v[252:255], s[8:15] dmask:0x3 dim:SQ_RSRC_IMG_CUBE d16
// GFX11: [0x0c,0x03,0x06,0xf0,0xfc,0xff,0x02,0x00]

image_load_mip v[5:6], v[1:2], s[8:15] dmask:0x3 dim:SQ_RSRC_IMG_CUBE a16 tfe d16
// GFX11: [0x0c,0x03,0x07,0xf0,0x01,0x05,0x22,0x00]

image_load_mip v[254:255], v[254:255], s[8:15] dmask:0x3 dim:SQ_RSRC_IMG_CUBE a16 tfe d16
// GFX11: [0x0c,0x03,0x07,0xf0,0xfe,0xfe,0x22,0x00]

image_load_mip v5, v[1:3], s[8:15] dmask:0x4 dim:SQ_RSRC_IMG_1D_ARRAY
// GFX11: [0x10,0x04,0x04,0xf0,0x01,0x05,0x02,0x00]

image_load_mip v255, v[253:255], s[8:15] dmask:0x4 dim:SQ_RSRC_IMG_1D_ARRAY
// GFX11: [0x10,0x04,0x04,0xf0,0xfd,0xff,0x02,0x00]

image_load_mip v[5:6], v[1:2], s[8:15] dmask:0x4 dim:SQ_RSRC_IMG_1D_ARRAY a16 tfe
// GFX11: [0x10,0x04,0x05,0xf0,0x01,0x05,0x22,0x00]

image_load_mip v[254:255], v[254:255], s[8:15] dmask:0x4 dim:SQ_RSRC_IMG_1D_ARRAY a16 tfe
// GFX11: [0x10,0x04,0x05,0xf0,0xfe,0xfe,0x22,0x00]

image_load_mip v5, v[1:4], s[8:15] dmask:0x4 dim:SQ_RSRC_IMG_2D_ARRAY d16
// GFX11: [0x14,0x04,0x06,0xf0,0x01,0x05,0x02,0x00]

image_load_mip v255, v[252:255], s[8:15] dmask:0x4 dim:SQ_RSRC_IMG_2D_ARRAY d16
// GFX11: [0x14,0x04,0x06,0xf0,0xfc,0xff,0x02,0x00]

image_load_mip v[5:6], v[1:2], s[96:103] dmask:0x4 dim:SQ_RSRC_IMG_2D_ARRAY a16 tfe d16
// GFX11: [0x14,0x04,0x07,0xf0,0x01,0x05,0x38,0x00]

image_load_mip v[254:255], v[254:255], ttmp[8:15] dmask:0x4 dim:SQ_RSRC_IMG_2D_ARRAY unorm glc slc dlc a16 tfe lwe d16
// GFX11: [0x94,0x74,0x07,0xf0,0xfe,0xfe,0x7d,0x00]

image_load_mip_pck v[5:6], v[1:2], s[8:15] dmask:0x3 dim:SQ_RSRC_IMG_1D
// GFX11: [0x00,0x03,0x10,0xf0,0x01,0x05,0x02,0x00]

image_load_mip_pck v[5:6], v[254:255], s[8:15] dmask:0x3 dim:SQ_RSRC_IMG_1D
// GFX11: [0x00,0x03,0x10,0xf0,0xfe,0x05,0x02,0x00]

image_load_mip_pck v[5:6], v1, s[8:15] dmask:0x3 dim:SQ_RSRC_IMG_1D a16
// GFX11: [0x00,0x03,0x11,0xf0,0x01,0x05,0x02,0x00]

image_load_mip_pck v[5:6], v255, s[8:15] dmask:0x3 dim:SQ_RSRC_IMG_1D a16
// GFX11: [0x00,0x03,0x11,0xf0,0xff,0x05,0x02,0x00]

image_load_mip_pck v[5:6], v[1:4], s[8:15] dmask:0x3 dim:SQ_RSRC_IMG_3D
// GFX11: [0x08,0x03,0x10,0xf0,0x01,0x05,0x02,0x00]

image_load_mip_pck v[5:6], v[252:255], s[8:15] dmask:0x3 dim:SQ_RSRC_IMG_3D
// GFX11: [0x08,0x03,0x10,0xf0,0xfc,0x05,0x02,0x00]

image_load_mip_pck v[5:6], v[1:2], s[8:15] dmask:0x3 dim:SQ_RSRC_IMG_3D a16
// GFX11: [0x08,0x03,0x11,0xf0,0x01,0x05,0x02,0x00]

image_load_mip_pck v[5:6], v[254:255], s[8:15] dmask:0x3 dim:SQ_RSRC_IMG_3D a16
// GFX11: [0x08,0x03,0x11,0xf0,0xfe,0x05,0x02,0x00]

image_load_mip_pck v[5:6], v[1:3], s[8:15] dmask:0x3 dim:SQ_RSRC_IMG_2D
// GFX11: [0x04,0x03,0x10,0xf0,0x01,0x05,0x02,0x00]

image_load_mip_pck v[5:6], v[253:255], s[8:15] dmask:0x3 dim:SQ_RSRC_IMG_2D
// GFX11: [0x04,0x03,0x10,0xf0,0xfd,0x05,0x02,0x00]

image_load_mip_pck v[5:6], v[1:2], s[8:15] dmask:0x3 dim:SQ_RSRC_IMG_2D a16
// GFX11: [0x04,0x03,0x11,0xf0,0x01,0x05,0x02,0x00]

image_load_mip_pck v[5:6], v[254:255], s[8:15] dmask:0x3 dim:SQ_RSRC_IMG_2D a16
// GFX11: [0x04,0x03,0x11,0xf0,0xfe,0x05,0x02,0x00]

image_load_mip_pck v[5:6], v[1:4], s[8:15] dmask:0x3 dim:SQ_RSRC_IMG_CUBE
// GFX11: [0x0c,0x03,0x10,0xf0,0x01,0x05,0x02,0x00]

image_load_mip_pck v[5:6], v[252:255], s[8:15] dmask:0x3 dim:SQ_RSRC_IMG_CUBE
// GFX11: [0x0c,0x03,0x10,0xf0,0xfc,0x05,0x02,0x00]

image_load_mip_pck v[5:6], v[1:2], s[8:15] dmask:0x3 dim:SQ_RSRC_IMG_CUBE a16
// GFX11: [0x0c,0x03,0x11,0xf0,0x01,0x05,0x02,0x00]

image_load_mip_pck v[5:6], v[254:255], s[8:15] dmask:0x3 dim:SQ_RSRC_IMG_CUBE a16
// GFX11: [0x0c,0x03,0x11,0xf0,0xfe,0x05,0x02,0x00]

image_load_mip_pck v[5:6], v[1:3], s[8:15] dmask:0x3 dim:SQ_RSRC_IMG_1D_ARRAY
// GFX11: [0x10,0x03,0x10,0xf0,0x01,0x05,0x02,0x00]

image_load_mip_pck v[254:255], v[253:255], s[8:15] dmask:0x3 dim:SQ_RSRC_IMG_1D_ARRAY
// GFX11: [0x10,0x03,0x10,0xf0,0xfd,0xfe,0x02,0x00]

image_load_mip_pck v[5:7], v[1:2], s[8:15] dmask:0x3 dim:SQ_RSRC_IMG_1D_ARRAY a16 tfe
// GFX11: [0x10,0x03,0x11,0xf0,0x01,0x05,0x22,0x00]

image_load_mip_pck v[253:255], v[254:255], s[8:15] dmask:0x3 dim:SQ_RSRC_IMG_1D_ARRAY a16 tfe
// GFX11: [0x10,0x03,0x11,0xf0,0xfe,0xfd,0x22,0x00]

image_load_mip_pck v5, v[1:4], s[8:15] dmask:0x4 dim:SQ_RSRC_IMG_2D_ARRAY
// GFX11: [0x14,0x04,0x10,0xf0,0x01,0x05,0x02,0x00]

image_load_mip_pck v255, v[252:255], s[8:15] dmask:0x4 dim:SQ_RSRC_IMG_2D_ARRAY
// GFX11: [0x14,0x04,0x10,0xf0,0xfc,0xff,0x02,0x00]

image_load_mip_pck v[5:6], v[1:2], s[96:103] dmask:0x4 dim:SQ_RSRC_IMG_2D_ARRAY a16 tfe
// GFX11: [0x14,0x04,0x11,0xf0,0x01,0x05,0x38,0x00]

image_load_mip_pck v[254:255], v[254:255], ttmp[8:15] dmask:0x4 dim:SQ_RSRC_IMG_2D_ARRAY unorm glc slc dlc a16 tfe lwe
// GFX11: [0x94,0x74,0x11,0xf0,0xfe,0xfe,0x7d,0x00]

image_load_mip_pck_sgn v[5:6], v[1:2], s[8:15] dmask:0x3 dim:SQ_RSRC_IMG_1D
// GFX11: [0x00,0x03,0x14,0xf0,0x01,0x05,0x02,0x00]

image_load_mip_pck_sgn v[5:6], v[254:255], s[8:15] dmask:0x3 dim:SQ_RSRC_IMG_1D
// GFX11: [0x00,0x03,0x14,0xf0,0xfe,0x05,0x02,0x00]

image_load_mip_pck_sgn v[5:6], v1, s[8:15] dmask:0x3 dim:SQ_RSRC_IMG_1D a16
// GFX11: [0x00,0x03,0x15,0xf0,0x01,0x05,0x02,0x00]

image_load_mip_pck_sgn v[5:6], v255, s[8:15] dmask:0x3 dim:SQ_RSRC_IMG_1D a16
// GFX11: [0x00,0x03,0x15,0xf0,0xff,0x05,0x02,0x00]

image_load_mip_pck_sgn v[5:6], v[1:4], s[8:15] dmask:0x3 dim:SQ_RSRC_IMG_3D
// GFX11: [0x08,0x03,0x14,0xf0,0x01,0x05,0x02,0x00]

image_load_mip_pck_sgn v[5:6], v[252:255], s[8:15] dmask:0x3 dim:SQ_RSRC_IMG_3D
// GFX11: [0x08,0x03,0x14,0xf0,0xfc,0x05,0x02,0x00]

image_load_mip_pck_sgn v[5:6], v[1:2], s[8:15] dmask:0x3 dim:SQ_RSRC_IMG_3D a16
// GFX11: [0x08,0x03,0x15,0xf0,0x01,0x05,0x02,0x00]

image_load_mip_pck_sgn v[5:6], v[254:255], s[8:15] dmask:0x3 dim:SQ_RSRC_IMG_3D a16
// GFX11: [0x08,0x03,0x15,0xf0,0xfe,0x05,0x02,0x00]

image_load_mip_pck_sgn v[5:6], v[1:3], s[8:15] dmask:0x3 dim:SQ_RSRC_IMG_2D
// GFX11: [0x04,0x03,0x14,0xf0,0x01,0x05,0x02,0x00]

image_load_mip_pck_sgn v[5:6], v[253:255], s[8:15] dmask:0x3 dim:SQ_RSRC_IMG_2D
// GFX11: [0x04,0x03,0x14,0xf0,0xfd,0x05,0x02,0x00]

image_load_mip_pck_sgn v[5:6], v[1:2], s[8:15] dmask:0x3 dim:SQ_RSRC_IMG_2D a16
// GFX11: [0x04,0x03,0x15,0xf0,0x01,0x05,0x02,0x00]

image_load_mip_pck_sgn v[5:6], v[254:255], s[8:15] dmask:0x3 dim:SQ_RSRC_IMG_2D a16
// GFX11: [0x04,0x03,0x15,0xf0,0xfe,0x05,0x02,0x00]

image_load_mip_pck_sgn v[5:6], v[1:4], s[8:15] dmask:0x3 dim:SQ_RSRC_IMG_CUBE
// GFX11: [0x0c,0x03,0x14,0xf0,0x01,0x05,0x02,0x00]

image_load_mip_pck_sgn v[5:6], v[252:255], s[8:15] dmask:0x3 dim:SQ_RSRC_IMG_CUBE
// GFX11: [0x0c,0x03,0x14,0xf0,0xfc,0x05,0x02,0x00]

image_load_mip_pck_sgn v[5:6], v[1:2], s[8:15] dmask:0x3 dim:SQ_RSRC_IMG_CUBE a16
// GFX11: [0x0c,0x03,0x15,0xf0,0x01,0x05,0x02,0x00]

image_load_mip_pck_sgn v[5:6], v[254:255], s[8:15] dmask:0x3 dim:SQ_RSRC_IMG_CUBE a16
// GFX11: [0x0c,0x03,0x15,0xf0,0xfe,0x05,0x02,0x00]

image_load_mip_pck_sgn v[5:6], v[1:3], s[8:15] dmask:0x3 dim:SQ_RSRC_IMG_1D_ARRAY
// GFX11: [0x10,0x03,0x14,0xf0,0x01,0x05,0x02,0x00]

image_load_mip_pck_sgn v[254:255], v[253:255], s[8:15] dmask:0x3 dim:SQ_RSRC_IMG_1D_ARRAY
// GFX11: [0x10,0x03,0x14,0xf0,0xfd,0xfe,0x02,0x00]

image_load_mip_pck_sgn v[5:7], v[1:2], s[8:15] dmask:0x3 dim:SQ_RSRC_IMG_1D_ARRAY a16 tfe
// GFX11: [0x10,0x03,0x15,0xf0,0x01,0x05,0x22,0x00]

image_load_mip_pck_sgn v[253:255], v[254:255], s[8:15] dmask:0x3 dim:SQ_RSRC_IMG_1D_ARRAY a16 tfe
// GFX11: [0x10,0x03,0x15,0xf0,0xfe,0xfd,0x22,0x00]

image_load_mip_pck_sgn v5, v[1:4], s[8:15] dmask:0x4 dim:SQ_RSRC_IMG_2D_ARRAY
// GFX11: [0x14,0x04,0x14,0xf0,0x01,0x05,0x02,0x00]

image_load_mip_pck_sgn v255, v[252:255], s[8:15] dmask:0x4 dim:SQ_RSRC_IMG_2D_ARRAY
// GFX11: [0x14,0x04,0x14,0xf0,0xfc,0xff,0x02,0x00]

image_load_mip_pck_sgn v[5:6], v[1:2], s[96:103] dmask:0x4 dim:SQ_RSRC_IMG_2D_ARRAY a16 tfe
// GFX11: [0x14,0x04,0x15,0xf0,0x01,0x05,0x38,0x00]

image_load_mip_pck_sgn v[254:255], v[254:255], ttmp[8:15] dmask:0x4 dim:SQ_RSRC_IMG_2D_ARRAY unorm glc slc dlc a16 tfe lwe
// GFX11: [0x94,0x74,0x15,0xf0,0xfe,0xfe,0x7d,0x00]

image_load_pck v[5:6], v1, s[8:15] dmask:0x3 dim:SQ_RSRC_IMG_1D
// GFX11: [0x00,0x03,0x08,0xf0,0x01,0x05,0x02,0x00]

image_load_pck v[5:6], v255, s[8:15] dmask:0x3 dim:SQ_RSRC_IMG_1D
// GFX11: [0x00,0x03,0x08,0xf0,0xff,0x05,0x02,0x00]

image_load_pck v[5:6], v1, s[8:15] dmask:0x3 dim:SQ_RSRC_IMG_1D a16
// GFX11: [0x00,0x03,0x09,0xf0,0x01,0x05,0x02,0x00]

image_load_pck v[5:6], v255, s[8:15] dmask:0x3 dim:SQ_RSRC_IMG_1D a16
// GFX11: [0x00,0x03,0x09,0xf0,0xff,0x05,0x02,0x00]

image_load_pck v[5:6], v[1:3], s[8:15] dmask:0x3 dim:SQ_RSRC_IMG_3D
// GFX11: [0x08,0x03,0x08,0xf0,0x01,0x05,0x02,0x00]

image_load_pck v[5:6], v[253:255], s[8:15] dmask:0x3 dim:SQ_RSRC_IMG_3D
// GFX11: [0x08,0x03,0x08,0xf0,0xfd,0x05,0x02,0x00]

image_load_pck v[5:6], v[1:2], s[8:15] dmask:0x3 dim:SQ_RSRC_IMG_3D a16
// GFX11: [0x08,0x03,0x09,0xf0,0x01,0x05,0x02,0x00]

image_load_pck v[5:6], v[254:255], s[8:15] dmask:0x3 dim:SQ_RSRC_IMG_3D a16
// GFX11: [0x08,0x03,0x09,0xf0,0xfe,0x05,0x02,0x00]

image_load_pck v[5:6], v[1:4], s[8:15] dmask:0x3 dim:SQ_RSRC_IMG_2D_MSAA_ARRAY
// GFX11: [0x1c,0x03,0x08,0xf0,0x01,0x05,0x02,0x00]

image_load_pck v[5:6], v[252:255], s[8:15] dmask:0x3 dim:SQ_RSRC_IMG_2D_MSAA_ARRAY
// GFX11: [0x1c,0x03,0x08,0xf0,0xfc,0x05,0x02,0x00]

image_load_pck v[5:6], v[1:2], s[8:15] dmask:0x3 dim:SQ_RSRC_IMG_2D_MSAA_ARRAY a16
// GFX11: [0x1c,0x03,0x09,0xf0,0x01,0x05,0x02,0x00]

image_load_pck v[5:6], v[254:255], s[8:15] dmask:0x3 dim:SQ_RSRC_IMG_2D_MSAA_ARRAY a16
// GFX11: [0x1c,0x03,0x09,0xf0,0xfe,0x05,0x02,0x00]

image_load_pck v[5:6], v[1:2], s[8:15] dmask:0x3 dim:SQ_RSRC_IMG_2D
// GFX11: [0x04,0x03,0x08,0xf0,0x01,0x05,0x02,0x00]

image_load_pck v[5:6], v[254:255], s[8:15] dmask:0x3 dim:SQ_RSRC_IMG_2D
// GFX11: [0x04,0x03,0x08,0xf0,0xfe,0x05,0x02,0x00]

image_load_pck v[5:6], v1, s[8:15] dmask:0x3 dim:SQ_RSRC_IMG_2D a16
// GFX11: [0x04,0x03,0x09,0xf0,0x01,0x05,0x02,0x00]

image_load_pck v[5:6], v255, s[8:15] dmask:0x3 dim:SQ_RSRC_IMG_2D a16
// GFX11: [0x04,0x03,0x09,0xf0,0xff,0x05,0x02,0x00]

image_load_pck v[5:6], v[1:3], s[8:15] dmask:0x3 dim:SQ_RSRC_IMG_CUBE
// GFX11: [0x0c,0x03,0x08,0xf0,0x01,0x05,0x02,0x00]

image_load_pck v[5:6], v[253:255], s[8:15] dmask:0x3 dim:SQ_RSRC_IMG_CUBE
// GFX11: [0x0c,0x03,0x08,0xf0,0xfd,0x05,0x02,0x00]

image_load_pck v[5:6], v[1:2], s[8:15] dmask:0x3 dim:SQ_RSRC_IMG_CUBE a16
// GFX11: [0x0c,0x03,0x09,0xf0,0x01,0x05,0x02,0x00]

image_load_pck v[5:6], v[254:255], s[8:15] dmask:0x3 dim:SQ_RSRC_IMG_CUBE a16
// GFX11: [0x0c,0x03,0x09,0xf0,0xfe,0x05,0x02,0x00]

image_load_pck v[5:6], v[1:2], s[8:15] dmask:0x3 dim:SQ_RSRC_IMG_1D_ARRAY
// GFX11: [0x10,0x03,0x08,0xf0,0x01,0x05,0x02,0x00]

image_load_pck v[5:6], v[254:255], s[8:15] dmask:0x3 dim:SQ_RSRC_IMG_1D_ARRAY
// GFX11: [0x10,0x03,0x08,0xf0,0xfe,0x05,0x02,0x00]

image_load_pck v[5:6], v1, s[8:15] dmask:0x3 dim:SQ_RSRC_IMG_1D_ARRAY a16
// GFX11: [0x10,0x03,0x09,0xf0,0x01,0x05,0x02,0x00]

image_load_pck v[5:6], v255, s[8:15] dmask:0x3 dim:SQ_RSRC_IMG_1D_ARRAY a16
// GFX11: [0x10,0x03,0x09,0xf0,0xff,0x05,0x02,0x00]

image_load_pck v[5:6], v[1:3], s[8:15] dmask:0x3 dim:SQ_RSRC_IMG_2D_ARRAY
// GFX11: [0x14,0x03,0x08,0xf0,0x01,0x05,0x02,0x00]

image_load_pck v[254:255], v[253:255], s[8:15] dmask:0x3 dim:SQ_RSRC_IMG_2D_ARRAY
// GFX11: [0x14,0x03,0x08,0xf0,0xfd,0xfe,0x02,0x00]

image_load_pck v[5:7], v[1:2], s[8:15] dmask:0x3 dim:SQ_RSRC_IMG_2D_ARRAY a16 tfe
// GFX11: [0x14,0x03,0x09,0xf0,0x01,0x05,0x22,0x00]

image_load_pck v[253:255], v[254:255], s[8:15] dmask:0x3 dim:SQ_RSRC_IMG_2D_ARRAY a16 tfe
// GFX11: [0x14,0x03,0x09,0xf0,0xfe,0xfd,0x22,0x00]

image_load_pck v5, v[1:3], s[8:15] dmask:0x4 dim:SQ_RSRC_IMG_2D_MSAA
// GFX11: [0x18,0x04,0x08,0xf0,0x01,0x05,0x02,0x00]

image_load_pck v255, v[253:255], s[8:15] dmask:0x4 dim:SQ_RSRC_IMG_2D_MSAA
// GFX11: [0x18,0x04,0x08,0xf0,0xfd,0xff,0x02,0x00]

image_load_pck v[5:6], v[1:2], s[96:103] dmask:0x4 dim:SQ_RSRC_IMG_2D_MSAA a16 tfe
// GFX11: [0x18,0x04,0x09,0xf0,0x01,0x05,0x38,0x00]

image_load_pck v[254:255], v[254:255], ttmp[8:15] dmask:0x4 dim:SQ_RSRC_IMG_2D_MSAA unorm glc slc dlc a16 tfe lwe
// GFX11: [0x98,0x74,0x09,0xf0,0xfe,0xfe,0x7d,0x00]

image_load_pck_sgn v[5:6], v1, s[8:15] dmask:0x3 dim:SQ_RSRC_IMG_1D
// GFX11: [0x00,0x03,0x0c,0xf0,0x01,0x05,0x02,0x00]

image_load_pck_sgn v[5:6], v255, s[8:15] dmask:0x3 dim:SQ_RSRC_IMG_1D
// GFX11: [0x00,0x03,0x0c,0xf0,0xff,0x05,0x02,0x00]

image_load_pck_sgn v[5:6], v1, s[8:15] dmask:0x3 dim:SQ_RSRC_IMG_1D a16
// GFX11: [0x00,0x03,0x0d,0xf0,0x01,0x05,0x02,0x00]

image_load_pck_sgn v[5:6], v255, s[8:15] dmask:0x3 dim:SQ_RSRC_IMG_1D a16
// GFX11: [0x00,0x03,0x0d,0xf0,0xff,0x05,0x02,0x00]

image_load_pck_sgn v[5:6], v[1:3], s[8:15] dmask:0x3 dim:SQ_RSRC_IMG_3D
// GFX11: [0x08,0x03,0x0c,0xf0,0x01,0x05,0x02,0x00]

image_load_pck_sgn v[5:6], v[253:255], s[8:15] dmask:0x3 dim:SQ_RSRC_IMG_3D
// GFX11: [0x08,0x03,0x0c,0xf0,0xfd,0x05,0x02,0x00]

image_load_pck_sgn v[5:6], v[1:2], s[8:15] dmask:0x3 dim:SQ_RSRC_IMG_3D a16
// GFX11: [0x08,0x03,0x0d,0xf0,0x01,0x05,0x02,0x00]

image_load_pck_sgn v[5:6], v[254:255], s[8:15] dmask:0x3 dim:SQ_RSRC_IMG_3D a16
// GFX11: [0x08,0x03,0x0d,0xf0,0xfe,0x05,0x02,0x00]

image_load_pck_sgn v[5:6], v[1:4], s[8:15] dmask:0x3 dim:SQ_RSRC_IMG_2D_MSAA_ARRAY
// GFX11: [0x1c,0x03,0x0c,0xf0,0x01,0x05,0x02,0x00]

image_load_pck_sgn v[5:6], v[252:255], s[8:15] dmask:0x3 dim:SQ_RSRC_IMG_2D_MSAA_ARRAY
// GFX11: [0x1c,0x03,0x0c,0xf0,0xfc,0x05,0x02,0x00]

image_load_pck_sgn v[5:6], v[1:2], s[8:15] dmask:0x3 dim:SQ_RSRC_IMG_2D_MSAA_ARRAY a16
// GFX11: [0x1c,0x03,0x0d,0xf0,0x01,0x05,0x02,0x00]

image_load_pck_sgn v[5:6], v[254:255], s[8:15] dmask:0x3 dim:SQ_RSRC_IMG_2D_MSAA_ARRAY a16
// GFX11: [0x1c,0x03,0x0d,0xf0,0xfe,0x05,0x02,0x00]

image_load_pck_sgn v[5:6], v[1:2], s[8:15] dmask:0x3 dim:SQ_RSRC_IMG_2D
// GFX11: [0x04,0x03,0x0c,0xf0,0x01,0x05,0x02,0x00]

image_load_pck_sgn v[5:6], v[254:255], s[8:15] dmask:0x3 dim:SQ_RSRC_IMG_2D
// GFX11: [0x04,0x03,0x0c,0xf0,0xfe,0x05,0x02,0x00]

image_load_pck_sgn v[5:6], v1, s[8:15] dmask:0x3 dim:SQ_RSRC_IMG_2D a16
// GFX11: [0x04,0x03,0x0d,0xf0,0x01,0x05,0x02,0x00]

image_load_pck_sgn v[5:6], v255, s[8:15] dmask:0x3 dim:SQ_RSRC_IMG_2D a16
// GFX11: [0x04,0x03,0x0d,0xf0,0xff,0x05,0x02,0x00]

image_load_pck_sgn v[5:6], v[1:3], s[8:15] dmask:0x3 dim:SQ_RSRC_IMG_CUBE
// GFX11: [0x0c,0x03,0x0c,0xf0,0x01,0x05,0x02,0x00]

image_load_pck_sgn v[5:6], v[253:255], s[8:15] dmask:0x3 dim:SQ_RSRC_IMG_CUBE
// GFX11: [0x0c,0x03,0x0c,0xf0,0xfd,0x05,0x02,0x00]

image_load_pck_sgn v[5:6], v[1:2], s[8:15] dmask:0x3 dim:SQ_RSRC_IMG_CUBE a16
// GFX11: [0x0c,0x03,0x0d,0xf0,0x01,0x05,0x02,0x00]

image_load_pck_sgn v[5:6], v[254:255], s[8:15] dmask:0x3 dim:SQ_RSRC_IMG_CUBE a16
// GFX11: [0x0c,0x03,0x0d,0xf0,0xfe,0x05,0x02,0x00]

image_load_pck_sgn v[5:6], v[1:2], s[8:15] dmask:0x3 dim:SQ_RSRC_IMG_1D_ARRAY
// GFX11: [0x10,0x03,0x0c,0xf0,0x01,0x05,0x02,0x00]

image_load_pck_sgn v[5:6], v[254:255], s[8:15] dmask:0x3 dim:SQ_RSRC_IMG_1D_ARRAY
// GFX11: [0x10,0x03,0x0c,0xf0,0xfe,0x05,0x02,0x00]

image_load_pck_sgn v[5:6], v1, s[8:15] dmask:0x3 dim:SQ_RSRC_IMG_1D_ARRAY a16
// GFX11: [0x10,0x03,0x0d,0xf0,0x01,0x05,0x02,0x00]

image_load_pck_sgn v[5:6], v255, s[8:15] dmask:0x3 dim:SQ_RSRC_IMG_1D_ARRAY a16
// GFX11: [0x10,0x03,0x0d,0xf0,0xff,0x05,0x02,0x00]

image_load_pck_sgn v[5:6], v[1:3], s[8:15] dmask:0x3 dim:SQ_RSRC_IMG_2D_ARRAY
// GFX11: [0x14,0x03,0x0c,0xf0,0x01,0x05,0x02,0x00]

image_load_pck_sgn v[254:255], v[253:255], s[8:15] dmask:0x3 dim:SQ_RSRC_IMG_2D_ARRAY
// GFX11: [0x14,0x03,0x0c,0xf0,0xfd,0xfe,0x02,0x00]

image_load_pck_sgn v[5:7], v[1:2], s[8:15] dmask:0x3 dim:SQ_RSRC_IMG_2D_ARRAY a16 tfe
// GFX11: [0x14,0x03,0x0d,0xf0,0x01,0x05,0x22,0x00]

image_load_pck_sgn v[253:255], v[254:255], s[8:15] dmask:0x3 dim:SQ_RSRC_IMG_2D_ARRAY a16 tfe
// GFX11: [0x14,0x03,0x0d,0xf0,0xfe,0xfd,0x22,0x00]

image_load_pck_sgn v5, v[1:3], s[8:15] dmask:0x4 dim:SQ_RSRC_IMG_2D_MSAA
// GFX11: [0x18,0x04,0x0c,0xf0,0x01,0x05,0x02,0x00]

image_load_pck_sgn v255, v[253:255], s[8:15] dmask:0x4 dim:SQ_RSRC_IMG_2D_MSAA
// GFX11: [0x18,0x04,0x0c,0xf0,0xfd,0xff,0x02,0x00]

image_load_pck_sgn v[5:6], v[1:2], s[96:103] dmask:0x4 dim:SQ_RSRC_IMG_2D_MSAA a16 tfe
// GFX11: [0x18,0x04,0x0d,0xf0,0x01,0x05,0x38,0x00]

image_load_pck_sgn v[254:255], v[254:255], ttmp[8:15] dmask:0x4 dim:SQ_RSRC_IMG_2D_MSAA unorm glc slc dlc a16 tfe lwe
// GFX11: [0x98,0x74,0x0d,0xf0,0xfe,0xfe,0x7d,0x00]

image_msaa_load v[5:8], v[1:4], s[8:15] dmask:0x4 dim:SQ_RSRC_IMG_2D_MSAA_ARRAY
// GFX11: [0x1c,0x04,0x60,0xf0,0x01,0x05,0x02,0x00]

image_msaa_load v[252:255], v[252:255], s[8:15] dmask:0x4 dim:SQ_RSRC_IMG_2D_MSAA_ARRAY
// GFX11: [0x1c,0x04,0x60,0xf0,0xfc,0xfc,0x02,0x00]

image_msaa_load v[5:9], v[1:2], s[8:15] dmask:0x4 dim:SQ_RSRC_IMG_2D_MSAA_ARRAY a16 tfe
// GFX11: [0x1c,0x04,0x61,0xf0,0x01,0x05,0x22,0x00]

image_msaa_load v[251:255], v[254:255], s[8:15] dmask:0x4 dim:SQ_RSRC_IMG_2D_MSAA_ARRAY a16 tfe
// GFX11: [0x1c,0x04,0x61,0xf0,0xfe,0xfb,0x22,0x00]

image_msaa_load v[5:6], v[1:3], s[8:15] dmask:0x4 dim:SQ_RSRC_IMG_2D_MSAA d16
// GFX11: [0x18,0x04,0x62,0xf0,0x01,0x05,0x02,0x00]

image_msaa_load v[254:255], v[253:255], s[8:15] dmask:0x4 dim:SQ_RSRC_IMG_2D_MSAA d16
// GFX11: [0x18,0x04,0x62,0xf0,0xfd,0xfe,0x02,0x00]

image_msaa_load v[5:7], v[1:2], s[96:103] dmask:0x4 dim:SQ_RSRC_IMG_2D_MSAA a16 tfe d16
// GFX11: [0x18,0x04,0x63,0xf0,0x01,0x05,0x38,0x00]

image_msaa_load v[253:255], v[254:255], ttmp[8:15] dmask:0x4 dim:SQ_RSRC_IMG_2D_MSAA unorm glc slc dlc a16 tfe lwe d16
// GFX11: [0x98,0x74,0x63,0xf0,0xfe,0xfd,0x7d,0x00]

image_sample v[5:6], v1, s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_1D
// GFX11: [0x00,0x03,0x6c,0xf0,0x01,0x05,0x02,0x0c]

image_sample v[5:6], v255, s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_1D
// GFX11: [0x00,0x03,0x6c,0xf0,0xff,0x05,0x02,0x0c]

image_sample v[5:6], v1, s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_1D a16
// GFX11: [0x00,0x03,0x6d,0xf0,0x01,0x05,0x02,0x0c]

image_sample v[5:6], v255, s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_1D a16
// GFX11: [0x00,0x03,0x6d,0xf0,0xff,0x05,0x02,0x0c]

image_sample v[5:6], v[1:3], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_3D
// GFX11: [0x08,0x03,0x6c,0xf0,0x01,0x05,0x02,0x0c]

image_sample v[5:6], v[253:255], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_3D
// GFX11: [0x08,0x03,0x6c,0xf0,0xfd,0x05,0x02,0x0c]

image_sample v[5:6], v[1:2], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_3D a16
// GFX11: [0x08,0x03,0x6d,0xf0,0x01,0x05,0x02,0x0c]

image_sample v[5:6], v[254:255], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_3D a16
// GFX11: [0x08,0x03,0x6d,0xf0,0xfe,0x05,0x02,0x0c]

image_sample v[5:6], v[1:2], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_2D
// GFX11: [0x04,0x03,0x6c,0xf0,0x01,0x05,0x02,0x0c]

image_sample v[254:255], v[254:255], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_2D
// GFX11: [0x04,0x03,0x6c,0xf0,0xfe,0xfe,0x02,0x0c]

image_sample v[5:7], v1, s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_2D a16 tfe
// GFX11: [0x04,0x03,0x6d,0xf0,0x01,0x05,0x22,0x0c]

image_sample v[253:255], v255, s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_2D a16 tfe
// GFX11: [0x04,0x03,0x6d,0xf0,0xff,0xfd,0x22,0x0c]

image_sample v5, v[1:3], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_CUBE d16
// GFX11: [0x0c,0x03,0x6e,0xf0,0x01,0x05,0x02,0x0c]

image_sample v255, v[253:255], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_CUBE d16
// GFX11: [0x0c,0x03,0x6e,0xf0,0xfd,0xff,0x02,0x0c]

image_sample v[5:6], v[1:2], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_CUBE a16 tfe d16
// GFX11: [0x0c,0x03,0x6f,0xf0,0x01,0x05,0x22,0x0c]

image_sample v[254:255], v[254:255], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_CUBE a16 tfe d16
// GFX11: [0x0c,0x03,0x6f,0xf0,0xfe,0xfe,0x22,0x0c]

image_sample v5, v[1:2], s[8:15], s[12:15] dmask:0x4 dim:SQ_RSRC_IMG_1D_ARRAY
// GFX11: [0x10,0x04,0x6c,0xf0,0x01,0x05,0x02,0x0c]

image_sample v255, v[254:255], s[8:15], s[12:15] dmask:0x4 dim:SQ_RSRC_IMG_1D_ARRAY
// GFX11: [0x10,0x04,0x6c,0xf0,0xfe,0xff,0x02,0x0c]

image_sample v[5:6], v1, s[8:15], s[12:15] dmask:0x4 dim:SQ_RSRC_IMG_1D_ARRAY a16 tfe
// GFX11: [0x10,0x04,0x6d,0xf0,0x01,0x05,0x22,0x0c]

image_sample v[254:255], v255, s[8:15], s[12:15] dmask:0x4 dim:SQ_RSRC_IMG_1D_ARRAY a16 tfe
// GFX11: [0x10,0x04,0x6d,0xf0,0xff,0xfe,0x22,0x0c]

image_sample v5, v[1:3], s[8:15], s[12:15] dmask:0x4 dim:SQ_RSRC_IMG_2D_ARRAY d16
// GFX11: [0x14,0x04,0x6e,0xf0,0x01,0x05,0x02,0x0c]

image_sample v255, v[253:255], s[8:15], s[12:15] dmask:0x4 dim:SQ_RSRC_IMG_2D_ARRAY d16
// GFX11: [0x14,0x04,0x6e,0xf0,0xfd,0xff,0x02,0x0c]

image_sample v[5:6], v[1:2], s[96:103], s[100:103] dmask:0x4 dim:SQ_RSRC_IMG_2D_ARRAY a16 tfe d16
// GFX11: [0x14,0x04,0x6f,0xf0,0x01,0x05,0x38,0x64]

image_sample v[254:255], v[254:255], ttmp[8:15], ttmp[12:15] dmask:0x4 dim:SQ_RSRC_IMG_2D_ARRAY unorm glc slc dlc a16 tfe lwe d16
// GFX11: [0x94,0x74,0x6f,0xf0,0xfe,0xfe,0x7d,0x78]

image_sample_b v[5:6], v[1:2], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_1D
// GFX11: [0x00,0x03,0x78,0xf0,0x01,0x05,0x02,0x0c]

image_sample_b v[254:255], v[1:2], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_1D
// GFX11: [0x00,0x03,0x78,0xf0,0x01,0xfe,0x02,0x0c]

image_sample_b v[5:7], v[1:2], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_1D tfe
// GFX11: [0x00,0x03,0x78,0xf0,0x01,0x05,0x22,0x0c]

image_sample_b v[253:255], v[1:2], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_1D tfe
// GFX11: [0x00,0x03,0x78,0xf0,0x01,0xfd,0x22,0x0c]

image_sample_b v5, v[1:2], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_1D d16
// GFX11: [0x00,0x03,0x7a,0xf0,0x01,0x05,0x02,0x0c]

image_sample_b v255, v[254:255], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_1D d16
// GFX11: [0x00,0x03,0x7a,0xf0,0xfe,0xff,0x02,0x0c]

image_sample_b v[5:6], v[1:4], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_3D tfe d16
// GFX11: [0x08,0x03,0x7a,0xf0,0x01,0x05,0x22,0x0c]

image_sample_b v[254:255], v[252:255], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_3D tfe d16
// GFX11: [0x08,0x03,0x7a,0xf0,0xfc,0xfe,0x22,0x0c]

image_sample_b v5, v[1:3], s[8:15], s[12:15] dmask:0x4 dim:SQ_RSRC_IMG_2D
// GFX11: [0x04,0x04,0x78,0xf0,0x01,0x05,0x02,0x0c]

image_sample_b v255, v[253:255], s[8:15], s[12:15] dmask:0x4 dim:SQ_RSRC_IMG_2D
// GFX11: [0x04,0x04,0x78,0xf0,0xfd,0xff,0x02,0x0c]

image_sample_b v[5:6], v[1:4], s[8:15], s[12:15] dmask:0x4 dim:SQ_RSRC_IMG_CUBE tfe
// GFX11: [0x0c,0x04,0x78,0xf0,0x01,0x05,0x22,0x0c]

image_sample_b v[254:255], v[252:255], s[8:15], s[12:15] dmask:0x4 dim:SQ_RSRC_IMG_CUBE tfe
// GFX11: [0x0c,0x04,0x78,0xf0,0xfc,0xfe,0x22,0x0c]

image_sample_b v5, v[1:3], s[8:15], s[12:15] dmask:0x4 dim:SQ_RSRC_IMG_1D_ARRAY d16
// GFX11: [0x10,0x04,0x7a,0xf0,0x01,0x05,0x02,0x0c]

image_sample_b v255, v[253:255], s[8:15], s[12:15] dmask:0x4 dim:SQ_RSRC_IMG_1D_ARRAY d16
// GFX11: [0x10,0x04,0x7a,0xf0,0xfd,0xff,0x02,0x0c]

image_sample_b v[5:6], v[1:4], s[96:103], s[100:103] dmask:0x4 dim:SQ_RSRC_IMG_2D_ARRAY tfe d16
// GFX11: [0x14,0x04,0x7a,0xf0,0x01,0x05,0x38,0x64]

image_sample_b v[254:255], v[252:255], ttmp[8:15], ttmp[12:15] dmask:0x4 dim:SQ_RSRC_IMG_2D_ARRAY unorm glc slc dlc tfe lwe d16
// GFX11: [0x94,0x74,0x7a,0xf0,0xfc,0xfe,0x7d,0x78]

image_sample_b_cl v[5:6], v[1:3], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_1D
// GFX11: [0x00,0x03,0x08,0xf1,0x01,0x05,0x02,0x0c]

image_sample_b_cl v[254:255], v[1:3], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_1D
// GFX11: [0x00,0x03,0x08,0xf1,0x01,0xfe,0x02,0x0c]

image_sample_b_cl v[5:7], v[1:3], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_1D tfe
// GFX11: [0x00,0x03,0x08,0xf1,0x01,0x05,0x22,0x0c]

image_sample_b_cl v[253:255], v[1:3], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_1D tfe
// GFX11: [0x00,0x03,0x08,0xf1,0x01,0xfd,0x22,0x0c]

image_sample_b_cl v5, v[1:3], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_1D d16
// GFX11: [0x00,0x03,0x0a,0xf1,0x01,0x05,0x02,0x0c]

image_sample_b_cl v255, v[253:255], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_1D d16
// GFX11: [0x00,0x03,0x0a,0xf1,0xfd,0xff,0x02,0x0c]

image_sample_b_cl v[5:6], v[1:5], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_3D tfe d16
// GFX11: [0x08,0x03,0x0a,0xf1,0x01,0x05,0x22,0x0c]

image_sample_b_cl v[254:255], v[251:255], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_3D tfe d16
// GFX11: [0x08,0x03,0x0a,0xf1,0xfb,0xfe,0x22,0x0c]

image_sample_b_cl v5, v[1:4], s[8:15], s[12:15] dmask:0x4 dim:SQ_RSRC_IMG_2D
// GFX11: [0x04,0x04,0x08,0xf1,0x01,0x05,0x02,0x0c]

image_sample_b_cl v255, v[252:255], s[8:15], s[12:15] dmask:0x4 dim:SQ_RSRC_IMG_2D
// GFX11: [0x04,0x04,0x08,0xf1,0xfc,0xff,0x02,0x0c]

image_sample_b_cl v[5:6], v[1:5], s[8:15], s[12:15] dmask:0x4 dim:SQ_RSRC_IMG_CUBE tfe
// GFX11: [0x0c,0x04,0x08,0xf1,0x01,0x05,0x22,0x0c]

image_sample_b_cl v[254:255], v[251:255], s[8:15], s[12:15] dmask:0x4 dim:SQ_RSRC_IMG_CUBE tfe
// GFX11: [0x0c,0x04,0x08,0xf1,0xfb,0xfe,0x22,0x0c]

image_sample_b_cl v5, v[1:4], s[8:15], s[12:15] dmask:0x4 dim:SQ_RSRC_IMG_1D_ARRAY d16
// GFX11: [0x10,0x04,0x0a,0xf1,0x01,0x05,0x02,0x0c]

image_sample_b_cl v255, v[252:255], s[8:15], s[12:15] dmask:0x4 dim:SQ_RSRC_IMG_1D_ARRAY d16
// GFX11: [0x10,0x04,0x0a,0xf1,0xfc,0xff,0x02,0x0c]

image_sample_b_cl v[5:6], v[1:5], s[96:103], s[100:103] dmask:0x4 dim:SQ_RSRC_IMG_2D_ARRAY tfe d16
// GFX11: [0x14,0x04,0x0a,0xf1,0x01,0x05,0x38,0x64]

image_sample_b_cl v[254:255], v[251:255], ttmp[8:15], ttmp[12:15] dmask:0x4 dim:SQ_RSRC_IMG_2D_ARRAY unorm glc slc dlc tfe lwe d16
// GFX11: [0x94,0x74,0x0a,0xf1,0xfb,0xfe,0x7d,0x78]

image_sample_b_cl_o v[5:6], v[1:4], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_1D
// GFX11: [0x00,0x03,0x20,0xf1,0x01,0x05,0x02,0x0c]

image_sample_b_cl_o v[254:255], v[1:4], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_1D
// GFX11: [0x00,0x03,0x20,0xf1,0x01,0xfe,0x02,0x0c]

image_sample_b_cl_o v[5:7], v[1:4], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_1D tfe
// GFX11: [0x00,0x03,0x20,0xf1,0x01,0x05,0x22,0x0c]

image_sample_b_cl_o v[253:255], v[1:4], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_1D tfe
// GFX11: [0x00,0x03,0x20,0xf1,0x01,0xfd,0x22,0x0c]

image_sample_b_cl_o v5, v[1:4], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_1D d16
// GFX11: [0x00,0x03,0x22,0xf1,0x01,0x05,0x02,0x0c]

image_sample_b_cl_o v255, v[252:255], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_1D d16
// GFX11: [0x00,0x03,0x22,0xf1,0xfc,0xff,0x02,0x0c]

image_sample_b_cl_o v[5:6], v[1:6], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_3D tfe d16
// GFX11: [0x08,0x03,0x22,0xf1,0x01,0x05,0x22,0x0c]

image_sample_b_cl_o v[254:255], v[250:255], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_3D tfe d16
// GFX11: [0x08,0x03,0x22,0xf1,0xfa,0xfe,0x22,0x0c]

image_sample_b_cl_o v5, v[1:5], s[8:15], s[12:15] dmask:0x4 dim:SQ_RSRC_IMG_2D
// GFX11: [0x04,0x04,0x20,0xf1,0x01,0x05,0x02,0x0c]

image_sample_b_cl_o v255, v[251:255], s[8:15], s[12:15] dmask:0x4 dim:SQ_RSRC_IMG_2D
// GFX11: [0x04,0x04,0x20,0xf1,0xfb,0xff,0x02,0x0c]

image_sample_b_cl_o v[5:6], v[1:6], s[8:15], s[12:15] dmask:0x4 dim:SQ_RSRC_IMG_CUBE tfe
// GFX11: [0x0c,0x04,0x20,0xf1,0x01,0x05,0x22,0x0c]

image_sample_b_cl_o v[254:255], v[250:255], s[8:15], s[12:15] dmask:0x4 dim:SQ_RSRC_IMG_CUBE tfe
// GFX11: [0x0c,0x04,0x20,0xf1,0xfa,0xfe,0x22,0x0c]

image_sample_b_cl_o v5, v[1:5], s[8:15], s[12:15] dmask:0x4 dim:SQ_RSRC_IMG_1D_ARRAY d16
// GFX11: [0x10,0x04,0x22,0xf1,0x01,0x05,0x02,0x0c]

image_sample_b_cl_o v255, v[251:255], s[8:15], s[12:15] dmask:0x4 dim:SQ_RSRC_IMG_1D_ARRAY d16
// GFX11: [0x10,0x04,0x22,0xf1,0xfb,0xff,0x02,0x0c]

image_sample_b_cl_o v[5:6], v[1:6], s[96:103], s[100:103] dmask:0x4 dim:SQ_RSRC_IMG_2D_ARRAY tfe d16
// GFX11: [0x14,0x04,0x22,0xf1,0x01,0x05,0x38,0x64]

image_sample_b_cl_o v[254:255], v[250:255], ttmp[8:15], ttmp[12:15] dmask:0x4 dim:SQ_RSRC_IMG_2D_ARRAY unorm glc slc dlc tfe lwe d16
// GFX11: [0x94,0x74,0x22,0xf1,0xfa,0xfe,0x7d,0x78]

image_sample_b_o v[5:6], v[1:3], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_1D
// GFX11: [0x00,0x03,0xa0,0xf0,0x01,0x05,0x02,0x0c]

image_sample_b_o v[254:255], v[1:3], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_1D
// GFX11: [0x00,0x03,0xa0,0xf0,0x01,0xfe,0x02,0x0c]

image_sample_b_o v[5:7], v[1:3], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_1D tfe
// GFX11: [0x00,0x03,0xa0,0xf0,0x01,0x05,0x22,0x0c]

image_sample_b_o v[253:255], v[1:3], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_1D tfe
// GFX11: [0x00,0x03,0xa0,0xf0,0x01,0xfd,0x22,0x0c]

image_sample_b_o v5, v[1:3], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_1D d16
// GFX11: [0x00,0x03,0xa2,0xf0,0x01,0x05,0x02,0x0c]

image_sample_b_o v255, v[253:255], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_1D d16
// GFX11: [0x00,0x03,0xa2,0xf0,0xfd,0xff,0x02,0x0c]

image_sample_b_o v[5:6], v[1:5], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_3D tfe d16
// GFX11: [0x08,0x03,0xa2,0xf0,0x01,0x05,0x22,0x0c]

image_sample_b_o v[254:255], v[251:255], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_3D tfe d16
// GFX11: [0x08,0x03,0xa2,0xf0,0xfb,0xfe,0x22,0x0c]

image_sample_b_o v5, v[1:4], s[8:15], s[12:15] dmask:0x4 dim:SQ_RSRC_IMG_2D
// GFX11: [0x04,0x04,0xa0,0xf0,0x01,0x05,0x02,0x0c]

image_sample_b_o v255, v[252:255], s[8:15], s[12:15] dmask:0x4 dim:SQ_RSRC_IMG_2D
// GFX11: [0x04,0x04,0xa0,0xf0,0xfc,0xff,0x02,0x0c]

image_sample_b_o v[5:6], v[1:5], s[8:15], s[12:15] dmask:0x4 dim:SQ_RSRC_IMG_CUBE tfe
// GFX11: [0x0c,0x04,0xa0,0xf0,0x01,0x05,0x22,0x0c]

image_sample_b_o v[254:255], v[251:255], s[8:15], s[12:15] dmask:0x4 dim:SQ_RSRC_IMG_CUBE tfe
// GFX11: [0x0c,0x04,0xa0,0xf0,0xfb,0xfe,0x22,0x0c]

image_sample_b_o v5, v[1:4], s[8:15], s[12:15] dmask:0x4 dim:SQ_RSRC_IMG_1D_ARRAY d16
// GFX11: [0x10,0x04,0xa2,0xf0,0x01,0x05,0x02,0x0c]

image_sample_b_o v255, v[252:255], s[8:15], s[12:15] dmask:0x4 dim:SQ_RSRC_IMG_1D_ARRAY d16
// GFX11: [0x10,0x04,0xa2,0xf0,0xfc,0xff,0x02,0x0c]

image_sample_b_o v[5:6], v[1:5], s[96:103], s[100:103] dmask:0x4 dim:SQ_RSRC_IMG_2D_ARRAY tfe d16
// GFX11: [0x14,0x04,0xa2,0xf0,0x01,0x05,0x38,0x64]

image_sample_b_o v[254:255], v[251:255], ttmp[8:15], ttmp[12:15] dmask:0x4 dim:SQ_RSRC_IMG_2D_ARRAY unorm glc slc dlc tfe lwe d16
// GFX11: [0x94,0x74,0xa2,0xf0,0xfb,0xfe,0x7d,0x78]

image_sample_c v[5:6], v[1:2], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_1D
// GFX11: [0x00,0x03,0x80,0xf0,0x01,0x05,0x02,0x0c]

image_sample_c v[5:6], v[254:255], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_1D
// GFX11: [0x00,0x03,0x80,0xf0,0xfe,0x05,0x02,0x0c]

image_sample_c v[5:6], v[1:2], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_1D a16
// GFX11: [0x00,0x03,0x81,0xf0,0x01,0x05,0x02,0x0c]

image_sample_c v[5:6], v[254:255], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_1D a16
// GFX11: [0x00,0x03,0x81,0xf0,0xfe,0x05,0x02,0x0c]

image_sample_c v[5:6], v[1:4], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_3D
// GFX11: [0x08,0x03,0x80,0xf0,0x01,0x05,0x02,0x0c]

image_sample_c v[5:6], v[252:255], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_3D
// GFX11: [0x08,0x03,0x80,0xf0,0xfc,0x05,0x02,0x0c]

image_sample_c v[5:6], v[1:3], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_3D a16
// GFX11: [0x08,0x03,0x81,0xf0,0x01,0x05,0x02,0x0c]

image_sample_c v[5:6], v[253:255], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_3D a16
// GFX11: [0x08,0x03,0x81,0xf0,0xfd,0x05,0x02,0x0c]

image_sample_c v[5:6], v[1:3], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_2D
// GFX11: [0x04,0x03,0x80,0xf0,0x01,0x05,0x02,0x0c]

image_sample_c v[254:255], v[253:255], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_2D
// GFX11: [0x04,0x03,0x80,0xf0,0xfd,0xfe,0x02,0x0c]

image_sample_c v[5:7], v[1:2], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_2D a16 tfe
// GFX11: [0x04,0x03,0x81,0xf0,0x01,0x05,0x22,0x0c]

image_sample_c v[253:255], v[254:255], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_2D a16 tfe
// GFX11: [0x04,0x03,0x81,0xf0,0xfe,0xfd,0x22,0x0c]

image_sample_c v5, v[1:4], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_CUBE d16
// GFX11: [0x0c,0x03,0x82,0xf0,0x01,0x05,0x02,0x0c]

image_sample_c v255, v[252:255], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_CUBE d16
// GFX11: [0x0c,0x03,0x82,0xf0,0xfc,0xff,0x02,0x0c]

image_sample_c v[5:6], v[1:3], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_CUBE a16 tfe d16
// GFX11: [0x0c,0x03,0x83,0xf0,0x01,0x05,0x22,0x0c]

image_sample_c v[254:255], v[253:255], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_CUBE a16 tfe d16
// GFX11: [0x0c,0x03,0x83,0xf0,0xfd,0xfe,0x22,0x0c]

image_sample_c v5, v[1:3], s[8:15], s[12:15] dmask:0x4 dim:SQ_RSRC_IMG_1D_ARRAY
// GFX11: [0x10,0x04,0x80,0xf0,0x01,0x05,0x02,0x0c]

image_sample_c v255, v[253:255], s[8:15], s[12:15] dmask:0x4 dim:SQ_RSRC_IMG_1D_ARRAY
// GFX11: [0x10,0x04,0x80,0xf0,0xfd,0xff,0x02,0x0c]

image_sample_c v[5:6], v[1:2], s[8:15], s[12:15] dmask:0x4 dim:SQ_RSRC_IMG_1D_ARRAY a16 tfe
// GFX11: [0x10,0x04,0x81,0xf0,0x01,0x05,0x22,0x0c]

image_sample_c v[254:255], v[254:255], s[8:15], s[12:15] dmask:0x4 dim:SQ_RSRC_IMG_1D_ARRAY a16 tfe
// GFX11: [0x10,0x04,0x81,0xf0,0xfe,0xfe,0x22,0x0c]

image_sample_c v5, v[1:4], s[8:15], s[12:15] dmask:0x4 dim:SQ_RSRC_IMG_2D_ARRAY d16
// GFX11: [0x14,0x04,0x82,0xf0,0x01,0x05,0x02,0x0c]

image_sample_c v255, v[252:255], s[8:15], s[12:15] dmask:0x4 dim:SQ_RSRC_IMG_2D_ARRAY d16
// GFX11: [0x14,0x04,0x82,0xf0,0xfc,0xff,0x02,0x0c]

image_sample_c v[5:6], v[1:3], s[96:103], s[100:103] dmask:0x4 dim:SQ_RSRC_IMG_2D_ARRAY a16 tfe d16
// GFX11: [0x14,0x04,0x83,0xf0,0x01,0x05,0x38,0x64]

image_sample_c v[254:255], v[253:255], ttmp[8:15], ttmp[12:15] dmask:0x4 dim:SQ_RSRC_IMG_2D_ARRAY unorm glc slc dlc a16 tfe lwe d16
// GFX11: [0x94,0x74,0x83,0xf0,0xfd,0xfe,0x7d,0x78]

image_sample_c_b v[5:6], v[1:3], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_1D
// GFX11: [0x00,0x03,0x8c,0xf0,0x01,0x05,0x02,0x0c]

image_sample_c_b v[5:6], v[253:255], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_1D
// GFX11: [0x00,0x03,0x8c,0xf0,0xfd,0x05,0x02,0x0c]

image_sample_c_b v[5:6], v[1:3], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_1D a16
// GFX11: [0x00,0x03,0x8d,0xf0,0x01,0x05,0x02,0x0c]

image_sample_c_b v[5:6], v[253:255], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_1D a16
// GFX11: [0x00,0x03,0x8d,0xf0,0xfd,0x05,0x02,0x0c]

image_sample_c_b v[5:6], v[1:5], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_3D
// GFX11: [0x08,0x03,0x8c,0xf0,0x01,0x05,0x02,0x0c]

image_sample_c_b v[5:6], v[251:255], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_3D
// GFX11: [0x08,0x03,0x8c,0xf0,0xfb,0x05,0x02,0x0c]

image_sample_c_b v[5:6], v[1:4], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_3D a16
// GFX11: [0x08,0x03,0x8d,0xf0,0x01,0x05,0x02,0x0c]

image_sample_c_b v[5:6], v[252:255], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_3D a16
// GFX11: [0x08,0x03,0x8d,0xf0,0xfc,0x05,0x02,0x0c]

image_sample_c_b v[5:6], v[1:4], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_2D
// GFX11: [0x04,0x03,0x8c,0xf0,0x01,0x05,0x02,0x0c]

image_sample_c_b v[254:255], v[252:255], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_2D
// GFX11: [0x04,0x03,0x8c,0xf0,0xfc,0xfe,0x02,0x0c]

image_sample_c_b v[5:7], v[1:3], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_2D a16 tfe
// GFX11: [0x04,0x03,0x8d,0xf0,0x01,0x05,0x22,0x0c]

image_sample_c_b v[253:255], v[253:255], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_2D a16 tfe
// GFX11: [0x04,0x03,0x8d,0xf0,0xfd,0xfd,0x22,0x0c]

image_sample_c_b v5, v[1:5], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_CUBE d16
// GFX11: [0x0c,0x03,0x8e,0xf0,0x01,0x05,0x02,0x0c]

image_sample_c_b v255, v[251:255], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_CUBE d16
// GFX11: [0x0c,0x03,0x8e,0xf0,0xfb,0xff,0x02,0x0c]

image_sample_c_b v[5:6], v[1:4], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_CUBE a16 tfe d16
// GFX11: [0x0c,0x03,0x8f,0xf0,0x01,0x05,0x22,0x0c]

image_sample_c_b v[254:255], v[252:255], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_CUBE a16 tfe d16
// GFX11: [0x0c,0x03,0x8f,0xf0,0xfc,0xfe,0x22,0x0c]

image_sample_c_b v5, v[1:4], s[8:15], s[12:15] dmask:0x4 dim:SQ_RSRC_IMG_1D_ARRAY
// GFX11: [0x10,0x04,0x8c,0xf0,0x01,0x05,0x02,0x0c]

image_sample_c_b v255, v[252:255], s[8:15], s[12:15] dmask:0x4 dim:SQ_RSRC_IMG_1D_ARRAY
// GFX11: [0x10,0x04,0x8c,0xf0,0xfc,0xff,0x02,0x0c]

image_sample_c_b v[5:6], v[1:3], s[8:15], s[12:15] dmask:0x4 dim:SQ_RSRC_IMG_1D_ARRAY a16 tfe
// GFX11: [0x10,0x04,0x8d,0xf0,0x01,0x05,0x22,0x0c]

image_sample_c_b v[254:255], v[253:255], s[8:15], s[12:15] dmask:0x4 dim:SQ_RSRC_IMG_1D_ARRAY a16 tfe
// GFX11: [0x10,0x04,0x8d,0xf0,0xfd,0xfe,0x22,0x0c]

image_sample_c_b v5, v[1:5], s[8:15], s[12:15] dmask:0x4 dim:SQ_RSRC_IMG_2D_ARRAY d16
// GFX11: [0x14,0x04,0x8e,0xf0,0x01,0x05,0x02,0x0c]

image_sample_c_b v255, v[251:255], s[8:15], s[12:15] dmask:0x4 dim:SQ_RSRC_IMG_2D_ARRAY d16
// GFX11: [0x14,0x04,0x8e,0xf0,0xfb,0xff,0x02,0x0c]

image_sample_c_b v[5:6], v[1:4], s[96:103], s[100:103] dmask:0x4 dim:SQ_RSRC_IMG_2D_ARRAY a16 tfe d16
// GFX11: [0x14,0x04,0x8f,0xf0,0x01,0x05,0x38,0x64]

image_sample_c_b v[254:255], v[252:255], ttmp[8:15], ttmp[12:15] dmask:0x4 dim:SQ_RSRC_IMG_2D_ARRAY unorm glc slc dlc a16 tfe lwe d16
// GFX11: [0x94,0x74,0x8f,0xf0,0xfc,0xfe,0x7d,0x78]

image_sample_c_b_cl v[5:6], v[1:4], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_1D
// GFX11: [0x00,0x03,0x14,0xf1,0x01,0x05,0x02,0x0c]

image_sample_c_b_cl v[5:6], v[252:255], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_1D
// GFX11: [0x00,0x03,0x14,0xf1,0xfc,0x05,0x02,0x0c]

image_sample_c_b_cl v[5:6], v[1:3], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_1D a16
// GFX11: [0x00,0x03,0x15,0xf1,0x01,0x05,0x02,0x0c]

image_sample_c_b_cl v[5:6], v[253:255], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_1D a16
// GFX11: [0x00,0x03,0x15,0xf1,0xfd,0x05,0x02,0x0c]

image_sample_c_b_cl v[5:6], v[1:6], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_3D
// GFX11: [0x08,0x03,0x14,0xf1,0x01,0x05,0x02,0x0c]

image_sample_c_b_cl v[5:6], v[250:255], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_3D
// GFX11: [0x08,0x03,0x14,0xf1,0xfa,0x05,0x02,0x0c]

image_sample_c_b_cl v[5:6], v[1:4], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_3D a16
// GFX11: [0x08,0x03,0x15,0xf1,0x01,0x05,0x02,0x0c]

image_sample_c_b_cl v[5:6], v[252:255], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_3D a16
// GFX11: [0x08,0x03,0x15,0xf1,0xfc,0x05,0x02,0x0c]

image_sample_c_b_cl v[5:6], v[1:5], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_2D
// GFX11: [0x04,0x03,0x14,0xf1,0x01,0x05,0x02,0x0c]

image_sample_c_b_cl v[254:255], v[251:255], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_2D
// GFX11: [0x04,0x03,0x14,0xf1,0xfb,0xfe,0x02,0x0c]

image_sample_c_b_cl v[5:7], v[1:4], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_2D a16 tfe
// GFX11: [0x04,0x03,0x15,0xf1,0x01,0x05,0x22,0x0c]

image_sample_c_b_cl v[253:255], v[252:255], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_2D a16 tfe
// GFX11: [0x04,0x03,0x15,0xf1,0xfc,0xfd,0x22,0x0c]

image_sample_c_b_cl v5, v[1:6], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_CUBE d16
// GFX11: [0x0c,0x03,0x16,0xf1,0x01,0x05,0x02,0x0c]

image_sample_c_b_cl v255, v[250:255], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_CUBE d16
// GFX11: [0x0c,0x03,0x16,0xf1,0xfa,0xff,0x02,0x0c]

image_sample_c_b_cl v[5:6], v[1:4], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_CUBE a16 tfe d16
// GFX11: [0x0c,0x03,0x17,0xf1,0x01,0x05,0x22,0x0c]

image_sample_c_b_cl v[254:255], v[252:255], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_CUBE a16 tfe d16
// GFX11: [0x0c,0x03,0x17,0xf1,0xfc,0xfe,0x22,0x0c]

image_sample_c_b_cl v5, v[1:5], s[8:15], s[12:15] dmask:0x4 dim:SQ_RSRC_IMG_1D_ARRAY
// GFX11: [0x10,0x04,0x14,0xf1,0x01,0x05,0x02,0x0c]

image_sample_c_b_cl v255, v[251:255], s[8:15], s[12:15] dmask:0x4 dim:SQ_RSRC_IMG_1D_ARRAY
// GFX11: [0x10,0x04,0x14,0xf1,0xfb,0xff,0x02,0x0c]

image_sample_c_b_cl v[5:6], v[1:4], s[8:15], s[12:15] dmask:0x4 dim:SQ_RSRC_IMG_1D_ARRAY a16 tfe
// GFX11: [0x10,0x04,0x15,0xf1,0x01,0x05,0x22,0x0c]

image_sample_c_b_cl v[254:255], v[252:255], s[8:15], s[12:15] dmask:0x4 dim:SQ_RSRC_IMG_1D_ARRAY a16 tfe
// GFX11: [0x10,0x04,0x15,0xf1,0xfc,0xfe,0x22,0x0c]

image_sample_c_b_cl v5, v[1:6], s[8:15], s[12:15] dmask:0x4 dim:SQ_RSRC_IMG_2D_ARRAY d16
// GFX11: [0x14,0x04,0x16,0xf1,0x01,0x05,0x02,0x0c]

image_sample_c_b_cl v255, v[250:255], s[8:15], s[12:15] dmask:0x4 dim:SQ_RSRC_IMG_2D_ARRAY d16
// GFX11: [0x14,0x04,0x16,0xf1,0xfa,0xff,0x02,0x0c]

image_sample_c_b_cl v[5:6], v[1:4], s[96:103], s[100:103] dmask:0x4 dim:SQ_RSRC_IMG_2D_ARRAY a16 tfe d16
// GFX11: [0x14,0x04,0x17,0xf1,0x01,0x05,0x38,0x64]

image_sample_c_b_cl v[254:255], v[252:255], ttmp[8:15], ttmp[12:15] dmask:0x4 dim:SQ_RSRC_IMG_2D_ARRAY unorm glc slc dlc a16 tfe lwe d16
// GFX11: [0x94,0x74,0x17,0xf1,0xfc,0xfe,0x7d,0x78]

image_sample_c_b_cl_o v[5:6], v[1:5], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_1D
// GFX11: [0x00,0x03,0x2c,0xf1,0x01,0x05,0x02,0x0c]

image_sample_c_b_cl_o v[5:6], v[251:255], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_1D
// GFX11: [0x00,0x03,0x2c,0xf1,0xfb,0x05,0x02,0x0c]

image_sample_c_b_cl_o v[5:6], v[1:4], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_1D a16
// GFX11: [0x00,0x03,0x2d,0xf1,0x01,0x05,0x02,0x0c]

image_sample_c_b_cl_o v[5:6], v[252:255], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_1D a16
// GFX11: [0x00,0x03,0x2d,0xf1,0xfc,0x05,0x02,0x0c]

image_sample_c_b_cl_o v[5:6], v[1:7], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_3D
// GFX11: [0x08,0x03,0x2c,0xf1,0x01,0x05,0x02,0x0c]

image_sample_c_b_cl_o v[5:6], v[249:255], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_3D
// GFX11: [0x08,0x03,0x2c,0xf1,0xf9,0x05,0x02,0x0c]

image_sample_c_b_cl_o v[5:6], v[1:5], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_3D a16
// GFX11: [0x08,0x03,0x2d,0xf1,0x01,0x05,0x02,0x0c]

image_sample_c_b_cl_o v[5:6], v[251:255], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_3D a16
// GFX11: [0x08,0x03,0x2d,0xf1,0xfb,0x05,0x02,0x0c]

image_sample_c_b_cl_o v[5:6], v[1:6], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_2D
// GFX11: [0x04,0x03,0x2c,0xf1,0x01,0x05,0x02,0x0c]

image_sample_c_b_cl_o v[254:255], v[250:255], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_2D
// GFX11: [0x04,0x03,0x2c,0xf1,0xfa,0xfe,0x02,0x0c]

image_sample_c_b_cl_o v[5:7], v[1:5], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_2D a16 tfe
// GFX11: [0x04,0x03,0x2d,0xf1,0x01,0x05,0x22,0x0c]

image_sample_c_b_cl_o v[253:255], v[251:255], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_2D a16 tfe
// GFX11: [0x04,0x03,0x2d,0xf1,0xfb,0xfd,0x22,0x0c]

image_sample_c_b_cl_o v5, v[1:7], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_CUBE d16
// GFX11: [0x0c,0x03,0x2e,0xf1,0x01,0x05,0x02,0x0c]

image_sample_c_b_cl_o v255, v[249:255], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_CUBE d16
// GFX11: [0x0c,0x03,0x2e,0xf1,0xf9,0xff,0x02,0x0c]

image_sample_c_b_cl_o v[5:6], v[1:5], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_CUBE a16 tfe d16
// GFX11: [0x0c,0x03,0x2f,0xf1,0x01,0x05,0x22,0x0c]

image_sample_c_b_cl_o v[254:255], v[251:255], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_CUBE a16 tfe d16
// GFX11: [0x0c,0x03,0x2f,0xf1,0xfb,0xfe,0x22,0x0c]

image_sample_c_b_cl_o v5, v[1:6], s[8:15], s[12:15] dmask:0x4 dim:SQ_RSRC_IMG_1D_ARRAY
// GFX11: [0x10,0x04,0x2c,0xf1,0x01,0x05,0x02,0x0c]

image_sample_c_b_cl_o v255, v[250:255], s[8:15], s[12:15] dmask:0x4 dim:SQ_RSRC_IMG_1D_ARRAY
// GFX11: [0x10,0x04,0x2c,0xf1,0xfa,0xff,0x02,0x0c]

image_sample_c_b_cl_o v[5:6], v[1:5], s[8:15], s[12:15] dmask:0x4 dim:SQ_RSRC_IMG_1D_ARRAY a16 tfe
// GFX11: [0x10,0x04,0x2d,0xf1,0x01,0x05,0x22,0x0c]

image_sample_c_b_cl_o v[254:255], v[251:255], s[8:15], s[12:15] dmask:0x4 dim:SQ_RSRC_IMG_1D_ARRAY a16 tfe
// GFX11: [0x10,0x04,0x2d,0xf1,0xfb,0xfe,0x22,0x0c]

image_sample_c_b_cl_o v5, v[1:7], s[8:15], s[12:15] dmask:0x4 dim:SQ_RSRC_IMG_2D_ARRAY d16
// GFX11: [0x14,0x04,0x2e,0xf1,0x01,0x05,0x02,0x0c]

image_sample_c_b_cl_o v255, v[249:255], s[8:15], s[12:15] dmask:0x4 dim:SQ_RSRC_IMG_2D_ARRAY d16
// GFX11: [0x14,0x04,0x2e,0xf1,0xf9,0xff,0x02,0x0c]

image_sample_c_b_cl_o v[5:6], v[1:5], s[96:103], s[100:103] dmask:0x4 dim:SQ_RSRC_IMG_2D_ARRAY a16 tfe d16
// GFX11: [0x14,0x04,0x2f,0xf1,0x01,0x05,0x38,0x64]

image_sample_c_b_cl_o v[254:255], v[251:255], ttmp[8:15], ttmp[12:15] dmask:0x4 dim:SQ_RSRC_IMG_2D_ARRAY unorm glc slc dlc a16 tfe lwe d16
// GFX11: [0x94,0x74,0x2f,0xf1,0xfb,0xfe,0x7d,0x78]

image_sample_c_b_o v[5:6], v[1:4], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_1D
// GFX11: [0x00,0x03,0xb4,0xf0,0x01,0x05,0x02,0x0c]

image_sample_c_b_o v[5:6], v[252:255], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_1D
// GFX11: [0x00,0x03,0xb4,0xf0,0xfc,0x05,0x02,0x0c]

image_sample_c_b_o v[5:6], v[1:4], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_1D a16
// GFX11: [0x00,0x03,0xb5,0xf0,0x01,0x05,0x02,0x0c]

image_sample_c_b_o v[5:6], v[252:255], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_1D a16
// GFX11: [0x00,0x03,0xb5,0xf0,0xfc,0x05,0x02,0x0c]

image_sample_c_b_o v[5:6], v[1:6], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_3D
// GFX11: [0x08,0x03,0xb4,0xf0,0x01,0x05,0x02,0x0c]

image_sample_c_b_o v[5:6], v[250:255], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_3D
// GFX11: [0x08,0x03,0xb4,0xf0,0xfa,0x05,0x02,0x0c]

image_sample_c_b_o v[5:6], v[1:5], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_3D a16
// GFX11: [0x08,0x03,0xb5,0xf0,0x01,0x05,0x02,0x0c]

image_sample_c_b_o v[5:6], v[251:255], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_3D a16
// GFX11: [0x08,0x03,0xb5,0xf0,0xfb,0x05,0x02,0x0c]

image_sample_c_b_o v[5:6], v[1:5], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_2D
// GFX11: [0x04,0x03,0xb4,0xf0,0x01,0x05,0x02,0x0c]

image_sample_c_b_o v[254:255], v[251:255], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_2D
// GFX11: [0x04,0x03,0xb4,0xf0,0xfb,0xfe,0x02,0x0c]

image_sample_c_b_o v[5:7], v[1:4], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_2D a16 tfe
// GFX11: [0x04,0x03,0xb5,0xf0,0x01,0x05,0x22,0x0c]

image_sample_c_b_o v[253:255], v[252:255], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_2D a16 tfe
// GFX11: [0x04,0x03,0xb5,0xf0,0xfc,0xfd,0x22,0x0c]

image_sample_c_b_o v5, v[1:6], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_CUBE d16
// GFX11: [0x0c,0x03,0xb6,0xf0,0x01,0x05,0x02,0x0c]

image_sample_c_b_o v255, v[250:255], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_CUBE d16
// GFX11: [0x0c,0x03,0xb6,0xf0,0xfa,0xff,0x02,0x0c]

image_sample_c_b_o v[5:6], v[1:5], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_CUBE a16 tfe d16
// GFX11: [0x0c,0x03,0xb7,0xf0,0x01,0x05,0x22,0x0c]

image_sample_c_b_o v[254:255], v[251:255], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_CUBE a16 tfe d16
// GFX11: [0x0c,0x03,0xb7,0xf0,0xfb,0xfe,0x22,0x0c]

image_sample_c_b_o v5, v[1:5], s[8:15], s[12:15] dmask:0x4 dim:SQ_RSRC_IMG_1D_ARRAY
// GFX11: [0x10,0x04,0xb4,0xf0,0x01,0x05,0x02,0x0c]

image_sample_c_b_o v255, v[251:255], s[8:15], s[12:15] dmask:0x4 dim:SQ_RSRC_IMG_1D_ARRAY
// GFX11: [0x10,0x04,0xb4,0xf0,0xfb,0xff,0x02,0x0c]

image_sample_c_b_o v[5:6], v[1:4], s[8:15], s[12:15] dmask:0x4 dim:SQ_RSRC_IMG_1D_ARRAY a16 tfe
// GFX11: [0x10,0x04,0xb5,0xf0,0x01,0x05,0x22,0x0c]

image_sample_c_b_o v[254:255], v[252:255], s[8:15], s[12:15] dmask:0x4 dim:SQ_RSRC_IMG_1D_ARRAY a16 tfe
// GFX11: [0x10,0x04,0xb5,0xf0,0xfc,0xfe,0x22,0x0c]

image_sample_c_b_o v5, v[1:6], s[8:15], s[12:15] dmask:0x4 dim:SQ_RSRC_IMG_2D_ARRAY d16
// GFX11: [0x14,0x04,0xb6,0xf0,0x01,0x05,0x02,0x0c]

image_sample_c_b_o v255, v[250:255], s[8:15], s[12:15] dmask:0x4 dim:SQ_RSRC_IMG_2D_ARRAY d16
// GFX11: [0x14,0x04,0xb6,0xf0,0xfa,0xff,0x02,0x0c]

image_sample_c_b_o v[5:6], v[1:5], s[96:103], s[100:103] dmask:0x4 dim:SQ_RSRC_IMG_2D_ARRAY a16 tfe d16
// GFX11: [0x14,0x04,0xb7,0xf0,0x01,0x05,0x38,0x64]

image_sample_c_b_o v[254:255], v[251:255], ttmp[8:15], ttmp[12:15] dmask:0x4 dim:SQ_RSRC_IMG_2D_ARRAY unorm glc slc dlc a16 tfe lwe d16
// GFX11: [0x94,0x74,0xb7,0xf0,0xfb,0xfe,0x7d,0x78]

image_sample_c_cl v[5:6], v[1:3], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_1D
// GFX11: [0x00,0x03,0x0c,0xf1,0x01,0x05,0x02,0x0c]

image_sample_c_cl v[5:6], v[253:255], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_1D
// GFX11: [0x00,0x03,0x0c,0xf1,0xfd,0x05,0x02,0x0c]

image_sample_c_cl v[5:6], v[1:2], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_1D a16
// GFX11: [0x00,0x03,0x0d,0xf1,0x01,0x05,0x02,0x0c]

image_sample_c_cl v[5:6], v[254:255], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_1D a16
// GFX11: [0x00,0x03,0x0d,0xf1,0xfe,0x05,0x02,0x0c]

image_sample_c_cl v[5:6], v[1:5], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_3D
// GFX11: [0x08,0x03,0x0c,0xf1,0x01,0x05,0x02,0x0c]

image_sample_c_cl v[5:6], v[251:255], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_3D
// GFX11: [0x08,0x03,0x0c,0xf1,0xfb,0x05,0x02,0x0c]

image_sample_c_cl v[5:6], v[1:3], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_3D a16
// GFX11: [0x08,0x03,0x0d,0xf1,0x01,0x05,0x02,0x0c]

image_sample_c_cl v[5:6], v[253:255], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_3D a16
// GFX11: [0x08,0x03,0x0d,0xf1,0xfd,0x05,0x02,0x0c]

image_sample_c_cl v[5:6], v[1:4], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_2D
// GFX11: [0x04,0x03,0x0c,0xf1,0x01,0x05,0x02,0x0c]

image_sample_c_cl v[254:255], v[252:255], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_2D
// GFX11: [0x04,0x03,0x0c,0xf1,0xfc,0xfe,0x02,0x0c]

image_sample_c_cl v[5:7], v[1:3], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_2D a16 tfe
// GFX11: [0x04,0x03,0x0d,0xf1,0x01,0x05,0x22,0x0c]

image_sample_c_cl v[253:255], v[253:255], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_2D a16 tfe
// GFX11: [0x04,0x03,0x0d,0xf1,0xfd,0xfd,0x22,0x0c]

image_sample_c_cl v5, v[1:5], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_CUBE d16
// GFX11: [0x0c,0x03,0x0e,0xf1,0x01,0x05,0x02,0x0c]

image_sample_c_cl v255, v[251:255], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_CUBE d16
// GFX11: [0x0c,0x03,0x0e,0xf1,0xfb,0xff,0x02,0x0c]

image_sample_c_cl v[5:6], v[1:3], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_CUBE a16 tfe d16
// GFX11: [0x0c,0x03,0x0f,0xf1,0x01,0x05,0x22,0x0c]

image_sample_c_cl v[254:255], v[253:255], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_CUBE a16 tfe d16
// GFX11: [0x0c,0x03,0x0f,0xf1,0xfd,0xfe,0x22,0x0c]

image_sample_c_cl v5, v[1:4], s[8:15], s[12:15] dmask:0x4 dim:SQ_RSRC_IMG_1D_ARRAY
// GFX11: [0x10,0x04,0x0c,0xf1,0x01,0x05,0x02,0x0c]

image_sample_c_cl v255, v[252:255], s[8:15], s[12:15] dmask:0x4 dim:SQ_RSRC_IMG_1D_ARRAY
// GFX11: [0x10,0x04,0x0c,0xf1,0xfc,0xff,0x02,0x0c]

image_sample_c_cl v[5:6], v[1:3], s[8:15], s[12:15] dmask:0x4 dim:SQ_RSRC_IMG_1D_ARRAY a16 tfe
// GFX11: [0x10,0x04,0x0d,0xf1,0x01,0x05,0x22,0x0c]

image_sample_c_cl v[254:255], v[253:255], s[8:15], s[12:15] dmask:0x4 dim:SQ_RSRC_IMG_1D_ARRAY a16 tfe
// GFX11: [0x10,0x04,0x0d,0xf1,0xfd,0xfe,0x22,0x0c]

image_sample_c_cl v5, v[1:5], s[8:15], s[12:15] dmask:0x4 dim:SQ_RSRC_IMG_2D_ARRAY d16
// GFX11: [0x14,0x04,0x0e,0xf1,0x01,0x05,0x02,0x0c]

image_sample_c_cl v255, v[251:255], s[8:15], s[12:15] dmask:0x4 dim:SQ_RSRC_IMG_2D_ARRAY d16
// GFX11: [0x14,0x04,0x0e,0xf1,0xfb,0xff,0x02,0x0c]

image_sample_c_cl v[5:6], v[1:3], s[96:103], s[100:103] dmask:0x4 dim:SQ_RSRC_IMG_2D_ARRAY a16 tfe d16
// GFX11: [0x14,0x04,0x0f,0xf1,0x01,0x05,0x38,0x64]

image_sample_c_cl v[254:255], v[253:255], ttmp[8:15], ttmp[12:15] dmask:0x4 dim:SQ_RSRC_IMG_2D_ARRAY unorm glc slc dlc a16 tfe lwe d16
// GFX11: [0x94,0x74,0x0f,0xf1,0xfd,0xfe,0x7d,0x78]

image_sample_c_cl_o v[5:6], v[1:4], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_1D
// GFX11: [0x00,0x03,0x24,0xf1,0x01,0x05,0x02,0x0c]

image_sample_c_cl_o v[5:6], v[252:255], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_1D
// GFX11: [0x00,0x03,0x24,0xf1,0xfc,0x05,0x02,0x0c]

image_sample_c_cl_o v[5:6], v[1:3], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_1D a16
// GFX11: [0x00,0x03,0x25,0xf1,0x01,0x05,0x02,0x0c]

image_sample_c_cl_o v[5:6], v[253:255], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_1D a16
// GFX11: [0x00,0x03,0x25,0xf1,0xfd,0x05,0x02,0x0c]

image_sample_c_cl_o v[5:6], v[1:6], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_3D
// GFX11: [0x08,0x03,0x24,0xf1,0x01,0x05,0x02,0x0c]

image_sample_c_cl_o v[5:6], v[250:255], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_3D
// GFX11: [0x08,0x03,0x24,0xf1,0xfa,0x05,0x02,0x0c]

image_sample_c_cl_o v[5:6], v[1:4], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_3D a16
// GFX11: [0x08,0x03,0x25,0xf1,0x01,0x05,0x02,0x0c]

image_sample_c_cl_o v[5:6], v[252:255], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_3D a16
// GFX11: [0x08,0x03,0x25,0xf1,0xfc,0x05,0x02,0x0c]

image_sample_c_cl_o v[5:6], v[1:5], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_2D
// GFX11: [0x04,0x03,0x24,0xf1,0x01,0x05,0x02,0x0c]

image_sample_c_cl_o v[254:255], v[251:255], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_2D
// GFX11: [0x04,0x03,0x24,0xf1,0xfb,0xfe,0x02,0x0c]

image_sample_c_cl_o v[5:7], v[1:4], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_2D a16 tfe
// GFX11: [0x04,0x03,0x25,0xf1,0x01,0x05,0x22,0x0c]

image_sample_c_cl_o v[253:255], v[252:255], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_2D a16 tfe
// GFX11: [0x04,0x03,0x25,0xf1,0xfc,0xfd,0x22,0x0c]

image_sample_c_cl_o v5, v[1:6], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_CUBE d16
// GFX11: [0x0c,0x03,0x26,0xf1,0x01,0x05,0x02,0x0c]

image_sample_c_cl_o v255, v[250:255], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_CUBE d16
// GFX11: [0x0c,0x03,0x26,0xf1,0xfa,0xff,0x02,0x0c]

image_sample_c_cl_o v[5:6], v[1:4], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_CUBE a16 tfe d16
// GFX11: [0x0c,0x03,0x27,0xf1,0x01,0x05,0x22,0x0c]

image_sample_c_cl_o v[254:255], v[252:255], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_CUBE a16 tfe d16
// GFX11: [0x0c,0x03,0x27,0xf1,0xfc,0xfe,0x22,0x0c]

image_sample_c_cl_o v5, v[1:5], s[8:15], s[12:15] dmask:0x4 dim:SQ_RSRC_IMG_1D_ARRAY
// GFX11: [0x10,0x04,0x24,0xf1,0x01,0x05,0x02,0x0c]

image_sample_c_cl_o v255, v[251:255], s[8:15], s[12:15] dmask:0x4 dim:SQ_RSRC_IMG_1D_ARRAY
// GFX11: [0x10,0x04,0x24,0xf1,0xfb,0xff,0x02,0x0c]

image_sample_c_cl_o v[5:6], v[1:4], s[8:15], s[12:15] dmask:0x4 dim:SQ_RSRC_IMG_1D_ARRAY a16 tfe
// GFX11: [0x10,0x04,0x25,0xf1,0x01,0x05,0x22,0x0c]

image_sample_c_cl_o v[254:255], v[252:255], s[8:15], s[12:15] dmask:0x4 dim:SQ_RSRC_IMG_1D_ARRAY a16 tfe
// GFX11: [0x10,0x04,0x25,0xf1,0xfc,0xfe,0x22,0x0c]

image_sample_c_cl_o v5, v[1:6], s[8:15], s[12:15] dmask:0x4 dim:SQ_RSRC_IMG_2D_ARRAY d16
// GFX11: [0x14,0x04,0x26,0xf1,0x01,0x05,0x02,0x0c]

image_sample_c_cl_o v255, v[250:255], s[8:15], s[12:15] dmask:0x4 dim:SQ_RSRC_IMG_2D_ARRAY d16
// GFX11: [0x14,0x04,0x26,0xf1,0xfa,0xff,0x02,0x0c]

image_sample_c_cl_o v[5:6], v[1:4], s[96:103], s[100:103] dmask:0x4 dim:SQ_RSRC_IMG_2D_ARRAY a16 tfe d16
// GFX11: [0x14,0x04,0x27,0xf1,0x01,0x05,0x38,0x64]

image_sample_c_cl_o v[254:255], v[252:255], ttmp[8:15], ttmp[12:15] dmask:0x4 dim:SQ_RSRC_IMG_2D_ARRAY unorm glc slc dlc a16 tfe lwe d16
// GFX11: [0x94,0x74,0x27,0xf1,0xfc,0xfe,0x7d,0x78]

image_sample_c_d v[5:6], v[1:4], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_1D
// GFX11: [0x00,0x03,0x84,0xf0,0x01,0x05,0x02,0x0c]

image_sample_c_d v[5:6], v[252:255], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_1D
// GFX11: [0x00,0x03,0x84,0xf0,0xfc,0x05,0x02,0x0c]

image_sample_c_d v[5:6], v[1:4], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_1D a16
// GFX11: [0x00,0x03,0x85,0xf0,0x01,0x05,0x02,0x0c]

image_sample_c_d v[5:6], v[252:255], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_1D a16
// GFX11: [0x00,0x03,0x85,0xf0,0xfc,0x05,0x02,0x0c]

image_sample_c_d v[5:6], v[1:10], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_3D
// GFX11: [0x08,0x03,0x84,0xf0,0x01,0x05,0x02,0x0c]

image_sample_c_d v[5:6], v[240:249], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_3D
// GFX11: [0x08,0x03,0x84,0xf0,0xf0,0x05,0x02,0x0c]

image_sample_c_d v[5:6], v[1:9], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_3D a16
// GFX11: [0x08,0x03,0x85,0xf0,0x01,0x05,0x02,0x0c]

image_sample_c_d v[5:6], v[241:249], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_3D a16
// GFX11: [0x08,0x03,0x85,0xf0,0xf1,0x05,0x02,0x0c]

image_sample_c_d v[5:6], v[1:7], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_2D
// GFX11: [0x04,0x03,0x84,0xf0,0x01,0x05,0x02,0x0c]

image_sample_c_d v[254:255], v[249:255], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_2D
// GFX11: [0x04,0x03,0x84,0xf0,0xf9,0xfe,0x02,0x0c]

image_sample_c_d v[5:7], v[1:6], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_2D a16 tfe
// GFX11: [0x04,0x03,0x85,0xf0,0x01,0x05,0x22,0x0c]

image_sample_c_d v[253:255], v[250:255], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_2D a16 tfe
// GFX11: [0x04,0x03,0x85,0xf0,0xfa,0xfd,0x22,0x0c]

image_sample_c_d v5, v[1:8], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_CUBE d16
// GFX11: [0x0c,0x03,0x86,0xf0,0x01,0x05,0x02,0x0c]

image_sample_c_d v255, v[248:255], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_CUBE d16
// GFX11: [0x0c,0x03,0x86,0xf0,0xf8,0xff,0x02,0x0c]

image_sample_c_d v[5:6], v[1:7], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_CUBE a16 tfe d16
// GFX11: [0x0c,0x03,0x87,0xf0,0x01,0x05,0x22,0x0c]

image_sample_c_d v[254:255], v[249:255], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_CUBE a16 tfe d16
// GFX11: [0x0c,0x03,0x87,0xf0,0xf9,0xfe,0x22,0x0c]

image_sample_c_d v5, v[1:5], s[8:15], s[12:15] dmask:0x4 dim:SQ_RSRC_IMG_1D_ARRAY
// GFX11: [0x10,0x04,0x84,0xf0,0x01,0x05,0x02,0x0c]

image_sample_c_d v255, v[251:255], s[8:15], s[12:15] dmask:0x4 dim:SQ_RSRC_IMG_1D_ARRAY
// GFX11: [0x10,0x04,0x84,0xf0,0xfb,0xff,0x02,0x0c]

image_sample_c_d v[5:6], v[1:4], s[8:15], s[12:15] dmask:0x4 dim:SQ_RSRC_IMG_1D_ARRAY a16 tfe
// GFX11: [0x10,0x04,0x85,0xf0,0x01,0x05,0x22,0x0c]

image_sample_c_d v[254:255], v[252:255], s[8:15], s[12:15] dmask:0x4 dim:SQ_RSRC_IMG_1D_ARRAY a16 tfe
// GFX11: [0x10,0x04,0x85,0xf0,0xfc,0xfe,0x22,0x0c]

image_sample_c_d v5, v[1:8], s[8:15], s[12:15] dmask:0x4 dim:SQ_RSRC_IMG_2D_ARRAY d16
// GFX11: [0x14,0x04,0x86,0xf0,0x01,0x05,0x02,0x0c]

image_sample_c_d v255, v[248:255], s[8:15], s[12:15] dmask:0x4 dim:SQ_RSRC_IMG_2D_ARRAY d16
// GFX11: [0x14,0x04,0x86,0xf0,0xf8,0xff,0x02,0x0c]

image_sample_c_d v[5:6], v[1:7], s[96:103], s[100:103] dmask:0x4 dim:SQ_RSRC_IMG_2D_ARRAY a16 tfe d16
// GFX11: [0x14,0x04,0x87,0xf0,0x01,0x05,0x38,0x64]

image_sample_c_d v[254:255], v[249:255], ttmp[8:15], ttmp[12:15] dmask:0x4 dim:SQ_RSRC_IMG_2D_ARRAY unorm glc slc dlc a16 tfe lwe d16
// GFX11: [0x94,0x74,0x87,0xf0,0xf9,0xfe,0x7d,0x78]

image_sample_c_d_cl v[5:6], v[1:5], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_1D
// GFX11: [0x00,0x03,0x10,0xf1,0x01,0x05,0x02,0x0c]

image_sample_c_d_cl v[5:6], v[251:255], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_1D
// GFX11: [0x00,0x03,0x10,0xf1,0xfb,0x05,0x02,0x0c]

image_sample_c_d_cl v[5:6], v[1:4], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_1D a16
// GFX11: [0x00,0x03,0x11,0xf1,0x01,0x05,0x02,0x0c]

image_sample_c_d_cl v[5:6], v[252:255], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_1D a16
// GFX11: [0x00,0x03,0x11,0xf1,0xfc,0x05,0x02,0x0c]

image_sample_c_d_cl v[5:6], v[1:11], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_3D
// GFX11: [0x08,0x03,0x10,0xf1,0x01,0x05,0x02,0x0c]

image_sample_c_d_cl v[5:6], v[241:251], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_3D
// GFX11: [0x08,0x03,0x10,0xf1,0xf1,0x05,0x02,0x0c]

image_sample_c_d_cl v[5:6], v[1:9], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_3D a16
// GFX11: [0x08,0x03,0x11,0xf1,0x01,0x05,0x02,0x0c]

image_sample_c_d_cl v[5:6], v[241:249], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_3D a16
// GFX11: [0x08,0x03,0x11,0xf1,0xf1,0x05,0x02,0x0c]

image_sample_c_d_cl v[5:6], v[1:8], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_2D
// GFX11: [0x04,0x03,0x10,0xf1,0x01,0x05,0x02,0x0c]

image_sample_c_d_cl v[254:255], v[248:255], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_2D
// GFX11: [0x04,0x03,0x10,0xf1,0xf8,0xfe,0x02,0x0c]

image_sample_c_d_cl v[5:7], v[1:7], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_2D a16 tfe
// GFX11: [0x04,0x03,0x11,0xf1,0x01,0x05,0x22,0x0c]

image_sample_c_d_cl v[253:255], v[249:255], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_2D a16 tfe
// GFX11: [0x04,0x03,0x11,0xf1,0xf9,0xfd,0x22,0x0c]

image_sample_c_d_cl v5, v[1:9], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_CUBE d16
// GFX11: [0x0c,0x03,0x12,0xf1,0x01,0x05,0x02,0x0c]

image_sample_c_d_cl v255, v[241:249], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_CUBE d16
// GFX11: [0x0c,0x03,0x12,0xf1,0xf1,0xff,0x02,0x0c]

image_sample_c_d_cl v[5:6], v[1:7], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_CUBE a16 tfe d16
// GFX11: [0x0c,0x03,0x13,0xf1,0x01,0x05,0x22,0x0c]

image_sample_c_d_cl v[254:255], v[249:255], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_CUBE a16 tfe d16
// GFX11: [0x0c,0x03,0x13,0xf1,0xf9,0xfe,0x22,0x0c]

image_sample_c_d_cl v5, v[1:6], s[8:15], s[12:15] dmask:0x4 dim:SQ_RSRC_IMG_1D_ARRAY
// GFX11: [0x10,0x04,0x10,0xf1,0x01,0x05,0x02,0x0c]

image_sample_c_d_cl v255, v[250:255], s[8:15], s[12:15] dmask:0x4 dim:SQ_RSRC_IMG_1D_ARRAY
// GFX11: [0x10,0x04,0x10,0xf1,0xfa,0xff,0x02,0x0c]

image_sample_c_d_cl v[5:6], v[1:5], s[8:15], s[12:15] dmask:0x4 dim:SQ_RSRC_IMG_1D_ARRAY a16 tfe
// GFX11: [0x10,0x04,0x11,0xf1,0x01,0x05,0x22,0x0c]

image_sample_c_d_cl v[254:255], v[251:255], s[8:15], s[12:15] dmask:0x4 dim:SQ_RSRC_IMG_1D_ARRAY a16 tfe
// GFX11: [0x10,0x04,0x11,0xf1,0xfb,0xfe,0x22,0x0c]

image_sample_c_d_cl v5, v[1:9], s[8:15], s[12:15] dmask:0x4 dim:SQ_RSRC_IMG_2D_ARRAY d16
// GFX11: [0x14,0x04,0x12,0xf1,0x01,0x05,0x02,0x0c]

image_sample_c_d_cl v255, v[241:249], s[8:15], s[12:15] dmask:0x4 dim:SQ_RSRC_IMG_2D_ARRAY d16
// GFX11: [0x14,0x04,0x12,0xf1,0xf1,0xff,0x02,0x0c]

image_sample_c_d_cl v[5:6], v[1:7], s[96:103], s[100:103] dmask:0x4 dim:SQ_RSRC_IMG_2D_ARRAY a16 tfe d16
// GFX11: [0x14,0x04,0x13,0xf1,0x01,0x05,0x38,0x64]

image_sample_c_d_cl v[254:255], v[249:255], ttmp[8:15], ttmp[12:15] dmask:0x4 dim:SQ_RSRC_IMG_2D_ARRAY unorm glc slc dlc a16 tfe lwe d16
// GFX11: [0x94,0x74,0x13,0xf1,0xf9,0xfe,0x7d,0x78]

image_sample_c_d_cl_g16 v[5:6], v[1:5], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_1D
// GFX11: [0x00,0x03,0x50,0xf1,0x01,0x05,0x02,0x0c]

image_sample_c_d_cl_g16 v[5:6], v[251:255], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_1D
// GFX11: [0x00,0x03,0x50,0xf1,0xfb,0x05,0x02,0x0c]

image_sample_c_d_cl_g16 v[5:6], v[1:4], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_1D a16
// GFX11: [0x00,0x03,0x51,0xf1,0x01,0x05,0x02,0x0c]

image_sample_c_d_cl_g16 v[5:6], v[252:255], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_1D a16
// GFX11: [0x00,0x03,0x51,0xf1,0xfc,0x05,0x02,0x0c]

image_sample_c_d_cl_g16 v[5:6], v[1:9], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_3D
// GFX11: [0x08,0x03,0x50,0xf1,0x01,0x05,0x02,0x0c]

image_sample_c_d_cl_g16 v[5:6], v[241:249], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_3D
// GFX11: [0x08,0x03,0x50,0xf1,0xf1,0x05,0x02,0x0c]

image_sample_c_d_cl_g16 v[5:6], v[1:7], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_3D a16
// GFX11: [0x08,0x03,0x51,0xf1,0x01,0x05,0x02,0x0c]

image_sample_c_d_cl_g16 v[5:6], v[249:255], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_3D a16
// GFX11: [0x08,0x03,0x51,0xf1,0xf9,0x05,0x02,0x0c]

image_sample_c_d_cl_g16 v[5:6], v[1:6], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_2D
// GFX11: [0x04,0x03,0x50,0xf1,0x01,0x05,0x02,0x0c]

image_sample_c_d_cl_g16 v[254:255], v[250:255], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_2D
// GFX11: [0x04,0x03,0x50,0xf1,0xfa,0xfe,0x02,0x0c]

image_sample_c_d_cl_g16 v[5:7], v[1:5], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_2D a16 tfe
// GFX11: [0x04,0x03,0x51,0xf1,0x01,0x05,0x22,0x0c]

image_sample_c_d_cl_g16 v[253:255], v[251:255], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_2D a16 tfe
// GFX11: [0x04,0x03,0x51,0xf1,0xfb,0xfd,0x22,0x0c]

image_sample_c_d_cl_g16 v5, v[1:7], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_CUBE d16
// GFX11: [0x0c,0x03,0x52,0xf1,0x01,0x05,0x02,0x0c]

image_sample_c_d_cl_g16 v255, v[249:255], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_CUBE d16
// GFX11: [0x0c,0x03,0x52,0xf1,0xf9,0xff,0x02,0x0c]

image_sample_c_d_cl_g16 v[5:6], v[1:5], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_CUBE a16 tfe d16
// GFX11: [0x0c,0x03,0x53,0xf1,0x01,0x05,0x22,0x0c]

image_sample_c_d_cl_g16 v[254:255], v[251:255], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_CUBE a16 tfe d16
// GFX11: [0x0c,0x03,0x53,0xf1,0xfb,0xfe,0x22,0x0c]

image_sample_c_d_cl_g16 v5, v[1:6], s[8:15], s[12:15] dmask:0x4 dim:SQ_RSRC_IMG_1D_ARRAY
// GFX11: [0x10,0x04,0x50,0xf1,0x01,0x05,0x02,0x0c]

image_sample_c_d_cl_g16 v255, v[250:255], s[8:15], s[12:15] dmask:0x4 dim:SQ_RSRC_IMG_1D_ARRAY
// GFX11: [0x10,0x04,0x50,0xf1,0xfa,0xff,0x02,0x0c]

image_sample_c_d_cl_g16 v[5:6], v[1:5], s[8:15], s[12:15] dmask:0x4 dim:SQ_RSRC_IMG_1D_ARRAY a16 tfe
// GFX11: [0x10,0x04,0x51,0xf1,0x01,0x05,0x22,0x0c]

image_sample_c_d_cl_g16 v[254:255], v[251:255], s[8:15], s[12:15] dmask:0x4 dim:SQ_RSRC_IMG_1D_ARRAY a16 tfe
// GFX11: [0x10,0x04,0x51,0xf1,0xfb,0xfe,0x22,0x0c]

image_sample_c_d_cl_g16 v5, v[1:7], s[8:15], s[12:15] dmask:0x4 dim:SQ_RSRC_IMG_2D_ARRAY d16
// GFX11: [0x14,0x04,0x52,0xf1,0x01,0x05,0x02,0x0c]

image_sample_c_d_cl_g16 v255, v[249:255], s[8:15], s[12:15] dmask:0x4 dim:SQ_RSRC_IMG_2D_ARRAY d16
// GFX11: [0x14,0x04,0x52,0xf1,0xf9,0xff,0x02,0x0c]

image_sample_c_d_cl_g16 v[5:6], v[1:5], s[96:103], s[100:103] dmask:0x4 dim:SQ_RSRC_IMG_2D_ARRAY a16 tfe d16
// GFX11: [0x14,0x04,0x53,0xf1,0x01,0x05,0x38,0x64]

image_sample_c_d_cl_g16 v[254:255], v[251:255], ttmp[8:15], ttmp[12:15] dmask:0x4 dim:SQ_RSRC_IMG_2D_ARRAY unorm glc slc dlc a16 tfe lwe d16
// GFX11: [0x94,0x74,0x53,0xf1,0xfb,0xfe,0x7d,0x78]

image_sample_c_d_cl_o v[5:6], v[1:6], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_1D
// GFX11: [0x00,0x03,0x28,0xf1,0x01,0x05,0x02,0x0c]

image_sample_c_d_cl_o v[5:6], v[250:255], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_1D
// GFX11: [0x00,0x03,0x28,0xf1,0xfa,0x05,0x02,0x0c]

image_sample_c_d_cl_o v[5:6], v[1:5], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_1D a16
// GFX11: [0x00,0x03,0x29,0xf1,0x01,0x05,0x02,0x0c]

image_sample_c_d_cl_o v[5:6], v[251:255], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_1D a16
// GFX11: [0x00,0x03,0x29,0xf1,0xfb,0x05,0x02,0x0c]

image_sample_c_d_cl_o v[5:6], v[1:12], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_3D
// GFX11: [0x08,0x03,0x28,0xf1,0x01,0x05,0x02,0x0c]

image_sample_c_d_cl_o v[5:6], v[240:251], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_3D
// GFX11: [0x08,0x03,0x28,0xf1,0xf0,0x05,0x02,0x0c]

image_sample_c_d_cl_o v[5:6], v[1:10], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_3D a16
// GFX11: [0x08,0x03,0x29,0xf1,0x01,0x05,0x02,0x0c]

image_sample_c_d_cl_o v[5:6], v[240:249], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_3D a16
// GFX11: [0x08,0x03,0x29,0xf1,0xf0,0x05,0x02,0x0c]

image_sample_c_d_cl_o v[5:6], v[1:9], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_2D
// GFX11: [0x04,0x03,0x28,0xf1,0x01,0x05,0x02,0x0c]

image_sample_c_d_cl_o v[254:255], v[241:249], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_2D
// GFX11: [0x04,0x03,0x28,0xf1,0xf1,0xfe,0x02,0x0c]

image_sample_c_d_cl_o v[5:7], v[1:8], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_2D a16 tfe
// GFX11: [0x04,0x03,0x29,0xf1,0x01,0x05,0x22,0x0c]

image_sample_c_d_cl_o v[253:255], v[248:255], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_2D a16 tfe
// GFX11: [0x04,0x03,0x29,0xf1,0xf8,0xfd,0x22,0x0c]

image_sample_c_d_cl_o v5, v[1:10], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_CUBE d16
// GFX11: [0x0c,0x03,0x2a,0xf1,0x01,0x05,0x02,0x0c]

image_sample_c_d_cl_o v255, v[240:249], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_CUBE d16
// GFX11: [0x0c,0x03,0x2a,0xf1,0xf0,0xff,0x02,0x0c]

image_sample_c_d_cl_o v[5:6], v[1:8], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_CUBE a16 tfe d16
// GFX11: [0x0c,0x03,0x2b,0xf1,0x01,0x05,0x22,0x0c]

image_sample_c_d_cl_o v[254:255], v[248:255], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_CUBE a16 tfe d16
// GFX11: [0x0c,0x03,0x2b,0xf1,0xf8,0xfe,0x22,0x0c]

image_sample_c_d_cl_o v5, v[1:7], s[8:15], s[12:15] dmask:0x4 dim:SQ_RSRC_IMG_1D_ARRAY
// GFX11: [0x10,0x04,0x28,0xf1,0x01,0x05,0x02,0x0c]

image_sample_c_d_cl_o v255, v[249:255], s[8:15], s[12:15] dmask:0x4 dim:SQ_RSRC_IMG_1D_ARRAY
// GFX11: [0x10,0x04,0x28,0xf1,0xf9,0xff,0x02,0x0c]

image_sample_c_d_cl_o v[5:6], v[1:6], s[8:15], s[12:15] dmask:0x4 dim:SQ_RSRC_IMG_1D_ARRAY a16 tfe
// GFX11: [0x10,0x04,0x29,0xf1,0x01,0x05,0x22,0x0c]

image_sample_c_d_cl_o v[254:255], v[250:255], s[8:15], s[12:15] dmask:0x4 dim:SQ_RSRC_IMG_1D_ARRAY a16 tfe
// GFX11: [0x10,0x04,0x29,0xf1,0xfa,0xfe,0x22,0x0c]

image_sample_c_d_cl_o v5, v[1:10], s[8:15], s[12:15] dmask:0x4 dim:SQ_RSRC_IMG_2D_ARRAY d16
// GFX11: [0x14,0x04,0x2a,0xf1,0x01,0x05,0x02,0x0c]

image_sample_c_d_cl_o v255, v[240:249], s[8:15], s[12:15] dmask:0x4 dim:SQ_RSRC_IMG_2D_ARRAY d16
// GFX11: [0x14,0x04,0x2a,0xf1,0xf0,0xff,0x02,0x0c]

image_sample_c_d_cl_o v[5:6], v[1:8], s[96:103], s[100:103] dmask:0x4 dim:SQ_RSRC_IMG_2D_ARRAY a16 tfe d16
// GFX11: [0x14,0x04,0x2b,0xf1,0x01,0x05,0x38,0x64]

image_sample_c_d_cl_o v[254:255], v[248:255], ttmp[8:15], ttmp[12:15] dmask:0x4 dim:SQ_RSRC_IMG_2D_ARRAY unorm glc slc dlc a16 tfe lwe d16
// GFX11: [0x94,0x74,0x2b,0xf1,0xf8,0xfe,0x7d,0x78]

image_sample_c_d_cl_o_g16 v[5:6], v[1:6], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_1D
// GFX11: [0x00,0x03,0x58,0xf1,0x01,0x05,0x02,0x0c]

image_sample_c_d_cl_o_g16 v[5:6], v[250:255], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_1D
// GFX11: [0x00,0x03,0x58,0xf1,0xfa,0x05,0x02,0x0c]

image_sample_c_d_cl_o_g16 v[5:6], v[1:5], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_1D a16
// GFX11: [0x00,0x03,0x59,0xf1,0x01,0x05,0x02,0x0c]

image_sample_c_d_cl_o_g16 v[5:6], v[251:255], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_1D a16
// GFX11: [0x00,0x03,0x59,0xf1,0xfb,0x05,0x02,0x0c]

image_sample_c_d_cl_o_g16 v[5:6], v[1:10], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_3D
// GFX11: [0x08,0x03,0x58,0xf1,0x01,0x05,0x02,0x0c]

image_sample_c_d_cl_o_g16 v[5:6], v[240:249], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_3D
// GFX11: [0x08,0x03,0x58,0xf1,0xf0,0x05,0x02,0x0c]

image_sample_c_d_cl_o_g16 v[5:6], v[1:8], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_3D a16
// GFX11: [0x08,0x03,0x59,0xf1,0x01,0x05,0x02,0x0c]

image_sample_c_d_cl_o_g16 v[5:6], v[248:255], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_3D a16
// GFX11: [0x08,0x03,0x59,0xf1,0xf8,0x05,0x02,0x0c]

image_sample_c_d_cl_o_g16 v[5:6], v[1:7], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_2D
// GFX11: [0x04,0x03,0x58,0xf1,0x01,0x05,0x02,0x0c]

image_sample_c_d_cl_o_g16 v[254:255], v[249:255], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_2D
// GFX11: [0x04,0x03,0x58,0xf1,0xf9,0xfe,0x02,0x0c]

image_sample_c_d_cl_o_g16 v[5:7], v[1:6], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_2D a16 tfe
// GFX11: [0x04,0x03,0x59,0xf1,0x01,0x05,0x22,0x0c]

image_sample_c_d_cl_o_g16 v[253:255], v[250:255], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_2D a16 tfe
// GFX11: [0x04,0x03,0x59,0xf1,0xfa,0xfd,0x22,0x0c]

image_sample_c_d_cl_o_g16 v5, v[1:8], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_CUBE d16
// GFX11: [0x0c,0x03,0x5a,0xf1,0x01,0x05,0x02,0x0c]

image_sample_c_d_cl_o_g16 v255, v[248:255], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_CUBE d16
// GFX11: [0x0c,0x03,0x5a,0xf1,0xf8,0xff,0x02,0x0c]

image_sample_c_d_cl_o_g16 v[5:6], v[1:6], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_CUBE a16 tfe d16
// GFX11: [0x0c,0x03,0x5b,0xf1,0x01,0x05,0x22,0x0c]

image_sample_c_d_cl_o_g16 v[254:255], v[250:255], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_CUBE a16 tfe d16
// GFX11: [0x0c,0x03,0x5b,0xf1,0xfa,0xfe,0x22,0x0c]

image_sample_c_d_cl_o_g16 v5, v[1:7], s[8:15], s[12:15] dmask:0x4 dim:SQ_RSRC_IMG_1D_ARRAY
// GFX11: [0x10,0x04,0x58,0xf1,0x01,0x05,0x02,0x0c]

image_sample_c_d_cl_o_g16 v255, v[249:255], s[8:15], s[12:15] dmask:0x4 dim:SQ_RSRC_IMG_1D_ARRAY
// GFX11: [0x10,0x04,0x58,0xf1,0xf9,0xff,0x02,0x0c]

image_sample_c_d_cl_o_g16 v[5:6], v[1:6], s[8:15], s[12:15] dmask:0x4 dim:SQ_RSRC_IMG_1D_ARRAY a16 tfe
// GFX11: [0x10,0x04,0x59,0xf1,0x01,0x05,0x22,0x0c]

image_sample_c_d_cl_o_g16 v[254:255], v[250:255], s[8:15], s[12:15] dmask:0x4 dim:SQ_RSRC_IMG_1D_ARRAY a16 tfe
// GFX11: [0x10,0x04,0x59,0xf1,0xfa,0xfe,0x22,0x0c]

image_sample_c_d_cl_o_g16 v5, v[1:8], s[8:15], s[12:15] dmask:0x4 dim:SQ_RSRC_IMG_2D_ARRAY d16
// GFX11: [0x14,0x04,0x5a,0xf1,0x01,0x05,0x02,0x0c]

image_sample_c_d_cl_o_g16 v255, v[248:255], s[8:15], s[12:15] dmask:0x4 dim:SQ_RSRC_IMG_2D_ARRAY d16
// GFX11: [0x14,0x04,0x5a,0xf1,0xf8,0xff,0x02,0x0c]

image_sample_c_d_cl_o_g16 v[5:6], v[1:6], s[96:103], s[100:103] dmask:0x4 dim:SQ_RSRC_IMG_2D_ARRAY a16 tfe d16
// GFX11: [0x14,0x04,0x5b,0xf1,0x01,0x05,0x38,0x64]

image_sample_c_d_cl_o_g16 v[254:255], v[250:255], ttmp[8:15], ttmp[12:15] dmask:0x4 dim:SQ_RSRC_IMG_2D_ARRAY unorm glc slc dlc a16 tfe lwe d16
// GFX11: [0x94,0x74,0x5b,0xf1,0xfa,0xfe,0x7d,0x78]

image_sample_c_d_g16 v[5:6], v[1:4], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_1D
// GFX11: [0x00,0x03,0xe8,0xf0,0x01,0x05,0x02,0x0c]

image_sample_c_d_g16 v[5:6], v[252:255], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_1D
// GFX11: [0x00,0x03,0xe8,0xf0,0xfc,0x05,0x02,0x0c]

image_sample_c_d_g16 v[5:6], v[1:4], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_1D a16
// GFX11: [0x00,0x03,0xe9,0xf0,0x01,0x05,0x02,0x0c]

image_sample_c_d_g16 v[5:6], v[252:255], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_1D a16
// GFX11: [0x00,0x03,0xe9,0xf0,0xfc,0x05,0x02,0x0c]

image_sample_c_d_g16 v[5:6], v[1:8], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_3D
// GFX11: [0x08,0x03,0xe8,0xf0,0x01,0x05,0x02,0x0c]

image_sample_c_d_g16 v[5:6], v[248:255], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_3D
// GFX11: [0x08,0x03,0xe8,0xf0,0xf8,0x05,0x02,0x0c]

image_sample_c_d_g16 v[5:6], v[1:7], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_3D a16
// GFX11: [0x08,0x03,0xe9,0xf0,0x01,0x05,0x02,0x0c]

image_sample_c_d_g16 v[5:6], v[249:255], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_3D a16
// GFX11: [0x08,0x03,0xe9,0xf0,0xf9,0x05,0x02,0x0c]

image_sample_c_d_g16 v[5:6], v[1:5], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_2D
// GFX11: [0x04,0x03,0xe8,0xf0,0x01,0x05,0x02,0x0c]

image_sample_c_d_g16 v[254:255], v[251:255], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_2D
// GFX11: [0x04,0x03,0xe8,0xf0,0xfb,0xfe,0x02,0x0c]

image_sample_c_d_g16 v[5:7], v[1:4], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_2D a16 tfe
// GFX11: [0x04,0x03,0xe9,0xf0,0x01,0x05,0x22,0x0c]

image_sample_c_d_g16 v[253:255], v[252:255], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_2D a16 tfe
// GFX11: [0x04,0x03,0xe9,0xf0,0xfc,0xfd,0x22,0x0c]

image_sample_c_d_g16 v5, v[1:6], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_CUBE d16
// GFX11: [0x0c,0x03,0xea,0xf0,0x01,0x05,0x02,0x0c]

image_sample_c_d_g16 v255, v[250:255], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_CUBE d16
// GFX11: [0x0c,0x03,0xea,0xf0,0xfa,0xff,0x02,0x0c]

image_sample_c_d_g16 v[5:6], v[1:5], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_CUBE a16 tfe d16
// GFX11: [0x0c,0x03,0xeb,0xf0,0x01,0x05,0x22,0x0c]

image_sample_c_d_g16 v[254:255], v[251:255], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_CUBE a16 tfe d16
// GFX11: [0x0c,0x03,0xeb,0xf0,0xfb,0xfe,0x22,0x0c]

image_sample_c_d_g16 v5, v[1:5], s[8:15], s[12:15] dmask:0x4 dim:SQ_RSRC_IMG_1D_ARRAY
// GFX11: [0x10,0x04,0xe8,0xf0,0x01,0x05,0x02,0x0c]

image_sample_c_d_g16 v255, v[251:255], s[8:15], s[12:15] dmask:0x4 dim:SQ_RSRC_IMG_1D_ARRAY
// GFX11: [0x10,0x04,0xe8,0xf0,0xfb,0xff,0x02,0x0c]

image_sample_c_d_g16 v[5:6], v[1:4], s[8:15], s[12:15] dmask:0x4 dim:SQ_RSRC_IMG_1D_ARRAY a16 tfe
// GFX11: [0x10,0x04,0xe9,0xf0,0x01,0x05,0x22,0x0c]

image_sample_c_d_g16 v[254:255], v[252:255], s[8:15], s[12:15] dmask:0x4 dim:SQ_RSRC_IMG_1D_ARRAY a16 tfe
// GFX11: [0x10,0x04,0xe9,0xf0,0xfc,0xfe,0x22,0x0c]

image_sample_c_d_g16 v5, v[1:6], s[8:15], s[12:15] dmask:0x4 dim:SQ_RSRC_IMG_2D_ARRAY d16
// GFX11: [0x14,0x04,0xea,0xf0,0x01,0x05,0x02,0x0c]

image_sample_c_d_g16 v255, v[250:255], s[8:15], s[12:15] dmask:0x4 dim:SQ_RSRC_IMG_2D_ARRAY d16
// GFX11: [0x14,0x04,0xea,0xf0,0xfa,0xff,0x02,0x0c]

image_sample_c_d_g16 v[5:6], v[1:5], s[96:103], s[100:103] dmask:0x4 dim:SQ_RSRC_IMG_2D_ARRAY a16 tfe d16
// GFX11: [0x14,0x04,0xeb,0xf0,0x01,0x05,0x38,0x64]

image_sample_c_d_g16 v[254:255], v[251:255], ttmp[8:15], ttmp[12:15] dmask:0x4 dim:SQ_RSRC_IMG_2D_ARRAY unorm glc slc dlc a16 tfe lwe d16
// GFX11: [0x94,0x74,0xeb,0xf0,0xfb,0xfe,0x7d,0x78]

image_sample_c_d_o v[5:6], v[1:5], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_1D
// GFX11: [0x00,0x03,0xac,0xf0,0x01,0x05,0x02,0x0c]

image_sample_c_d_o v[5:6], v[251:255], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_1D
// GFX11: [0x00,0x03,0xac,0xf0,0xfb,0x05,0x02,0x0c]

image_sample_c_d_o v[5:6], v[1:5], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_1D a16
// GFX11: [0x00,0x03,0xad,0xf0,0x01,0x05,0x02,0x0c]

image_sample_c_d_o v[5:6], v[251:255], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_1D a16
// GFX11: [0x00,0x03,0xad,0xf0,0xfb,0x05,0x02,0x0c]

image_sample_c_d_o v[5:6], v[1:11], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_3D
// GFX11: [0x08,0x03,0xac,0xf0,0x01,0x05,0x02,0x0c]

image_sample_c_d_o v[5:6], v[241:251], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_3D
// GFX11: [0x08,0x03,0xac,0xf0,0xf1,0x05,0x02,0x0c]

image_sample_c_d_o v[5:6], v[1:10], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_3D a16
// GFX11: [0x08,0x03,0xad,0xf0,0x01,0x05,0x02,0x0c]

image_sample_c_d_o v[5:6], v[240:249], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_3D a16
// GFX11: [0x08,0x03,0xad,0xf0,0xf0,0x05,0x02,0x0c]

image_sample_c_d_o v[5:6], v[1:8], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_2D
// GFX11: [0x04,0x03,0xac,0xf0,0x01,0x05,0x02,0x0c]

image_sample_c_d_o v[254:255], v[248:255], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_2D
// GFX11: [0x04,0x03,0xac,0xf0,0xf8,0xfe,0x02,0x0c]

image_sample_c_d_o v[5:7], v[1:7], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_2D a16 tfe
// GFX11: [0x04,0x03,0xad,0xf0,0x01,0x05,0x22,0x0c]

image_sample_c_d_o v[253:255], v[249:255], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_2D a16 tfe
// GFX11: [0x04,0x03,0xad,0xf0,0xf9,0xfd,0x22,0x0c]

image_sample_c_d_o v5, v[1:9], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_CUBE d16
// GFX11: [0x0c,0x03,0xae,0xf0,0x01,0x05,0x02,0x0c]

image_sample_c_d_o v255, v[241:249], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_CUBE d16
// GFX11: [0x0c,0x03,0xae,0xf0,0xf1,0xff,0x02,0x0c]

image_sample_c_d_o v[5:6], v[1:8], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_CUBE a16 tfe d16
// GFX11: [0x0c,0x03,0xaf,0xf0,0x01,0x05,0x22,0x0c]

image_sample_c_d_o v[254:255], v[248:255], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_CUBE a16 tfe d16
// GFX11: [0x0c,0x03,0xaf,0xf0,0xf8,0xfe,0x22,0x0c]

image_sample_c_d_o v5, v[1:6], s[8:15], s[12:15] dmask:0x4 dim:SQ_RSRC_IMG_1D_ARRAY
// GFX11: [0x10,0x04,0xac,0xf0,0x01,0x05,0x02,0x0c]

image_sample_c_d_o v255, v[250:255], s[8:15], s[12:15] dmask:0x4 dim:SQ_RSRC_IMG_1D_ARRAY
// GFX11: [0x10,0x04,0xac,0xf0,0xfa,0xff,0x02,0x0c]

image_sample_c_d_o v[5:6], v[1:5], s[8:15], s[12:15] dmask:0x4 dim:SQ_RSRC_IMG_1D_ARRAY a16 tfe
// GFX11: [0x10,0x04,0xad,0xf0,0x01,0x05,0x22,0x0c]

image_sample_c_d_o v[254:255], v[251:255], s[8:15], s[12:15] dmask:0x4 dim:SQ_RSRC_IMG_1D_ARRAY a16 tfe
// GFX11: [0x10,0x04,0xad,0xf0,0xfb,0xfe,0x22,0x0c]

image_sample_c_d_o v5, v[1:9], s[8:15], s[12:15] dmask:0x4 dim:SQ_RSRC_IMG_2D_ARRAY d16
// GFX11: [0x14,0x04,0xae,0xf0,0x01,0x05,0x02,0x0c]

image_sample_c_d_o v255, v[241:249], s[8:15], s[12:15] dmask:0x4 dim:SQ_RSRC_IMG_2D_ARRAY d16
// GFX11: [0x14,0x04,0xae,0xf0,0xf1,0xff,0x02,0x0c]

image_sample_c_d_o v[5:6], v[1:8], s[96:103], s[100:103] dmask:0x4 dim:SQ_RSRC_IMG_2D_ARRAY a16 tfe d16
// GFX11: [0x14,0x04,0xaf,0xf0,0x01,0x05,0x38,0x64]

image_sample_c_d_o v[254:255], v[248:255], ttmp[8:15], ttmp[12:15] dmask:0x4 dim:SQ_RSRC_IMG_2D_ARRAY unorm glc slc dlc a16 tfe lwe d16
// GFX11: [0x94,0x74,0xaf,0xf0,0xf8,0xfe,0x7d,0x78]

image_sample_c_d_o_g16 v[5:6], v[1:5], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_1D
// GFX11: [0x00,0x03,0xf0,0xf0,0x01,0x05,0x02,0x0c]

image_sample_c_d_o_g16 v[5:6], v[251:255], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_1D
// GFX11: [0x00,0x03,0xf0,0xf0,0xfb,0x05,0x02,0x0c]

image_sample_c_d_o_g16 v[5:6], v[1:5], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_1D a16
// GFX11: [0x00,0x03,0xf1,0xf0,0x01,0x05,0x02,0x0c]

image_sample_c_d_o_g16 v[5:6], v[251:255], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_1D a16
// GFX11: [0x00,0x03,0xf1,0xf0,0xfb,0x05,0x02,0x0c]

image_sample_c_d_o_g16 v[5:6], v[1:9], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_3D
// GFX11: [0x08,0x03,0xf0,0xf0,0x01,0x05,0x02,0x0c]

image_sample_c_d_o_g16 v[5:6], v[241:249], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_3D
// GFX11: [0x08,0x03,0xf0,0xf0,0xf1,0x05,0x02,0x0c]

image_sample_c_d_o_g16 v[5:6], v[1:8], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_3D a16
// GFX11: [0x08,0x03,0xf1,0xf0,0x01,0x05,0x02,0x0c]

image_sample_c_d_o_g16 v[5:6], v[248:255], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_3D a16
// GFX11: [0x08,0x03,0xf1,0xf0,0xf8,0x05,0x02,0x0c]

image_sample_c_d_o_g16 v[5:6], v[1:6], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_2D
// GFX11: [0x04,0x03,0xf0,0xf0,0x01,0x05,0x02,0x0c]

image_sample_c_d_o_g16 v[254:255], v[250:255], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_2D
// GFX11: [0x04,0x03,0xf0,0xf0,0xfa,0xfe,0x02,0x0c]

image_sample_c_d_o_g16 v[5:7], v[1:5], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_2D a16 tfe
// GFX11: [0x04,0x03,0xf1,0xf0,0x01,0x05,0x22,0x0c]

image_sample_c_d_o_g16 v[253:255], v[251:255], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_2D a16 tfe
// GFX11: [0x04,0x03,0xf1,0xf0,0xfb,0xfd,0x22,0x0c]

image_sample_c_d_o_g16 v5, v[1:7], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_CUBE d16
// GFX11: [0x0c,0x03,0xf2,0xf0,0x01,0x05,0x02,0x0c]

image_sample_c_d_o_g16 v255, v[249:255], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_CUBE d16
// GFX11: [0x0c,0x03,0xf2,0xf0,0xf9,0xff,0x02,0x0c]

image_sample_c_d_o_g16 v[5:6], v[1:6], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_CUBE a16 tfe d16
// GFX11: [0x0c,0x03,0xf3,0xf0,0x01,0x05,0x22,0x0c]

image_sample_c_d_o_g16 v[254:255], v[250:255], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_CUBE a16 tfe d16
// GFX11: [0x0c,0x03,0xf3,0xf0,0xfa,0xfe,0x22,0x0c]

image_sample_c_d_o_g16 v5, v[1:6], s[8:15], s[12:15] dmask:0x4 dim:SQ_RSRC_IMG_1D_ARRAY
// GFX11: [0x10,0x04,0xf0,0xf0,0x01,0x05,0x02,0x0c]

image_sample_c_d_o_g16 v255, v[250:255], s[8:15], s[12:15] dmask:0x4 dim:SQ_RSRC_IMG_1D_ARRAY
// GFX11: [0x10,0x04,0xf0,0xf0,0xfa,0xff,0x02,0x0c]

image_sample_c_d_o_g16 v[5:6], v[1:5], s[8:15], s[12:15] dmask:0x4 dim:SQ_RSRC_IMG_1D_ARRAY a16 tfe
// GFX11: [0x10,0x04,0xf1,0xf0,0x01,0x05,0x22,0x0c]

image_sample_c_d_o_g16 v[254:255], v[251:255], s[8:15], s[12:15] dmask:0x4 dim:SQ_RSRC_IMG_1D_ARRAY a16 tfe
// GFX11: [0x10,0x04,0xf1,0xf0,0xfb,0xfe,0x22,0x0c]

image_sample_c_d_o_g16 v5, v[1:7], s[8:15], s[12:15] dmask:0x4 dim:SQ_RSRC_IMG_2D_ARRAY d16
// GFX11: [0x14,0x04,0xf2,0xf0,0x01,0x05,0x02,0x0c]

image_sample_c_d_o_g16 v255, v[249:255], s[8:15], s[12:15] dmask:0x4 dim:SQ_RSRC_IMG_2D_ARRAY d16
// GFX11: [0x14,0x04,0xf2,0xf0,0xf9,0xff,0x02,0x0c]

image_sample_c_d_o_g16 v[5:6], v[1:6], s[96:103], s[100:103] dmask:0x4 dim:SQ_RSRC_IMG_2D_ARRAY a16 tfe d16
// GFX11: [0x14,0x04,0xf3,0xf0,0x01,0x05,0x38,0x64]

image_sample_c_d_o_g16 v[254:255], v[250:255], ttmp[8:15], ttmp[12:15] dmask:0x4 dim:SQ_RSRC_IMG_2D_ARRAY unorm glc slc dlc a16 tfe lwe d16
// GFX11: [0x94,0x74,0xf3,0xf0,0xfa,0xfe,0x7d,0x78]

image_sample_c_l v[5:6], v[1:3], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_1D
// GFX11: [0x00,0x03,0x88,0xf0,0x01,0x05,0x02,0x0c]

image_sample_c_l v[5:6], v[253:255], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_1D
// GFX11: [0x00,0x03,0x88,0xf0,0xfd,0x05,0x02,0x0c]

image_sample_c_l v[5:6], v[1:2], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_1D a16
// GFX11: [0x00,0x03,0x89,0xf0,0x01,0x05,0x02,0x0c]

image_sample_c_l v[5:6], v[254:255], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_1D a16
// GFX11: [0x00,0x03,0x89,0xf0,0xfe,0x05,0x02,0x0c]

image_sample_c_l v[5:6], v[1:5], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_3D
// GFX11: [0x08,0x03,0x88,0xf0,0x01,0x05,0x02,0x0c]

image_sample_c_l v[5:6], v[251:255], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_3D
// GFX11: [0x08,0x03,0x88,0xf0,0xfb,0x05,0x02,0x0c]

image_sample_c_l v[5:6], v[1:3], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_3D a16
// GFX11: [0x08,0x03,0x89,0xf0,0x01,0x05,0x02,0x0c]

image_sample_c_l v[5:6], v[253:255], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_3D a16
// GFX11: [0x08,0x03,0x89,0xf0,0xfd,0x05,0x02,0x0c]

image_sample_c_l v[5:6], v[1:4], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_2D
// GFX11: [0x04,0x03,0x88,0xf0,0x01,0x05,0x02,0x0c]

image_sample_c_l v[254:255], v[252:255], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_2D
// GFX11: [0x04,0x03,0x88,0xf0,0xfc,0xfe,0x02,0x0c]

image_sample_c_l v[5:7], v[1:3], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_2D a16 tfe
// GFX11: [0x04,0x03,0x89,0xf0,0x01,0x05,0x22,0x0c]

image_sample_c_l v[253:255], v[253:255], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_2D a16 tfe
// GFX11: [0x04,0x03,0x89,0xf0,0xfd,0xfd,0x22,0x0c]

image_sample_c_l v5, v[1:5], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_CUBE d16
// GFX11: [0x0c,0x03,0x8a,0xf0,0x01,0x05,0x02,0x0c]

image_sample_c_l v255, v[251:255], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_CUBE d16
// GFX11: [0x0c,0x03,0x8a,0xf0,0xfb,0xff,0x02,0x0c]

image_sample_c_l v[5:6], v[1:3], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_CUBE a16 tfe d16
// GFX11: [0x0c,0x03,0x8b,0xf0,0x01,0x05,0x22,0x0c]

image_sample_c_l v[254:255], v[253:255], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_CUBE a16 tfe d16
// GFX11: [0x0c,0x03,0x8b,0xf0,0xfd,0xfe,0x22,0x0c]

image_sample_c_l v5, v[1:4], s[8:15], s[12:15] dmask:0x4 dim:SQ_RSRC_IMG_1D_ARRAY
// GFX11: [0x10,0x04,0x88,0xf0,0x01,0x05,0x02,0x0c]

image_sample_c_l v255, v[252:255], s[8:15], s[12:15] dmask:0x4 dim:SQ_RSRC_IMG_1D_ARRAY
// GFX11: [0x10,0x04,0x88,0xf0,0xfc,0xff,0x02,0x0c]

image_sample_c_l v[5:6], v[1:3], s[8:15], s[12:15] dmask:0x4 dim:SQ_RSRC_IMG_1D_ARRAY a16 tfe
// GFX11: [0x10,0x04,0x89,0xf0,0x01,0x05,0x22,0x0c]

image_sample_c_l v[254:255], v[253:255], s[8:15], s[12:15] dmask:0x4 dim:SQ_RSRC_IMG_1D_ARRAY a16 tfe
// GFX11: [0x10,0x04,0x89,0xf0,0xfd,0xfe,0x22,0x0c]

image_sample_c_l v5, v[1:5], s[8:15], s[12:15] dmask:0x4 dim:SQ_RSRC_IMG_2D_ARRAY d16
// GFX11: [0x14,0x04,0x8a,0xf0,0x01,0x05,0x02,0x0c]

image_sample_c_l v255, v[251:255], s[8:15], s[12:15] dmask:0x4 dim:SQ_RSRC_IMG_2D_ARRAY d16
// GFX11: [0x14,0x04,0x8a,0xf0,0xfb,0xff,0x02,0x0c]

image_sample_c_l v[5:6], v[1:3], s[96:103], s[100:103] dmask:0x4 dim:SQ_RSRC_IMG_2D_ARRAY a16 tfe d16
// GFX11: [0x14,0x04,0x8b,0xf0,0x01,0x05,0x38,0x64]

image_sample_c_l v[254:255], v[253:255], ttmp[8:15], ttmp[12:15] dmask:0x4 dim:SQ_RSRC_IMG_2D_ARRAY unorm glc slc dlc a16 tfe lwe d16
// GFX11: [0x94,0x74,0x8b,0xf0,0xfd,0xfe,0x7d,0x78]

image_sample_c_l_o v[5:6], v[1:4], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_1D
// GFX11: [0x00,0x03,0xb0,0xf0,0x01,0x05,0x02,0x0c]

image_sample_c_l_o v[5:6], v[252:255], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_1D
// GFX11: [0x00,0x03,0xb0,0xf0,0xfc,0x05,0x02,0x0c]

image_sample_c_l_o v[5:6], v[1:3], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_1D a16
// GFX11: [0x00,0x03,0xb1,0xf0,0x01,0x05,0x02,0x0c]

image_sample_c_l_o v[5:6], v[253:255], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_1D a16
// GFX11: [0x00,0x03,0xb1,0xf0,0xfd,0x05,0x02,0x0c]

image_sample_c_l_o v[5:6], v[1:6], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_3D
// GFX11: [0x08,0x03,0xb0,0xf0,0x01,0x05,0x02,0x0c]

image_sample_c_l_o v[5:6], v[250:255], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_3D
// GFX11: [0x08,0x03,0xb0,0xf0,0xfa,0x05,0x02,0x0c]

image_sample_c_l_o v[5:6], v[1:4], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_3D a16
// GFX11: [0x08,0x03,0xb1,0xf0,0x01,0x05,0x02,0x0c]

image_sample_c_l_o v[5:6], v[252:255], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_3D a16
// GFX11: [0x08,0x03,0xb1,0xf0,0xfc,0x05,0x02,0x0c]

image_sample_c_l_o v[5:6], v[1:5], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_2D
// GFX11: [0x04,0x03,0xb0,0xf0,0x01,0x05,0x02,0x0c]

image_sample_c_l_o v[254:255], v[251:255], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_2D
// GFX11: [0x04,0x03,0xb0,0xf0,0xfb,0xfe,0x02,0x0c]

image_sample_c_l_o v[5:7], v[1:4], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_2D a16 tfe
// GFX11: [0x04,0x03,0xb1,0xf0,0x01,0x05,0x22,0x0c]

image_sample_c_l_o v[253:255], v[252:255], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_2D a16 tfe
// GFX11: [0x04,0x03,0xb1,0xf0,0xfc,0xfd,0x22,0x0c]

image_sample_c_l_o v5, v[1:6], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_CUBE d16
// GFX11: [0x0c,0x03,0xb2,0xf0,0x01,0x05,0x02,0x0c]

image_sample_c_l_o v255, v[250:255], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_CUBE d16
// GFX11: [0x0c,0x03,0xb2,0xf0,0xfa,0xff,0x02,0x0c]

image_sample_c_l_o v[5:6], v[1:4], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_CUBE a16 tfe d16
// GFX11: [0x0c,0x03,0xb3,0xf0,0x01,0x05,0x22,0x0c]

image_sample_c_l_o v[254:255], v[252:255], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_CUBE a16 tfe d16
// GFX11: [0x0c,0x03,0xb3,0xf0,0xfc,0xfe,0x22,0x0c]

image_sample_c_l_o v5, v[1:5], s[8:15], s[12:15] dmask:0x4 dim:SQ_RSRC_IMG_1D_ARRAY
// GFX11: [0x10,0x04,0xb0,0xf0,0x01,0x05,0x02,0x0c]

image_sample_c_l_o v255, v[251:255], s[8:15], s[12:15] dmask:0x4 dim:SQ_RSRC_IMG_1D_ARRAY
// GFX11: [0x10,0x04,0xb0,0xf0,0xfb,0xff,0x02,0x0c]

image_sample_c_l_o v[5:6], v[1:4], s[8:15], s[12:15] dmask:0x4 dim:SQ_RSRC_IMG_1D_ARRAY a16 tfe
// GFX11: [0x10,0x04,0xb1,0xf0,0x01,0x05,0x22,0x0c]

image_sample_c_l_o v[254:255], v[252:255], s[8:15], s[12:15] dmask:0x4 dim:SQ_RSRC_IMG_1D_ARRAY a16 tfe
// GFX11: [0x10,0x04,0xb1,0xf0,0xfc,0xfe,0x22,0x0c]

image_sample_c_l_o v5, v[1:6], s[8:15], s[12:15] dmask:0x4 dim:SQ_RSRC_IMG_2D_ARRAY d16
// GFX11: [0x14,0x04,0xb2,0xf0,0x01,0x05,0x02,0x0c]

image_sample_c_l_o v255, v[250:255], s[8:15], s[12:15] dmask:0x4 dim:SQ_RSRC_IMG_2D_ARRAY d16
// GFX11: [0x14,0x04,0xb2,0xf0,0xfa,0xff,0x02,0x0c]

image_sample_c_l_o v[5:6], v[1:4], s[96:103], s[100:103] dmask:0x4 dim:SQ_RSRC_IMG_2D_ARRAY a16 tfe d16
// GFX11: [0x14,0x04,0xb3,0xf0,0x01,0x05,0x38,0x64]

image_sample_c_l_o v[254:255], v[252:255], ttmp[8:15], ttmp[12:15] dmask:0x4 dim:SQ_RSRC_IMG_2D_ARRAY unorm glc slc dlc a16 tfe lwe d16
// GFX11: [0x94,0x74,0xb3,0xf0,0xfc,0xfe,0x7d,0x78]

image_sample_c_lz v[5:6], v[1:2], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_1D
// GFX11: [0x00,0x03,0x90,0xf0,0x01,0x05,0x02,0x0c]

image_sample_c_lz v[5:6], v[254:255], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_1D
// GFX11: [0x00,0x03,0x90,0xf0,0xfe,0x05,0x02,0x0c]

image_sample_c_lz v[5:6], v[1:2], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_1D a16
// GFX11: [0x00,0x03,0x91,0xf0,0x01,0x05,0x02,0x0c]

image_sample_c_lz v[5:6], v[254:255], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_1D a16
// GFX11: [0x00,0x03,0x91,0xf0,0xfe,0x05,0x02,0x0c]

image_sample_c_lz v[5:6], v[1:4], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_3D
// GFX11: [0x08,0x03,0x90,0xf0,0x01,0x05,0x02,0x0c]

image_sample_c_lz v[5:6], v[252:255], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_3D
// GFX11: [0x08,0x03,0x90,0xf0,0xfc,0x05,0x02,0x0c]

image_sample_c_lz v[5:6], v[1:3], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_3D a16
// GFX11: [0x08,0x03,0x91,0xf0,0x01,0x05,0x02,0x0c]

image_sample_c_lz v[5:6], v[253:255], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_3D a16
// GFX11: [0x08,0x03,0x91,0xf0,0xfd,0x05,0x02,0x0c]

image_sample_c_lz v[5:6], v[1:3], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_2D
// GFX11: [0x04,0x03,0x90,0xf0,0x01,0x05,0x02,0x0c]

image_sample_c_lz v[254:255], v[253:255], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_2D
// GFX11: [0x04,0x03,0x90,0xf0,0xfd,0xfe,0x02,0x0c]

image_sample_c_lz v[5:7], v[1:2], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_2D a16 tfe
// GFX11: [0x04,0x03,0x91,0xf0,0x01,0x05,0x22,0x0c]

image_sample_c_lz v[253:255], v[254:255], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_2D a16 tfe
// GFX11: [0x04,0x03,0x91,0xf0,0xfe,0xfd,0x22,0x0c]

image_sample_c_lz v5, v[1:4], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_CUBE d16
// GFX11: [0x0c,0x03,0x92,0xf0,0x01,0x05,0x02,0x0c]

image_sample_c_lz v255, v[252:255], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_CUBE d16
// GFX11: [0x0c,0x03,0x92,0xf0,0xfc,0xff,0x02,0x0c]

image_sample_c_lz v[5:6], v[1:3], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_CUBE a16 tfe d16
// GFX11: [0x0c,0x03,0x93,0xf0,0x01,0x05,0x22,0x0c]

image_sample_c_lz v[254:255], v[253:255], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_CUBE a16 tfe d16
// GFX11: [0x0c,0x03,0x93,0xf0,0xfd,0xfe,0x22,0x0c]

image_sample_c_lz v5, v[1:3], s[8:15], s[12:15] dmask:0x4 dim:SQ_RSRC_IMG_1D_ARRAY
// GFX11: [0x10,0x04,0x90,0xf0,0x01,0x05,0x02,0x0c]

image_sample_c_lz v255, v[253:255], s[8:15], s[12:15] dmask:0x4 dim:SQ_RSRC_IMG_1D_ARRAY
// GFX11: [0x10,0x04,0x90,0xf0,0xfd,0xff,0x02,0x0c]

image_sample_c_lz v[5:6], v[1:2], s[8:15], s[12:15] dmask:0x4 dim:SQ_RSRC_IMG_1D_ARRAY a16 tfe
// GFX11: [0x10,0x04,0x91,0xf0,0x01,0x05,0x22,0x0c]

image_sample_c_lz v[254:255], v[254:255], s[8:15], s[12:15] dmask:0x4 dim:SQ_RSRC_IMG_1D_ARRAY a16 tfe
// GFX11: [0x10,0x04,0x91,0xf0,0xfe,0xfe,0x22,0x0c]

image_sample_c_lz v5, v[1:4], s[8:15], s[12:15] dmask:0x4 dim:SQ_RSRC_IMG_2D_ARRAY d16
// GFX11: [0x14,0x04,0x92,0xf0,0x01,0x05,0x02,0x0c]

image_sample_c_lz v255, v[252:255], s[8:15], s[12:15] dmask:0x4 dim:SQ_RSRC_IMG_2D_ARRAY d16
// GFX11: [0x14,0x04,0x92,0xf0,0xfc,0xff,0x02,0x0c]

image_sample_c_lz v[5:6], v[1:3], s[96:103], s[100:103] dmask:0x4 dim:SQ_RSRC_IMG_2D_ARRAY a16 tfe d16
// GFX11: [0x14,0x04,0x93,0xf0,0x01,0x05,0x38,0x64]

image_sample_c_lz v[254:255], v[253:255], ttmp[8:15], ttmp[12:15] dmask:0x4 dim:SQ_RSRC_IMG_2D_ARRAY unorm glc slc dlc a16 tfe lwe d16
// GFX11: [0x94,0x74,0x93,0xf0,0xfd,0xfe,0x7d,0x78]

image_sample_c_lz_o v[5:6], v[1:3], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_1D
// GFX11: [0x00,0x03,0xb8,0xf0,0x01,0x05,0x02,0x0c]

image_sample_c_lz_o v[5:6], v[253:255], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_1D
// GFX11: [0x00,0x03,0xb8,0xf0,0xfd,0x05,0x02,0x0c]

image_sample_c_lz_o v[5:6], v[1:3], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_1D a16
// GFX11: [0x00,0x03,0xb9,0xf0,0x01,0x05,0x02,0x0c]

image_sample_c_lz_o v[5:6], v[253:255], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_1D a16
// GFX11: [0x00,0x03,0xb9,0xf0,0xfd,0x05,0x02,0x0c]

image_sample_c_lz_o v[5:6], v[1:5], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_3D
// GFX11: [0x08,0x03,0xb8,0xf0,0x01,0x05,0x02,0x0c]

image_sample_c_lz_o v[5:6], v[251:255], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_3D
// GFX11: [0x08,0x03,0xb8,0xf0,0xfb,0x05,0x02,0x0c]

image_sample_c_lz_o v[5:6], v[1:4], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_3D a16
// GFX11: [0x08,0x03,0xb9,0xf0,0x01,0x05,0x02,0x0c]

image_sample_c_lz_o v[5:6], v[252:255], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_3D a16
// GFX11: [0x08,0x03,0xb9,0xf0,0xfc,0x05,0x02,0x0c]

image_sample_c_lz_o v[5:6], v[1:4], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_2D
// GFX11: [0x04,0x03,0xb8,0xf0,0x01,0x05,0x02,0x0c]

image_sample_c_lz_o v[254:255], v[252:255], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_2D
// GFX11: [0x04,0x03,0xb8,0xf0,0xfc,0xfe,0x02,0x0c]

image_sample_c_lz_o v[5:7], v[1:3], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_2D a16 tfe
// GFX11: [0x04,0x03,0xb9,0xf0,0x01,0x05,0x22,0x0c]

image_sample_c_lz_o v[253:255], v[253:255], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_2D a16 tfe
// GFX11: [0x04,0x03,0xb9,0xf0,0xfd,0xfd,0x22,0x0c]

image_sample_c_lz_o v5, v[1:5], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_CUBE d16
// GFX11: [0x0c,0x03,0xba,0xf0,0x01,0x05,0x02,0x0c]

image_sample_c_lz_o v255, v[251:255], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_CUBE d16
// GFX11: [0x0c,0x03,0xba,0xf0,0xfb,0xff,0x02,0x0c]

image_sample_c_lz_o v[5:6], v[1:4], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_CUBE a16 tfe d16
// GFX11: [0x0c,0x03,0xbb,0xf0,0x01,0x05,0x22,0x0c]

image_sample_c_lz_o v[254:255], v[252:255], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_CUBE a16 tfe d16
// GFX11: [0x0c,0x03,0xbb,0xf0,0xfc,0xfe,0x22,0x0c]

image_sample_c_lz_o v5, v[1:4], s[8:15], s[12:15] dmask:0x4 dim:SQ_RSRC_IMG_1D_ARRAY
// GFX11: [0x10,0x04,0xb8,0xf0,0x01,0x05,0x02,0x0c]

image_sample_c_lz_o v255, v[252:255], s[8:15], s[12:15] dmask:0x4 dim:SQ_RSRC_IMG_1D_ARRAY
// GFX11: [0x10,0x04,0xb8,0xf0,0xfc,0xff,0x02,0x0c]

image_sample_c_lz_o v[5:6], v[1:3], s[8:15], s[12:15] dmask:0x4 dim:SQ_RSRC_IMG_1D_ARRAY a16 tfe
// GFX11: [0x10,0x04,0xb9,0xf0,0x01,0x05,0x22,0x0c]

image_sample_c_lz_o v[254:255], v[253:255], s[8:15], s[12:15] dmask:0x4 dim:SQ_RSRC_IMG_1D_ARRAY a16 tfe
// GFX11: [0x10,0x04,0xb9,0xf0,0xfd,0xfe,0x22,0x0c]

image_sample_c_lz_o v5, v[1:5], s[8:15], s[12:15] dmask:0x4 dim:SQ_RSRC_IMG_2D_ARRAY d16
// GFX11: [0x14,0x04,0xba,0xf0,0x01,0x05,0x02,0x0c]

image_sample_c_lz_o v255, v[251:255], s[8:15], s[12:15] dmask:0x4 dim:SQ_RSRC_IMG_2D_ARRAY d16
// GFX11: [0x14,0x04,0xba,0xf0,0xfb,0xff,0x02,0x0c]

image_sample_c_lz_o v[5:6], v[1:4], s[96:103], s[100:103] dmask:0x4 dim:SQ_RSRC_IMG_2D_ARRAY a16 tfe d16
// GFX11: [0x14,0x04,0xbb,0xf0,0x01,0x05,0x38,0x64]

image_sample_c_lz_o v[254:255], v[252:255], ttmp[8:15], ttmp[12:15] dmask:0x4 dim:SQ_RSRC_IMG_2D_ARRAY unorm glc slc dlc a16 tfe lwe d16
// GFX11: [0x94,0x74,0xbb,0xf0,0xfc,0xfe,0x7d,0x78]

image_sample_c_o v[5:6], v[1:3], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_1D
// GFX11: [0x00,0x03,0xa8,0xf0,0x01,0x05,0x02,0x0c]

image_sample_c_o v[5:6], v[253:255], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_1D
// GFX11: [0x00,0x03,0xa8,0xf0,0xfd,0x05,0x02,0x0c]

image_sample_c_o v[5:6], v[1:3], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_1D a16
// GFX11: [0x00,0x03,0xa9,0xf0,0x01,0x05,0x02,0x0c]

image_sample_c_o v[5:6], v[253:255], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_1D a16
// GFX11: [0x00,0x03,0xa9,0xf0,0xfd,0x05,0x02,0x0c]

image_sample_c_o v[5:6], v[1:5], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_3D
// GFX11: [0x08,0x03,0xa8,0xf0,0x01,0x05,0x02,0x0c]

image_sample_c_o v[5:6], v[251:255], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_3D
// GFX11: [0x08,0x03,0xa8,0xf0,0xfb,0x05,0x02,0x0c]

image_sample_c_o v[5:6], v[1:4], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_3D a16
// GFX11: [0x08,0x03,0xa9,0xf0,0x01,0x05,0x02,0x0c]

image_sample_c_o v[5:6], v[252:255], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_3D a16
// GFX11: [0x08,0x03,0xa9,0xf0,0xfc,0x05,0x02,0x0c]

image_sample_c_o v[5:6], v[1:4], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_2D
// GFX11: [0x04,0x03,0xa8,0xf0,0x01,0x05,0x02,0x0c]

image_sample_c_o v[254:255], v[252:255], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_2D
// GFX11: [0x04,0x03,0xa8,0xf0,0xfc,0xfe,0x02,0x0c]

image_sample_c_o v[5:7], v[1:3], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_2D a16 tfe
// GFX11: [0x04,0x03,0xa9,0xf0,0x01,0x05,0x22,0x0c]

image_sample_c_o v[253:255], v[253:255], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_2D a16 tfe
// GFX11: [0x04,0x03,0xa9,0xf0,0xfd,0xfd,0x22,0x0c]

image_sample_c_o v5, v[1:5], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_CUBE d16
// GFX11: [0x0c,0x03,0xaa,0xf0,0x01,0x05,0x02,0x0c]

image_sample_c_o v255, v[251:255], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_CUBE d16
// GFX11: [0x0c,0x03,0xaa,0xf0,0xfb,0xff,0x02,0x0c]

image_sample_c_o v[5:6], v[1:4], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_CUBE a16 tfe d16
// GFX11: [0x0c,0x03,0xab,0xf0,0x01,0x05,0x22,0x0c]

image_sample_c_o v[254:255], v[252:255], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_CUBE a16 tfe d16
// GFX11: [0x0c,0x03,0xab,0xf0,0xfc,0xfe,0x22,0x0c]

image_sample_c_o v5, v[1:4], s[8:15], s[12:15] dmask:0x4 dim:SQ_RSRC_IMG_1D_ARRAY
// GFX11: [0x10,0x04,0xa8,0xf0,0x01,0x05,0x02,0x0c]

image_sample_c_o v255, v[252:255], s[8:15], s[12:15] dmask:0x4 dim:SQ_RSRC_IMG_1D_ARRAY
// GFX11: [0x10,0x04,0xa8,0xf0,0xfc,0xff,0x02,0x0c]

image_sample_c_o v[5:6], v[1:3], s[8:15], s[12:15] dmask:0x4 dim:SQ_RSRC_IMG_1D_ARRAY a16 tfe
// GFX11: [0x10,0x04,0xa9,0xf0,0x01,0x05,0x22,0x0c]

image_sample_c_o v[254:255], v[253:255], s[8:15], s[12:15] dmask:0x4 dim:SQ_RSRC_IMG_1D_ARRAY a16 tfe
// GFX11: [0x10,0x04,0xa9,0xf0,0xfd,0xfe,0x22,0x0c]

image_sample_c_o v5, v[1:5], s[8:15], s[12:15] dmask:0x4 dim:SQ_RSRC_IMG_2D_ARRAY d16
// GFX11: [0x14,0x04,0xaa,0xf0,0x01,0x05,0x02,0x0c]

image_sample_c_o v255, v[251:255], s[8:15], s[12:15] dmask:0x4 dim:SQ_RSRC_IMG_2D_ARRAY d16
// GFX11: [0x14,0x04,0xaa,0xf0,0xfb,0xff,0x02,0x0c]

image_sample_c_o v[5:6], v[1:4], s[96:103], s[100:103] dmask:0x4 dim:SQ_RSRC_IMG_2D_ARRAY a16 tfe d16
// GFX11: [0x14,0x04,0xab,0xf0,0x01,0x05,0x38,0x64]

image_sample_c_o v[254:255], v[252:255], ttmp[8:15], ttmp[12:15] dmask:0x4 dim:SQ_RSRC_IMG_2D_ARRAY unorm glc slc dlc a16 tfe lwe d16
// GFX11: [0x94,0x74,0xab,0xf0,0xfc,0xfe,0x7d,0x78]

image_sample_cl v[5:6], v[1:2], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_1D
// GFX11: [0x00,0x03,0x00,0xf1,0x01,0x05,0x02,0x0c]

image_sample_cl v[5:6], v[254:255], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_1D
// GFX11: [0x00,0x03,0x00,0xf1,0xfe,0x05,0x02,0x0c]

image_sample_cl v[5:6], v1, s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_1D a16
// GFX11: [0x00,0x03,0x01,0xf1,0x01,0x05,0x02,0x0c]

image_sample_cl v[5:6], v255, s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_1D a16
// GFX11: [0x00,0x03,0x01,0xf1,0xff,0x05,0x02,0x0c]

image_sample_cl v[5:6], v[1:4], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_3D
// GFX11: [0x08,0x03,0x00,0xf1,0x01,0x05,0x02,0x0c]

image_sample_cl v[5:6], v[252:255], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_3D
// GFX11: [0x08,0x03,0x00,0xf1,0xfc,0x05,0x02,0x0c]

image_sample_cl v[5:6], v[1:2], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_3D a16
// GFX11: [0x08,0x03,0x01,0xf1,0x01,0x05,0x02,0x0c]

image_sample_cl v[5:6], v[254:255], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_3D a16
// GFX11: [0x08,0x03,0x01,0xf1,0xfe,0x05,0x02,0x0c]

image_sample_cl v[5:6], v[1:3], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_2D
// GFX11: [0x04,0x03,0x00,0xf1,0x01,0x05,0x02,0x0c]

image_sample_cl v[254:255], v[253:255], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_2D
// GFX11: [0x04,0x03,0x00,0xf1,0xfd,0xfe,0x02,0x0c]

image_sample_cl v[5:7], v[1:2], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_2D a16 tfe
// GFX11: [0x04,0x03,0x01,0xf1,0x01,0x05,0x22,0x0c]

image_sample_cl v[253:255], v[254:255], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_2D a16 tfe
// GFX11: [0x04,0x03,0x01,0xf1,0xfe,0xfd,0x22,0x0c]

image_sample_cl v5, v[1:4], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_CUBE d16
// GFX11: [0x0c,0x03,0x02,0xf1,0x01,0x05,0x02,0x0c]

image_sample_cl v255, v[252:255], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_CUBE d16
// GFX11: [0x0c,0x03,0x02,0xf1,0xfc,0xff,0x02,0x0c]

image_sample_cl v[5:6], v[1:2], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_CUBE a16 tfe d16
// GFX11: [0x0c,0x03,0x03,0xf1,0x01,0x05,0x22,0x0c]

image_sample_cl v[254:255], v[254:255], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_CUBE a16 tfe d16
// GFX11: [0x0c,0x03,0x03,0xf1,0xfe,0xfe,0x22,0x0c]

image_sample_cl v5, v[1:3], s[8:15], s[12:15] dmask:0x4 dim:SQ_RSRC_IMG_1D_ARRAY
// GFX11: [0x10,0x04,0x00,0xf1,0x01,0x05,0x02,0x0c]

image_sample_cl v255, v[253:255], s[8:15], s[12:15] dmask:0x4 dim:SQ_RSRC_IMG_1D_ARRAY
// GFX11: [0x10,0x04,0x00,0xf1,0xfd,0xff,0x02,0x0c]

image_sample_cl v[5:6], v[1:2], s[8:15], s[12:15] dmask:0x4 dim:SQ_RSRC_IMG_1D_ARRAY a16 tfe
// GFX11: [0x10,0x04,0x01,0xf1,0x01,0x05,0x22,0x0c]

image_sample_cl v[254:255], v[254:255], s[8:15], s[12:15] dmask:0x4 dim:SQ_RSRC_IMG_1D_ARRAY a16 tfe
// GFX11: [0x10,0x04,0x01,0xf1,0xfe,0xfe,0x22,0x0c]

image_sample_cl v5, v[1:4], s[8:15], s[12:15] dmask:0x4 dim:SQ_RSRC_IMG_2D_ARRAY d16
// GFX11: [0x14,0x04,0x02,0xf1,0x01,0x05,0x02,0x0c]

image_sample_cl v255, v[252:255], s[8:15], s[12:15] dmask:0x4 dim:SQ_RSRC_IMG_2D_ARRAY d16
// GFX11: [0x14,0x04,0x02,0xf1,0xfc,0xff,0x02,0x0c]

image_sample_cl v[5:6], v[1:2], s[96:103], s[100:103] dmask:0x4 dim:SQ_RSRC_IMG_2D_ARRAY a16 tfe d16
// GFX11: [0x14,0x04,0x03,0xf1,0x01,0x05,0x38,0x64]

image_sample_cl v[254:255], v[254:255], ttmp[8:15], ttmp[12:15] dmask:0x4 dim:SQ_RSRC_IMG_2D_ARRAY unorm glc slc dlc a16 tfe lwe d16
// GFX11: [0x94,0x74,0x03,0xf1,0xfe,0xfe,0x7d,0x78]

image_sample_cl_o v[5:6], v[1:3], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_1D
// GFX11: [0x00,0x03,0x18,0xf1,0x01,0x05,0x02,0x0c]

image_sample_cl_o v[5:6], v[253:255], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_1D
// GFX11: [0x00,0x03,0x18,0xf1,0xfd,0x05,0x02,0x0c]

image_sample_cl_o v[5:6], v[1:2], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_1D a16
// GFX11: [0x00,0x03,0x19,0xf1,0x01,0x05,0x02,0x0c]

image_sample_cl_o v[5:6], v[254:255], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_1D a16
// GFX11: [0x00,0x03,0x19,0xf1,0xfe,0x05,0x02,0x0c]

image_sample_cl_o v[5:6], v[1:5], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_3D
// GFX11: [0x08,0x03,0x18,0xf1,0x01,0x05,0x02,0x0c]

image_sample_cl_o v[5:6], v[251:255], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_3D
// GFX11: [0x08,0x03,0x18,0xf1,0xfb,0x05,0x02,0x0c]

image_sample_cl_o v[5:6], v[1:3], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_3D a16
// GFX11: [0x08,0x03,0x19,0xf1,0x01,0x05,0x02,0x0c]

image_sample_cl_o v[5:6], v[253:255], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_3D a16
// GFX11: [0x08,0x03,0x19,0xf1,0xfd,0x05,0x02,0x0c]

image_sample_cl_o v[5:6], v[1:4], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_2D
// GFX11: [0x04,0x03,0x18,0xf1,0x01,0x05,0x02,0x0c]

image_sample_cl_o v[254:255], v[252:255], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_2D
// GFX11: [0x04,0x03,0x18,0xf1,0xfc,0xfe,0x02,0x0c]

image_sample_cl_o v[5:7], v[1:3], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_2D a16 tfe
// GFX11: [0x04,0x03,0x19,0xf1,0x01,0x05,0x22,0x0c]

image_sample_cl_o v[253:255], v[253:255], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_2D a16 tfe
// GFX11: [0x04,0x03,0x19,0xf1,0xfd,0xfd,0x22,0x0c]

image_sample_cl_o v5, v[1:5], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_CUBE d16
// GFX11: [0x0c,0x03,0x1a,0xf1,0x01,0x05,0x02,0x0c]

image_sample_cl_o v255, v[251:255], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_CUBE d16
// GFX11: [0x0c,0x03,0x1a,0xf1,0xfb,0xff,0x02,0x0c]

image_sample_cl_o v[5:6], v[1:3], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_CUBE a16 tfe d16
// GFX11: [0x0c,0x03,0x1b,0xf1,0x01,0x05,0x22,0x0c]

image_sample_cl_o v[254:255], v[253:255], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_CUBE a16 tfe d16
// GFX11: [0x0c,0x03,0x1b,0xf1,0xfd,0xfe,0x22,0x0c]

image_sample_cl_o v5, v[1:4], s[8:15], s[12:15] dmask:0x4 dim:SQ_RSRC_IMG_1D_ARRAY
// GFX11: [0x10,0x04,0x18,0xf1,0x01,0x05,0x02,0x0c]

image_sample_cl_o v255, v[252:255], s[8:15], s[12:15] dmask:0x4 dim:SQ_RSRC_IMG_1D_ARRAY
// GFX11: [0x10,0x04,0x18,0xf1,0xfc,0xff,0x02,0x0c]

image_sample_cl_o v[5:6], v[1:3], s[8:15], s[12:15] dmask:0x4 dim:SQ_RSRC_IMG_1D_ARRAY a16 tfe
// GFX11: [0x10,0x04,0x19,0xf1,0x01,0x05,0x22,0x0c]

image_sample_cl_o v[254:255], v[253:255], s[8:15], s[12:15] dmask:0x4 dim:SQ_RSRC_IMG_1D_ARRAY a16 tfe
// GFX11: [0x10,0x04,0x19,0xf1,0xfd,0xfe,0x22,0x0c]

image_sample_cl_o v5, v[1:5], s[8:15], s[12:15] dmask:0x4 dim:SQ_RSRC_IMG_2D_ARRAY d16
// GFX11: [0x14,0x04,0x1a,0xf1,0x01,0x05,0x02,0x0c]

image_sample_cl_o v255, v[251:255], s[8:15], s[12:15] dmask:0x4 dim:SQ_RSRC_IMG_2D_ARRAY d16
// GFX11: [0x14,0x04,0x1a,0xf1,0xfb,0xff,0x02,0x0c]

image_sample_cl_o v[5:6], v[1:3], s[96:103], s[100:103] dmask:0x4 dim:SQ_RSRC_IMG_2D_ARRAY a16 tfe d16
// GFX11: [0x14,0x04,0x1b,0xf1,0x01,0x05,0x38,0x64]

image_sample_cl_o v[254:255], v[253:255], ttmp[8:15], ttmp[12:15] dmask:0x4 dim:SQ_RSRC_IMG_2D_ARRAY unorm glc slc dlc a16 tfe lwe d16
// GFX11: [0x94,0x74,0x1b,0xf1,0xfd,0xfe,0x7d,0x78]

image_sample_d v[5:6], v[1:3], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_1D
// GFX11: [0x00,0x03,0x70,0xf0,0x01,0x05,0x02,0x0c]

image_sample_d v[5:6], v[253:255], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_1D
// GFX11: [0x00,0x03,0x70,0xf0,0xfd,0x05,0x02,0x0c]

image_sample_d v[5:6], v[1:3], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_1D a16
// GFX11: [0x00,0x03,0x71,0xf0,0x01,0x05,0x02,0x0c]

image_sample_d v[5:6], v[253:255], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_1D a16
// GFX11: [0x00,0x03,0x71,0xf0,0xfd,0x05,0x02,0x0c]

image_sample_d v[5:6], v[1:9], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_3D
// GFX11: [0x08,0x03,0x70,0xf0,0x01,0x05,0x02,0x0c]

image_sample_d v[5:6], v[241:249], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_3D
// GFX11: [0x08,0x03,0x70,0xf0,0xf1,0x05,0x02,0x0c]

image_sample_d v[5:6], v[1:8], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_3D a16
// GFX11: [0x08,0x03,0x71,0xf0,0x01,0x05,0x02,0x0c]

image_sample_d v[5:6], v[248:255], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_3D a16
// GFX11: [0x08,0x03,0x71,0xf0,0xf8,0x05,0x02,0x0c]

image_sample_d v[5:6], v[1:6], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_2D
// GFX11: [0x04,0x03,0x70,0xf0,0x01,0x05,0x02,0x0c]

image_sample_d v[254:255], v[250:255], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_2D
// GFX11: [0x04,0x03,0x70,0xf0,0xfa,0xfe,0x02,0x0c]

image_sample_d v[5:7], v[1:5], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_2D a16 tfe
// GFX11: [0x04,0x03,0x71,0xf0,0x01,0x05,0x22,0x0c]

image_sample_d v[253:255], v[251:255], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_2D a16 tfe
// GFX11: [0x04,0x03,0x71,0xf0,0xfb,0xfd,0x22,0x0c]

image_sample_d v5, v[1:7], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_CUBE d16
// GFX11: [0x0c,0x03,0x72,0xf0,0x01,0x05,0x02,0x0c]

image_sample_d v255, v[249:255], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_CUBE d16
// GFX11: [0x0c,0x03,0x72,0xf0,0xf9,0xff,0x02,0x0c]

image_sample_d v[5:6], v[1:6], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_CUBE a16 tfe d16
// GFX11: [0x0c,0x03,0x73,0xf0,0x01,0x05,0x22,0x0c]

image_sample_d v[254:255], v[250:255], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_CUBE a16 tfe d16
// GFX11: [0x0c,0x03,0x73,0xf0,0xfa,0xfe,0x22,0x0c]

image_sample_d v5, v[1:4], s[8:15], s[12:15] dmask:0x4 dim:SQ_RSRC_IMG_1D_ARRAY
// GFX11: [0x10,0x04,0x70,0xf0,0x01,0x05,0x02,0x0c]

image_sample_d v255, v[252:255], s[8:15], s[12:15] dmask:0x4 dim:SQ_RSRC_IMG_1D_ARRAY
// GFX11: [0x10,0x04,0x70,0xf0,0xfc,0xff,0x02,0x0c]

image_sample_d v[5:6], v[1:3], s[8:15], s[12:15] dmask:0x4 dim:SQ_RSRC_IMG_1D_ARRAY a16 tfe
// GFX11: [0x10,0x04,0x71,0xf0,0x01,0x05,0x22,0x0c]

image_sample_d v[254:255], v[253:255], s[8:15], s[12:15] dmask:0x4 dim:SQ_RSRC_IMG_1D_ARRAY a16 tfe
// GFX11: [0x10,0x04,0x71,0xf0,0xfd,0xfe,0x22,0x0c]

image_sample_d v5, v[1:7], s[8:15], s[12:15] dmask:0x4 dim:SQ_RSRC_IMG_2D_ARRAY d16
// GFX11: [0x14,0x04,0x72,0xf0,0x01,0x05,0x02,0x0c]

image_sample_d v255, v[249:255], s[8:15], s[12:15] dmask:0x4 dim:SQ_RSRC_IMG_2D_ARRAY d16
// GFX11: [0x14,0x04,0x72,0xf0,0xf9,0xff,0x02,0x0c]

image_sample_d v[5:6], v[1:6], s[96:103], s[100:103] dmask:0x4 dim:SQ_RSRC_IMG_2D_ARRAY a16 tfe d16
// GFX11: [0x14,0x04,0x73,0xf0,0x01,0x05,0x38,0x64]

image_sample_d v[254:255], v[250:255], ttmp[8:15], ttmp[12:15] dmask:0x4 dim:SQ_RSRC_IMG_2D_ARRAY unorm glc slc dlc a16 tfe lwe d16
// GFX11: [0x94,0x74,0x73,0xf0,0xfa,0xfe,0x7d,0x78]

image_sample_d_cl v[5:6], v[1:4], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_1D
// GFX11: [0x00,0x03,0x04,0xf1,0x01,0x05,0x02,0x0c]

image_sample_d_cl v[5:6], v[252:255], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_1D
// GFX11: [0x00,0x03,0x04,0xf1,0xfc,0x05,0x02,0x0c]

image_sample_d_cl v[5:6], v[1:3], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_1D a16
// GFX11: [0x00,0x03,0x05,0xf1,0x01,0x05,0x02,0x0c]

image_sample_d_cl v[5:6], v[253:255], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_1D a16
// GFX11: [0x00,0x03,0x05,0xf1,0xfd,0x05,0x02,0x0c]

image_sample_d_cl v[5:6], v[1:10], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_3D
// GFX11: [0x08,0x03,0x04,0xf1,0x01,0x05,0x02,0x0c]

image_sample_d_cl v[5:6], v[240:249], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_3D
// GFX11: [0x08,0x03,0x04,0xf1,0xf0,0x05,0x02,0x0c]

image_sample_d_cl v[5:6], v[1:8], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_3D a16
// GFX11: [0x08,0x03,0x05,0xf1,0x01,0x05,0x02,0x0c]

image_sample_d_cl v[5:6], v[248:255], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_3D a16
// GFX11: [0x08,0x03,0x05,0xf1,0xf8,0x05,0x02,0x0c]

image_sample_d_cl v[5:6], v[1:7], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_2D
// GFX11: [0x04,0x03,0x04,0xf1,0x01,0x05,0x02,0x0c]

image_sample_d_cl v[254:255], v[249:255], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_2D
// GFX11: [0x04,0x03,0x04,0xf1,0xf9,0xfe,0x02,0x0c]

image_sample_d_cl v[5:7], v[1:6], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_2D a16 tfe
// GFX11: [0x04,0x03,0x05,0xf1,0x01,0x05,0x22,0x0c]

image_sample_d_cl v[253:255], v[250:255], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_2D a16 tfe
// GFX11: [0x04,0x03,0x05,0xf1,0xfa,0xfd,0x22,0x0c]

image_sample_d_cl v5, v[1:8], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_CUBE d16
// GFX11: [0x0c,0x03,0x06,0xf1,0x01,0x05,0x02,0x0c]

image_sample_d_cl v255, v[248:255], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_CUBE d16
// GFX11: [0x0c,0x03,0x06,0xf1,0xf8,0xff,0x02,0x0c]

image_sample_d_cl v[5:6], v[1:6], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_CUBE a16 tfe d16
// GFX11: [0x0c,0x03,0x07,0xf1,0x01,0x05,0x22,0x0c]

image_sample_d_cl v[254:255], v[250:255], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_CUBE a16 tfe d16
// GFX11: [0x0c,0x03,0x07,0xf1,0xfa,0xfe,0x22,0x0c]

image_sample_d_cl v5, v[1:5], s[8:15], s[12:15] dmask:0x4 dim:SQ_RSRC_IMG_1D_ARRAY
// GFX11: [0x10,0x04,0x04,0xf1,0x01,0x05,0x02,0x0c]

image_sample_d_cl v255, v[251:255], s[8:15], s[12:15] dmask:0x4 dim:SQ_RSRC_IMG_1D_ARRAY
// GFX11: [0x10,0x04,0x04,0xf1,0xfb,0xff,0x02,0x0c]

image_sample_d_cl v[5:6], v[1:4], s[8:15], s[12:15] dmask:0x4 dim:SQ_RSRC_IMG_1D_ARRAY a16 tfe
// GFX11: [0x10,0x04,0x05,0xf1,0x01,0x05,0x22,0x0c]

image_sample_d_cl v[254:255], v[252:255], s[8:15], s[12:15] dmask:0x4 dim:SQ_RSRC_IMG_1D_ARRAY a16 tfe
// GFX11: [0x10,0x04,0x05,0xf1,0xfc,0xfe,0x22,0x0c]

image_sample_d_cl v5, v[1:8], s[8:15], s[12:15] dmask:0x4 dim:SQ_RSRC_IMG_2D_ARRAY d16
// GFX11: [0x14,0x04,0x06,0xf1,0x01,0x05,0x02,0x0c]

image_sample_d_cl v255, v[248:255], s[8:15], s[12:15] dmask:0x4 dim:SQ_RSRC_IMG_2D_ARRAY d16
// GFX11: [0x14,0x04,0x06,0xf1,0xf8,0xff,0x02,0x0c]

image_sample_d_cl v[5:6], v[1:6], s[96:103], s[100:103] dmask:0x4 dim:SQ_RSRC_IMG_2D_ARRAY a16 tfe d16
// GFX11: [0x14,0x04,0x07,0xf1,0x01,0x05,0x38,0x64]

image_sample_d_cl v[254:255], v[250:255], ttmp[8:15], ttmp[12:15] dmask:0x4 dim:SQ_RSRC_IMG_2D_ARRAY unorm glc slc dlc a16 tfe lwe d16
// GFX11: [0x94,0x74,0x07,0xf1,0xfa,0xfe,0x7d,0x78]

image_sample_d_cl_g16 v[5:6], v[1:4], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_1D
// GFX11: [0x00,0x03,0x7c,0xf1,0x01,0x05,0x02,0x0c]

image_sample_d_cl_g16 v[5:6], v[252:255], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_1D
// GFX11: [0x00,0x03,0x7c,0xf1,0xfc,0x05,0x02,0x0c]

image_sample_d_cl_g16 v[5:6], v[1:3], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_1D a16
// GFX11: [0x00,0x03,0x7d,0xf1,0x01,0x05,0x02,0x0c]

image_sample_d_cl_g16 v[5:6], v[253:255], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_1D a16
// GFX11: [0x00,0x03,0x7d,0xf1,0xfd,0x05,0x02,0x0c]

image_sample_d_cl_g16 v[5:6], v[1:8], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_3D
// GFX11: [0x08,0x03,0x7c,0xf1,0x01,0x05,0x02,0x0c]

image_sample_d_cl_g16 v[5:6], v[248:255], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_3D
// GFX11: [0x08,0x03,0x7c,0xf1,0xf8,0x05,0x02,0x0c]

image_sample_d_cl_g16 v[5:6], v[1:6], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_3D a16
// GFX11: [0x08,0x03,0x7d,0xf1,0x01,0x05,0x02,0x0c]

image_sample_d_cl_g16 v[5:6], v[250:255], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_3D a16
// GFX11: [0x08,0x03,0x7d,0xf1,0xfa,0x05,0x02,0x0c]

image_sample_d_cl_g16 v[5:6], v[1:5], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_2D
// GFX11: [0x04,0x03,0x7c,0xf1,0x01,0x05,0x02,0x0c]

image_sample_d_cl_g16 v[254:255], v[251:255], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_2D
// GFX11: [0x04,0x03,0x7c,0xf1,0xfb,0xfe,0x02,0x0c]

image_sample_d_cl_g16 v[5:7], v[1:4], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_2D a16 tfe
// GFX11: [0x04,0x03,0x7d,0xf1,0x01,0x05,0x22,0x0c]

image_sample_d_cl_g16 v[253:255], v[252:255], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_2D a16 tfe
// GFX11: [0x04,0x03,0x7d,0xf1,0xfc,0xfd,0x22,0x0c]

image_sample_d_cl_g16 v5, v[1:6], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_CUBE d16
// GFX11: [0x0c,0x03,0x7e,0xf1,0x01,0x05,0x02,0x0c]

image_sample_d_cl_g16 v255, v[250:255], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_CUBE d16
// GFX11: [0x0c,0x03,0x7e,0xf1,0xfa,0xff,0x02,0x0c]

image_sample_d_cl_g16 v[5:6], v[1:4], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_CUBE a16 tfe d16
// GFX11: [0x0c,0x03,0x7f,0xf1,0x01,0x05,0x22,0x0c]

image_sample_d_cl_g16 v[254:255], v[252:255], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_CUBE a16 tfe d16
// GFX11: [0x0c,0x03,0x7f,0xf1,0xfc,0xfe,0x22,0x0c]

image_sample_d_cl_g16 v5, v[1:5], s[8:15], s[12:15] dmask:0x4 dim:SQ_RSRC_IMG_1D_ARRAY
// GFX11: [0x10,0x04,0x7c,0xf1,0x01,0x05,0x02,0x0c]

image_sample_d_cl_g16 v255, v[251:255], s[8:15], s[12:15] dmask:0x4 dim:SQ_RSRC_IMG_1D_ARRAY
// GFX11: [0x10,0x04,0x7c,0xf1,0xfb,0xff,0x02,0x0c]

image_sample_d_cl_g16 v[5:6], v[1:4], s[8:15], s[12:15] dmask:0x4 dim:SQ_RSRC_IMG_1D_ARRAY a16 tfe
// GFX11: [0x10,0x04,0x7d,0xf1,0x01,0x05,0x22,0x0c]

image_sample_d_cl_g16 v[254:255], v[252:255], s[8:15], s[12:15] dmask:0x4 dim:SQ_RSRC_IMG_1D_ARRAY a16 tfe
// GFX11: [0x10,0x04,0x7d,0xf1,0xfc,0xfe,0x22,0x0c]

image_sample_d_cl_g16 v5, v[1:6], s[8:15], s[12:15] dmask:0x4 dim:SQ_RSRC_IMG_2D_ARRAY d16
// GFX11: [0x14,0x04,0x7e,0xf1,0x01,0x05,0x02,0x0c]

image_sample_d_cl_g16 v255, v[250:255], s[8:15], s[12:15] dmask:0x4 dim:SQ_RSRC_IMG_2D_ARRAY d16
// GFX11: [0x14,0x04,0x7e,0xf1,0xfa,0xff,0x02,0x0c]

image_sample_d_cl_g16 v[5:6], v[1:4], s[96:103], s[100:103] dmask:0x4 dim:SQ_RSRC_IMG_2D_ARRAY a16 tfe d16
// GFX11: [0x14,0x04,0x7f,0xf1,0x01,0x05,0x38,0x64]

image_sample_d_cl_g16 v[254:255], v[252:255], ttmp[8:15], ttmp[12:15] dmask:0x4 dim:SQ_RSRC_IMG_2D_ARRAY unorm glc slc dlc a16 tfe lwe d16
// GFX11: [0x94,0x74,0x7f,0xf1,0xfc,0xfe,0x7d,0x78]

image_sample_d_cl_o v[5:6], v[1:5], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_1D
// GFX11: [0x00,0x03,0x1c,0xf1,0x01,0x05,0x02,0x0c]

image_sample_d_cl_o v[5:6], v[251:255], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_1D
// GFX11: [0x00,0x03,0x1c,0xf1,0xfb,0x05,0x02,0x0c]

image_sample_d_cl_o v[5:6], v[1:4], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_1D a16
// GFX11: [0x00,0x03,0x1d,0xf1,0x01,0x05,0x02,0x0c]

image_sample_d_cl_o v[5:6], v[252:255], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_1D a16
// GFX11: [0x00,0x03,0x1d,0xf1,0xfc,0x05,0x02,0x0c]

image_sample_d_cl_o v[5:6], v[1:11], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_3D
// GFX11: [0x08,0x03,0x1c,0xf1,0x01,0x05,0x02,0x0c]

image_sample_d_cl_o v[5:6], v[241:251], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_3D
// GFX11: [0x08,0x03,0x1c,0xf1,0xf1,0x05,0x02,0x0c]

image_sample_d_cl_o v[5:6], v[1:9], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_3D a16
// GFX11: [0x08,0x03,0x1d,0xf1,0x01,0x05,0x02,0x0c]

image_sample_d_cl_o v[5:6], v[241:249], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_3D a16
// GFX11: [0x08,0x03,0x1d,0xf1,0xf1,0x05,0x02,0x0c]

image_sample_d_cl_o v[5:6], v[1:8], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_2D
// GFX11: [0x04,0x03,0x1c,0xf1,0x01,0x05,0x02,0x0c]

image_sample_d_cl_o v[254:255], v[248:255], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_2D
// GFX11: [0x04,0x03,0x1c,0xf1,0xf8,0xfe,0x02,0x0c]

image_sample_d_cl_o v[5:7], v[1:7], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_2D a16 tfe
// GFX11: [0x04,0x03,0x1d,0xf1,0x01,0x05,0x22,0x0c]

image_sample_d_cl_o v[253:255], v[249:255], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_2D a16 tfe
// GFX11: [0x04,0x03,0x1d,0xf1,0xf9,0xfd,0x22,0x0c]

image_sample_d_cl_o v5, v[1:9], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_CUBE d16
// GFX11: [0x0c,0x03,0x1e,0xf1,0x01,0x05,0x02,0x0c]

image_sample_d_cl_o v255, v[241:249], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_CUBE d16
// GFX11: [0x0c,0x03,0x1e,0xf1,0xf1,0xff,0x02,0x0c]

image_sample_d_cl_o v[5:6], v[1:7], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_CUBE a16 tfe d16
// GFX11: [0x0c,0x03,0x1f,0xf1,0x01,0x05,0x22,0x0c]

image_sample_d_cl_o v[254:255], v[249:255], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_CUBE a16 tfe d16
// GFX11: [0x0c,0x03,0x1f,0xf1,0xf9,0xfe,0x22,0x0c]

image_sample_d_cl_o v5, v[1:6], s[8:15], s[12:15] dmask:0x4 dim:SQ_RSRC_IMG_1D_ARRAY
// GFX11: [0x10,0x04,0x1c,0xf1,0x01,0x05,0x02,0x0c]

image_sample_d_cl_o v255, v[250:255], s[8:15], s[12:15] dmask:0x4 dim:SQ_RSRC_IMG_1D_ARRAY
// GFX11: [0x10,0x04,0x1c,0xf1,0xfa,0xff,0x02,0x0c]

image_sample_d_cl_o v[5:6], v[1:5], s[8:15], s[12:15] dmask:0x4 dim:SQ_RSRC_IMG_1D_ARRAY a16 tfe
// GFX11: [0x10,0x04,0x1d,0xf1,0x01,0x05,0x22,0x0c]

image_sample_d_cl_o v[254:255], v[251:255], s[8:15], s[12:15] dmask:0x4 dim:SQ_RSRC_IMG_1D_ARRAY a16 tfe
// GFX11: [0x10,0x04,0x1d,0xf1,0xfb,0xfe,0x22,0x0c]

image_sample_d_cl_o v5, v[1:9], s[8:15], s[12:15] dmask:0x4 dim:SQ_RSRC_IMG_2D_ARRAY d16
// GFX11: [0x14,0x04,0x1e,0xf1,0x01,0x05,0x02,0x0c]

image_sample_d_cl_o v255, v[241:249], s[8:15], s[12:15] dmask:0x4 dim:SQ_RSRC_IMG_2D_ARRAY d16
// GFX11: [0x14,0x04,0x1e,0xf1,0xf1,0xff,0x02,0x0c]

image_sample_d_cl_o v[5:6], v[1:7], s[96:103], s[100:103] dmask:0x4 dim:SQ_RSRC_IMG_2D_ARRAY a16 tfe d16
// GFX11: [0x14,0x04,0x1f,0xf1,0x01,0x05,0x38,0x64]

image_sample_d_cl_o v[254:255], v[249:255], ttmp[8:15], ttmp[12:15] dmask:0x4 dim:SQ_RSRC_IMG_2D_ARRAY unorm glc slc dlc a16 tfe lwe d16
// GFX11: [0x94,0x74,0x1f,0xf1,0xf9,0xfe,0x7d,0x78]

image_sample_d_cl_o_g16 v[5:6], v[1:5], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_1D
// GFX11: [0x00,0x03,0x54,0xf1,0x01,0x05,0x02,0x0c]

image_sample_d_cl_o_g16 v[5:6], v[251:255], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_1D
// GFX11: [0x00,0x03,0x54,0xf1,0xfb,0x05,0x02,0x0c]

image_sample_d_cl_o_g16 v[5:6], v[1:4], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_1D a16
// GFX11: [0x00,0x03,0x55,0xf1,0x01,0x05,0x02,0x0c]

image_sample_d_cl_o_g16 v[5:6], v[252:255], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_1D a16
// GFX11: [0x00,0x03,0x55,0xf1,0xfc,0x05,0x02,0x0c]

image_sample_d_cl_o_g16 v[5:6], v[1:9], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_3D
// GFX11: [0x08,0x03,0x54,0xf1,0x01,0x05,0x02,0x0c]

image_sample_d_cl_o_g16 v[5:6], v[241:249], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_3D
// GFX11: [0x08,0x03,0x54,0xf1,0xf1,0x05,0x02,0x0c]

image_sample_d_cl_o_g16 v[5:6], v[1:7], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_3D a16
// GFX11: [0x08,0x03,0x55,0xf1,0x01,0x05,0x02,0x0c]

image_sample_d_cl_o_g16 v[5:6], v[249:255], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_3D a16
// GFX11: [0x08,0x03,0x55,0xf1,0xf9,0x05,0x02,0x0c]

image_sample_d_cl_o_g16 v[5:6], v[1:6], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_2D
// GFX11: [0x04,0x03,0x54,0xf1,0x01,0x05,0x02,0x0c]

image_sample_d_cl_o_g16 v[254:255], v[250:255], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_2D
// GFX11: [0x04,0x03,0x54,0xf1,0xfa,0xfe,0x02,0x0c]

image_sample_d_cl_o_g16 v[5:7], v[1:5], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_2D a16 tfe
// GFX11: [0x04,0x03,0x55,0xf1,0x01,0x05,0x22,0x0c]

image_sample_d_cl_o_g16 v[253:255], v[251:255], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_2D a16 tfe
// GFX11: [0x04,0x03,0x55,0xf1,0xfb,0xfd,0x22,0x0c]

image_sample_d_cl_o_g16 v5, v[1:7], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_CUBE d16
// GFX11: [0x0c,0x03,0x56,0xf1,0x01,0x05,0x02,0x0c]

image_sample_d_cl_o_g16 v255, v[249:255], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_CUBE d16
// GFX11: [0x0c,0x03,0x56,0xf1,0xf9,0xff,0x02,0x0c]

image_sample_d_cl_o_g16 v[5:6], v[1:5], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_CUBE a16 tfe d16
// GFX11: [0x0c,0x03,0x57,0xf1,0x01,0x05,0x22,0x0c]

image_sample_d_cl_o_g16 v[254:255], v[251:255], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_CUBE a16 tfe d16
// GFX11: [0x0c,0x03,0x57,0xf1,0xfb,0xfe,0x22,0x0c]

image_sample_d_cl_o_g16 v5, v[1:6], s[8:15], s[12:15] dmask:0x4 dim:SQ_RSRC_IMG_1D_ARRAY
// GFX11: [0x10,0x04,0x54,0xf1,0x01,0x05,0x02,0x0c]

image_sample_d_cl_o_g16 v255, v[250:255], s[8:15], s[12:15] dmask:0x4 dim:SQ_RSRC_IMG_1D_ARRAY
// GFX11: [0x10,0x04,0x54,0xf1,0xfa,0xff,0x02,0x0c]

image_sample_d_cl_o_g16 v[5:6], v[1:5], s[8:15], s[12:15] dmask:0x4 dim:SQ_RSRC_IMG_1D_ARRAY a16 tfe
// GFX11: [0x10,0x04,0x55,0xf1,0x01,0x05,0x22,0x0c]

image_sample_d_cl_o_g16 v[254:255], v[251:255], s[8:15], s[12:15] dmask:0x4 dim:SQ_RSRC_IMG_1D_ARRAY a16 tfe
// GFX11: [0x10,0x04,0x55,0xf1,0xfb,0xfe,0x22,0x0c]

image_sample_d_cl_o_g16 v5, v[1:7], s[8:15], s[12:15] dmask:0x4 dim:SQ_RSRC_IMG_2D_ARRAY d16
// GFX11: [0x14,0x04,0x56,0xf1,0x01,0x05,0x02,0x0c]

image_sample_d_cl_o_g16 v255, v[249:255], s[8:15], s[12:15] dmask:0x4 dim:SQ_RSRC_IMG_2D_ARRAY d16
// GFX11: [0x14,0x04,0x56,0xf1,0xf9,0xff,0x02,0x0c]

image_sample_d_cl_o_g16 v[5:6], v[1:5], s[96:103], s[100:103] dmask:0x4 dim:SQ_RSRC_IMG_2D_ARRAY a16 tfe d16
// GFX11: [0x14,0x04,0x57,0xf1,0x01,0x05,0x38,0x64]

image_sample_d_cl_o_g16 v[254:255], v[251:255], ttmp[8:15], ttmp[12:15] dmask:0x4 dim:SQ_RSRC_IMG_2D_ARRAY unorm glc slc dlc a16 tfe lwe d16
// GFX11: [0x94,0x74,0x57,0xf1,0xfb,0xfe,0x7d,0x78]

image_sample_d_g16 v[5:6], v[1:3], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_1D
// GFX11: [0x00,0x03,0xe4,0xf0,0x01,0x05,0x02,0x0c]

image_sample_d_g16 v[5:6], v[253:255], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_1D
// GFX11: [0x00,0x03,0xe4,0xf0,0xfd,0x05,0x02,0x0c]

image_sample_d_g16 v[5:6], v[1:3], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_1D a16
// GFX11: [0x00,0x03,0xe5,0xf0,0x01,0x05,0x02,0x0c]

image_sample_d_g16 v[5:6], v[253:255], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_1D a16
// GFX11: [0x00,0x03,0xe5,0xf0,0xfd,0x05,0x02,0x0c]

image_sample_d_g16 v[5:6], v[1:7], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_3D
// GFX11: [0x08,0x03,0xe4,0xf0,0x01,0x05,0x02,0x0c]

image_sample_d_g16 v[5:6], v[249:255], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_3D
// GFX11: [0x08,0x03,0xe4,0xf0,0xf9,0x05,0x02,0x0c]

image_sample_d_g16 v[5:6], v[1:6], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_3D a16
// GFX11: [0x08,0x03,0xe5,0xf0,0x01,0x05,0x02,0x0c]

image_sample_d_g16 v[5:6], v[250:255], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_3D a16
// GFX11: [0x08,0x03,0xe5,0xf0,0xfa,0x05,0x02,0x0c]

image_sample_d_g16 v[5:6], v[1:4], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_2D
// GFX11: [0x04,0x03,0xe4,0xf0,0x01,0x05,0x02,0x0c]

image_sample_d_g16 v[254:255], v[252:255], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_2D
// GFX11: [0x04,0x03,0xe4,0xf0,0xfc,0xfe,0x02,0x0c]

image_sample_d_g16 v[5:7], v[1:3], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_2D a16 tfe
// GFX11: [0x04,0x03,0xe5,0xf0,0x01,0x05,0x22,0x0c]

image_sample_d_g16 v[253:255], v[253:255], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_2D a16 tfe
// GFX11: [0x04,0x03,0xe5,0xf0,0xfd,0xfd,0x22,0x0c]

image_sample_d_g16 v5, v[1:5], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_CUBE d16
// GFX11: [0x0c,0x03,0xe6,0xf0,0x01,0x05,0x02,0x0c]

image_sample_d_g16 v255, v[251:255], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_CUBE d16
// GFX11: [0x0c,0x03,0xe6,0xf0,0xfb,0xff,0x02,0x0c]

image_sample_d_g16 v[5:6], v[1:4], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_CUBE a16 tfe d16
// GFX11: [0x0c,0x03,0xe7,0xf0,0x01,0x05,0x22,0x0c]

image_sample_d_g16 v[254:255], v[252:255], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_CUBE a16 tfe d16
// GFX11: [0x0c,0x03,0xe7,0xf0,0xfc,0xfe,0x22,0x0c]

image_sample_d_g16 v5, v[1:4], s[8:15], s[12:15] dmask:0x4 dim:SQ_RSRC_IMG_1D_ARRAY
// GFX11: [0x10,0x04,0xe4,0xf0,0x01,0x05,0x02,0x0c]

image_sample_d_g16 v255, v[252:255], s[8:15], s[12:15] dmask:0x4 dim:SQ_RSRC_IMG_1D_ARRAY
// GFX11: [0x10,0x04,0xe4,0xf0,0xfc,0xff,0x02,0x0c]

image_sample_d_g16 v[5:6], v[1:3], s[8:15], s[12:15] dmask:0x4 dim:SQ_RSRC_IMG_1D_ARRAY a16 tfe
// GFX11: [0x10,0x04,0xe5,0xf0,0x01,0x05,0x22,0x0c]

image_sample_d_g16 v[254:255], v[253:255], s[8:15], s[12:15] dmask:0x4 dim:SQ_RSRC_IMG_1D_ARRAY a16 tfe
// GFX11: [0x10,0x04,0xe5,0xf0,0xfd,0xfe,0x22,0x0c]

image_sample_d_g16 v5, v[1:5], s[8:15], s[12:15] dmask:0x4 dim:SQ_RSRC_IMG_2D_ARRAY d16
// GFX11: [0x14,0x04,0xe6,0xf0,0x01,0x05,0x02,0x0c]

image_sample_d_g16 v255, v[251:255], s[8:15], s[12:15] dmask:0x4 dim:SQ_RSRC_IMG_2D_ARRAY d16
// GFX11: [0x14,0x04,0xe6,0xf0,0xfb,0xff,0x02,0x0c]

image_sample_d_g16 v[5:6], v[1:4], s[96:103], s[100:103] dmask:0x4 dim:SQ_RSRC_IMG_2D_ARRAY a16 tfe d16
// GFX11: [0x14,0x04,0xe7,0xf0,0x01,0x05,0x38,0x64]

image_sample_d_g16 v[254:255], v[252:255], ttmp[8:15], ttmp[12:15] dmask:0x4 dim:SQ_RSRC_IMG_2D_ARRAY unorm glc slc dlc a16 tfe lwe d16
// GFX11: [0x94,0x74,0xe7,0xf0,0xfc,0xfe,0x7d,0x78]

image_sample_d_o v[5:6], v[1:4], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_1D
// GFX11: [0x00,0x03,0x98,0xf0,0x01,0x05,0x02,0x0c]

image_sample_d_o v[5:6], v[252:255], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_1D
// GFX11: [0x00,0x03,0x98,0xf0,0xfc,0x05,0x02,0x0c]

image_sample_d_o v[5:6], v[1:4], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_1D a16
// GFX11: [0x00,0x03,0x99,0xf0,0x01,0x05,0x02,0x0c]

image_sample_d_o v[5:6], v[252:255], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_1D a16
// GFX11: [0x00,0x03,0x99,0xf0,0xfc,0x05,0x02,0x0c]

image_sample_d_o v[5:6], v[1:10], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_3D
// GFX11: [0x08,0x03,0x98,0xf0,0x01,0x05,0x02,0x0c]

image_sample_d_o v[5:6], v[240:249], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_3D
// GFX11: [0x08,0x03,0x98,0xf0,0xf0,0x05,0x02,0x0c]

image_sample_d_o v[5:6], v[1:9], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_3D a16
// GFX11: [0x08,0x03,0x99,0xf0,0x01,0x05,0x02,0x0c]

image_sample_d_o v[5:6], v[241:249], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_3D a16
// GFX11: [0x08,0x03,0x99,0xf0,0xf1,0x05,0x02,0x0c]

image_sample_d_o v[5:6], v[1:7], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_2D
// GFX11: [0x04,0x03,0x98,0xf0,0x01,0x05,0x02,0x0c]

image_sample_d_o v[254:255], v[249:255], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_2D
// GFX11: [0x04,0x03,0x98,0xf0,0xf9,0xfe,0x02,0x0c]

image_sample_d_o v[5:7], v[1:6], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_2D a16 tfe
// GFX11: [0x04,0x03,0x99,0xf0,0x01,0x05,0x22,0x0c]

image_sample_d_o v[253:255], v[250:255], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_2D a16 tfe
// GFX11: [0x04,0x03,0x99,0xf0,0xfa,0xfd,0x22,0x0c]

image_sample_d_o v5, v[1:8], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_CUBE d16
// GFX11: [0x0c,0x03,0x9a,0xf0,0x01,0x05,0x02,0x0c]

image_sample_d_o v255, v[248:255], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_CUBE d16
// GFX11: [0x0c,0x03,0x9a,0xf0,0xf8,0xff,0x02,0x0c]

image_sample_d_o v[5:6], v[1:7], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_CUBE a16 tfe d16
// GFX11: [0x0c,0x03,0x9b,0xf0,0x01,0x05,0x22,0x0c]

image_sample_d_o v[254:255], v[249:255], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_CUBE a16 tfe d16
// GFX11: [0x0c,0x03,0x9b,0xf0,0xf9,0xfe,0x22,0x0c]

image_sample_d_o v5, v[1:5], s[8:15], s[12:15] dmask:0x4 dim:SQ_RSRC_IMG_1D_ARRAY
// GFX11: [0x10,0x04,0x98,0xf0,0x01,0x05,0x02,0x0c]

image_sample_d_o v255, v[251:255], s[8:15], s[12:15] dmask:0x4 dim:SQ_RSRC_IMG_1D_ARRAY
// GFX11: [0x10,0x04,0x98,0xf0,0xfb,0xff,0x02,0x0c]

image_sample_d_o v[5:6], v[1:4], s[8:15], s[12:15] dmask:0x4 dim:SQ_RSRC_IMG_1D_ARRAY a16 tfe
// GFX11: [0x10,0x04,0x99,0xf0,0x01,0x05,0x22,0x0c]

image_sample_d_o v[254:255], v[252:255], s[8:15], s[12:15] dmask:0x4 dim:SQ_RSRC_IMG_1D_ARRAY a16 tfe
// GFX11: [0x10,0x04,0x99,0xf0,0xfc,0xfe,0x22,0x0c]

image_sample_d_o v5, v[1:8], s[8:15], s[12:15] dmask:0x4 dim:SQ_RSRC_IMG_2D_ARRAY d16
// GFX11: [0x14,0x04,0x9a,0xf0,0x01,0x05,0x02,0x0c]

image_sample_d_o v255, v[248:255], s[8:15], s[12:15] dmask:0x4 dim:SQ_RSRC_IMG_2D_ARRAY d16
// GFX11: [0x14,0x04,0x9a,0xf0,0xf8,0xff,0x02,0x0c]

image_sample_d_o v[5:6], v[1:7], s[96:103], s[100:103] dmask:0x4 dim:SQ_RSRC_IMG_2D_ARRAY a16 tfe d16
// GFX11: [0x14,0x04,0x9b,0xf0,0x01,0x05,0x38,0x64]

image_sample_d_o v[254:255], v[249:255], ttmp[8:15], ttmp[12:15] dmask:0x4 dim:SQ_RSRC_IMG_2D_ARRAY unorm glc slc dlc a16 tfe lwe d16
// GFX11: [0x94,0x74,0x9b,0xf0,0xf9,0xfe,0x7d,0x78]

image_sample_d_o_g16 v[5:6], v[1:4], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_1D
// GFX11: [0x00,0x03,0xec,0xf0,0x01,0x05,0x02,0x0c]

image_sample_d_o_g16 v[5:6], v[252:255], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_1D
// GFX11: [0x00,0x03,0xec,0xf0,0xfc,0x05,0x02,0x0c]

image_sample_d_o_g16 v[5:6], v[1:4], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_1D a16
// GFX11: [0x00,0x03,0xed,0xf0,0x01,0x05,0x02,0x0c]

image_sample_d_o_g16 v[5:6], v[252:255], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_1D a16
// GFX11: [0x00,0x03,0xed,0xf0,0xfc,0x05,0x02,0x0c]

image_sample_d_o_g16 v[5:6], v[1:8], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_3D
// GFX11: [0x08,0x03,0xec,0xf0,0x01,0x05,0x02,0x0c]

image_sample_d_o_g16 v[5:6], v[248:255], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_3D
// GFX11: [0x08,0x03,0xec,0xf0,0xf8,0x05,0x02,0x0c]

image_sample_d_o_g16 v[5:6], v[1:7], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_3D a16
// GFX11: [0x08,0x03,0xed,0xf0,0x01,0x05,0x02,0x0c]

image_sample_d_o_g16 v[5:6], v[249:255], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_3D a16
// GFX11: [0x08,0x03,0xed,0xf0,0xf9,0x05,0x02,0x0c]

image_sample_d_o_g16 v[5:6], v[1:5], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_2D
// GFX11: [0x04,0x03,0xec,0xf0,0x01,0x05,0x02,0x0c]

image_sample_d_o_g16 v[254:255], v[251:255], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_2D
// GFX11: [0x04,0x03,0xec,0xf0,0xfb,0xfe,0x02,0x0c]

image_sample_d_o_g16 v[5:7], v[1:4], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_2D a16 tfe
// GFX11: [0x04,0x03,0xed,0xf0,0x01,0x05,0x22,0x0c]

image_sample_d_o_g16 v[253:255], v[252:255], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_2D a16 tfe
// GFX11: [0x04,0x03,0xed,0xf0,0xfc,0xfd,0x22,0x0c]

image_sample_d_o_g16 v5, v[1:6], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_CUBE d16
// GFX11: [0x0c,0x03,0xee,0xf0,0x01,0x05,0x02,0x0c]

image_sample_d_o_g16 v255, v[250:255], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_CUBE d16
// GFX11: [0x0c,0x03,0xee,0xf0,0xfa,0xff,0x02,0x0c]

image_sample_d_o_g16 v[5:6], v[1:5], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_CUBE a16 tfe d16
// GFX11: [0x0c,0x03,0xef,0xf0,0x01,0x05,0x22,0x0c]

image_sample_d_o_g16 v[254:255], v[251:255], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_CUBE a16 tfe d16
// GFX11: [0x0c,0x03,0xef,0xf0,0xfb,0xfe,0x22,0x0c]

image_sample_d_o_g16 v5, v[1:5], s[8:15], s[12:15] dmask:0x4 dim:SQ_RSRC_IMG_1D_ARRAY
// GFX11: [0x10,0x04,0xec,0xf0,0x01,0x05,0x02,0x0c]

image_sample_d_o_g16 v255, v[251:255], s[8:15], s[12:15] dmask:0x4 dim:SQ_RSRC_IMG_1D_ARRAY
// GFX11: [0x10,0x04,0xec,0xf0,0xfb,0xff,0x02,0x0c]

image_sample_d_o_g16 v[5:6], v[1:4], s[8:15], s[12:15] dmask:0x4 dim:SQ_RSRC_IMG_1D_ARRAY a16 tfe
// GFX11: [0x10,0x04,0xed,0xf0,0x01,0x05,0x22,0x0c]

image_sample_d_o_g16 v[254:255], v[252:255], s[8:15], s[12:15] dmask:0x4 dim:SQ_RSRC_IMG_1D_ARRAY a16 tfe
// GFX11: [0x10,0x04,0xed,0xf0,0xfc,0xfe,0x22,0x0c]

image_sample_d_o_g16 v5, v[1:6], s[8:15], s[12:15] dmask:0x4 dim:SQ_RSRC_IMG_2D_ARRAY d16
// GFX11: [0x14,0x04,0xee,0xf0,0x01,0x05,0x02,0x0c]

image_sample_d_o_g16 v255, v[250:255], s[8:15], s[12:15] dmask:0x4 dim:SQ_RSRC_IMG_2D_ARRAY d16
// GFX11: [0x14,0x04,0xee,0xf0,0xfa,0xff,0x02,0x0c]

image_sample_d_o_g16 v[5:6], v[1:5], s[96:103], s[100:103] dmask:0x4 dim:SQ_RSRC_IMG_2D_ARRAY a16 tfe d16
// GFX11: [0x14,0x04,0xef,0xf0,0x01,0x05,0x38,0x64]

image_sample_d_o_g16 v[254:255], v[251:255], ttmp[8:15], ttmp[12:15] dmask:0x4 dim:SQ_RSRC_IMG_2D_ARRAY unorm glc slc dlc a16 tfe lwe d16
// GFX11: [0x94,0x74,0xef,0xf0,0xfb,0xfe,0x7d,0x78]

image_sample_l v[5:6], v[1:2], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_1D
// GFX11: [0x00,0x03,0x74,0xf0,0x01,0x05,0x02,0x0c]

image_sample_l v[5:6], v[254:255], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_1D
// GFX11: [0x00,0x03,0x74,0xf0,0xfe,0x05,0x02,0x0c]

image_sample_l v[5:6], v1, s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_1D a16
// GFX11: [0x00,0x03,0x75,0xf0,0x01,0x05,0x02,0x0c]

image_sample_l v[5:6], v255, s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_1D a16
// GFX11: [0x00,0x03,0x75,0xf0,0xff,0x05,0x02,0x0c]

image_sample_l v[5:6], v[1:4], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_3D
// GFX11: [0x08,0x03,0x74,0xf0,0x01,0x05,0x02,0x0c]

image_sample_l v[5:6], v[252:255], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_3D
// GFX11: [0x08,0x03,0x74,0xf0,0xfc,0x05,0x02,0x0c]

image_sample_l v[5:6], v[1:2], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_3D a16
// GFX11: [0x08,0x03,0x75,0xf0,0x01,0x05,0x02,0x0c]

image_sample_l v[5:6], v[254:255], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_3D a16
// GFX11: [0x08,0x03,0x75,0xf0,0xfe,0x05,0x02,0x0c]

image_sample_l v[5:6], v[1:3], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_2D
// GFX11: [0x04,0x03,0x74,0xf0,0x01,0x05,0x02,0x0c]

image_sample_l v[254:255], v[253:255], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_2D
// GFX11: [0x04,0x03,0x74,0xf0,0xfd,0xfe,0x02,0x0c]

image_sample_l v[5:7], v[1:2], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_2D a16 tfe
// GFX11: [0x04,0x03,0x75,0xf0,0x01,0x05,0x22,0x0c]

image_sample_l v[253:255], v[254:255], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_2D a16 tfe
// GFX11: [0x04,0x03,0x75,0xf0,0xfe,0xfd,0x22,0x0c]

image_sample_l v5, v[1:4], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_CUBE d16
// GFX11: [0x0c,0x03,0x76,0xf0,0x01,0x05,0x02,0x0c]

image_sample_l v255, v[252:255], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_CUBE d16
// GFX11: [0x0c,0x03,0x76,0xf0,0xfc,0xff,0x02,0x0c]

image_sample_l v[5:6], v[1:2], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_CUBE a16 tfe d16
// GFX11: [0x0c,0x03,0x77,0xf0,0x01,0x05,0x22,0x0c]

image_sample_l v[254:255], v[254:255], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_CUBE a16 tfe d16
// GFX11: [0x0c,0x03,0x77,0xf0,0xfe,0xfe,0x22,0x0c]

image_sample_l v5, v[1:3], s[8:15], s[12:15] dmask:0x4 dim:SQ_RSRC_IMG_1D_ARRAY
// GFX11: [0x10,0x04,0x74,0xf0,0x01,0x05,0x02,0x0c]

image_sample_l v255, v[253:255], s[8:15], s[12:15] dmask:0x4 dim:SQ_RSRC_IMG_1D_ARRAY
// GFX11: [0x10,0x04,0x74,0xf0,0xfd,0xff,0x02,0x0c]

image_sample_l v[5:6], v[1:2], s[8:15], s[12:15] dmask:0x4 dim:SQ_RSRC_IMG_1D_ARRAY a16 tfe
// GFX11: [0x10,0x04,0x75,0xf0,0x01,0x05,0x22,0x0c]

image_sample_l v[254:255], v[254:255], s[8:15], s[12:15] dmask:0x4 dim:SQ_RSRC_IMG_1D_ARRAY a16 tfe
// GFX11: [0x10,0x04,0x75,0xf0,0xfe,0xfe,0x22,0x0c]

image_sample_l v5, v[1:4], s[8:15], s[12:15] dmask:0x4 dim:SQ_RSRC_IMG_2D_ARRAY d16
// GFX11: [0x14,0x04,0x76,0xf0,0x01,0x05,0x02,0x0c]

image_sample_l v255, v[252:255], s[8:15], s[12:15] dmask:0x4 dim:SQ_RSRC_IMG_2D_ARRAY d16
// GFX11: [0x14,0x04,0x76,0xf0,0xfc,0xff,0x02,0x0c]

image_sample_l v[5:6], v[1:2], s[96:103], s[100:103] dmask:0x4 dim:SQ_RSRC_IMG_2D_ARRAY a16 tfe d16
// GFX11: [0x14,0x04,0x77,0xf0,0x01,0x05,0x38,0x64]

image_sample_l v[254:255], v[254:255], ttmp[8:15], ttmp[12:15] dmask:0x4 dim:SQ_RSRC_IMG_2D_ARRAY unorm glc slc dlc a16 tfe lwe d16
// GFX11: [0x94,0x74,0x77,0xf0,0xfe,0xfe,0x7d,0x78]

image_sample_l_o v[5:6], v[1:3], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_1D
// GFX11: [0x00,0x03,0x9c,0xf0,0x01,0x05,0x02,0x0c]

image_sample_l_o v[5:6], v[253:255], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_1D
// GFX11: [0x00,0x03,0x9c,0xf0,0xfd,0x05,0x02,0x0c]

image_sample_l_o v[5:6], v[1:2], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_1D a16
// GFX11: [0x00,0x03,0x9d,0xf0,0x01,0x05,0x02,0x0c]

image_sample_l_o v[5:6], v[254:255], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_1D a16
// GFX11: [0x00,0x03,0x9d,0xf0,0xfe,0x05,0x02,0x0c]

image_sample_l_o v[5:6], v[1:5], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_3D
// GFX11: [0x08,0x03,0x9c,0xf0,0x01,0x05,0x02,0x0c]

image_sample_l_o v[5:6], v[251:255], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_3D
// GFX11: [0x08,0x03,0x9c,0xf0,0xfb,0x05,0x02,0x0c]

image_sample_l_o v[5:6], v[1:3], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_3D a16
// GFX11: [0x08,0x03,0x9d,0xf0,0x01,0x05,0x02,0x0c]

image_sample_l_o v[5:6], v[253:255], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_3D a16
// GFX11: [0x08,0x03,0x9d,0xf0,0xfd,0x05,0x02,0x0c]

image_sample_l_o v[5:6], v[1:4], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_2D
// GFX11: [0x04,0x03,0x9c,0xf0,0x01,0x05,0x02,0x0c]

image_sample_l_o v[254:255], v[252:255], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_2D
// GFX11: [0x04,0x03,0x9c,0xf0,0xfc,0xfe,0x02,0x0c]

image_sample_l_o v[5:7], v[1:3], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_2D a16 tfe
// GFX11: [0x04,0x03,0x9d,0xf0,0x01,0x05,0x22,0x0c]

image_sample_l_o v[253:255], v[253:255], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_2D a16 tfe
// GFX11: [0x04,0x03,0x9d,0xf0,0xfd,0xfd,0x22,0x0c]

image_sample_l_o v5, v[1:5], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_CUBE d16
// GFX11: [0x0c,0x03,0x9e,0xf0,0x01,0x05,0x02,0x0c]

image_sample_l_o v255, v[251:255], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_CUBE d16
// GFX11: [0x0c,0x03,0x9e,0xf0,0xfb,0xff,0x02,0x0c]

image_sample_l_o v[5:6], v[1:3], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_CUBE a16 tfe d16
// GFX11: [0x0c,0x03,0x9f,0xf0,0x01,0x05,0x22,0x0c]

image_sample_l_o v[254:255], v[253:255], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_CUBE a16 tfe d16
// GFX11: [0x0c,0x03,0x9f,0xf0,0xfd,0xfe,0x22,0x0c]

image_sample_l_o v5, v[1:4], s[8:15], s[12:15] dmask:0x4 dim:SQ_RSRC_IMG_1D_ARRAY
// GFX11: [0x10,0x04,0x9c,0xf0,0x01,0x05,0x02,0x0c]

image_sample_l_o v255, v[252:255], s[8:15], s[12:15] dmask:0x4 dim:SQ_RSRC_IMG_1D_ARRAY
// GFX11: [0x10,0x04,0x9c,0xf0,0xfc,0xff,0x02,0x0c]

image_sample_l_o v[5:6], v[1:3], s[8:15], s[12:15] dmask:0x4 dim:SQ_RSRC_IMG_1D_ARRAY a16 tfe
// GFX11: [0x10,0x04,0x9d,0xf0,0x01,0x05,0x22,0x0c]

image_sample_l_o v[254:255], v[253:255], s[8:15], s[12:15] dmask:0x4 dim:SQ_RSRC_IMG_1D_ARRAY a16 tfe
// GFX11: [0x10,0x04,0x9d,0xf0,0xfd,0xfe,0x22,0x0c]

image_sample_l_o v5, v[1:5], s[8:15], s[12:15] dmask:0x4 dim:SQ_RSRC_IMG_2D_ARRAY d16
// GFX11: [0x14,0x04,0x9e,0xf0,0x01,0x05,0x02,0x0c]

image_sample_l_o v255, v[251:255], s[8:15], s[12:15] dmask:0x4 dim:SQ_RSRC_IMG_2D_ARRAY d16
// GFX11: [0x14,0x04,0x9e,0xf0,0xfb,0xff,0x02,0x0c]

image_sample_l_o v[5:6], v[1:3], s[96:103], s[100:103] dmask:0x4 dim:SQ_RSRC_IMG_2D_ARRAY a16 tfe d16
// GFX11: [0x14,0x04,0x9f,0xf0,0x01,0x05,0x38,0x64]

image_sample_l_o v[254:255], v[253:255], ttmp[8:15], ttmp[12:15] dmask:0x4 dim:SQ_RSRC_IMG_2D_ARRAY unorm glc slc dlc a16 tfe lwe d16
// GFX11: [0x94,0x74,0x9f,0xf0,0xfd,0xfe,0x7d,0x78]

image_sample_lz v[5:6], v1, s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_1D
// GFX11: [0x00,0x03,0x7c,0xf0,0x01,0x05,0x02,0x0c]

image_sample_lz v[5:6], v255, s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_1D
// GFX11: [0x00,0x03,0x7c,0xf0,0xff,0x05,0x02,0x0c]

image_sample_lz v[5:6], v1, s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_1D a16
// GFX11: [0x00,0x03,0x7d,0xf0,0x01,0x05,0x02,0x0c]

image_sample_lz v[5:6], v255, s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_1D a16
// GFX11: [0x00,0x03,0x7d,0xf0,0xff,0x05,0x02,0x0c]

image_sample_lz v[5:6], v[1:3], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_3D
// GFX11: [0x08,0x03,0x7c,0xf0,0x01,0x05,0x02,0x0c]

image_sample_lz v[5:6], v[253:255], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_3D
// GFX11: [0x08,0x03,0x7c,0xf0,0xfd,0x05,0x02,0x0c]

image_sample_lz v[5:6], v[1:2], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_3D a16
// GFX11: [0x08,0x03,0x7d,0xf0,0x01,0x05,0x02,0x0c]

image_sample_lz v[5:6], v[254:255], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_3D a16
// GFX11: [0x08,0x03,0x7d,0xf0,0xfe,0x05,0x02,0x0c]

image_sample_lz v[5:6], v[1:2], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_2D
// GFX11: [0x04,0x03,0x7c,0xf0,0x01,0x05,0x02,0x0c]

image_sample_lz v[254:255], v[254:255], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_2D
// GFX11: [0x04,0x03,0x7c,0xf0,0xfe,0xfe,0x02,0x0c]

image_sample_lz v[5:7], v1, s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_2D a16 tfe
// GFX11: [0x04,0x03,0x7d,0xf0,0x01,0x05,0x22,0x0c]

image_sample_lz v[253:255], v255, s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_2D a16 tfe
// GFX11: [0x04,0x03,0x7d,0xf0,0xff,0xfd,0x22,0x0c]

image_sample_lz v5, v[1:3], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_CUBE d16
// GFX11: [0x0c,0x03,0x7e,0xf0,0x01,0x05,0x02,0x0c]

image_sample_lz v255, v[253:255], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_CUBE d16
// GFX11: [0x0c,0x03,0x7e,0xf0,0xfd,0xff,0x02,0x0c]

image_sample_lz v[5:6], v[1:2], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_CUBE a16 tfe d16
// GFX11: [0x0c,0x03,0x7f,0xf0,0x01,0x05,0x22,0x0c]

image_sample_lz v[254:255], v[254:255], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_CUBE a16 tfe d16
// GFX11: [0x0c,0x03,0x7f,0xf0,0xfe,0xfe,0x22,0x0c]

image_sample_lz v5, v[1:2], s[8:15], s[12:15] dmask:0x4 dim:SQ_RSRC_IMG_1D_ARRAY
// GFX11: [0x10,0x04,0x7c,0xf0,0x01,0x05,0x02,0x0c]

image_sample_lz v255, v[254:255], s[8:15], s[12:15] dmask:0x4 dim:SQ_RSRC_IMG_1D_ARRAY
// GFX11: [0x10,0x04,0x7c,0xf0,0xfe,0xff,0x02,0x0c]

image_sample_lz v[5:6], v1, s[8:15], s[12:15] dmask:0x4 dim:SQ_RSRC_IMG_1D_ARRAY a16 tfe
// GFX11: [0x10,0x04,0x7d,0xf0,0x01,0x05,0x22,0x0c]

image_sample_lz v[254:255], v255, s[8:15], s[12:15] dmask:0x4 dim:SQ_RSRC_IMG_1D_ARRAY a16 tfe
// GFX11: [0x10,0x04,0x7d,0xf0,0xff,0xfe,0x22,0x0c]

image_sample_lz v5, v[1:3], s[8:15], s[12:15] dmask:0x4 dim:SQ_RSRC_IMG_2D_ARRAY d16
// GFX11: [0x14,0x04,0x7e,0xf0,0x01,0x05,0x02,0x0c]

image_sample_lz v255, v[253:255], s[8:15], s[12:15] dmask:0x4 dim:SQ_RSRC_IMG_2D_ARRAY d16
// GFX11: [0x14,0x04,0x7e,0xf0,0xfd,0xff,0x02,0x0c]

image_sample_lz v[5:6], v[1:2], s[96:103], s[100:103] dmask:0x4 dim:SQ_RSRC_IMG_2D_ARRAY a16 tfe d16
// GFX11: [0x14,0x04,0x7f,0xf0,0x01,0x05,0x38,0x64]

image_sample_lz v[254:255], v[254:255], ttmp[8:15], ttmp[12:15] dmask:0x4 dim:SQ_RSRC_IMG_2D_ARRAY unorm glc slc dlc a16 tfe lwe d16
// GFX11: [0x94,0x74,0x7f,0xf0,0xfe,0xfe,0x7d,0x78]

image_sample_lz_o v[5:6], v[1:2], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_1D
// GFX11: [0x00,0x03,0xa4,0xf0,0x01,0x05,0x02,0x0c]

image_sample_lz_o v[5:6], v[254:255], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_1D
// GFX11: [0x00,0x03,0xa4,0xf0,0xfe,0x05,0x02,0x0c]

image_sample_lz_o v[5:6], v[1:2], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_1D a16
// GFX11: [0x00,0x03,0xa5,0xf0,0x01,0x05,0x02,0x0c]

image_sample_lz_o v[5:6], v[254:255], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_1D a16
// GFX11: [0x00,0x03,0xa5,0xf0,0xfe,0x05,0x02,0x0c]

image_sample_lz_o v[5:6], v[1:4], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_3D
// GFX11: [0x08,0x03,0xa4,0xf0,0x01,0x05,0x02,0x0c]

image_sample_lz_o v[5:6], v[252:255], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_3D
// GFX11: [0x08,0x03,0xa4,0xf0,0xfc,0x05,0x02,0x0c]

image_sample_lz_o v[5:6], v[1:3], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_3D a16
// GFX11: [0x08,0x03,0xa5,0xf0,0x01,0x05,0x02,0x0c]

image_sample_lz_o v[5:6], v[253:255], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_3D a16
// GFX11: [0x08,0x03,0xa5,0xf0,0xfd,0x05,0x02,0x0c]

image_sample_lz_o v[5:6], v[1:3], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_2D
// GFX11: [0x04,0x03,0xa4,0xf0,0x01,0x05,0x02,0x0c]

image_sample_lz_o v[254:255], v[253:255], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_2D
// GFX11: [0x04,0x03,0xa4,0xf0,0xfd,0xfe,0x02,0x0c]

image_sample_lz_o v[5:7], v[1:2], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_2D a16 tfe
// GFX11: [0x04,0x03,0xa5,0xf0,0x01,0x05,0x22,0x0c]

image_sample_lz_o v[253:255], v[254:255], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_2D a16 tfe
// GFX11: [0x04,0x03,0xa5,0xf0,0xfe,0xfd,0x22,0x0c]

image_sample_lz_o v5, v[1:4], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_CUBE d16
// GFX11: [0x0c,0x03,0xa6,0xf0,0x01,0x05,0x02,0x0c]

image_sample_lz_o v255, v[252:255], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_CUBE d16
// GFX11: [0x0c,0x03,0xa6,0xf0,0xfc,0xff,0x02,0x0c]

image_sample_lz_o v[5:6], v[1:3], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_CUBE a16 tfe d16
// GFX11: [0x0c,0x03,0xa7,0xf0,0x01,0x05,0x22,0x0c]

image_sample_lz_o v[254:255], v[253:255], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_CUBE a16 tfe d16
// GFX11: [0x0c,0x03,0xa7,0xf0,0xfd,0xfe,0x22,0x0c]

image_sample_lz_o v5, v[1:3], s[8:15], s[12:15] dmask:0x4 dim:SQ_RSRC_IMG_1D_ARRAY
// GFX11: [0x10,0x04,0xa4,0xf0,0x01,0x05,0x02,0x0c]

image_sample_lz_o v255, v[253:255], s[8:15], s[12:15] dmask:0x4 dim:SQ_RSRC_IMG_1D_ARRAY
// GFX11: [0x10,0x04,0xa4,0xf0,0xfd,0xff,0x02,0x0c]

image_sample_lz_o v[5:6], v[1:2], s[8:15], s[12:15] dmask:0x4 dim:SQ_RSRC_IMG_1D_ARRAY a16 tfe
// GFX11: [0x10,0x04,0xa5,0xf0,0x01,0x05,0x22,0x0c]

image_sample_lz_o v[254:255], v[254:255], s[8:15], s[12:15] dmask:0x4 dim:SQ_RSRC_IMG_1D_ARRAY a16 tfe
// GFX11: [0x10,0x04,0xa5,0xf0,0xfe,0xfe,0x22,0x0c]

image_sample_lz_o v5, v[1:4], s[8:15], s[12:15] dmask:0x4 dim:SQ_RSRC_IMG_2D_ARRAY d16
// GFX11: [0x14,0x04,0xa6,0xf0,0x01,0x05,0x02,0x0c]

image_sample_lz_o v255, v[252:255], s[8:15], s[12:15] dmask:0x4 dim:SQ_RSRC_IMG_2D_ARRAY d16
// GFX11: [0x14,0x04,0xa6,0xf0,0xfc,0xff,0x02,0x0c]

image_sample_lz_o v[5:6], v[1:3], s[96:103], s[100:103] dmask:0x4 dim:SQ_RSRC_IMG_2D_ARRAY a16 tfe d16
// GFX11: [0x14,0x04,0xa7,0xf0,0x01,0x05,0x38,0x64]

image_sample_lz_o v[254:255], v[253:255], ttmp[8:15], ttmp[12:15] dmask:0x4 dim:SQ_RSRC_IMG_2D_ARRAY unorm glc slc dlc a16 tfe lwe d16
// GFX11: [0x94,0x74,0xa7,0xf0,0xfd,0xfe,0x7d,0x78]

image_sample_o v[5:6], v[1:2], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_1D
// GFX11: [0x00,0x03,0x94,0xf0,0x01,0x05,0x02,0x0c]

image_sample_o v[5:6], v[254:255], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_1D
// GFX11: [0x00,0x03,0x94,0xf0,0xfe,0x05,0x02,0x0c]

image_sample_o v[5:6], v[1:2], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_1D a16
// GFX11: [0x00,0x03,0x95,0xf0,0x01,0x05,0x02,0x0c]

image_sample_o v[5:6], v[254:255], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_1D a16
// GFX11: [0x00,0x03,0x95,0xf0,0xfe,0x05,0x02,0x0c]

image_sample_o v[5:6], v[1:4], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_3D
// GFX11: [0x08,0x03,0x94,0xf0,0x01,0x05,0x02,0x0c]

image_sample_o v[5:6], v[252:255], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_3D
// GFX11: [0x08,0x03,0x94,0xf0,0xfc,0x05,0x02,0x0c]

image_sample_o v[5:6], v[1:3], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_3D a16
// GFX11: [0x08,0x03,0x95,0xf0,0x01,0x05,0x02,0x0c]

image_sample_o v[5:6], v[253:255], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_3D a16
// GFX11: [0x08,0x03,0x95,0xf0,0xfd,0x05,0x02,0x0c]

image_sample_o v[5:6], v[1:3], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_2D
// GFX11: [0x04,0x03,0x94,0xf0,0x01,0x05,0x02,0x0c]

image_sample_o v[254:255], v[253:255], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_2D
// GFX11: [0x04,0x03,0x94,0xf0,0xfd,0xfe,0x02,0x0c]

image_sample_o v[5:7], v[1:2], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_2D a16 tfe
// GFX11: [0x04,0x03,0x95,0xf0,0x01,0x05,0x22,0x0c]

image_sample_o v[253:255], v[254:255], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_2D a16 tfe
// GFX11: [0x04,0x03,0x95,0xf0,0xfe,0xfd,0x22,0x0c]

image_sample_o v5, v[1:4], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_CUBE d16
// GFX11: [0x0c,0x03,0x96,0xf0,0x01,0x05,0x02,0x0c]

image_sample_o v255, v[252:255], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_CUBE d16
// GFX11: [0x0c,0x03,0x96,0xf0,0xfc,0xff,0x02,0x0c]

image_sample_o v[5:6], v[1:3], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_CUBE a16 tfe d16
// GFX11: [0x0c,0x03,0x97,0xf0,0x01,0x05,0x22,0x0c]

image_sample_o v[254:255], v[253:255], s[8:15], s[12:15] dmask:0x3 dim:SQ_RSRC_IMG_CUBE a16 tfe d16
// GFX11: [0x0c,0x03,0x97,0xf0,0xfd,0xfe,0x22,0x0c]

image_sample_o v5, v[1:3], s[8:15], s[12:15] dmask:0x4 dim:SQ_RSRC_IMG_1D_ARRAY
// GFX11: [0x10,0x04,0x94,0xf0,0x01,0x05,0x02,0x0c]

image_sample_o v255, v[253:255], s[8:15], s[12:15] dmask:0x4 dim:SQ_RSRC_IMG_1D_ARRAY
// GFX11: [0x10,0x04,0x94,0xf0,0xfd,0xff,0x02,0x0c]

image_sample_o v[5:6], v[1:2], s[8:15], s[12:15] dmask:0x4 dim:SQ_RSRC_IMG_1D_ARRAY a16 tfe
// GFX11: [0x10,0x04,0x95,0xf0,0x01,0x05,0x22,0x0c]

image_sample_o v[254:255], v[254:255], s[8:15], s[12:15] dmask:0x4 dim:SQ_RSRC_IMG_1D_ARRAY a16 tfe
// GFX11: [0x10,0x04,0x95,0xf0,0xfe,0xfe,0x22,0x0c]

image_sample_o v5, v[1:4], s[8:15], s[12:15] dmask:0x4 dim:SQ_RSRC_IMG_2D_ARRAY d16
// GFX11: [0x14,0x04,0x96,0xf0,0x01,0x05,0x02,0x0c]

image_sample_o v255, v[252:255], s[8:15], s[12:15] dmask:0x4 dim:SQ_RSRC_IMG_2D_ARRAY d16
// GFX11: [0x14,0x04,0x96,0xf0,0xfc,0xff,0x02,0x0c]

image_sample_o v[5:6], v[1:3], s[96:103], s[100:103] dmask:0x4 dim:SQ_RSRC_IMG_2D_ARRAY a16 tfe d16
// GFX11: [0x14,0x04,0x97,0xf0,0x01,0x05,0x38,0x64]

image_sample_o v[254:255], v[253:255], ttmp[8:15], ttmp[12:15] dmask:0x4 dim:SQ_RSRC_IMG_2D_ARRAY unorm glc slc dlc a16 tfe lwe d16
// GFX11: [0x94,0x74,0x97,0xf0,0xfd,0xfe,0x7d,0x78]

image_store v[1:2], v2, s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_1D unorm
// GFX11: [0x80,0x03,0x18,0xf0,0x02,0x01,0x03,0x00]

image_store v[1:2], v255, s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_1D unorm
// GFX11: [0x80,0x03,0x18,0xf0,0xff,0x01,0x03,0x00]

image_store v[1:2], v2, s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_1D unorm a16
// GFX11: [0x80,0x03,0x19,0xf0,0x02,0x01,0x03,0x00]

image_store v[1:2], v255, s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_1D unorm a16
// GFX11: [0x80,0x03,0x19,0xf0,0xff,0x01,0x03,0x00]

image_store v[1:2], v[2:4], s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_3D unorm
// GFX11: [0x88,0x03,0x18,0xf0,0x02,0x01,0x03,0x00]

image_store v[1:2], v[253:255], s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_3D unorm
// GFX11: [0x88,0x03,0x18,0xf0,0xfd,0x01,0x03,0x00]

image_store v[1:2], v[2:3], s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_3D unorm a16
// GFX11: [0x88,0x03,0x19,0xf0,0x02,0x01,0x03,0x00]

image_store v[1:2], v[254:255], s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_3D unorm a16
// GFX11: [0x88,0x03,0x19,0xf0,0xfe,0x01,0x03,0x00]

image_store v[1:2], v[2:5], s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_2D_MSAA_ARRAY unorm
// GFX11: [0x9c,0x03,0x18,0xf0,0x02,0x01,0x03,0x00]

image_store v[1:2], v[252:255], s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_2D_MSAA_ARRAY unorm
// GFX11: [0x9c,0x03,0x18,0xf0,0xfc,0x01,0x03,0x00]

image_store v[1:2], v[2:3], s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_2D_MSAA_ARRAY unorm a16
// GFX11: [0x9c,0x03,0x19,0xf0,0x02,0x01,0x03,0x00]

image_store v[1:2], v[254:255], s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_2D_MSAA_ARRAY unorm a16
// GFX11: [0x9c,0x03,0x19,0xf0,0xfe,0x01,0x03,0x00]

image_store v[1:2], v[2:3], s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_2D unorm
// GFX11: [0x84,0x03,0x18,0xf0,0x02,0x01,0x03,0x00]

image_store v[1:2], v[254:255], s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_2D unorm
// GFX11: [0x84,0x03,0x18,0xf0,0xfe,0x01,0x03,0x00]

image_store v[1:2], v2, s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_2D unorm a16
// GFX11: [0x84,0x03,0x19,0xf0,0x02,0x01,0x03,0x00]

image_store v[1:2], v255, s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_2D unorm a16
// GFX11: [0x84,0x03,0x19,0xf0,0xff,0x01,0x03,0x00]

image_store v[1:2], v[2:4], s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_CUBE unorm
// GFX11: [0x8c,0x03,0x18,0xf0,0x02,0x01,0x03,0x00]

image_store v[1:2], v[253:255], s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_CUBE unorm
// GFX11: [0x8c,0x03,0x18,0xf0,0xfd,0x01,0x03,0x00]

image_store v[1:2], v[2:3], s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_CUBE unorm a16
// GFX11: [0x8c,0x03,0x19,0xf0,0x02,0x01,0x03,0x00]

image_store v[1:2], v[254:255], s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_CUBE unorm a16
// GFX11: [0x8c,0x03,0x19,0xf0,0xfe,0x01,0x03,0x00]

image_store v[1:2], v[2:3], s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_1D_ARRAY unorm
// GFX11: [0x90,0x03,0x18,0xf0,0x02,0x01,0x03,0x00]

image_store v[1:2], v[254:255], s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_1D_ARRAY unorm
// GFX11: [0x90,0x03,0x18,0xf0,0xfe,0x01,0x03,0x00]

image_store v[1:2], v2, s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_1D_ARRAY unorm a16
// GFX11: [0x90,0x03,0x19,0xf0,0x02,0x01,0x03,0x00]

image_store v[1:2], v255, s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_1D_ARRAY unorm a16
// GFX11: [0x90,0x03,0x19,0xf0,0xff,0x01,0x03,0x00]

image_store v[1:2], v[2:4], s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_2D_ARRAY unorm
// GFX11: [0x94,0x03,0x18,0xf0,0x02,0x01,0x03,0x00]

image_store v[254:255], v[253:255], s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_2D_ARRAY unorm
// GFX11: [0x94,0x03,0x18,0xf0,0xfd,0xfe,0x03,0x00]

image_store v1, v[2:3], s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_2D_ARRAY unorm a16 d16
// GFX11: [0x94,0x03,0x1b,0xf0,0x02,0x01,0x03,0x00]

image_store v255, v[254:255], s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_2D_ARRAY unorm a16 d16
// GFX11: [0x94,0x03,0x1b,0xf0,0xfe,0xff,0x03,0x00]

image_store v1, v[2:4], s[12:19] dmask:0x4 dim:SQ_RSRC_IMG_2D_MSAA unorm
// GFX11: [0x98,0x04,0x18,0xf0,0x02,0x01,0x03,0x00]

image_store v255, v[253:255], s[12:19] dmask:0x4 dim:SQ_RSRC_IMG_2D_MSAA unorm
// GFX11: [0x98,0x04,0x18,0xf0,0xfd,0xff,0x03,0x00]

image_store v1, v[2:3], s[96:103] dmask:0x4 dim:SQ_RSRC_IMG_2D_MSAA unorm a16 d16
// GFX11: [0x98,0x04,0x1b,0xf0,0x02,0x01,0x18,0x00]

image_store v255, v[254:255], ttmp[8:15] dmask:0x4 dim:SQ_RSRC_IMG_2D_MSAA unorm glc slc dlc a16 lwe d16
// GFX11: [0x98,0x74,0x1b,0xf0,0xfe,0xff,0x5d,0x00]

image_store_mip v[1:2], v[2:3], s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_1D unorm
// GFX11: [0x80,0x03,0x1c,0xf0,0x02,0x01,0x03,0x00]

image_store_mip v[1:2], v[254:255], s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_1D unorm
// GFX11: [0x80,0x03,0x1c,0xf0,0xfe,0x01,0x03,0x00]

image_store_mip v[1:2], v2, s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_1D unorm a16
// GFX11: [0x80,0x03,0x1d,0xf0,0x02,0x01,0x03,0x00]

image_store_mip v[1:2], v255, s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_1D unorm a16
// GFX11: [0x80,0x03,0x1d,0xf0,0xff,0x01,0x03,0x00]

image_store_mip v[1:2], v[2:5], s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_3D unorm
// GFX11: [0x88,0x03,0x1c,0xf0,0x02,0x01,0x03,0x00]

image_store_mip v[1:2], v[252:255], s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_3D unorm
// GFX11: [0x88,0x03,0x1c,0xf0,0xfc,0x01,0x03,0x00]

image_store_mip v[1:2], v[2:3], s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_3D unorm a16
// GFX11: [0x88,0x03,0x1d,0xf0,0x02,0x01,0x03,0x00]

image_store_mip v[1:2], v[254:255], s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_3D unorm a16
// GFX11: [0x88,0x03,0x1d,0xf0,0xfe,0x01,0x03,0x00]

image_store_mip v[1:2], v[2:4], s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_2D unorm
// GFX11: [0x84,0x03,0x1c,0xf0,0x02,0x01,0x03,0x00]

image_store_mip v[1:2], v[253:255], s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_2D unorm
// GFX11: [0x84,0x03,0x1c,0xf0,0xfd,0x01,0x03,0x00]

image_store_mip v[1:2], v[2:3], s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_2D unorm a16
// GFX11: [0x84,0x03,0x1d,0xf0,0x02,0x01,0x03,0x00]

image_store_mip v[1:2], v[254:255], s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_2D unorm a16
// GFX11: [0x84,0x03,0x1d,0xf0,0xfe,0x01,0x03,0x00]

image_store_mip v[1:2], v[2:5], s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_CUBE unorm
// GFX11: [0x8c,0x03,0x1c,0xf0,0x02,0x01,0x03,0x00]

image_store_mip v[1:2], v[252:255], s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_CUBE unorm
// GFX11: [0x8c,0x03,0x1c,0xf0,0xfc,0x01,0x03,0x00]

image_store_mip v[1:2], v[2:3], s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_CUBE unorm a16
// GFX11: [0x8c,0x03,0x1d,0xf0,0x02,0x01,0x03,0x00]

image_store_mip v[1:2], v[254:255], s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_CUBE unorm a16
// GFX11: [0x8c,0x03,0x1d,0xf0,0xfe,0x01,0x03,0x00]

image_store_mip v[1:2], v[2:4], s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_1D_ARRAY unorm
// GFX11: [0x90,0x03,0x1c,0xf0,0x02,0x01,0x03,0x00]

image_store_mip v[254:255], v[253:255], s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_1D_ARRAY unorm
// GFX11: [0x90,0x03,0x1c,0xf0,0xfd,0xfe,0x03,0x00]

image_store_mip v1, v[2:3], s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_1D_ARRAY unorm a16 d16
// GFX11: [0x90,0x03,0x1f,0xf0,0x02,0x01,0x03,0x00]

image_store_mip v255, v[254:255], s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_1D_ARRAY unorm a16 d16
// GFX11: [0x90,0x03,0x1f,0xf0,0xfe,0xff,0x03,0x00]

image_store_mip v1, v[2:5], s[12:19] dmask:0x4 dim:SQ_RSRC_IMG_2D_ARRAY unorm
// GFX11: [0x94,0x04,0x1c,0xf0,0x02,0x01,0x03,0x00]

image_store_mip v255, v[252:255], s[12:19] dmask:0x4 dim:SQ_RSRC_IMG_2D_ARRAY unorm
// GFX11: [0x94,0x04,0x1c,0xf0,0xfc,0xff,0x03,0x00]

image_store_mip v1, v[2:3], s[96:103] dmask:0x4 dim:SQ_RSRC_IMG_2D_ARRAY unorm a16 d16
// GFX11: [0x94,0x04,0x1f,0xf0,0x02,0x01,0x18,0x00]

image_store_mip v255, v[254:255], ttmp[8:15] dmask:0x4 dim:SQ_RSRC_IMG_2D_ARRAY unorm glc slc dlc a16 lwe d16
// GFX11: [0x94,0x74,0x1f,0xf0,0xfe,0xff,0x5d,0x00]

image_store_mip_pck v[1:2], v[2:3], s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_1D unorm
// GFX11: [0x80,0x03,0x24,0xf0,0x02,0x01,0x03,0x00]

image_store_mip_pck v[1:2], v[254:255], s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_1D unorm
// GFX11: [0x80,0x03,0x24,0xf0,0xfe,0x01,0x03,0x00]

image_store_mip_pck v[1:2], v2, s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_1D unorm a16
// GFX11: [0x80,0x03,0x25,0xf0,0x02,0x01,0x03,0x00]

image_store_mip_pck v[1:2], v255, s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_1D unorm a16
// GFX11: [0x80,0x03,0x25,0xf0,0xff,0x01,0x03,0x00]

image_store_mip_pck v[1:2], v[2:5], s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_3D unorm
// GFX11: [0x88,0x03,0x24,0xf0,0x02,0x01,0x03,0x00]

image_store_mip_pck v[1:2], v[252:255], s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_3D unorm
// GFX11: [0x88,0x03,0x24,0xf0,0xfc,0x01,0x03,0x00]

image_store_mip_pck v[1:2], v[2:3], s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_3D unorm a16
// GFX11: [0x88,0x03,0x25,0xf0,0x02,0x01,0x03,0x00]

image_store_mip_pck v[1:2], v[254:255], s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_3D unorm a16
// GFX11: [0x88,0x03,0x25,0xf0,0xfe,0x01,0x03,0x00]

image_store_mip_pck v[1:2], v[2:4], s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_2D unorm
// GFX11: [0x84,0x03,0x24,0xf0,0x02,0x01,0x03,0x00]

image_store_mip_pck v[1:2], v[253:255], s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_2D unorm
// GFX11: [0x84,0x03,0x24,0xf0,0xfd,0x01,0x03,0x00]

image_store_mip_pck v[1:2], v[2:3], s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_2D unorm a16
// GFX11: [0x84,0x03,0x25,0xf0,0x02,0x01,0x03,0x00]

image_store_mip_pck v[1:2], v[254:255], s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_2D unorm a16
// GFX11: [0x84,0x03,0x25,0xf0,0xfe,0x01,0x03,0x00]

image_store_mip_pck v[1:2], v[2:5], s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_CUBE unorm
// GFX11: [0x8c,0x03,0x24,0xf0,0x02,0x01,0x03,0x00]

image_store_mip_pck v[1:2], v[252:255], s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_CUBE unorm
// GFX11: [0x8c,0x03,0x24,0xf0,0xfc,0x01,0x03,0x00]

image_store_mip_pck v[1:2], v[2:3], s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_CUBE unorm a16
// GFX11: [0x8c,0x03,0x25,0xf0,0x02,0x01,0x03,0x00]

image_store_mip_pck v[1:2], v[254:255], s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_CUBE unorm a16
// GFX11: [0x8c,0x03,0x25,0xf0,0xfe,0x01,0x03,0x00]

image_store_mip_pck v[1:2], v[2:4], s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_1D_ARRAY unorm
// GFX11: [0x90,0x03,0x24,0xf0,0x02,0x01,0x03,0x00]

image_store_mip_pck v[1:2], v[253:255], s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_1D_ARRAY unorm
// GFX11: [0x90,0x03,0x24,0xf0,0xfd,0x01,0x03,0x00]

image_store_mip_pck v[1:2], v[2:3], s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_1D_ARRAY unorm a16
// GFX11: [0x90,0x03,0x25,0xf0,0x02,0x01,0x03,0x00]

image_store_mip_pck v[1:2], v[254:255], s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_1D_ARRAY unorm a16
// GFX11: [0x90,0x03,0x25,0xf0,0xfe,0x01,0x03,0x00]

image_store_mip_pck v[1:2], v[2:5], s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_2D_ARRAY unorm
// GFX11: [0x94,0x03,0x24,0xf0,0x02,0x01,0x03,0x00]

image_store_mip_pck v[254:255], v[252:255], s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_2D_ARRAY unorm
// GFX11: [0x94,0x03,0x24,0xf0,0xfc,0xfe,0x03,0x00]

image_store_mip_pck v1, v[2:3], s[96:103] dmask:0x4 dim:SQ_RSRC_IMG_2D_ARRAY unorm a16
// GFX11: [0x94,0x04,0x25,0xf0,0x02,0x01,0x18,0x00]

image_store_mip_pck v255, v[254:255], ttmp[8:15] dmask:0x4 dim:SQ_RSRC_IMG_2D_ARRAY unorm glc slc dlc a16 lwe
// GFX11: [0x94,0x74,0x25,0xf0,0xfe,0xff,0x5d,0x00]

image_store_pck v[1:2], v2, s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_1D unorm
// GFX11: [0x80,0x03,0x20,0xf0,0x02,0x01,0x03,0x00]

image_store_pck v[1:2], v255, s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_1D unorm
// GFX11: [0x80,0x03,0x20,0xf0,0xff,0x01,0x03,0x00]

image_store_pck v[1:2], v2, s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_1D unorm a16
// GFX11: [0x80,0x03,0x21,0xf0,0x02,0x01,0x03,0x00]

image_store_pck v[1:2], v255, s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_1D unorm a16
// GFX11: [0x80,0x03,0x21,0xf0,0xff,0x01,0x03,0x00]

image_store_pck v[1:2], v[2:4], s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_3D unorm
// GFX11: [0x88,0x03,0x20,0xf0,0x02,0x01,0x03,0x00]

image_store_pck v[1:2], v[253:255], s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_3D unorm
// GFX11: [0x88,0x03,0x20,0xf0,0xfd,0x01,0x03,0x00]

image_store_pck v[1:2], v[2:3], s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_3D unorm a16
// GFX11: [0x88,0x03,0x21,0xf0,0x02,0x01,0x03,0x00]

image_store_pck v[1:2], v[254:255], s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_3D unorm a16
// GFX11: [0x88,0x03,0x21,0xf0,0xfe,0x01,0x03,0x00]

image_store_pck v[1:2], v[2:5], s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_2D_MSAA_ARRAY unorm
// GFX11: [0x9c,0x03,0x20,0xf0,0x02,0x01,0x03,0x00]

image_store_pck v[1:2], v[252:255], s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_2D_MSAA_ARRAY unorm
// GFX11: [0x9c,0x03,0x20,0xf0,0xfc,0x01,0x03,0x00]

image_store_pck v[1:2], v[2:3], s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_2D_MSAA_ARRAY unorm a16
// GFX11: [0x9c,0x03,0x21,0xf0,0x02,0x01,0x03,0x00]

image_store_pck v[1:2], v[254:255], s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_2D_MSAA_ARRAY unorm a16
// GFX11: [0x9c,0x03,0x21,0xf0,0xfe,0x01,0x03,0x00]

image_store_pck v[1:2], v[2:3], s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_2D unorm
// GFX11: [0x84,0x03,0x20,0xf0,0x02,0x01,0x03,0x00]

image_store_pck v[1:2], v[254:255], s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_2D unorm
// GFX11: [0x84,0x03,0x20,0xf0,0xfe,0x01,0x03,0x00]

image_store_pck v[1:2], v2, s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_2D unorm a16
// GFX11: [0x84,0x03,0x21,0xf0,0x02,0x01,0x03,0x00]

image_store_pck v[1:2], v255, s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_2D unorm a16
// GFX11: [0x84,0x03,0x21,0xf0,0xff,0x01,0x03,0x00]

image_store_pck v[1:2], v[2:4], s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_CUBE unorm
// GFX11: [0x8c,0x03,0x20,0xf0,0x02,0x01,0x03,0x00]

image_store_pck v[1:2], v[253:255], s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_CUBE unorm
// GFX11: [0x8c,0x03,0x20,0xf0,0xfd,0x01,0x03,0x00]

image_store_pck v[1:2], v[2:3], s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_CUBE unorm a16
// GFX11: [0x8c,0x03,0x21,0xf0,0x02,0x01,0x03,0x00]

image_store_pck v[1:2], v[254:255], s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_CUBE unorm a16
// GFX11: [0x8c,0x03,0x21,0xf0,0xfe,0x01,0x03,0x00]

image_store_pck v[1:2], v[2:3], s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_1D_ARRAY unorm
// GFX11: [0x90,0x03,0x20,0xf0,0x02,0x01,0x03,0x00]

image_store_pck v[1:2], v[254:255], s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_1D_ARRAY unorm
// GFX11: [0x90,0x03,0x20,0xf0,0xfe,0x01,0x03,0x00]

image_store_pck v[1:2], v2, s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_1D_ARRAY unorm a16
// GFX11: [0x90,0x03,0x21,0xf0,0x02,0x01,0x03,0x00]

image_store_pck v[1:2], v255, s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_1D_ARRAY unorm a16
// GFX11: [0x90,0x03,0x21,0xf0,0xff,0x01,0x03,0x00]

image_store_pck v[1:2], v[2:4], s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_2D_ARRAY unorm
// GFX11: [0x94,0x03,0x20,0xf0,0x02,0x01,0x03,0x00]

image_store_pck v[1:2], v[253:255], s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_2D_ARRAY unorm
// GFX11: [0x94,0x03,0x20,0xf0,0xfd,0x01,0x03,0x00]

image_store_pck v[1:2], v[2:3], s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_2D_ARRAY unorm a16
// GFX11: [0x94,0x03,0x21,0xf0,0x02,0x01,0x03,0x00]

image_store_pck v[1:2], v[254:255], s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_2D_ARRAY unorm a16
// GFX11: [0x94,0x03,0x21,0xf0,0xfe,0x01,0x03,0x00]

image_store_pck v[1:2], v[2:4], s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_2D_MSAA unorm
// GFX11: [0x98,0x03,0x20,0xf0,0x02,0x01,0x03,0x00]

image_store_pck v[254:255], v[253:255], s[12:19] dmask:0x3 dim:SQ_RSRC_IMG_2D_MSAA unorm
// GFX11: [0x98,0x03,0x20,0xf0,0xfd,0xfe,0x03,0x00]

image_store_pck v1, v[2:3], s[96:103] dmask:0x4 dim:SQ_RSRC_IMG_2D_MSAA unorm a16
// GFX11: [0x98,0x04,0x21,0xf0,0x02,0x01,0x18,0x00]

image_store_pck v255, v[254:255], ttmp[8:15] dmask:0x4 dim:SQ_RSRC_IMG_2D_MSAA unorm glc slc dlc a16 lwe
// GFX11: [0x98,0x74,0x21,0xf0,0xfe,0xff,0x5d,0x00]
