; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mtriple=riscv64 -verify-machineinstrs < %s \
; RUN:   | FileCheck %s -check-prefixes=RV64I
; RUN: llc -mtriple=riscv64 -mattr=+xtheadbs -verify-machineinstrs < %s \
; RUN:   | FileCheck %s -check-prefixes=RV64XTHEADBS

define signext i32 @th_tst_i32(i32 signext %a) nounwind {
; RV64I-LABEL: th_tst_i32:
; RV64I:       # %bb.0:
; RV64I-NEXT:    slli a0, a0, 58
; RV64I-NEXT:    srli a0, a0, 63
; RV64I-NEXT:    ret
;
; RV64XTHEADBS-LABEL: th_tst_i32:
; RV64XTHEADBS:       # %bb.0:
; RV64XTHEADBS-NEXT:    th.tst a0, a0, 5
; RV64XTHEADBS-NEXT:    ret
  %shr = lshr i32 %a, 5
  %and = and i32 %shr, 1
  ret i32 %and
}

define i64 @the_tst_i64(i64 %a) nounwind {
; RV64I-LABEL: the_tst_i64:
; RV64I:       # %bb.0:
; RV64I-NEXT:    slli a0, a0, 58
; RV64I-NEXT:    srli a0, a0, 63
; RV64I-NEXT:    ret
;
; RV64XTHEADBS-LABEL: the_tst_i64:
; RV64XTHEADBS:       # %bb.0:
; RV64XTHEADBS-NEXT:    th.tst a0, a0, 5
; RV64XTHEADBS-NEXT:    ret
  %shr = lshr i64 %a, 5
  %and = and i64 %shr, 1
  ret i64 %and
}

define signext i32 @th_tst_i32_cmp(i32 signext %a) nounwind {
; RV64I-LABEL: th_tst_i32_cmp:
; RV64I:       # %bb.0:
; RV64I-NEXT:    slli a0, a0, 58
; RV64I-NEXT:    srli a0, a0, 63
; RV64I-NEXT:    ret
;
; RV64XTHEADBS-LABEL: th_tst_i32_cmp:
; RV64XTHEADBS:       # %bb.0:
; RV64XTHEADBS-NEXT:    th.tst a0, a0, 5
; RV64XTHEADBS-NEXT:    ret
  %and = and i32 %a, 32
  %cmp = icmp ne i32 %and, 0
  %zext = zext i1 %cmp to i32
  ret i32 %zext
}

define i64 @th_tst_i64_cmp(i64 %a) nounwind {
; RV64I-LABEL: th_tst_i64_cmp:
; RV64I:       # %bb.0:
; RV64I-NEXT:    slli a0, a0, 58
; RV64I-NEXT:    srli a0, a0, 63
; RV64I-NEXT:    ret
;
; RV64XTHEADBS-LABEL: th_tst_i64_cmp:
; RV64XTHEADBS:       # %bb.0:
; RV64XTHEADBS-NEXT:    th.tst a0, a0, 5
; RV64XTHEADBS-NEXT:    ret
  %and = and i64 %a, 32
  %cmp = icmp ne i64 %and, 0
  %zext = zext i1 %cmp to i64
  ret i64 %zext
}

