; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -global-isel=0 -march=amdgcn -mcpu=gfx1010 -verify-machineinstrs | FileCheck %s -check-prefixes=GFX10,GFX10-SDAG
; RUN: llc < %s -global-isel=0 -march=amdgcn -mcpu=gfx1100 -verify-machineinstrs | FileCheck %s -check-prefixes=GFX11,GFX11-SDAG
; RUN: llc < %s -global-isel=1 -march=amdgcn -mcpu=gfx1010 -verify-machineinstrs | FileCheck %s -check-prefixes=GFX10,GFX10-GISEL
; RUN: llc < %s -global-isel=1 -march=amdgcn -mcpu=gfx1100 -verify-machineinstrs | FileCheck %s -check-prefixes=GFX11,GFX11-GISEL

declare float @llvm.amdgcn.global.atomic.fmin.f32.p1.f32(ptr addrspace(1) %ptr, float %data)
declare float @llvm.amdgcn.global.atomic.fmax.f32.p1.f32(ptr addrspace(1) %ptr, float %data)

define amdgpu_cs void @global_atomic_fmin_f32_noret(ptr addrspace(1) %ptr, float %data) {
; GFX10-LABEL: global_atomic_fmin_f32_noret:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    global_atomic_fmin v[0:1], v2, off
; GFX10-NEXT:    s_endpgm
;
; GFX11-LABEL: global_atomic_fmin_f32_noret:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    global_atomic_min_f32 v[0:1], v2, off
; GFX11-NEXT:    s_nop 0
; GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-NEXT:    s_endpgm
  %ret = call float @llvm.amdgcn.global.atomic.fmin.f32.p1.f32(ptr addrspace(1) %ptr, float %data)
  ret void
}

define amdgpu_cs void @global_atomic_fmax_f32_noret(ptr addrspace(1) %ptr, float %data) {
; GFX10-LABEL: global_atomic_fmax_f32_noret:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    global_atomic_fmax v[0:1], v2, off
; GFX10-NEXT:    s_endpgm
;
; GFX11-LABEL: global_atomic_fmax_f32_noret:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    global_atomic_max_f32 v[0:1], v2, off
; GFX11-NEXT:    s_nop 0
; GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-NEXT:    s_endpgm
  %ret = call float @llvm.amdgcn.global.atomic.fmax.f32.p1.f32(ptr addrspace(1) %ptr, float %data)
  ret void
}

define amdgpu_cs void @global_atomic_fmax_f32_rtn(ptr addrspace(1) %ptr, float %data, ptr addrspace(1) %out) {
; GFX10-LABEL: global_atomic_fmax_f32_rtn:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    global_atomic_fmax v0, v[0:1], v2, off glc
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    global_store_dword v[3:4], v0, off
; GFX10-NEXT:    s_endpgm
;
; GFX11-LABEL: global_atomic_fmax_f32_rtn:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    global_atomic_max_f32 v0, v[0:1], v2, off glc
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    global_store_b32 v[3:4], v0, off
; GFX11-NEXT:    s_nop 0
; GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-NEXT:    s_endpgm
  %ret = call float @llvm.amdgcn.global.atomic.fmax.f32.p1.f32(ptr addrspace(1) %ptr, float %data)
  store float %ret, ptr addrspace(1) %out
  ret void
}

define amdgpu_cs void @global_atomic_fmin_f32_rtn(ptr addrspace(1) %ptr, float %data, ptr addrspace(1) %out) {
; GFX10-LABEL: global_atomic_fmin_f32_rtn:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    global_atomic_fmin v0, v[0:1], v2, off glc
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    global_store_dword v[3:4], v0, off
; GFX10-NEXT:    s_endpgm
;
; GFX11-LABEL: global_atomic_fmin_f32_rtn:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    global_atomic_min_f32 v0, v[0:1], v2, off glc
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    global_store_b32 v[3:4], v0, off
; GFX11-NEXT:    s_nop 0
; GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-NEXT:    s_endpgm
  %ret = call float @llvm.amdgcn.global.atomic.fmin.f32.p1.f32(ptr addrspace(1) %ptr, float %data)
  store float %ret, ptr addrspace(1) %out
  ret void
}
;; NOTE: These prefixes are unused and the list is autogenerated. Do not add tests below this line:
; GFX10-GISEL: {{.*}}
; GFX10-SDAG: {{.*}}
; GFX11-GISEL: {{.*}}
; GFX11-SDAG: {{.*}}
