; NOTE: Assertions have been autogenerated by utils/update_analyze_test_checks.py
; RUN: opt -disable-output "-passes=print<scalar-evolution>" < %s 2>&1 | FileCheck %s

define void @umin_sext_x_zext_x(i32 %len) {
; CHECK-LABEL: 'umin_sext_x_zext_x'
; CHECK-NEXT:  Classifying expressions for: @umin_sext_x_zext_x
; CHECK-NEXT:    %len.zext = zext i32 %len to i64
; CHECK-NEXT:    --> (zext i32 %len to i64) U: [0,4294967296) S: [0,4294967296)
; CHECK-NEXT:    %len.sext = sext i32 %len to i64
; CHECK-NEXT:    --> (sext i32 %len to i64) U: [-2147483648,2147483648) S: [-2147483648,2147483648)
; CHECK-NEXT:    %iv = phi i64 [ 0, %entry ], [ %iv.next, %loop ]
; CHECK-NEXT:    --> {0,+,1}<nuw><nsw><%loop> U: [0,4294967296) S: [0,4294967296) Exits: (zext i32 %len to i64) LoopDispositions: { %loop: Computable }
; CHECK-NEXT:    %iv.next = add i64 %iv, 1
; CHECK-NEXT:    --> {1,+,1}<nuw><nsw><%loop> U: [1,4294967297) S: [1,4294967297) Exits: (1 + (zext i32 %len to i64))<nuw><nsw> LoopDispositions: { %loop: Computable }
; CHECK-NEXT:    %and = and i1 %cmp1, %cmp2
; CHECK-NEXT:    --> (%cmp1 umin %cmp2) U: full-set S: full-set Exits: <<Unknown>> LoopDispositions: { %loop: Variant }
; CHECK-NEXT:  Determining loop execution counts for: @umin_sext_x_zext_x
; CHECK-NEXT:  Loop %loop: backedge-taken count is (zext i32 %len to i64)
; CHECK-NEXT:  Loop %loop: constant max backedge-taken count is 4294967295
; CHECK-NEXT:  Loop %loop: symbolic max backedge-taken count is (zext i32 %len to i64)
; CHECK-NEXT:  Loop %loop: Predicated backedge-taken count is (zext i32 %len to i64)
; CHECK-NEXT:   Predicates:
; CHECK:       Loop %loop: Trip multiple is 1
;
entry:
  %len.zext = zext i32 %len to i64
  %len.sext = sext i32 %len to i64
  br label %loop
loop:
  %iv = phi i64 [0, %entry], [%iv.next, %loop]
  %iv.next = add i64 %iv, 1
  %cmp1 = icmp ult i64 %iv, %len.zext
  %cmp2 = icmp ult i64 %iv, %len.sext
  %and = and i1 %cmp1, %cmp2
  br i1 %and, label %loop, label %exit
exit:
  ret void
}

define void @ule_sext_x_zext_x(i32 %len) {
; CHECK-LABEL: 'ule_sext_x_zext_x'
; CHECK-NEXT:  Classifying expressions for: @ule_sext_x_zext_x
; CHECK-NEXT:    %len.zext = zext i32 %len to i64
; CHECK-NEXT:    --> (zext i32 %len to i64) U: [0,4294967296) S: [0,4294967296)
; CHECK-NEXT:    %len.sext = sext i32 %len to i64
; CHECK-NEXT:    --> (sext i32 %len to i64) U: [-2147483648,2147483648) S: [-2147483648,2147483648)
; CHECK-NEXT:    %iv = phi i64 [ 0, %entry ], [ %iv.next, %loop ]
; CHECK-NEXT:    --> {0,+,1}<nuw><nsw><%loop> U: [0,4294967296) S: [0,4294967296) Exits: (zext i32 %len to i64) LoopDispositions: { %loop: Computable }
; CHECK-NEXT:    %iv.next = add i64 %iv, 1
; CHECK-NEXT:    --> {1,+,1}<nuw><nsw><%loop> U: [1,4294967297) S: [1,4294967297) Exits: (1 + (zext i32 %len to i64))<nuw><nsw> LoopDispositions: { %loop: Computable }
; CHECK-NEXT:    %sel = select i1 %cmp1, i64 %len.zext, i64 %len.sext
; CHECK-NEXT:    --> (zext i32 %len to i64) U: [0,4294967296) S: [0,4294967296) Exits: (zext i32 %len to i64) LoopDispositions: { %loop: Invariant }
; CHECK-NEXT:  Determining loop execution counts for: @ule_sext_x_zext_x
; CHECK-NEXT:  Loop %loop: backedge-taken count is (zext i32 %len to i64)
; CHECK-NEXT:  Loop %loop: constant max backedge-taken count is 4294967295
; CHECK-NEXT:  Loop %loop: symbolic max backedge-taken count is (zext i32 %len to i64)
; CHECK-NEXT:  Loop %loop: Predicated backedge-taken count is (zext i32 %len to i64)
; CHECK-NEXT:   Predicates:
; CHECK:       Loop %loop: Trip multiple is 1
;
entry:
  %len.zext = zext i32 %len to i64
  %len.sext = sext i32 %len to i64
  br label %loop
loop:
  %iv = phi i64 [0, %entry], [%iv.next, %loop]
  %iv.next = add i64 %iv, 1
  %cmp1 = icmp ule i64 %len.zext, %len.sext
  %sel = select i1 %cmp1, i64 %len.zext, i64 %len.sext
  %cmp2 = icmp ult i64 %iv, %sel
  br i1 %cmp2, label %loop, label %exit
exit:
  ret void
}

define void @uge_sext_x_zext_x(i32 %len) {
; CHECK-LABEL: 'uge_sext_x_zext_x'
; CHECK-NEXT:  Classifying expressions for: @uge_sext_x_zext_x
; CHECK-NEXT:    %len.zext = zext i32 %len to i64
; CHECK-NEXT:    --> (zext i32 %len to i64) U: [0,4294967296) S: [0,4294967296)
; CHECK-NEXT:    %len.sext = sext i32 %len to i64
; CHECK-NEXT:    --> (sext i32 %len to i64) U: [-2147483648,2147483648) S: [-2147483648,2147483648)
; CHECK-NEXT:    %iv = phi i64 [ 0, %entry ], [ %iv.next, %loop ]
; CHECK-NEXT:    --> {0,+,1}<%loop> U: full-set S: full-set Exits: (sext i32 %len to i64) LoopDispositions: { %loop: Computable }
; CHECK-NEXT:    %iv.next = add i64 %iv, 1
; CHECK-NEXT:    --> {1,+,1}<%loop> U: full-set S: full-set Exits: (1 + (sext i32 %len to i64))<nsw> LoopDispositions: { %loop: Computable }
; CHECK-NEXT:    %sel = select i1 %cmp1, i64 %len.zext, i64 %len.sext
; CHECK-NEXT:    --> (sext i32 %len to i64) U: [-2147483648,2147483648) S: [-2147483648,2147483648) Exits: (sext i32 %len to i64) LoopDispositions: { %loop: Invariant }
; CHECK-NEXT:  Determining loop execution counts for: @uge_sext_x_zext_x
; CHECK-NEXT:  Loop %loop: backedge-taken count is (sext i32 %len to i64)
; CHECK-NEXT:  Loop %loop: constant max backedge-taken count is -1
; CHECK-NEXT:  Loop %loop: symbolic max backedge-taken count is (sext i32 %len to i64)
; CHECK-NEXT:  Loop %loop: Predicated backedge-taken count is (sext i32 %len to i64)
; CHECK-NEXT:   Predicates:
; CHECK:       Loop %loop: Trip multiple is 1
;
entry:
  %len.zext = zext i32 %len to i64
  %len.sext = sext i32 %len to i64
  br label %loop
loop:
  %iv = phi i64 [0, %entry], [%iv.next, %loop]
  %iv.next = add i64 %iv, 1
  %cmp1 = icmp uge i64 %len.zext, %len.sext
  %sel = select i1 %cmp1, i64 %len.zext, i64 %len.sext
  %cmp2 = icmp ult i64 %iv, %sel
  br i1 %cmp2, label %loop, label %exit
exit:
  ret void
}

define void @ult_sext_x_zext_x(i32 %len) {
; CHECK-LABEL: 'ult_sext_x_zext_x'
; CHECK-NEXT:  Classifying expressions for: @ult_sext_x_zext_x
; CHECK-NEXT:    %len.zext = zext i32 %len to i64
; CHECK-NEXT:    --> (zext i32 %len to i64) U: [0,4294967296) S: [0,4294967296)
; CHECK-NEXT:    %len.sext = sext i32 %len to i64
; CHECK-NEXT:    --> (sext i32 %len to i64) U: [-2147483648,2147483648) S: [-2147483648,2147483648)
; CHECK-NEXT:    %iv = phi i64 [ 0, %entry ], [ %iv.next, %loop ]
; CHECK-NEXT:    --> {0,+,1}<nuw><nsw><%loop> U: [0,4294967296) S: [0,4294967296) Exits: (zext i32 %len to i64) LoopDispositions: { %loop: Computable }
; CHECK-NEXT:    %iv.next = add i64 %iv, 1
; CHECK-NEXT:    --> {1,+,1}<nuw><nsw><%loop> U: [1,4294967297) S: [1,4294967297) Exits: (1 + (zext i32 %len to i64))<nuw><nsw> LoopDispositions: { %loop: Computable }
; CHECK-NEXT:    %umin = select i1 %cmp1, i64 %len.zext, i64 %len.sext
; CHECK-NEXT:    --> (zext i32 %len to i64) U: [0,4294967296) S: [0,4294967296) Exits: (zext i32 %len to i64) LoopDispositions: { %loop: Invariant }
; CHECK-NEXT:  Determining loop execution counts for: @ult_sext_x_zext_x
; CHECK-NEXT:  Loop %loop: backedge-taken count is (zext i32 %len to i64)
; CHECK-NEXT:  Loop %loop: constant max backedge-taken count is 4294967295
; CHECK-NEXT:  Loop %loop: symbolic max backedge-taken count is (zext i32 %len to i64)
; CHECK-NEXT:  Loop %loop: Predicated backedge-taken count is (zext i32 %len to i64)
; CHECK-NEXT:   Predicates:
; CHECK:       Loop %loop: Trip multiple is 1
;
entry:
  %len.zext = zext i32 %len to i64
  %len.sext = sext i32 %len to i64
  br label %loop
loop:
  %iv = phi i64 [0, %entry], [%iv.next, %loop]
  %iv.next = add i64 %iv, 1
  %cmp1 = icmp ult i64 %len.zext, %len.sext
  %umin = select i1 %cmp1, i64 %len.zext, i64 %len.sext
  %cmp2 = icmp ult i64 %iv, %umin
  br i1 %cmp2, label %loop, label %exit
exit:
  ret void
}

define void @ugt_sext_x_zext_x(i32 %len) {
; CHECK-LABEL: 'ugt_sext_x_zext_x'
; CHECK-NEXT:  Classifying expressions for: @ugt_sext_x_zext_x
; CHECK-NEXT:    %len.zext = zext i32 %len to i64
; CHECK-NEXT:    --> (zext i32 %len to i64) U: [0,4294967296) S: [0,4294967296)
; CHECK-NEXT:    %len.sext = sext i32 %len to i64
; CHECK-NEXT:    --> (sext i32 %len to i64) U: [-2147483648,2147483648) S: [-2147483648,2147483648)
; CHECK-NEXT:    %iv = phi i64 [ 0, %entry ], [ %iv.next, %loop ]
; CHECK-NEXT:    --> {0,+,1}<%loop> U: full-set S: full-set Exits: (sext i32 %len to i64) LoopDispositions: { %loop: Computable }
; CHECK-NEXT:    %iv.next = add i64 %iv, 1
; CHECK-NEXT:    --> {1,+,1}<%loop> U: full-set S: full-set Exits: (1 + (sext i32 %len to i64))<nsw> LoopDispositions: { %loop: Computable }
; CHECK-NEXT:    %umax = select i1 %cmp1, i64 %len.zext, i64 %len.sext
; CHECK-NEXT:    --> (sext i32 %len to i64) U: [-2147483648,2147483648) S: [-2147483648,2147483648) Exits: (sext i32 %len to i64) LoopDispositions: { %loop: Invariant }
; CHECK-NEXT:  Determining loop execution counts for: @ugt_sext_x_zext_x
; CHECK-NEXT:  Loop %loop: backedge-taken count is (sext i32 %len to i64)
; CHECK-NEXT:  Loop %loop: constant max backedge-taken count is -1
; CHECK-NEXT:  Loop %loop: symbolic max backedge-taken count is (sext i32 %len to i64)
; CHECK-NEXT:  Loop %loop: Predicated backedge-taken count is (sext i32 %len to i64)
; CHECK-NEXT:   Predicates:
; CHECK:       Loop %loop: Trip multiple is 1
;
entry:
  %len.zext = zext i32 %len to i64
  %len.sext = sext i32 %len to i64
  br label %loop
loop:
  %iv = phi i64 [0, %entry], [%iv.next, %loop]
  %iv.next = add i64 %iv, 1
  %cmp1 = icmp ugt i64 %len.zext, %len.sext
  %umax = select i1 %cmp1, i64 %len.zext, i64 %len.sext
  %cmp2 = icmp ult i64 %iv, %umax
  br i1 %cmp2, label %loop, label %exit
exit:
  ret void
}

define void @sle_sext_x_zext_x(i32 %len) {
; CHECK-LABEL: 'sle_sext_x_zext_x'
; CHECK-NEXT:  Classifying expressions for: @sle_sext_x_zext_x
; CHECK-NEXT:    %len.zext = zext i32 %len to i64
; CHECK-NEXT:    --> (zext i32 %len to i64) U: [0,4294967296) S: [0,4294967296)
; CHECK-NEXT:    %len.sext = sext i32 %len to i64
; CHECK-NEXT:    --> (sext i32 %len to i64) U: [-2147483648,2147483648) S: [-2147483648,2147483648)
; CHECK-NEXT:    %iv = phi i64 [ 0, %entry ], [ %iv.next, %loop ]
; CHECK-NEXT:    --> {0,+,1}<nuw><nsw><%loop> U: [0,4294967296) S: [0,4294967296) Exits: (zext i32 %len to i64) LoopDispositions: { %loop: Computable }
; CHECK-NEXT:    %iv.next = add i64 %iv, 1
; CHECK-NEXT:    --> {1,+,1}<nuw><nsw><%loop> U: [1,4294967297) S: [1,4294967297) Exits: (1 + (zext i32 %len to i64))<nuw><nsw> LoopDispositions: { %loop: Computable }
; CHECK-NEXT:    %sel = select i1 %cmp1, i64 %len.zext, i64 %len.sext
; CHECK-NEXT:    --> (zext i32 %len to i64) U: [0,4294967296) S: [0,4294967296) Exits: (zext i32 %len to i64) LoopDispositions: { %loop: Invariant }
; CHECK-NEXT:  Determining loop execution counts for: @sle_sext_x_zext_x
; CHECK-NEXT:  Loop %loop: backedge-taken count is (zext i32 %len to i64)
; CHECK-NEXT:  Loop %loop: constant max backedge-taken count is 4294967295
; CHECK-NEXT:  Loop %loop: symbolic max backedge-taken count is (zext i32 %len to i64)
; CHECK-NEXT:  Loop %loop: Predicated backedge-taken count is (zext i32 %len to i64)
; CHECK-NEXT:   Predicates:
; CHECK:       Loop %loop: Trip multiple is 1
;
entry:
  %len.zext = zext i32 %len to i64
  %len.sext = sext i32 %len to i64
  br label %loop
loop:
  %iv = phi i64 [0, %entry], [%iv.next, %loop]
  %iv.next = add i64 %iv, 1
  %cmp1 = icmp ule i64 %len.zext, %len.sext
  %sel = select i1 %cmp1, i64 %len.zext, i64 %len.sext
  %cmp2 = icmp ult i64 %iv, %sel
  br i1 %cmp2, label %loop, label %exit
exit:
  ret void
}

define void @sge_sext_x_zext_x(i32 %len) {
; CHECK-LABEL: 'sge_sext_x_zext_x'
; CHECK-NEXT:  Classifying expressions for: @sge_sext_x_zext_x
; CHECK-NEXT:    %len.zext = zext i32 %len to i64
; CHECK-NEXT:    --> (zext i32 %len to i64) U: [0,4294967296) S: [0,4294967296)
; CHECK-NEXT:    %len.sext = sext i32 %len to i64
; CHECK-NEXT:    --> (sext i32 %len to i64) U: [-2147483648,2147483648) S: [-2147483648,2147483648)
; CHECK-NEXT:    %iv = phi i64 [ 0, %entry ], [ %iv.next, %loop ]
; CHECK-NEXT:    --> {0,+,1}<nuw><nsw><%loop> U: [0,4294967296) S: [0,4294967296) Exits: (zext i32 %len to i64) LoopDispositions: { %loop: Computable }
; CHECK-NEXT:    %iv.next = add i64 %iv, 1
; CHECK-NEXT:    --> {1,+,1}<nuw><nsw><%loop> U: [1,4294967297) S: [1,4294967297) Exits: (1 + (zext i32 %len to i64))<nuw><nsw> LoopDispositions: { %loop: Computable }
; CHECK-NEXT:    %sel = select i1 %cmp1, i64 %len.zext, i64 %len.sext
; CHECK-NEXT:    --> (zext i32 %len to i64) U: [0,4294967296) S: [0,4294967296) Exits: (zext i32 %len to i64) LoopDispositions: { %loop: Invariant }
; CHECK-NEXT:  Determining loop execution counts for: @sge_sext_x_zext_x
; CHECK-NEXT:  Loop %loop: backedge-taken count is (zext i32 %len to i64)
; CHECK-NEXT:  Loop %loop: constant max backedge-taken count is 4294967295
; CHECK-NEXT:  Loop %loop: symbolic max backedge-taken count is (zext i32 %len to i64)
; CHECK-NEXT:  Loop %loop: Predicated backedge-taken count is (zext i32 %len to i64)
; CHECK-NEXT:   Predicates:
; CHECK:       Loop %loop: Trip multiple is 1
;
entry:
  %len.zext = zext i32 %len to i64
  %len.sext = sext i32 %len to i64
  br label %loop
loop:
  %iv = phi i64 [0, %entry], [%iv.next, %loop]
  %iv.next = add i64 %iv, 1
  %cmp1 = icmp sge i64 %len.zext, %len.sext
  %sel = select i1 %cmp1, i64 %len.zext, i64 %len.sext
  %cmp2 = icmp ult i64 %iv, %sel
  br i1 %cmp2, label %loop, label %exit
exit:
  ret void
}

define void @slt_sext_x_zext_x(i32 %len) {
; CHECK-LABEL: 'slt_sext_x_zext_x'
; CHECK-NEXT:  Classifying expressions for: @slt_sext_x_zext_x
; CHECK-NEXT:    %len.zext = zext i32 %len to i64
; CHECK-NEXT:    --> (zext i32 %len to i64) U: [0,4294967296) S: [0,4294967296)
; CHECK-NEXT:    %len.sext = sext i32 %len to i64
; CHECK-NEXT:    --> (sext i32 %len to i64) U: [-2147483648,2147483648) S: [-2147483648,2147483648)
; CHECK-NEXT:    %iv = phi i64 [ 0, %entry ], [ %iv.next, %loop ]
; CHECK-NEXT:    --> {0,+,1}<%loop> U: full-set S: full-set Exits: (sext i32 %len to i64) LoopDispositions: { %loop: Computable }
; CHECK-NEXT:    %iv.next = add i64 %iv, 1
; CHECK-NEXT:    --> {1,+,1}<%loop> U: full-set S: full-set Exits: (1 + (sext i32 %len to i64))<nsw> LoopDispositions: { %loop: Computable }
; CHECK-NEXT:    %umin = select i1 %cmp1, i64 %len.zext, i64 %len.sext
; CHECK-NEXT:    --> (sext i32 %len to i64) U: [-2147483648,2147483648) S: [-2147483648,2147483648) Exits: (sext i32 %len to i64) LoopDispositions: { %loop: Invariant }
; CHECK-NEXT:  Determining loop execution counts for: @slt_sext_x_zext_x
; CHECK-NEXT:  Loop %loop: backedge-taken count is (sext i32 %len to i64)
; CHECK-NEXT:  Loop %loop: constant max backedge-taken count is -1
; CHECK-NEXT:  Loop %loop: symbolic max backedge-taken count is (sext i32 %len to i64)
; CHECK-NEXT:  Loop %loop: Predicated backedge-taken count is (sext i32 %len to i64)
; CHECK-NEXT:   Predicates:
; CHECK:       Loop %loop: Trip multiple is 1
;
entry:
  %len.zext = zext i32 %len to i64
  %len.sext = sext i32 %len to i64
  br label %loop
loop:
  %iv = phi i64 [0, %entry], [%iv.next, %loop]
  %iv.next = add i64 %iv, 1
  %cmp1 = icmp slt i64 %len.zext, %len.sext
  %umin = select i1 %cmp1, i64 %len.zext, i64 %len.sext
  %cmp2 = icmp ult i64 %iv, %umin
  br i1 %cmp2, label %loop, label %exit
exit:
  ret void
}

define void @sgt_sext_x_zext_x(i32 %len) {
; CHECK-LABEL: 'sgt_sext_x_zext_x'
; CHECK-NEXT:  Classifying expressions for: @sgt_sext_x_zext_x
; CHECK-NEXT:    %len.zext = zext i32 %len to i64
; CHECK-NEXT:    --> (zext i32 %len to i64) U: [0,4294967296) S: [0,4294967296)
; CHECK-NEXT:    %len.sext = sext i32 %len to i64
; CHECK-NEXT:    --> (sext i32 %len to i64) U: [-2147483648,2147483648) S: [-2147483648,2147483648)
; CHECK-NEXT:    %iv = phi i64 [ 0, %entry ], [ %iv.next, %loop ]
; CHECK-NEXT:    --> {0,+,1}<nuw><nsw><%loop> U: [0,4294967296) S: [0,4294967296) Exits: (zext i32 %len to i64) LoopDispositions: { %loop: Computable }
; CHECK-NEXT:    %iv.next = add i64 %iv, 1
; CHECK-NEXT:    --> {1,+,1}<nuw><nsw><%loop> U: [1,4294967297) S: [1,4294967297) Exits: (1 + (zext i32 %len to i64))<nuw><nsw> LoopDispositions: { %loop: Computable }
; CHECK-NEXT:    %umax = select i1 %cmp1, i64 %len.zext, i64 %len.sext
; CHECK-NEXT:    --> (zext i32 %len to i64) U: [0,4294967296) S: [0,4294967296) Exits: (zext i32 %len to i64) LoopDispositions: { %loop: Invariant }
; CHECK-NEXT:  Determining loop execution counts for: @sgt_sext_x_zext_x
; CHECK-NEXT:  Loop %loop: backedge-taken count is (zext i32 %len to i64)
; CHECK-NEXT:  Loop %loop: constant max backedge-taken count is 4294967295
; CHECK-NEXT:  Loop %loop: symbolic max backedge-taken count is (zext i32 %len to i64)
; CHECK-NEXT:  Loop %loop: Predicated backedge-taken count is (zext i32 %len to i64)
; CHECK-NEXT:   Predicates:
; CHECK:       Loop %loop: Trip multiple is 1
;
entry:
  %len.zext = zext i32 %len to i64
  %len.sext = sext i32 %len to i64
  br label %loop
loop:
  %iv = phi i64 [0, %entry], [%iv.next, %loop]
  %iv.next = add i64 %iv, 1
  %cmp1 = icmp sgt i64 %len.zext, %len.sext
  %umax = select i1 %cmp1, i64 %len.zext, i64 %len.sext
  %cmp2 = icmp ult i64 %iv, %umax
  br i1 %cmp2, label %loop, label %exit
exit:
  ret void
}
