/*
 * Decompiled with CFR 0.152.
 */
package nicelee.ui.thread;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.net.URL;
import java.util.Collection;
import javax.accessibility.Accessible;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import nicelee.bilibili.INeedAV;
import nicelee.bilibili.exceptions.BilibiliError;
import nicelee.bilibili.model.ClipInfo;
import nicelee.bilibili.model.VideoInfo;
import nicelee.bilibili.parsers.impl.AbstractPageQueryParser;
import nicelee.bilibili.util.Logger;
import nicelee.bilibili.util.ResourcesUtil;
import nicelee.ui.Global;
import nicelee.ui.TabVideo;
import nicelee.ui.item.ClipInfoPanel;
import nicelee.ui.item.JOptionPaneManager;

public class GetVideoDetailThread
extends Thread {
    TabVideo video;
    String avId;

    public GetVideoDetailThread(TabVideo tabVideo, String string) {
        this.video = tabVideo;
        this.avId = string;
    }

    @Override
    public void run() {
        try {
            Accessible accessible;
            Object object;
            INeedAV iNeedAV = new INeedAV();
            VideoInfo videoInfo = iNeedAV.getVideoDetail(this.avId, Global.downloadFormat, false);
            if (iNeedAV.getInputParser(this.avId).getParser() instanceof AbstractPageQueryParser) {
                Logger.println("\u5f53\u524d\u4e3a\u5206\u9875\u67e5\u8be2");
                this.video.displayNextPagePanel();
            }
            this.video.setAvInfo(videoInfo);
            this.video.getLbAvID().setText(videoInfo.getVideoId());
            Collection<ClipInfo> collection = videoInfo.getClips().values();
            if (Global.autoDisplayPreviewPic) {
                if (collection.size() == 0) {
                    this.video.setCurrentDisplayPic(videoInfo.getVideoPreview());
                } else {
                    this.video.setCurrentDisplayPic(collection.iterator().next().getPicPreview());
                }
                try {
                    object = new URL(this.video.getCurrentDisplayPic());
                    accessible = new ImageIcon((URL)object);
                    accessible = new ImageIcon(((ImageIcon)accessible).getImage().getScaledInstance(700, 460, 4));
                    this.video.getLbAvPrivew().setIcon((Icon)((Object)accessible));
                    this.video.getLbAvPrivew().setText("");
                }
                catch (Exception exception) {
                    this.video.getLbAvPrivew().setText("\u65e0\u6548\u9884\u89c8\u56fe");
                }
            } else {
                this.video.getLbAvPrivew().setText("\u4e0d\u663e\u793a\u9884\u89c8");
            }
            this.video.getLbBreif().setText(videoInfo.getBrief());
            this.video.getLbBreif().setToolTipText(videoInfo.getBrief());
            this.video.getLbVideoTitle().setText(videoInfo.getVideoName());
            this.video.getLbVideoTitle().setToolTipText(videoInfo.getVideoName());
            object = videoInfo.getVideoName();
            if (((String)object).length() >= 12) {
                object = ((String)object).substring(0, 9) + "...";
            }
            this.video.getLbTabTitle().setText((String)object);
            accessible = this.video.getJpContent();
            ((JComponent)((Object)accessible)).setPreferredSize(new Dimension(340, 175 * videoInfo.getClips().size()));
            for (ClipInfo clipInfo : videoInfo.getClips().values()) {
                ClipInfoPanel clipInfoPanel = new ClipInfoPanel(videoInfo, clipInfo);
                ((Container)((Object)accessible)).add(clipInfoPanel);
            }
            ((JPanel)accessible).updateUI();
            ((Component)((Object)accessible)).repaint();
        }
        catch (BilibiliError bilibiliError) {
            bilibiliError.printStackTrace();
            JOptionPaneManager.alertErrMsgWithNewThread("\u53d1\u751f\u4e86\u9884\u6599\u4e4b\u5916\u7684\u9519\u8bef", ResourcesUtil.detailsOfException(bilibiliError));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

