/*
 * Decompiled with CFR 0.152.
 */
package nicelee.ui.thread;

import nicelee.bilibili.API;
import nicelee.bilibili.INeedAV;
import nicelee.bilibili.downloaders.Downloader;
import nicelee.bilibili.enums.StatusEnum;
import nicelee.bilibili.exceptions.BilibiliError;
import nicelee.bilibili.parsers.InputParser;
import nicelee.bilibili.util.CmdUtil;
import nicelee.bilibili.util.Logger;
import nicelee.bilibili.util.RepoUtil;
import nicelee.bilibili.util.ResourcesUtil;
import nicelee.bilibili.util.custom.System;
import nicelee.ui.Global;
import nicelee.ui.item.DownloadInfoPanel;
import nicelee.ui.item.JOptionPaneManager;

public class DownloadRunnableInternal
implements Runnable {
    final DownloadInfoPanel downPanel;
    final long urlTimestamp;
    final boolean invokeByContinueTask;
    final int failCnt;
    final String record;
    final INeedAV iNeedAV;
    final Downloader downloader;
    final String urlQuery;
    final String avid;
    final String cid;
    final String avid_qn;
    final String formattedTitle;
    final int qn;
    final int realQN;
    final int page;

    public DownloadRunnableInternal(DownloadInfoPanel downloadInfoPanel, long l, boolean bl, int n) {
        this.downPanel = downloadInfoPanel;
        this.urlTimestamp = l;
        this.invokeByContinueTask = bl;
        this.failCnt = n;
        this.iNeedAV = downloadInfoPanel.iNeedAV;
        this.downloader = this.iNeedAV.getDownloader();
        this.urlQuery = downloadInfoPanel.url;
        this.avid = downloadInfoPanel.getAvid();
        this.cid = downloadInfoPanel.getCid();
        this.avid_qn = downloadInfoPanel.avid_qn;
        this.formattedTitle = downloadInfoPanel.formattedTitle;
        this.qn = downloadInfoPanel.getQn();
        this.realQN = downloadInfoPanel.getRealqn();
        this.page = downloadInfoPanel.getClipInfo().getPage();
        this.record = this.avid_qn + "-p" + this.page;
    }

    @Override
    public void run() {
        try {
            if (this.downloader.currentStatus() == StatusEnum.NONE && this.downPanel.stopOnQueue) {
                Logger.println("\u5df2\u7ecf\u5220\u9664\u7b49\u5f85\u961f\u5217,\u65e0\u9700\u518d\u4e0b\u8f7d");
                return;
            }
            if (this.downloader.currentStatus() == StatusEnum.STOP) {
                Logger.println("\u5df2\u7ecf\u4eba\u5de5\u505c\u6b62,\u65e0\u9700\u518d\u4e0b\u8f7d");
                return;
            }
            String string = this.urlQuery;
            if (!ResourcesUtil.isPicture(this.avid)) {
                boolean bl = false;
                if (this.invokeByContinueTask && Global.reloadDownloadUrl) {
                    Logger.printf("\u91cd\u8bd5\u65f6\uff0c\u91cd\u65b0\u67e5\u8be2\u4e0b\u8f7d\u94fe\u63a5", new Object[0]);
                    bl = true;
                } else {
                    long l = System.currentTimeMillis();
                    long l2 = l - this.urlTimestamp;
                    if (l2 > Global.urlValidPeriod) {
                        Logger.printf("\u4e0b\u8f7durl\u8ddd\u79bb\u4e0a\u6b21\u67e5\u8be2\u5df2\u7ecf\u8fc7\u4e86\u8d85\u8fc7%d min\uff0c\u91cd\u65b0\u67e5\u8be2\u4e0b\u8f7d\u94fe\u63a5", Global.urlValidPeriod / 60000L);
                        bl = true;
                    }
                }
                if (bl) {
                    InputParser inputParser = this.iNeedAV.getInputParser(this.avid);
                    this.downPanel.url = string = inputParser.getVideoLink(this.avid, this.cid, this.qn, Global.downloadFormat);
                    if (this.realQN != inputParser.getVideoLinkQN()) {
                        Logger.println("\u6e05\u6670\u5ea6\u94fe\u63a5\u5df2\u7ecf\u6539\u53d8\uff0c\u65e0\u6cd5\u518d\u91cd\u65b0\u4e0b\u8f7d");
                        this.iNeedAV.getUtil().stopDownloadAsFail();
                        return;
                    }
                }
            }
            if (this.iNeedAV.downloadClip(string, this.avid, this.iNeedAV.getInputParser(this.avid).getVideoLinkQN(), this.page)) {
                if (Global.saveToRepo) {
                    RepoUtil.appendAndSave(this.record);
                }
                if (Global.thumbUpAfterDownloaded && Global.isLogin && this.avid.startsWith("BV")) {
                    API.like(this.avid);
                }
                CmdUtil.convertOrAppendCmdToRenameBat(this.avid_qn, this.formattedTitle, this.page);
            }
        }
        catch (BilibiliError bilibiliError) {
            JOptionPaneManager.alertErrMsgWithNewThread("\u53d1\u751f\u4e86\u9884\u6599\u4e4b\u5916\u7684\u9519\u8bef", ResourcesUtil.detailsOfException(bilibiliError));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (Global.sleepAfterDownloadComplete > 0L) {
            try {
                Thread.sleep(Global.sleepAfterDownloadComplete);
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        }
    }
}

