/*
 * Decompiled with CFR 0.152.
 */
package nicelee.ui.thread;

import java.awt.Component;
import java.awt.Desktop;
import java.awt.HeadlessException;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collection;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import nicelee.bilibili.INeedAV;
import nicelee.bilibili.enums.VideoQualityEnum;
import nicelee.bilibili.exceptions.BilibiliError;
import nicelee.bilibili.model.ClipInfo;
import nicelee.bilibili.model.VideoInfo;
import nicelee.bilibili.util.Logger;
import nicelee.bilibili.util.ResourcesUtil;
import nicelee.bilibili.util.batchdownload.BatchDownload;
import nicelee.ui.Global;
import nicelee.ui.item.JOptionPane;
import nicelee.ui.item.JOptionPaneManager;
import nicelee.ui.thread.DownloadRunnable;

public class BatchDownloadThread
extends Thread {
    String configFileName;
    String configFilePath;
    final Pattern pagePattern = Pattern.compile("p=[0-9]+$");

    public BatchDownloadThread(String string) {
        this.setName("Thread-BatchDownload");
        this.configFileName = string;
        this.configFilePath = "config/" + string;
    }

    @Override
    public void run() {
        try {
            Logger.println("\u4e00\u952e\u4e0b\u8f7d\u8fdb\u884c\u4e2d");
            File file = ResourcesUtil.search(this.configFilePath);
            this.checkValid(file);
            List<BatchDownload> list = new BatchDownload.BatchDownloadsBuilder(new FileInputStream(file)).Build();
            Logger.println("\u4e00\u952e\u4e0b\u8f7d\u8fdb\u884c\u4e2d\u3002\u3002\u3002\u3002\u3002");
            Logger.println(list);
            for (BatchDownload batchDownload : list) {
                Logger.printf("[url:%s] \u4efb\u52a1\u5f00\u59cb", batchDownload.getUrl());
                INeedAV iNeedAV = new INeedAV();
                String string = iNeedAV.getValidID(batchDownload.getUrl());
                Logger.println(string);
                Matcher matcher = this.pagePattern.matcher(string);
                boolean bl = true;
                if (!matcher.find()) {
                    bl = false;
                } else {
                    string = string.replaceFirst("p=[0-9]+$", "");
                }
                boolean bl2 = false;
                for (int i = batchDownload.getStartPage(); !bl2 && (bl || i < 2); ++i) {
                    String string2 = string + " p=" + i;
                    VideoInfo videoInfo = null;
                    try {
                        videoInfo = iNeedAV.getVideoDetail(string2, Global.downloadFormat, false);
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                        break;
                    }
                    Collection<ClipInfo> collection = videoInfo.getClips().values();
                    if (collection.size() == 0) break;
                    Logger.printf("\u5f53\u524durl: %s ,page: %d, \u5206\u9875\u67e5\u8be2\u5f00\u59cb\u8fdb\u884c", batchDownload.getUrl(), i);
                    for (ClipInfo clipInfo : collection) {
                        DownloadRunnable downloadRunnable;
                        if (batchDownload.matchStopCondition(clipInfo, i)) {
                            if (batchDownload.isIncludeBoundsBV() && batchDownload.matchDownloadCondition(clipInfo, i)) {
                                this.addTask(clipInfo);
                                downloadRunnable = new DownloadRunnable(videoInfo, clipInfo, VideoQualityEnum.getQN(Global.menu_qn));
                                Global.queryThreadPool.execute(downloadRunnable);
                            }
                            bl2 = true;
                            break;
                        }
                        if (!batchDownload.matchDownloadCondition(clipInfo, i)) continue;
                        this.addTask(clipInfo);
                        downloadRunnable = new DownloadRunnable(videoInfo, clipInfo, VideoQualityEnum.getQN(Global.menu_qn));
                        Global.queryThreadPool.execute(downloadRunnable);
                    }
                    Logger.printf("\u5f53\u524durl: %s ,page: %d, \u5206\u9875\u67e5\u8be2\u5b8c\u6bd5", batchDownload.getUrl(), i);
                    Thread.sleep(1500L);
                }
                Thread.sleep(1000L);
                Logger.printf("[url:%s] \u4efb\u52a1\u5b8c\u6bd5", batchDownload.getUrl());
                if (!batchDownload.isAlertAfterMissionComplete()) continue;
                this.showMessageDialog(null, "url:" + batchDownload.getUrl(), "\u4efb\u52a1\u5b8c\u6bd5!! " + batchDownload.getRemark(), 1);
            }
            this.showMessageDialog(null, "\u4e00\u952e\u4e0b\u8f7d\u5b8c\u6bd5", "OK", -1);
        }
        catch (BilibiliError bilibiliError) {
            JOptionPaneManager.alertErrMsgWithNewThread("\u53d1\u751f\u4e86\u9884\u6599\u4e4b\u5916\u7684\u9519\u8bef", ResourcesUtil.detailsOfException(bilibiliError));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        Logger.println("\u4e00\u952e\u4e0b\u8f7d\u8fd0\u884c\u5b8c\u6bd5");
    }

    public void checkValid(File file) throws IOException, URISyntaxException {
        if (file == null || !file.exists()) {
            Object[] objectArray;
            String string = "https://nICEnnnnnnnLee.github.io/BilibiliDown/guide/advanced/quick-batch-download";
            String string2 = "\u6279\u91cf\u4e0b\u8f7d\u914d\u7f6e\u4e0d\u5b58\u5728`" + this.configFilePath + "`!\r\n\u8bf7\u53c2\u8003\u914d\u7f6e" + string;
            int n = JOptionPane.showOptionDialog(null, string2, "\u9519\u8bef", 0, -1, null, objectArray = new Object[]{"\u786e\u8ba4", "\u524d\u5f80\u53c2\u8003\u6587\u6863"}, objectArray[0]);
            if (n == 1) {
                if (Desktop.isDesktopSupported()) {
                    Desktop.getDesktop().browse(new URI(string));
                } else {
                    Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
                    StringSelection stringSelection = new StringSelection(string);
                    clipboard.setContents(stringSelection, null);
                    JOptionPane.showMessageDialog(null, "\u76f8\u5173\u7f51\u9875\u94fe\u63a5\u5df2\u590d\u5236\u5230\u526a\u8d34\u677f");
                }
            }
            throw new RuntimeException("\u914d\u7f6e\u6587\u4ef6`" + this.configFilePath + "`\u4e0d\u5b58\u5728");
        }
    }

    public void addTask(ClipInfo clipInfo) {
    }

    public void showMessageDialog(Component component, String string, String string2, int n) throws HeadlessException {
        JOptionPane.showMessageDialog(component, string, string2, n);
    }
}

