/*
 * Decompiled with CFR 0.152.
 */
package nicelee.ui.thread;

import java.awt.Component;
import java.awt.HeadlessException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Random;
import java.util.TimeZone;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import nicelee.bilibili.model.ClipInfo;
import nicelee.bilibili.model.TaskInfo;
import nicelee.bilibili.pushers.Push;
import nicelee.bilibili.util.Logger;
import nicelee.bilibili.util.custom.System;
import nicelee.ui.Global;
import nicelee.ui.item.DownloadInfoPanel;
import nicelee.ui.thread.BatchDownloadThread;
import nicelee.ui.thread.CookieRefreshThread;

public class BatchDownloadRbyRThread
extends BatchDownloadThread {
    private static ConcurrentHashMap<ClipInfo, TaskInfo> currentTaskList;
    private static long batchDownloadBeginTime;
    private static long batchDownloadEndTime;
    static final SimpleDateFormat sdf;
    static final SimpleDateFormat sdfToday;
    final String[] plans;
    int taskOrderNo = 0;
    static final long MILLI_SECONDS_OF_ONE_DAY = 86400000L;
    static final Pattern rollTimePattern;
    static final Pattern toTimePattern;

    public BatchDownloadRbyRThread(String string) {
        super(string);
        this.setName("Thread-BatchDownload round by round");
        this.setDaemon(true);
        this.plans = Global.batchDownloadPlan.split(";");
    }

    public void runBatchDownloadOnce() {
        this.taskOrderNo = 0;
        batchDownloadBeginTime = System.currentTimeMillis();
        Logger.printf("--%s\u6279\u91cf\u4e0b\u8f7d\u5f00\u59cb", sdf.format(batchDownloadBeginTime));
        currentTaskList = new ConcurrentHashMap();
        super.run();
        this.waitUtilAllTaskDone(false);
        this.waitUtilAllTaskDone(true);
        batchDownloadEndTime = System.currentTimeMillis();
        Logger.printf("--%s\u6279\u91cf\u4e0b\u8f7d\u5b8c\u6bd5", sdf.format(batchDownloadEndTime));
        new Push().push(currentTaskList, batchDownloadBeginTime, batchDownloadEndTime);
        currentTaskList = null;
    }

    private void waitUtilAllTaskDone(boolean bl) {
        ArrayList<TaskInfo> arrayList = new ArrayList<TaskInfo>(currentTaskList.values());
        Collections.sort(arrayList, (taskInfo, taskInfo2) -> taskInfo.getOrderNum() - taskInfo2.getOrderNum());
        block2: for (TaskInfo taskInfo3 : arrayList) {
            int n = 0;
            while (this.isTaskRunning(taskInfo3)) {
                try {
                    if (taskInfo3.getStatus() == null) {
                        if (bl) {
                            taskInfo3.setStatus("not sent to download queue");
                            continue block2;
                        }
                        if (++n > 2 && (long)(n * 10000) > Global.sleepAfterDownloadQuery) continue block2;
                    }
                    BatchDownloadRbyRThread.sleep(10000L);
                    Logger.printf("\u7b49\u5f85\u4efb\u52a1\u5b8c\u6bd5%s %s %s", taskInfo3.getClip().getAvId(), taskInfo3.getClip().getAvTitle(), taskInfo3.getClip().getTitle());
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    private boolean isTaskRunning(TaskInfo taskInfo) {
        if (taskInfo.getStatus() != null) {
            if ("just put in download panel".equals(taskInfo.getStatus())) {
                DownloadInfoPanel downloadInfoPanel = new DownloadInfoPanel(taskInfo.getClip(), 0);
                return Global.downloadTaskList.containsKey(downloadInfoPanel);
            }
            return false;
        }
        return true;
    }

    @Override
    public void addTask(ClipInfo clipInfo) {
        if (currentTaskList != null) {
            currentTaskList.put(clipInfo, new TaskInfo(clipInfo, this.taskOrderNo));
            ++this.taskOrderNo;
        }
    }

    @Override
    public void showMessageDialog(Component component, String string, String string2, int n) throws HeadlessException {
        Logger.println(string);
        Logger.println(string2);
    }

    public static void taskSucceed(ClipInfo clipInfo, String string, String string2, String string3) {
        TaskInfo taskInfo;
        if (currentTaskList != null && (taskInfo = currentTaskList.get(clipInfo)) != null) {
            taskInfo.setFileName(string);
            taskInfo.setFileSize(string2);
            taskInfo.setQn(string3);
            taskInfo.setStatus("success");
        }
    }

    public static void taskFail(ClipInfo clipInfo, String string) {
        TaskInfo taskInfo;
        if (currentTaskList != null && (taskInfo = currentTaskList.get(clipInfo)) != null) {
            taskInfo.setStatus(string);
        }
    }

    @Override
    public void run() {
        try {
            long l = System.currentTimeMillis();
            while (true) {
                long l2 = System.currentTimeMillis();
                if (Global.downloadTab.activeTask == 0) {
                    for (DownloadInfoPanel downloadInfoPanel : Global.downloadTaskList.keySet()) {
                        downloadInfoPanel.removeTask(true);
                    }
                    if (Global.isLogin && !Global.runWASMinBrowser && l2 - l > 86400000L) {
                        CookieRefreshThread.showTips = false;
                        CookieRefreshThread cookieRefreshThread = CookieRefreshThread.newInstance();
                        cookieRefreshThread.start();
                        try {
                            cookieRefreshThread.join();
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        CookieRefreshThread.showTips = true;
                        l = l2;
                    }
                }
                this.runBatchDownloadOnce();
                try {
                    BatchDownloadRbyRThread.sleep(this.timeToSleep(this.plans, System.currentTimeMillis()));
                }
                catch (InterruptedException interruptedException) {
                    interruptedException.printStackTrace();
                }
            }
        }
        catch (ParseException parseException) {
            parseException.printStackTrace();
            return;
        }
    }

    public static void main(String[] stringArray) {
        try {
            long l;
            int n;
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            simpleDateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
            long l2 = simpleDateFormat.parse("2025-01-29 08:21:29").getTime();
            long l3 = 1706602889000L;
            long l4 = l2 - l3;
            System.out.println(l2);
            System.out.println(l3);
            System.out.println(l4 / 1000L / 60L / 60L / 24L);
            System.exit(1);
            BatchDownloadRbyRThread batchDownloadRbyRThread = new BatchDownloadRbyRThread("");
            String string = "06:00~02:00=>r(300,480); 02:00~04:00=>~06:00+r(0,360); 00:00~00:00=>r(30,31)";
            String[] stringArray2 = string.split(";");
            long l5 = sdf.parse("2024-01-21 21:01").getTime();
            for (n = 0; n < 10; ++n) {
                l = batchDownloadRbyRThread.timeToSleep(stringArray2, l5);
                System.out.println("sleep(s) " + l / 1000L);
            }
            System.out.println("-----------------------------");
            l5 = sdf.parse("2024-01-21 02:01").getTime();
            for (n = 0; n < 10; ++n) {
                l = batchDownloadRbyRThread.timeToSleep(stringArray2, l5);
                System.out.println("sleep(min) " + l / 1000L / 60L);
            }
            System.out.println("-----------------------------");
            l5 = sdf.parse("2024-01-21 04:01").getTime();
            for (n = 0; n < 10; ++n) {
                l = batchDownloadRbyRThread.timeToSleep(stringArray2, l5);
                System.out.println("sleep(s) " + l / 1000L);
            }
        }
        catch (ParseException parseException) {
            parseException.printStackTrace();
        }
    }

    public long timeToSleep(String[] stringArray, long l) throws ParseException {
        Random random = new Random();
        String string = sdfToday.format(l);
        for (String string2 : stringArray) {
            Matcher matcher;
            String[] stringArray2 = string2.split("=>");
            String[] stringArray3 = stringArray2[0].split("~");
            String string3 = string + " " + stringArray3[0].trim();
            long l2 = sdf.parse(string3).getTime();
            String string4 = string + " " + stringArray3[1].trim();
            long l3 = sdf.parse(string4).getTime();
            if (l3 <= l2) {
                l3 += 86400000L;
            }
            if (l < l2 || l > l3) continue;
            long l4 = 0L;
            long l5 = 0L;
            Matcher matcher2 = rollTimePattern.matcher(stringArray2[1]);
            if (matcher2.find()) {
                int n = Integer.parseInt(matcher2.group(1)) * 1000;
                int n2 = Integer.parseInt(matcher2.group(2)) * 1000;
                long l6 = l4 = n2 > n ? (long)(n + random.nextInt(n2 - n)) : (long)n;
            }
            if ((matcher = toTimePattern.matcher(stringArray2[1])).find()) {
                long l7 = sdf.parse(string + " " + matcher.group(1)).getTime();
                if (l7 < l) {
                    l7 += 86400000L;
                }
                l5 = l7 - l;
            }
            long l8 = l5 + l4;
            Logger.printf("\u73b0\u5728\u65f6\u95f4\u662f %s, \u5c06\u8981\u7b49\u5f85%dmin", sdf.format(System.currentTimeMillis()), l8 / 60000L);
            return l8;
        }
        throw new IllegalArgumentException("\u4e00\u952e\u4e0b\u8f7d\u8ba1\u5212\u65f6\u95f4\u914d\u7f6e\u9519\u8bef" + l);
    }

    static {
        sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm");
        sdfToday = new SimpleDateFormat("yyyy-MM-dd");
        TimeZone timeZone = TimeZone.getTimeZone("GMT+8:00");
        TimeZone.setDefault(timeZone);
        sdf.setTimeZone(timeZone);
        sdfToday.setTimeZone(timeZone);
        rollTimePattern = Pattern.compile("r\\(([0-9]+),([0-9]+)\\)");
        toTimePattern = Pattern.compile("~([0-9]{2}:[0-9]{2})");
    }
}

