/*
 * Decompiled with CFR 0.152.
 */
package nicelee.ui.item;

import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.WindowEvent;
import java.io.Serializable;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import nicelee.bilibili.util.Logger;
import nicelee.ui.FrameMain;
import nicelee.ui.Global;
import nicelee.ui.SysTray;
import nicelee.ui.item.JOptionPane;
import nicelee.ui.item.MJMenuBar;

public class MJTitleBar
extends JPanel
implements MouseListener,
MouseMotionListener {
    private static final long serialVersionUID = 7910189206713741389L;
    private JFrame frame;
    private JButton btnMin;
    private JButton btnClose;
    private Point pressedPoint;
    private boolean setTitle;
    private boolean setMenuBar;
    private JLabel title;

    public MJTitleBar(JFrame jFrame) {
        this(jFrame, false, false);
    }

    public MJTitleBar(JFrame jFrame, boolean bl) {
        this(jFrame, bl, false);
    }

    public MJTitleBar(JFrame jFrame, boolean bl, boolean bl2) {
        this.frame = jFrame;
        this.setTitle = bl;
        this.setMenuBar = bl2;
        this.init();
    }

    private void init() {
        this.frame.setUndecorated(true);
        this.setPreferredSize(new Dimension(this.frame.getWidth() - 4, 25));
        int n = this.setMenuBar ? -3 : 3;
        Logger.println(n);
        this.setLayout(new FlowLayout(2, 5, n));
        this.setOpaque(false);
        this.setBackground(Color.WHITE);
        if (this.setTitle) {
            this.initTitle();
        }
        if (this.setMenuBar) {
            this.initMenuBar();
        }
        this.initButton();
    }

    private void initTitle() {
        Serializable serializable;
        JLabel jLabel = null;
        if (this.frame.getIconImage() != null) {
            Logger.println("\u4e0d\u4e3anull");
            serializable = new ImageIcon(this.frame.getIconImage().getScaledInstance(25, 23, 1));
            jLabel = new JLabel((Icon)((Object)serializable));
            this.add(jLabel);
        }
        this.title = new JLabel();
        this.title.setText(this.frame.getTitle());
        if (this.setMenuBar) {
            this.title.setPreferredSize(new Dimension(350, 25));
            this.add(this.title);
            serializable = new JLabel();
            ((JComponent)serializable).setPreferredSize(new Dimension(542, 25));
            this.add((Component)serializable);
        } else {
            this.title.setHorizontalAlignment(0);
            this.title.setPreferredSize(new Dimension(this.frame.getWidth() - 60, 25));
            serializable = this.title.getFont();
            this.title.setFont(new Font(((Font)serializable).getName(), ((Font)serializable).getStyle(), 18));
            this.add(this.title);
        }
    }

    private void initMenuBar() {
        MJMenuBar mJMenuBar = new MJMenuBar(this.frame);
        mJMenuBar.setPreferredSize(new Dimension(150, 25));
        this.add(mJMenuBar);
        JLabel jLabel = new JLabel();
        jLabel.setPreferredSize(new Dimension(50, 25));
        this.add(jLabel);
        this.setBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, Color.DARK_GRAY));
    }

    private void initButton() {
        this.btnMin = new JButton();
        this.btnMin.setRolloverIcon(new ImageIcon(this.getClass().getResource("/resources/_h.jpg")));
        this.btnMin.setFocusPainted(false);
        this.btnMin.setBorderPainted(false);
        this.btnMin.setContentAreaFilled(false);
        ImageIcon imageIcon = new ImageIcon(this.getClass().getResource("/resources/_.jpg"));
        this.btnMin.setIcon(imageIcon);
        this.btnMin.setPreferredSize(new Dimension(20, 20));
        this.add(this.btnMin);
        this.btnClose = new JButton();
        this.btnClose.setRolloverIcon(new ImageIcon(this.getClass().getResource("/resources/xh.jpg")));
        this.btnClose.setFocusPainted(false);
        this.btnClose.setBorderPainted(false);
        this.btnClose.setContentAreaFilled(false);
        ImageIcon imageIcon2 = new ImageIcon(this.getClass().getResource("/resources/x.jpg"));
        this.btnClose.setIcon(imageIcon2);
        this.btnClose.setPreferredSize(new Dimension(20, 20));
        this.add(this.btnClose);
        this.addMouseMotionListener(this);
        this.addMouseListener(this);
        this.btnMin.addMouseListener(this);
        this.btnClose.addMouseListener(this);
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        if (mouseEvent.getSource() == this.btnClose) {
            if (this.frame instanceof FrameMain && SysTray.isSysTrayInitiated() && Global.closeToSystray) {
                Logger.println("\u6700\u5c0f\u5316\u5230\u7cfb\u7edf\u6258\u76d8");
                this.frame.setExtendedState(1);
                this.frame.setVisible(false);
            } else {
                Object[] objectArray;
                if (this.frame instanceof FrameMain && Global.downloadTab.activeTask > 0) {
                    objectArray = new Object[]{"\u6211\u8981\u9000\u51fa", "\u6211\u518d\u60f3\u60f3"};
                    String string = String.format("\u5f53\u524d\u4ecd\u6709 %d \u4e2a\u4efb\u52a1\u5728\u4e0b\u8f7d/\u8f6c\u7801\uff0c\u6b63\u5728\u8f6c\u7801\u7684\u6587\u4ef6\u9000\u51fa\u540e\u53ef\u80fd\u4e22\u5931\u6216\u5f02\u5e38\uff0c\u786e\u5b9a\u8981\u9000\u51fa\u5417\uff1f", Global.downloadTab.activeTask);
                    int n = JOptionPane.showOptionDialog(null, string, "\u8b66\u544a", 0, -1, null, objectArray, objectArray[0]);
                    Logger.println(n);
                    if (n != 0) {
                        return;
                    }
                }
                Logger.println("closing...");
                objectArray = new WindowEvent(this.frame, 201);
                this.frame.dispatchEvent((AWTEvent)objectArray);
            }
        } else if (mouseEvent.getSource() == this.btnMin) {
            this.frame.setExtendedState(1);
            if (this.frame instanceof FrameMain && SysTray.isSysTrayInitiated() && Global.minimizeToSystray) {
                Logger.println("\u6700\u5c0f\u5316\u5230\u7cfb\u7edf\u6258\u76d8");
                this.frame.setVisible(false);
            }
        }
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        if (mouseEvent.getSource() == this) {
            this.pressedPoint = SwingUtilities.convertPoint(this, mouseEvent.getPoint(), this.frame);
        }
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        if (mouseEvent.getSource() == this) {
            this.pressedPoint = null;
        }
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        if (this.pressedPoint != null && mouseEvent.getSource() != this.btnClose && mouseEvent.getSource() != this.btnMin) {
            int n = mouseEvent.getXOnScreen() - this.pressedPoint.x;
            int n2 = mouseEvent.getYOnScreen() - this.pressedPoint.y;
            if (n == this.frame.getX() && n2 == this.frame.getY()) {
                return;
            }
            this.frame.setLocation(n, n2);
        }
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
    }

    public void setTitle(String string) {
        this.title.setText(string);
    }
}

