/*
 * Decompiled with CFR 0.152.
 */
package nicelee.ui.item;

import java.awt.Color;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import nicelee.ui.Global;

public class MJTextField
extends JTextField
implements MouseListener,
KeyListener,
FocusListener {
    private static final long serialVersionUID = 10110L;
    private JPopupMenu pop = null;
    private JMenuItem selectAll = null;
    private JMenuItem copy = null;
    private JMenuItem paste = null;
    private JMenuItem cut = null;
    private String placeHolder;

    public MJTextField() {
        this.placeHolder = "";
        this.init();
    }

    public MJTextField(String string) {
        super(string);
        this.setForeground(Color.GRAY);
        this.placeHolder = string;
        this.init();
    }

    private void init() {
        this.addMouseListener(this);
        this.addKeyListener(this);
        this.addFocusListener(this);
        this.pop = new JPopupMenu();
        this.selectAll = new JMenuItem("\u5168\u9009");
        this.pop.add(this.selectAll);
        this.copy = new JMenuItem("\u590d\u5236");
        this.pop.add(this.copy);
        this.paste = new JMenuItem("\u7c98\u8d34");
        this.pop.add(this.paste);
        this.cut = new JMenuItem("\u526a\u5207");
        this.pop.add(this.cut);
        this.selectAll.setAccelerator(KeyStroke.getKeyStroke(65, 2));
        this.copy.setAccelerator(KeyStroke.getKeyStroke(67, 2));
        this.paste.setAccelerator(KeyStroke.getKeyStroke(86, 2));
        this.cut.setAccelerator(KeyStroke.getKeyStroke(88, 2));
        this.selectAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MJTextField.this.action(actionEvent);
            }
        });
        this.copy.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MJTextField.this.action(actionEvent);
            }
        });
        this.paste.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MJTextField.this.action(actionEvent);
            }
        });
        this.cut.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MJTextField.this.action(actionEvent);
            }
        });
        this.add(this.pop);
    }

    public void action(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.copy) {
            this.copy();
        } else if (actionEvent.getSource() == this.paste) {
            if (this.getText().equals(this.placeHolder)) {
                this.setText("");
            }
            this.setForeground(Color.BLACK);
            this.paste();
        } else if (actionEvent.getSource() == this.cut) {
            this.cut();
        } else if (actionEvent.getSource() == this.selectAll) {
            this.selectAll();
        }
    }

    public JPopupMenu getPop() {
        return this.pop;
    }

    public void setPop(JPopupMenu jPopupMenu) {
        this.pop = jPopupMenu;
    }

    public boolean isClipboardString() {
        boolean bl = false;
        Clipboard clipboard = this.getToolkit().getSystemClipboard();
        Transferable transferable = clipboard.getContents(this);
        try {
            if (transferable.getTransferData(DataFlavor.stringFlavor) instanceof String) {
                bl = true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return bl;
    }

    public boolean isCanCopy() {
        int n;
        boolean bl = false;
        int n2 = this.getSelectionStart();
        if (n2 != (n = this.getSelectionEnd())) {
            bl = true;
        }
        return bl;
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        if (mouseEvent.getButton() == 3) {
            this.copy.setEnabled(this.isCanCopy());
            this.paste.setEnabled(this.isClipboardString());
            this.cut.setEnabled(this.isCanCopy());
            this.pop.show(this, mouseEvent.getX(), mouseEvent.getY());
        }
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
        if (keyEvent.getKeyCode() == 10) {
            System.out.println("\u8f93\u5165\u4e86Enter\u952e");
            Global.index.search();
        }
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
        if (this.getText().equals(this.placeHolder)) {
            this.setText("");
        }
        this.setForeground(Color.BLACK);
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
        if (this.getText().isEmpty()) {
            this.setForeground(Color.GRAY);
            this.setText(this.placeHolder);
        }
    }
}

