/*
 * Decompiled with CFR 0.152.
 */
package nicelee.ui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import nicelee.bilibili.enums.VideoQualityEnum;
import nicelee.bilibili.model.ClipInfo;
import nicelee.bilibili.model.VideoInfo;
import nicelee.ui.Global;
import nicelee.ui.item.MJButton;
import nicelee.ui.thread.DownloadRunnable;

public class TabVideo
extends JPanel
implements ActionListener,
MouseListener {
    private static final long serialVersionUID = -5829023045158490350L;
    VideoInfo avInfo;
    JLabel lbTabTitle;
    JLabel lbVideoTitle = new JLabel("Av\u6807\u9898");
    JLabel lbAvID = new JLabel("AvID");
    JLabel lbBreif = new JLabel("Av\u7b80\u4ecb");
    JLabel lbAvPrivew;
    JPanel jpContent;
    JScrollPane jpScorll;
    JComboBox<String> cbQn;
    JButton btnDownAll;
    JButton btnDownCC;
    String currentDisplayPic;
    JPanel nextPagePanel;
    JLabel jlNextPageTips;
    protected JButton btnNextPage;

    public TabVideo(JLabel jLabel) {
        this.lbTabTitle = jLabel;
        this.init();
    }

    public void init() {
        Dimension dimension = new Dimension(86, 26);
        this.setOpaque(false);
        this.setLayout(new FlowLayout(0));
        JLabel jLabel = new JLabel();
        jLabel.setPreferredSize(new Dimension(1150, 50));
        this.add(jLabel);
        JLabel jLabel2 = new JLabel();
        jLabel2.setPreferredSize(new Dimension(100, 30));
        this.add(jLabel2);
        this.lbVideoTitle.setBorder(BorderFactory.createLineBorder(Color.red));
        this.lbVideoTitle.setPreferredSize(new Dimension(400, 30));
        this.lbVideoTitle.setBackground(Color.BLUE);
        this.lbVideoTitle.addMouseListener(this);
        this.add(this.lbVideoTitle);
        JLabel jLabel3 = new JLabel();
        jLabel3.setPreferredSize(new Dimension(30, 30));
        this.add(jLabel3);
        this.lbAvID.setBorder(BorderFactory.createLineBorder(Color.red));
        this.lbAvID.setPreferredSize(new Dimension(100, 30));
        this.lbAvID.addMouseListener(this);
        this.add(this.lbAvID);
        JLabel jLabel4 = new JLabel();
        jLabel4.setPreferredSize(new Dimension(40, 30));
        this.add(jLabel4);
        JLabel jLabel5 = new JLabel("\u4f18\u5148\u6e05\u6670\u5ea6");
        this.add(jLabel5);
        this.cbQn = new JComboBox();
        for (VideoQualityEnum object2 : VideoQualityEnum.values()) {
            this.cbQn.addItem(object2.getQuality());
        }
        this.cbQn.setSelectedItem(Global.tab_qn);
        this.btnDownAll = new MJButton("\u6279\u91cf\u4e0b\u8f7d");
        this.btnDownAll.setPreferredSize(dimension);
        this.btnDownAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TabVideo.this.download(true, VideoQualityEnum.getQN(TabVideo.this.cbQn.getSelectedItem().toString()));
            }
        });
        this.btnDownCC = new MJButton("\u5b57\u5e55\u4e0b\u8f7d");
        this.btnDownCC.setPreferredSize(dimension);
        this.btnDownCC.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TabVideo.this.downloadCC();
            }
        });
        this.add(this.cbQn);
        this.add(this.btnDownAll);
        this.add(this.btnDownCC);
        JLabel jLabel6 = new JLabel();
        jLabel6.setPreferredSize(new Dimension(90, 30));
        this.add(jLabel6);
        JLabel jLabel7 = new JLabel();
        jLabel7.setPreferredSize(new Dimension(100, 60));
        this.add(jLabel7);
        this.lbBreif.setBorder(BorderFactory.createLineBorder(Color.red));
        this.lbBreif.setPreferredSize(new Dimension(700, 60));
        this.lbBreif.addMouseListener(this);
        this.add(this.lbBreif);
        this.nextPagePanel = new JPanel(new FlowLayout(0));
        this.nextPagePanel.setPreferredSize(new Dimension(350, 60));
        this.nextPagePanel.setOpaque(false);
        this.add(this.nextPagePanel);
        JLabel jLabel8 = new JLabel();
        jLabel8.setPreferredSize(new Dimension(50, 60));
        this.nextPagePanel.add(jLabel8);
        this.jlNextPageTips = new JLabel("\u89c6\u9891\u6570\u91cf\u4e0d\u5bf9?\u8bd5\u8bd5\u8fd9\u4e2a-->");
        this.jlNextPageTips.setAlignmentX(50.0f);
        this.jlNextPageTips.setPreferredSize(new Dimension(150, 60));
        this.btnNextPage = new MJButton("\u4e0b\u4e00\u9875");
        this.btnNextPage.setPreferredSize(dimension);
        JLabel jLabel9 = new JLabel();
        jLabel9.setPreferredSize(new Dimension(100, 460));
        this.add(jLabel9);
        this.lbAvPrivew = new JLabel("\u52a0\u8f7d\u4e2d", 0);
        this.lbAvPrivew.setToolTipText("\u5355\u51fb\u83b7\u53d6\u56fe\u7247\u94fe\u63a5");
        this.lbAvPrivew.setFont(new Font("\u9ed1\u4f53", 1, 120));
        this.lbAvPrivew.setBorder(BorderFactory.createLineBorder(Color.red));
        this.lbAvPrivew.setPreferredSize(new Dimension(700, 460));
        this.lbAvPrivew.addMouseListener(this);
        this.add(this.lbAvPrivew);
        this.jpContent = new JPanel();
        this.jpContent.setPreferredSize(new Dimension(340, 300));
        this.jpContent.setOpaque(false);
        this.jpScorll = new JScrollPane(this.jpContent);
        this.jpScorll.setHorizontalScrollBarPolicy(31);
        this.jpScorll.setVerticalScrollBarPolicy(20);
        this.jpScorll.setBorder(BorderFactory.createLineBorder(Color.red));
        this.jpScorll.setPreferredSize(new Dimension(350, 460));
        this.jpScorll.setOpaque(false);
        this.jpScorll.getViewport().setOpaque(false);
        this.add(this.jpScorll);
    }

    public void displayNextPagePanel() {
        this.nextPagePanel.add(this.jlNextPageTips);
        this.nextPagePanel.add(this.btnNextPage);
    }

    public void download(boolean bl, int n) {
        int n2 = this.avInfo.getClips().values().size();
        this.download(0, n);
        if (bl) {
            for (int i = 1; i < n2; ++i) {
                this.download(i, n);
            }
        }
    }

    public void downloadCC() {
        int n = this.avInfo.getClips().values().size();
        for (int i = 0; i < n; ++i) {
            this.download(i, 800);
        }
    }

    private void download(int n, int n2) {
        try {
            ClipInfo clipInfo = (ClipInfo)this.avInfo.getClips().values().toArray()[n];
            DownloadRunnable downloadRunnable = new DownloadRunnable(this.avInfo, clipInfo, n2);
            Global.queryThreadPool.execute(downloadRunnable);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
    }

    public JLabel getLbTabTitle() {
        return this.lbTabTitle;
    }

    public void setLbTabTitle(JLabel jLabel) {
        this.lbTabTitle = jLabel;
    }

    public JLabel getLbVideoTitle() {
        return this.lbVideoTitle;
    }

    public void setLbVideoTitle(JLabel jLabel) {
        this.lbVideoTitle = jLabel;
    }

    public JLabel getLbAvID() {
        return this.lbAvID;
    }

    public void setLbAvID(JLabel jLabel) {
        this.lbAvID = jLabel;
    }

    public JLabel getLbBreif() {
        return this.lbBreif;
    }

    public void setLbBreif(JLabel jLabel) {
        this.lbBreif = jLabel;
    }

    public JLabel getLbAvPrivew() {
        return this.lbAvPrivew;
    }

    public void setLbAvPrivew(JLabel jLabel) {
        this.lbAvPrivew = jLabel;
    }

    public JScrollPane getJpScorll() {
        return this.jpScorll;
    }

    public void setJpScorll(JScrollPane jScrollPane) {
        this.jpScorll = jScrollPane;
    }

    public JPanel getJpContent() {
        return this.jpContent;
    }

    public void setJpContent(JPanel jPanel) {
        this.jpContent = jPanel;
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        JLabel jLabel = (JLabel)mouseEvent.getSource();
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        String string = null;
        string = jLabel == this.lbAvPrivew ? (this.currentDisplayPic != null ? this.currentDisplayPic : this.avInfo.getVideoPreview()) : jLabel.getText();
        if (string != null) {
            StringSelection stringSelection = new StringSelection(string);
            clipboard.setContents(stringSelection, null);
        }
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        JLabel jLabel = (JLabel)mouseEvent.getSource();
        jLabel.setBorder(BorderFactory.createLineBorder(Color.black, 3));
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        JLabel jLabel = (JLabel)mouseEvent.getSource();
        jLabel.setBorder(BorderFactory.createLineBorder(Color.red));
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    public VideoInfo getAvInfo() {
        return this.avInfo;
    }

    public void setAvInfo(VideoInfo videoInfo) {
        this.avInfo = videoInfo;
    }

    public String getCurrentDisplayPic() {
        return this.currentDisplayPic;
    }

    public void setCurrentDisplayPic(String string) {
        this.currentDisplayPic = string;
    }
}

