/*
 * Decompiled with CFR 0.152.
 */
package nicelee.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.net.URL;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import nicelee.bilibili.INeedAV;
import nicelee.bilibili.model.FavList;
import nicelee.bilibili.util.Logger;
import nicelee.ui.Global;
import nicelee.ui.TabVideo;
import nicelee.ui.item.JOptionPane;
import nicelee.ui.item.MJButton;
import nicelee.ui.item.MJTabVideo;
import nicelee.ui.item.MJTextField;
import nicelee.ui.thread.GetVideoDetailThread;
import nicelee.ui.thread.LoginThread;

public class TabIndex
extends JPanel
implements ActionListener,
MouseListener,
ItemListener {
    private static final long serialVersionUID = -5829023045158490349L;
    public ImageIcon imgIconHeaderDefault = new ImageIcon(this.getClass().getResource("/resources/header.png"));
    public ImageIcon backgroundIcon = Global.backgroundImg;
    public JLabel jlHeader;
    public JComboBox<Object> cmbFavList = new JComboBox();
    String placeHolder = "\u8bf7\u5728\u6b64\u8f93\u5165B\u7ad9 BV/av/ep/ss/md/ml\u53f7\u6216\u5730\u5740";
    JTextField txtSearch = new MJTextField(this.placeHolder);
    JButton btnSearch = new MJButton("\u67e5\u627e");
    JButton btnSearchNextPage = new MJButton("\u4e0b\u4e00\u9875");
    JTextArea consoleArea = new JTextArea(20, 50);
    JTabbedPane jTabbedpane;
    static Pattern paramPattern = Pattern.compile("(.*)p=([0-9]+)$");

    public TabIndex(JTabbedPane jTabbedPane) {
        this.jTabbedpane = jTabbedPane;
        this.init();
    }

    public void init() {
        this.setPreferredSize(new Dimension(1150, 620));
        JLabel jLabel = new JLabel();
        jLabel.setPreferredSize(new Dimension(920, 80));
        this.add(jLabel);
        this.imgIconHeaderDefault = new ImageIcon(this.imgIconHeaderDefault.getImage().getScaledInstance(80, 80, 1));
        this.jlHeader = new JLabel(this.imgIconHeaderDefault);
        this.jlHeader.addMouseListener(this);
        this.add(this.jlHeader);
        URL uRL = this.getClass().getResource("/resources/title.png");
        ImageIcon imageIcon = new ImageIcon(uRL);
        JLabel jLabel2 = new JLabel(imageIcon);
        this.add(jLabel2);
        JPanel jPanel = new JPanel();
        this.txtSearch.setPreferredSize(new Dimension(680, 40));
        this.btnSearch.addActionListener(this);
        this.btnSearch.setPreferredSize(new Dimension(80, 40));
        this.btnSearchNextPage.addActionListener(this);
        this.btnSearchNextPage.setPreferredSize(new Dimension(80, 40));
        this.cmbFavList.addItem("---\u6211\u7684\u6536\u85cf\u5939---");
        this.cmbFavList.setPreferredSize(new Dimension(120, 40));
        this.cmbFavList.addItemListener(this);
        jPanel.add(this.txtSearch);
        jPanel.add(this.btnSearch);
        jPanel.add(this.btnSearchNextPage);
        jPanel.add(this.cmbFavList);
        jPanel.setOpaque(false);
        this.add(jPanel);
        this.setOpaque(false);
    }

    public void closeAllVideoTabs() {
        System.out.println("\u5f53\u524dTab\u6570\u91cf\uff1a " + (this.jTabbedpane.getTabCount() - 2));
        System.out.println("\u6b63\u5728\u5173\u95edTab\u6807\u7b7e\u9875");
        for (int i = this.jTabbedpane.getTabCount() - 1; i >= 2; --i) {
            this.jTabbedpane.removeTabAt(i);
        }
        System.out.println("\u5f53\u524dTab\u6570\u91cf\uff1a " + (this.jTabbedpane.getTabCount() - 2));
    }

    public void downVideoTabs(boolean bl, int n) {
        for (int i = 0; i < this.jTabbedpane.getTabCount(); ++i) {
            System.out.printf("Tab \u9875\u5171 %d \u4e2a\uff0c\u5f53\u524d\u7b2c %d \u4e2a\r\n", this.jTabbedpane.getTabCount(), i);
            Component component = this.jTabbedpane.getComponentAt(i);
            if (!(component instanceof TabVideo)) continue;
            TabVideo tabVideo = (TabVideo)component;
            tabVideo.download(bl, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paintComponent(Graphics graphics) {
        if (this.ui == null || graphics == null) {
            return;
        }
        Graphics graphics2 = graphics.create();
        Image image = this.backgroundIcon.getImage();
        int n = image.getWidth(this.getParent());
        int n2 = image.getHeight(this.getParent());
        int n3 = 5;
        int n4 = this.getSize().width / (n + n3) + 1;
        int n5 = 5;
        int n6 = this.getSize().height / (n2 + n5) + 1;
        if (n4 >= 3) {
            for (int i = 0; i <= n4; ++i) {
                int n7 = n3 + (n + n3) * i;
                for (int j = 0; j < n6; ++j) {
                    int n8 = n5 + (n2 + n5) * j;
                    graphics2.drawImage(this.backgroundIcon.getImage(), n7, n8, n, n2, this.getParent());
                }
            }
        } else {
            graphics2.drawImage(this.backgroundIcon.getImage(), 0, 0, this.getSize().width, this.getSize().height, this.getParent());
        }
        this.setOpaque(false);
        try {
            this.ui.update(graphics2, this);
        }
        finally {
            graphics2.dispose();
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.btnSearch) {
            this.search();
        } else if (actionEvent.getSource() == this.btnSearchNextPage) {
            String string = this.txtSearch.getText();
            int n = 1;
            String string2 = null;
            Matcher matcher = paramPattern.matcher(string);
            if (matcher.find()) {
                n = Integer.parseInt(matcher.group(2));
                string2 = matcher.group(1) + "p=" + (n + 1);
            } else {
                string2 = string + " p=" + (n + 1);
            }
            this.txtSearch.setText(string2);
            this.search();
        }
    }

    public void search() {
        String string = this.txtSearch.getText();
        if (!this.placeHolder.equals(string)) {
            INeedAV iNeedAV = new INeedAV();
            string = iNeedAV.getValidID(string);
            Logger.println("\u5f53\u524d\u89e3\u6790\u7684id\u4e3a\uff1a" + string);
            this.popVideoInfoTab(string);
        }
    }

    private void popVideoInfoTab(String string) {
        if ("".equals(string)) {
            JOptionPane.showMessageDialog(this, "\u89e3\u6790\u94fe\u63a5\u5931\u8d25!", "\u5931\u8d25", 2);
            return;
        }
        JLabel jLabel = new JLabel("\u6b63\u5728\u52a0\u8f7d\u4e2d...");
        MJTabVideo mJTabVideo = new MJTabVideo(this.jTabbedpane, jLabel, string);
        this.jTabbedpane.addTab("\u4f5c\u54c1\u9875", mJTabVideo);
        this.jTabbedpane.setTabComponentAt(this.jTabbedpane.indexOfComponent(mJTabVideo), jLabel);
        GetVideoDetailThread getVideoDetailThread = new GetVideoDetailThread(mJTabVideo, string);
        getVideoDetailThread.start();
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        if (mouseEvent.getSource() == this.jlHeader) {
            Global.needToLogin = true;
            LoginThread loginThread = new LoginThread();
            loginThread.start();
        }
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        if (mouseEvent.getSource() == this.jlHeader) {
            this.jlHeader.setBorder(BorderFactory.createLineBorder(Color.red));
        }
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        if (mouseEvent.getSource() == this.jlHeader) {
            this.jlHeader.setBorder(null);
        }
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getStateChange() == 1) {
            if (itemEvent.getItem() instanceof FavList) {
                FavList favList = (FavList)itemEvent.getItem();
                String string = "https://space.bilibili.com/%s/favlist?fid=%s&ftype=create";
                string = String.format(string, favList.getOwnerId(), favList.getfId());
                this.txtSearch.setText(string);
                this.txtSearch.setForeground(Color.BLACK);
                this.search();
            } else if ("\u7a0d\u540e\u518d\u770b".equals(itemEvent.getItem().toString())) {
                this.txtSearch.setText("https://www.bilibili.com/watchlater/#/list");
                this.txtSearch.setForeground(Color.BLACK);
                this.search();
            }
        }
    }
}

