/*
 * Decompiled with CFR 0.152.
 */
package nicelee.server.core;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.net.Socket;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import nicelee.bilibili.PackageScanLoader;
import nicelee.bilibili.annotations.Controller;
import nicelee.bilibili.annotations.Value;
import nicelee.server.util.ResponseUtil;

public class PathDealer {
    protected Socket socketClient;

    public PathDealer() {
    }

    public PathDealer(Socket socket) {
        this.socketClient = socket;
    }

    public void dealRequest(BufferedWriter bufferedWriter, OutputStream outputStream, String string, String string2, String string3, HashMap<String, String> hashMap) throws IOException {
        this.dealRequest(bufferedWriter, outputStream, string, string2, string3, hashMap, false);
    }

    public void dealRequest(BufferedWriter bufferedWriter, OutputStream outputStream, String string, String string2, String string3, HashMap<String, String> hashMap, boolean bl) throws IOException {
        Method method = null;
        if ((method = this.findMethod(string, method)) != null) {
            this.dealWithPathKnown(bufferedWriter, outputStream, string, string2, string3, method, hashMap);
        } else {
            this.dealWithPathUnknown(bufferedWriter, string, bl);
        }
    }

    private Method findMethod(String string, Method method) {
        block0: for (Class<?> clazz : PackageScanLoader.controllerClazzes) {
            Controller controller = clazz.getAnnotation(Controller.class);
            String string2 = controller.path();
            for (Method method2 : clazz.getMethods()) {
                Controller controller2 = method2.getAnnotation(Controller.class);
                if (controller2 != null && controller2.specificPath().equals(string)) {
                    method = method2;
                    continue block0;
                }
                if (controller2 == null || !controller2.specificPath().isEmpty() && controller2.path().isEmpty()) continue;
                String string3 = string2 + controller2.path();
                if (controller2.matchAll()) {
                    if (!string3.equals(string)) continue;
                    method = method2;
                    continue block0;
                }
                if (string == null || !string.startsWith(string3)) continue;
                method = method2;
                continue block0;
            }
        }
        return method;
    }

    private void dealWithPathKnown(BufferedWriter bufferedWriter, OutputStream outputStream, String string, String string2, String string3, Method method, HashMap<String, String> hashMap) {
        block19: {
            Class<?> clazz = method.getDeclaringClass();
            Annotation[][] annotationArray = method.getParameterAnnotations();
            Class<?>[] classArray = method.getParameterTypes();
            Object[] objectArray = new Object[classArray.length];
            for (int i = 0; i < classArray.length; ++i) {
                if (classArray[i] == BufferedWriter.class) {
                    objectArray[i] = bufferedWriter;
                    continue;
                }
                if (classArray[i] == OutputStream.class) {
                    objectArray[i] = outputStream;
                    continue;
                }
                if (annotationArray[i].length > 0) {
                    Value value = (Value)annotationArray[i][0];
                    switch (value.key()) {
                        case "pathData": {
                            objectArray[i] = string;
                            break;
                        }
                        case "postData": {
                            objectArray[i] = string3;
                            break;
                        }
                        case "ipData": {
                            objectArray[i] = this.getRealIpAddr(hashMap);
                            break;
                        }
                        case "paramData": {
                            objectArray[i] = string2;
                            break;
                        }
                        default: {
                            objectArray[i] = PathDealer.getValue(string2, value.key());
                            break;
                        }
                    }
                    continue;
                }
                objectArray[i] = null;
            }
            try {
                String string4 = (String)method.invoke(clazz.newInstance(), objectArray);
                if (string4 == null) break block19;
                bufferedWriter.write(string4);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                System.out.println(clazz.getName());
                System.out.println(method.getName());
                for (Object object : objectArray) {
                    System.out.println(object);
                }
            }
        }
    }

    private void dealWithPathUnknown(BufferedWriter bufferedWriter, String string, boolean bl) throws IOException {
        ResponseUtil.response404NotFound(bufferedWriter);
        ResponseUtil.responseHeader(bufferedWriter, "Content-Type", "text/html; charset=UTF-8");
        ResponseUtil.endResponseHeader(bufferedWriter);
        if (bl) {
            bufferedWriter.write("command not found");
            return;
        }
        bufferedWriter.write("<html><head><title>Index</title></head><body><ul>");
        for (Class<?> clazz : PackageScanLoader.controllerClazzes) {
            Controller controller = clazz.getAnnotation(Controller.class);
            String string2 = controller.path();
            bufferedWriter.write("<li><a href=\"");
            bufferedWriter.write(controller.path());
            bufferedWriter.write("\">");
            bufferedWriter.write(controller.note());
            bufferedWriter.write("</a><br/>\r\n<ul>");
            for (Method method : clazz.getMethods()) {
                Controller controller2 = method.getAnnotation(Controller.class);
                if (controller2 == null || !controller2.specificPath().isEmpty() && controller2.path().isEmpty()) continue;
                String string3 = string2 + controller2.path();
                if (string != null && !string3.startsWith(string)) continue;
                bufferedWriter.write("<li>");
                bufferedWriter.write(controller2.note());
                bufferedWriter.write("<br/>\r\n<a href=\"");
                bufferedWriter.write(string3);
                bufferedWriter.write("\">");
                bufferedWriter.write(string3);
                bufferedWriter.write("</a><br/>\r\n<br/>\r\n</li>");
            }
            bufferedWriter.write("</ul></li><hr/>");
        }
        bufferedWriter.write("</ul></body></html>");
        ResponseUtil.endResponse(bufferedWriter);
    }

    public static String getValue(String string, String string2) {
        Pattern pattern = Pattern.compile(string2 + "=([^&]*)");
        Matcher matcher = pattern.matcher(string);
        if (matcher.find()) {
            return matcher.group(1);
        }
        return null;
    }

    private String getRealIpAddr(HashMap<String, String> hashMap) {
        String string = hashMap.get("x-forwarded-for");
        if (string != null && string.length() != 0 && !"unknown".equalsIgnoreCase(string) && string.indexOf(",") != -1) {
            string = string.split(",")[0];
        }
        if (string == null || string.length() == 0 || "unknown".equalsIgnoreCase(string)) {
            string = hashMap.get("proxy-client-ip");
        }
        if (string == null || string.length() == 0 || "unknown".equalsIgnoreCase(string)) {
            string = hashMap.get("wl-proxy-client-ip");
        }
        if (string == null || string.length() == 0 || "unknown".equalsIgnoreCase(string)) {
            string = hashMap.get("http_client_ip");
        }
        if (string == null || string.length() == 0 || "unknown".equalsIgnoreCase(string)) {
            string = hashMap.get("http_x_forwarded_for");
        }
        if (string == null || string.length() == 0 || "unknown".equalsIgnoreCase(string)) {
            string = hashMap.get("x-real-ip");
        }
        if (string == null || string.length() == 0 || "unknown".equalsIgnoreCase(string)) {
            string = this.socketClient.getInetAddress().toString().replace("/", "");
        }
        return string;
    }
}

