/*
 * Decompiled with CFR 0.152.
 */
package nicelee.bilibili.util.danmuku;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import nicelee.bilibili.util.danmuku.Danmuku;

public class Xml2Ass {
    int width = 1920;
    int height = 1080;

    public Xml2Ass(int n, int n2) {
        this.width = n;
        this.height = n2;
    }

    public Xml2Ass() {
        this(1920, 1080);
    }

    public static void main(String[] stringArray) {
        try {
            Xml2Ass xml2Ass = new Xml2Ass(1080, 720);
            List<Danmuku> list = xml2Ass.readXml("D:\\Workspace\\javaweb-springboot\\BilibiliDown\\release\\download\\\u60dc\u7f18\u3001\u8fc7\u53bb\\\u3010\u4e1e\u76f8\u53f8\u5f92\u3011\u72ed\u8def\u76f8\u9022\u52c7\u8005\u80dc-\u6570\u661f\u661f2_x264.xml");
            xml2Ass.writeAss(list, "D:\\Workspace\\javaweb-springboot\\BilibiliDown\\release\\download\\\u60dc\u7f18\u3001\u8fc7\u53bb\\\u3010\u4e1e\u76f8\u53f8\u5f92\u3011\u72ed\u8def\u76f8\u9022\u52c7\u8005\u80dc-pn1-p1-\u6570\u661f\u661f2_x264-80.ass");
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public List<Danmuku> readXml(String string) throws IOException {
        File file = new File(string);
        return this.readXml(file);
    }

    public List<Danmuku> readXml(File file) throws IOException {
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), "utf-8"));
        ArrayList<Danmuku> arrayList = new ArrayList<Danmuku>();
        Pattern pattern = Pattern.compile("<d p=\"([^,]*),([^,]*),([^,]*),([^,]*),([^,]*),([^,]*),([^,]*),([^,]*)(?:,[0-9]*)?\">(.*?)</d>");
        String string = bufferedReader.readLine();
        while (string != null) {
            Matcher matcher = pattern.matcher(string);
            while (matcher.find()) {
                double d = Double.parseDouble(matcher.group(1));
                int n = Integer.parseInt(matcher.group(2));
                if (n >= 1 & n <= 3) {
                    n = 0;
                } else {
                    if (n > 8) continue;
                    n -= 3;
                }
                int n2 = Integer.parseInt(matcher.group(3));
                if (n2 <= 12) {
                    n2 = 0;
                } else if (n2 <= 16) {
                    n2 = 1;
                } else if (n2 <= 18) {
                    n2 = 2;
                } else if (n2 <= 25) {
                    n2 = 3;
                } else if (n2 <= 36) {
                    n2 = 4;
                } else if (n2 <= 45) {
                    n2 = 5;
                } else {
                    if (n2 > 64) continue;
                    n2 = 6;
                }
                int n3 = Integer.parseInt(matcher.group(4));
                Danmuku danmuku = new Danmuku(d, n, n2, n3, matcher.group(9));
                arrayList.add(danmuku);
            }
            string = bufferedReader.readLine();
        }
        bufferedReader.close();
        arrayList.sort(new Comparator<Danmuku>(){

            @Override
            public int compare(Danmuku danmuku, Danmuku danmuku2) {
                Double d = danmuku.getTime();
                Double d2 = danmuku2.getTime();
                return d.compareTo(d2);
            }
        });
        return arrayList;
    }

    public void writeAss(List<Danmuku> list, String string) throws IOException {
        File file = new File(string);
        this.writeAss(list, file);
    }

    public void writeAss(List<Danmuku> list, File file) throws IOException {
        int n;
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        fileOutputStream.write(239);
        fileOutputStream.write(187);
        fileOutputStream.write(191);
        BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)fileOutputStream, Charset.forName("UTF-8")));
        bufferedWriter.write("[Script Info]\r\n");
        bufferedWriter.write("Title: Bilibili\u5f39\u5e55\u8f6cASS\u5b57\u5e55\r\n");
        bufferedWriter.write("Original Script: \u7531 https://github.com/nICEnnnnnnnLee \u5236\u4f5c\r\n");
        bufferedWriter.write("ScriptType: v4.00+\r\n");
        bufferedWriter.write("Collisions: Normal\r\n");
        bufferedWriter.write(String.format("PlayResX: %d\r\n", this.width));
        bufferedWriter.write(String.format("PlayResY: %d\r\n", this.height));
        bufferedWriter.write(String.format("Aspect Ratio: %d:%d\r\n", this.width, this.height));
        bufferedWriter.write("YCbCr Matrix: TV.601\r\n");
        bufferedWriter.write("[V4+ Styles]\r\n");
        bufferedWriter.write("Format: Name, Fontname, Fontsize, PrimaryColour, SecondaryColour, OutlineColour, BackColour, Bold, Italic, Underline, StrikeOut, ScaleX, ScaleY, Spacing, Angle, BorderStyle, Outline, Shadow, Alignment, MarginL, MarginR, MarginV, Encoding\r\n");
        for (n = 0; n <= 6; ++n) {
            String string = String.format("Style: %s,Microsoft YaHei UI,%d,&H66FFFFFF,&H66FFFFFF,&H66000000,&H66000000,0,0,0,0,100,100,0,0,1,1,1,2,20,20,2,0\r\n", Danmuku.getFontTypeStr(n), Danmuku.getFontSize(n));
            bufferedWriter.write(string);
        }
        bufferedWriter.write("[Events]\r\n");
        bufferedWriter.write("Format: Layer, Start, End, Style, Name, MarginL, MarginR, MarginV, Effect, Text\r\n");
        n = Danmuku.getFontSize(3);
        int n2 = Danmuku.getFontSize(6);
        int n3 = 0;
        int n4 = 0;
        int n5 = this.height - n2;
        for (Danmuku danmuku : list) {
            int n6;
            int n7;
            String string;
            String string2;
            String string3;
            String string4 = danmuku.getContent();
            if (danmuku.getType() == 0) {
                string3 = Danmuku.getFormatTime(danmuku.getTime());
                string2 = Danmuku.getFormatTime(danmuku.getTime() + 10.0);
                string = Danmuku.getFontTypeStr(danmuku.getFontSizeType());
                n7 = this.width;
                n6 = n3;
                int n8 = 0 - Danmuku.getFontSize(danmuku.getFontSizeType()) * string4.length() * 2;
                int n9 = n3;
                String string5 = Danmuku.getColor(danmuku.getFontColor());
                String string6 = String.format("Dialogue: 2,%s,%s,%s,,0000,0000,0000,,{\\move(%d, %d, %d, %d)\\c&H%s&}%s\r\n", string3, string2, string, n7, n6, n8, n9, string5, string4);
                bufferedWriter.write(string6);
                if ((n3 += n) < this.height - n2) continue;
                n3 = 0;
                continue;
            }
            if (danmuku.getType() == 1) {
                string3 = Danmuku.getFormatTime(danmuku.getTime());
                string2 = Danmuku.getFormatTime(danmuku.getTime() + 5.0);
                string = Danmuku.getFontTypeStr(danmuku.getFontSizeType());
                n7 = this.width / 2;
                n6 = n5;
                String string7 = Danmuku.getColor(danmuku.getFontColor());
                String string8 = String.format("Dialogue: 2,%s,%s,%s,,0000,0000,0000,,{\\an8\\pos(%d, %d)\\c&H%s&}%s\r\n", string3, string2, string, n7, n6, string7, string4);
                bufferedWriter.write(string8);
                if ((n5 -= n) > this.height / 2) continue;
                n5 = this.height - n2;
                continue;
            }
            if (danmuku.getType() != 2) continue;
            string3 = Danmuku.getFormatTime(danmuku.getTime());
            string2 = Danmuku.getFormatTime(danmuku.getTime() + 5.0);
            string = Danmuku.getFontTypeStr(danmuku.getFontSizeType());
            n7 = this.width / 2;
            n6 = n4;
            String string9 = Danmuku.getColor(danmuku.getFontColor());
            String string10 = String.format("Dialogue: 2,%s,%s,%s,,0000,0000,0000,,{\\an8\\pos(%d, %d)\\c&H%s&}%s\r\n", string3, string2, string, n7, n6, string9, string4);
            bufferedWriter.write(string10);
            if ((n4 += n) < this.height / 2) continue;
            n4 = 0;
        }
        bufferedWriter.flush();
        bufferedWriter.close();
        fileOutputStream.close();
    }
}

