/*
 * Decompiled with CFR 0.152.
 */
package nicelee.bilibili.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.lang.management.ManagementFactory;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import nicelee.bilibili.INeedAV;
import nicelee.bilibili.model.VideoInfo;
import nicelee.bilibili.util.CmdUtil;
import nicelee.bilibili.util.ConfigUtil;
import nicelee.bilibili.util.HttpHeaders;
import nicelee.bilibili.util.HttpRequestUtil;
import nicelee.bilibili.util.Logger;
import nicelee.bilibili.util.ResourcesUtil;
import nicelee.ui.Global;
import nicelee.ui.item.JOptionPane;
import nicelee.ui.thread.DownloadRunnable;
import org.json.JSONArray;
import org.json.JSONObject;

public class VersionManagerUtil {
    static HttpRequestUtil util = new HttpRequestUtil();
    static HttpHeaders headers = new HttpHeaders();
    public static String downUrl;
    public static String downName;
    public static String versionTag;
    public static String versionName;
    public static String changelogs;
    private static final Pattern versionPattern;

    public static boolean queryLatestVersion() {
        if (downUrl != null) {
            return VersionManagerUtil.isLatestVer(versionTag, Global.version);
        }
        String string = util.getContent("https://api.github.com/repos/nICEnnnnnnnLee/BilibiliDown/releases?per_page=1", headers.getHeaders());
        Logger.println(string);
        JSONObject jSONObject = new JSONArray(string).getJSONObject(0);
        versionTag = jSONObject.getString("tag_name").trim().toLowerCase();
        versionName = jSONObject.getString("name");
        changelogs = jSONObject.getString("body");
        JSONArray jSONArray = jSONObject.getJSONArray("assets");
        for (int i = 0; i < jSONArray.length(); ++i) {
            JSONObject jSONObject2 = jSONArray.getJSONObject(i);
            String string2 = jSONObject2.getString("name");
            Pattern pattern = Pattern.compile("^BilibiliDown.v[0-9\\.]+.release.zip$");
            if (!pattern.matcher(string2).find()) continue;
            downName = string2;
            downUrl = jSONObject2.getString("browser_download_url");
            break;
        }
        return VersionManagerUtil.isLatestVer(versionTag, Global.version);
    }

    private static boolean isLatestVer(String string, String string2) {
        Matcher matcher = versionPattern.matcher(string);
        matcher.find();
        int n = Integer.parseInt(matcher.group(1));
        int n2 = Integer.parseInt(matcher.group(2));
        Matcher matcher2 = versionPattern.matcher(string2);
        matcher2.find();
        int n3 = Integer.parseInt(matcher2.group(1));
        int n4 = Integer.parseInt(matcher2.group(2));
        return n3 > n || n3 == n && n4 >= n2;
    }

    public static void downloadLatestVersion() throws Exception {
        if (!VersionManagerUtil.queryLatestVersion()) {
            JOptionPane.showMessageDialog(null, changelogs, "\u66f4\u65b0\u65e5\u5fd7", 1);
            VideoInfo videoInfo = new INeedAV().getVideoDetail(downName, 0, false);
            DownloadRunnable downloadRunnable = new DownloadRunnable(videoInfo, videoInfo.getClips().get(1234L), 0);
            Global.queryThreadPool.execute(downloadRunnable);
        } else {
            System.out.print("\u5f53\u524d\u7248\u672c\u5df2\u662f\u6700\u65b0\uff0c\u65e0\u9700\u66f4\u65b0");
        }
    }

    private static void unzipTargetJar() throws IOException {
        VersionManagerUtil.unzipTargetJar(downName);
    }

    public static void unzipTargetJar(String string) throws IOException {
        int n;
        File file = new File(ResourcesUtil.baseDirectory(), "update");
        File file2 = new File(file, string);
        ZipInputStream zipInputStream = new ZipInputStream(new FileInputStream(file2));
        ZipEntry zipEntry = null;
        FileOutputStream fileOutputStream = null;
        byte[] byArray = new byte[1024];
        File file3 = new File(file, "INeedBiliAV.update.jar");
        if (file3.exists()) {
            file3.delete();
        }
        if (string.contains("pre-release")) {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            zipEntry = zipInputStream.getNextEntry();
            while ((n = zipInputStream.read(byArray)) > 0) {
                byteArrayOutputStream.write(byArray, 0, n);
            }
            byteArrayOutputStream.close();
            zipInputStream.closeEntry();
            zipInputStream.close();
            zipInputStream = new ZipInputStream(new ByteArrayInputStream(byteArrayOutputStream.toByteArray()));
        }
        while ((zipEntry = zipInputStream.getNextEntry()) != null) {
            if ("INeedBiliAV.jar".equals(zipEntry.getName())) {
                fileOutputStream = new FileOutputStream(file3);
                while ((n = zipInputStream.read(byArray)) > 0) {
                    fileOutputStream.write(byArray, 0, n);
                }
                fileOutputStream.close();
                zipInputStream.closeEntry();
                break;
            }
            zipInputStream.closeEntry();
        }
        zipInputStream.close();
    }

    public static void trySelfUpdate(String string) {
        try {
            Class<?> clazz = Class.forName("nicelee.memory.App", true, VersionManagerUtil.class.getClassLoader());
            File file = ResourcesUtil.search("update/INeedBiliAV.update.jar");
            File file2 = ResourcesUtil.search("INeedBiliAV.jar");
            if (file2.delete() && file.renameTo(file2)) {
                if ("1".equals(string)) {
                    clazz.getDeclaredMethod("restartApplication", new Class[0]).invoke(null, new Object[0]);
                }
                System.exit(1);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static void RunCmdAndCloseApp(String string) {
        VersionManagerUtil.trySelfUpdate(string);
        try {
            String string2 = ManagementFactory.getRuntimeMXBean().getName().split("@")[0];
            File file = ResourcesUtil.baseDirFile();
            if (System.getProperty("os.name").toLowerCase().contains("windows")) {
                String[] stringArray = new String[]{"cmd", "/c", "start", "update.bat", string, string2};
                CmdUtil.run(stringArray, file);
            } else {
                System.out.println(System.getProperty("os.name").toLowerCase());
                VersionManagerUtil.copy(VersionManagerUtil.class.getResourceAsStream("/resources/update.sh"), new File(ResourcesUtil.baseDirectory(), "update.sh"), false);
                CmdUtil.run(new String[]{"chmod", "+x", "./update.sh"}, file);
                String[] stringArray = new String[]{"./update.sh", "@" + string, string2, "bilibili.log"};
                if (!CmdUtil.run(stringArray, file)) {
                    JOptionPane.showMessageDialog(null, "update.sh\u8fd0\u884c\u5931\u8d25\u3002\u4f60\u9700\u8981\u8d4b\u4e88\u5176\u53ef\u6267\u884c\u6743\u9650\u3002\n\u8bf7\u5173\u95ed\u7a0b\u5e8f\uff0c\u7136\u540e\u6267\u884c\u547d\u4ee4\u884c\uff1a\nsudo chmod +x ./update.sh && ./update.sh", "!", 1);
                    return;
                }
            }
            System.exit(1);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static void copy(InputStream inputStream, File file, boolean bl) {
        try {
            if (file.exists()) {
                if (bl) {
                    file.delete();
                } else {
                    return;
                }
            }
            RandomAccessFile randomAccessFile = new RandomAccessFile(file, "rw");
            byte[] byArray = new byte[0x100000];
            int n = inputStream.read(byArray);
            while (n != -1) {
                randomAccessFile.write(byArray, 0, n);
                n = inputStream.read(byArray);
            }
            inputStream.close();
            randomAccessFile.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static void main(String[] stringArray) {
        block5: {
            ConfigUtil.initConfigs();
            if (!VersionManagerUtil.queryLatestVersion()) {
                System.out.println("\u6b63\u5728\u4e0b\u8f7d: " + downName);
                try {
                    util.setSavePath("update/");
                    if (util.download(downUrl, downName, headers.getHeaders())) {
                        VersionManagerUtil.unzipTargetJar();
                        System.exit(1);
                        break block5;
                    }
                    System.out.printf("\u4e0b\u8f7d %s \u5931\u8d25\n", downName);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    System.out.printf("\u4e0b\u8f7d %s \u5931\u8d25\n", downName);
                }
            } else {
                System.out.printf("\u5f53\u524d\u7248\u672c%s\u5df2\u662f\u6700\u65b0\uff0c\u65e0\u9700\u66f4\u65b0", Global.version);
                System.exit(0);
            }
        }
        System.exit(-1);
    }

    static {
        versionPattern = Pattern.compile("v([0-9]+)\\.([0-9]+)");
    }
}

