/*
 * Decompiled with CFR 0.152.
 */
package nicelee.bilibili.util;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Collections;
import java.util.HashMap;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import nicelee.bilibili.util.Logger;
import nicelee.bilibili.util.ResourcesUtil;
import nicelee.bilibili.util.convert.ConvertUtil;
import nicelee.bilibili.util.custom.System;
import nicelee.ui.Global;
import nicelee.ui.item.JOptionPane;

public class RepoUtil {
    static Pattern standardAvPattern;
    static boolean definitionStrictMode;
    static File fRepo;
    static Set<String> downRepo;
    static Thread convertThread;

    public static void init(boolean bl) {
        definitionStrictMode = Global.repoInDefinitionStrictMode;
        if (fRepo == null || bl) {
            fRepo = ResourcesUtil.sourceOf("config/repo.config");
            if (!fRepo.exists()) {
                try {
                    fRepo.createNewFile();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            standardAvPattern = Pattern.compile("^((?:av|h|cv|opus|BV|season|au|edd_)[0-9a-zA-Z_]+)-([0-9]+)(-p[0-9]+)$");
            int n = 310;
            try {
                long l = fRepo.length();
                long l2 = l / 19L + 233L;
                n = (int)((float)l2 / 0.75f);
            }
            catch (Exception exception) {
                // empty catch block
            }
            downRepo = Collections.newSetFromMap(new ConcurrentHashMap(n));
        }
        BufferedReader bufferedReader = null;
        try {
            String string;
            bufferedReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(fRepo), "utf-8"));
            while ((string = bufferedReader.readLine()) != null) {
                Matcher matcher = standardAvPattern.matcher(string);
                if (!matcher.find()) continue;
                if (string.startsWith("av")) {
                    String string2 = ConvertUtil.Av2Bv(matcher.group(1));
                    StringBuilder stringBuilder = new StringBuilder(string2);
                    if (definitionStrictMode) {
                        stringBuilder.append("-").append(matcher.group(2)).append(matcher.group(3));
                    } else {
                        stringBuilder.append(matcher.group(3));
                    }
                    downRepo.add(stringBuilder.toString());
                    System.out.println(stringBuilder.toString());
                    continue;
                }
                if (definitionStrictMode) {
                    downRepo.add(string);
                    continue;
                }
                downRepo.add(matcher.group(1) + matcher.group(3));
            }
            bufferedReader.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public static boolean isInRepo(String string) {
        System.out.println("\u67e5\u8be2\u8bb0\u5f55" + string);
        if (string.contains("-800-") || string.contains("-801-") || string.startsWith("FFmpeg")) {
            return false;
        }
        if (definitionStrictMode) {
            return downRepo.contains(string);
        }
        Matcher matcher = standardAvPattern.matcher(string);
        if (matcher.find()) {
            return downRepo.contains(matcher.group(1) + matcher.group(3));
        }
        return false;
    }

    public static void appendAndSave(String string) {
        Matcher matcher;
        System.out.println("\u5df2\u5b8c\u6210\u4e0b\u8f7d\uff1a " + string);
        if (string.contains("-800-") || string.contains("-801-")) {
            Logger.println("\u5b57\u5e55/\u5f39\u5e55\u6587\u4ef6\uff0c\u4e0d\u8ba1\u5165\u4e0b\u8f7d\u8bb0\u5f55");
            return;
        }
        if (!RepoUtil.isInRepo(string) && (matcher = standardAvPattern.matcher(string)).find()) {
            if (definitionStrictMode) {
                downRepo.add(string);
            } else {
                downRepo.add(matcher.group(1) + matcher.group(3));
            }
            RepoUtil.appendRecordToFile(string);
        }
    }

    public static void convert() {
        if (convertThread == null) {
            convertThread = new Thread(new Runnable(){

                @Override
                public void run() {
                    RepoUtil.convertSync();
                    System.out.println("\u8f6c\u6362\u7ed3\u675f");
                    convertThread = null;
                }
            });
            convertThread.start();
        }
    }

    public static void stopConvert() {
        if (convertThread != null) {
            convertThread.interrupt();
            System.out.println("\u4eba\u4e3a\u8f6c\u6362\u7ed3\u675f");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    static void convertSync() {
        Pattern pattern = Pattern.compile("^av([0-9a-zA-Z]+)(-[0-9]+-p[0-9]+)$");
        File file = ResourcesUtil.sourceOf("config/repo.config");
        File file2 = ResourcesUtil.sourceOf("config/repo.new.config");
        HashMap<String, String> hashMap = new HashMap<String, String>();
        BufferedReader bufferedReader = null;
        BufferedWriter bufferedWriter = null;
        int n = 0;
        try {
            bufferedReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file2), "utf-8"));
            while (bufferedReader.readLine() != null) {
                ++n;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            Object object;
            String string;
            bufferedReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), "utf-8"));
            bufferedWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file2, true), "utf-8"));
            int n2 = 0;
            while ((string = bufferedReader.readLine()) != null) {
                if (++n2 % 100 == 0) {
                    System.out.println("\u5f53\u524d\u8f6c\u6362\u8fdb\u5ea6\uff1a " + n2);
                }
                if (n2 <= n) continue;
                Thread.sleep(0L);
                object = pattern.matcher(string);
                String string2 = null;
                if (((Matcher)object).find()) {
                    String string3 = ((Matcher)object).group(1);
                    String string4 = (String)hashMap.get(string3);
                    if (string4 == null) {
                        string4 = ConvertUtil.Av2Bv(Long.parseLong(string3));
                        hashMap.put(string3, string4);
                        string2 = string4 + ((Matcher)object).group(2);
                    } else {
                        string2 = string4 + ((Matcher)object).group(2);
                    }
                } else {
                    string2 = string;
                }
                bufferedWriter.write(string2);
                bufferedWriter.newLine();
            }
            bufferedReader.close();
            bufferedWriter.close();
            object = ResourcesUtil.sourceOf("config/repo.config.bk" + System.currentTimeMillis() / 1000L);
            ResourcesUtil.copy(file, (File)object);
            file.delete();
            ResourcesUtil.copy(file2, file);
            file2.delete();
            JOptionPane.showMessageDialog(null, "\u8f6c\u6362\u5b8c\u6bd5, \u8bf7\u91cd\u65b0\u52a0\u8f7d");
        }
        catch (Exception exception) {
            ResourcesUtil.closeQuietly(bufferedReader);
            ResourcesUtil.closeQuietly(bufferedWriter);
            catch (Throwable throwable) {
                ResourcesUtil.closeQuietly(bufferedReader);
                ResourcesUtil.closeQuietly(bufferedWriter);
                throw throwable;
            }
        }
        ResourcesUtil.closeQuietly(bufferedReader);
        ResourcesUtil.closeQuietly(bufferedWriter);
    }

    static synchronized void appendRecordToFile(String string) {
        try {
            FileWriter fileWriter = new FileWriter(fRepo, true);
            fileWriter.write(string);
            fileWriter.write("\n");
            fileWriter.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

