/*
 * Decompiled with CFR 0.152.
 */
package nicelee.bilibili.util;

import java.net.HttpCookie;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import nicelee.bilibili.API;

public class HttpCookies {
    static List<HttpCookie> globalCookies;
    static List<HttpCookie> globalCookiesWithFingerprint;
    static String csrf;
    static String refreshToken;

    public static List<HttpCookie> convertCookies(String string) {
        String[] stringArray;
        String[] stringArray2 = string.split("\n");
        if (stringArray2.length >= 2) {
            refreshToken = stringArray2[1].trim();
        }
        ArrayList<HttpCookie> arrayList = new ArrayList<HttpCookie>();
        for (String string2 : stringArray = stringArray2[0].replaceAll("\\||\r|\n| |\\[|\\]|\"", "").split(",|;|&")) {
            String[] stringArray3 = string2.split("=");
            HttpCookie httpCookie = new HttpCookie(stringArray3[0], stringArray3[1]);
            arrayList.add(httpCookie);
        }
        return arrayList;
    }

    public static List<HttpCookie> getGlobalCookies() {
        return globalCookies;
    }

    public static List<HttpCookie> globalCookiesWithFingerprint() {
        if (globalCookiesWithFingerprint == null) {
            String string = API.getFingerprint();
            globalCookiesWithFingerprint = new ArrayList<HttpCookie>();
            globalCookiesWithFingerprint.addAll(HttpCookies.convertCookies(string));
            if (globalCookies != null) {
                globalCookiesWithFingerprint.addAll(globalCookies);
            }
        }
        return globalCookiesWithFingerprint;
    }

    public static void setGlobalCookies(List<HttpCookie> list) {
        globalCookies = list;
        csrf = null;
        globalCookiesWithFingerprint = null;
    }

    public static String getCsrf() {
        if (csrf == null && globalCookies != null) {
            for (HttpCookie httpCookie : globalCookies) {
                if (!"bili_jct".equals(httpCookie.getName())) continue;
                csrf = httpCookie.getValue();
            }
        }
        return csrf;
    }

    public static String getRefreshToken() {
        return refreshToken;
    }

    public static void setRefreshToken(String string) {
        refreshToken = string;
    }

    public static String map2CookieStr(Map<String, String> map) {
        if (map.isEmpty()) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (Map.Entry<String, String> entry : map.entrySet()) {
            stringBuilder.append(entry.getKey()).append("=").append(entry.getValue()).append("; ");
        }
        return stringBuilder.substring(0, stringBuilder.length() - 2);
    }

    public static String get(String string) {
        for (HttpCookie httpCookie : HttpCookies.globalCookiesWithFingerprint()) {
            if (!string.equals(httpCookie.getName())) continue;
            return httpCookie.getValue();
        }
        return null;
    }

    public static boolean set(String string, String string2) {
        for (HttpCookie httpCookie : HttpCookies.globalCookiesWithFingerprint()) {
            if (!string.equals(httpCookie.getName())) continue;
            httpCookie.setValue(string2);
            return true;
        }
        HttpCookie httpCookie = new HttpCookie(string, string2);
        HttpCookies.globalCookiesWithFingerprint().add(httpCookie);
        return false;
    }
}

