/*
 * Decompiled with CFR 0.152.
 */
package nicelee.bilibili.util;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import nicelee.bilibili.util.ResourcesUtil;
import nicelee.ui.Global;

public class ConfigUtil {
    static final Pattern patternConfig = Pattern.compile("^[ ]*([0-9|a-z|A-Z|.|_]+)[ ]*=[ ]*([^ ]+.*$)");

    public static boolean isRunning() {
        File file = new File(ResourcesUtil.baseDirectory(), "config/.lock");
        try {
            System.out.println(file.getCanonicalPath());
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return file.isFile();
    }

    public static void createLock() {
        File file = new File(ResourcesUtil.baseDirectory(), "config");
        if (!file.exists()) {
            file.mkdirs();
        }
        File file2 = new File(file, ".lock");
        try {
            file2.createNewFile();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public static void deleteLock() {
        File file = new File(ResourcesUtil.baseDirectory(), "config/.lock");
        file.delete();
    }

    public static void initConfigs() {
        try (BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(ConfigUtil.class.getResourceAsStream("/resources/app.config"), Charset.forName("utf-8")));){
            String string = bufferedReader.readLine();
            while (string != null) {
                Matcher matcher = patternConfig.matcher(string);
                if (matcher.find()) {
                    Global.settings.put(matcher.group(1), matcher.group(2).trim());
                }
                string = bufferedReader.readLine();
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        System.out.println("----Config init begin...----");
        ConfigUtil.readConfig("config/app.config");
        ConfigUtil.readConfig("config/user.config");
        System.out.println("----Config ini end...----");
        Global.init();
    }

    public static boolean saveConfig() {
        File file = ResourcesUtil.sourceOf("config/app.config");
        File file2 = new File(file.getParentFile(), "app.config.new");
        try (BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file2), "utf-8"));){
            String string;
            LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>(Global.settings);
            LinkedHashMap<String, String> linkedHashMap2 = new LinkedHashMap<String, String>(linkedHashMap);
            try {
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), "utf-8"));
                Map.Entry entry = null;
                try {
                    string = bufferedReader.readLine();
                    while (string != null) {
                        Matcher matcher = patternConfig.matcher(string);
                        if (matcher.find()) {
                            String string2 = matcher.group(1);
                            String string3 = ((HashMap)linkedHashMap).getOrDefault(string2, matcher.group(2));
                            string = String.format("%s = %s", string2, string3);
                            bufferedWriter.write(string);
                            linkedHashMap2.remove(string2);
                        } else {
                            bufferedWriter.write(string);
                        }
                        bufferedWriter.newLine();
                        string = bufferedReader.readLine();
                    }
                }
                catch (Throwable throwable) {
                    entry = throwable;
                    throw throwable;
                }
                finally {
                    if (bufferedReader != null) {
                        if (entry != null) {
                            try {
                                bufferedReader.close();
                            }
                            catch (Throwable throwable) {
                                ((Throwable)((Object)entry)).addSuppressed(throwable);
                            }
                        } else {
                            bufferedReader.close();
                        }
                    }
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            for (Map.Entry entry : ((HashMap)linkedHashMap2).entrySet()) {
                if (((String)entry.getValue()).isEmpty() || Global.settingsMustCreateManualy.contains(entry.getKey())) continue;
                string = String.format("%s = %s", entry.getKey(), entry.getValue());
                bufferedWriter.write(string);
                bufferedWriter.newLine();
            }
        }
        catch (IOException iOException) {
            System.err.println("\u4fdd\u5b58\u6587\u4ef6\u5931\u8d25!! ");
            return false;
        }
        if (file2.exists()) {
            file.delete();
            return file2.renameTo(file);
        }
        return false;
    }

    private static void readConfig(String string) {
        File file = ResourcesUtil.search(string);
        if (file != null) {
            try (BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), "utf-8"));){
                String string2 = bufferedReader.readLine();
                while (string2 != null) {
                    Matcher matcher = patternConfig.matcher(string2);
                    if (matcher.find()) {
                        Global.settings.put(matcher.group(1), matcher.group(2).trim());
                        System.out.printf("  key-->value:  %s --> %s\r\n", matcher.group(1), matcher.group(2));
                    }
                    string2 = bufferedReader.readLine();
                }
            }
            catch (IOException iOException) {
                System.out.println("\u914d\u7f6e\u6587\u4ef6\u4e0d\u5b58\u5728! ");
            }
        }
    }
}

