/*
 * Decompiled with CFR 0.152.
 */
package nicelee.bilibili.util;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import nicelee.bilibili.model.ClipInfo;
import nicelee.bilibili.model.VideoInfo;
import nicelee.bilibili.util.Logger;
import nicelee.bilibili.util.check.FlvMerger;
import nicelee.bilibili.util.convert.ConvertUtil;
import nicelee.ui.Global;

public class CmdUtil {
    public static String FFMPEG_PATH = "ffmpeg";
    public static File DEFAULT_WORKING_DIR = null;
    private static final File NULL_FILE = new File(System.getProperty("os.name").startsWith("Windows") ? "NUL" : "/dev/null");
    private static final ProcessBuilder.Redirect DISCARD = ProcessBuilder.Redirect.to(NULL_FILE);
    static final Pattern filePattern = Pattern.compile("^(.*)(\\.(mp4|flv))$");
    static final Pattern cmdTxtPattern = Pattern.compile("^(av[0-9]+-[0-9]+-p[0-9]+\\.(flv|mp4))\\.txt$");
    static final Pattern cmdDonePartPattern = Pattern.compile("^av[0-9]+-[0-9]+-p[0-9]+-part[0-9]+\\.(flv|mp4)$");
    static final Pattern cmdPartPattern = Pattern.compile("^(.*)\\.part$");
    static final Pattern standardFileNamePattern = Pattern.compile("^av[0-9]+-[0-9]+-p[0-9]+\\.(flv|mp4)$");
    static final Pattern suffixPattern = Pattern.compile("\\.[^.]+$");
    static String[] suffixs = new String[]{".mp4", ".flv", ".jpg", ".webp", ".png", ".srt", ".ass", ".m4a", ".flac"};
    static Pattern splitUnit = Pattern.compile("avId|numAvId|pAv\\d?|pDisplay\\d?|qn|avTitle|clipTitle|UpName|UpId|listName|listOwnerName|favTime|cTime|\\((?<ifOrUnless0>[\\:!])(?<condition0>[^ ]+) (?<format0>[^\\)]*)\\)|\\[(?<ifOrUnless1>[\\:!])(?<condition1>[^ ]+) (?<format1>[^\\]]*)\\]");

    public static boolean run(String[] stringArray) {
        return CmdUtil.run(stringArray, DEFAULT_WORKING_DIR);
    }

    public static boolean run(String[] stringArray, File file) {
        Process process = null;
        try {
            ProcessBuilder processBuilder = new ProcessBuilder(stringArray).directory(file);
            if (Global.debugCmd) {
                processBuilder.redirectOutput(ProcessBuilder.Redirect.INHERIT);
                processBuilder.redirectError(ProcessBuilder.Redirect.INHERIT);
            } else {
                processBuilder.redirectOutput(DISCARD);
                processBuilder.redirectError(DISCARD);
            }
            process = processBuilder.start();
            process.waitFor();
            System.out.println("process \u6267\u884c\u5b8c\u6bd5");
            return true;
        }
        catch (Exception exception) {
            Logger.println(exception.toString());
            return false;
        }
    }

    public static boolean convert(String string, String string2, String string3) {
        String[] stringArray = CmdUtil.createConvertCmd(string, string2, string3);
        File file = new File(Global.savePath + string3);
        File file2 = new File(Global.savePath + string);
        File file3 = new File(Global.savePath + string2);
        if (!file.exists()) {
            Logger.println("\u4e0b\u8f7d\u5b8c\u6bd5, \u6b63\u5728\u8fd0\u884c\u8f6c\u7801\u7a0b\u5e8f...");
            CmdUtil.run(stringArray);
            if (file.exists() && file.length() > file2.length()) {
                file2.delete();
                file3.delete();
                return true;
            }
        } else {
            Logger.println("\u4e0b\u8f7d\u5b8c\u6bd5");
            return true;
        }
        Logger.println("\u8f6c\u7801\u5b8c\u6bd5");
        return false;
    }

    public static boolean convert(String string, int n) {
        File file = new File(Global.savePath + string);
        if (!file.exists()) {
            Object object;
            String string2;
            Object object2;
            Object object3;
            Logger.println("\u4e0b\u8f7d\u5b8c\u6bd5, \u6b63\u5728\u8fd0\u884c\u8f6c\u7801\u7a0b\u5e8f...");
            if (Global.flvUseFFmpeg) {
                object3 = CmdUtil.createConvertCmd(string, n);
                CmdUtil.run((String[])object3);
            } else {
                object3 = new ArrayList();
                object2 = filePattern.matcher(string);
                ((Matcher)object2).find();
                string2 = ((Matcher)object2).group(1);
                object = ((Matcher)object2).group(2);
                for (int i = 1; i <= n; ++i) {
                    File file2 = new File(Global.savePath, string2 + "-part" + i + (String)object);
                    object3.add(file2);
                }
                try {
                    new FlvMerger().merge((List<File>)object3, file);
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                    return false;
                }
            }
            Logger.println("\u8f6c\u7801\u5b8c\u6bd5");
            if (file.exists()) {
                File file3;
                object3 = filePattern.matcher(string);
                ((Matcher)object3).find();
                object2 = ((Matcher)object3).group(1);
                string2 = ((Matcher)object3).group(2);
                object = new ArrayList();
                long l = 0L;
                for (int i = 1; i <= n; ++i) {
                    file3 = new File(Global.savePath + (String)object2 + "-part" + i + string2);
                    object.add(file3);
                    l += file3.length();
                }
                Logger.println("\u8f6c\u7801\u540e\u6587\u4ef6\u5927\u5c0f: " + file.length());
                Logger.println("\u8f6c\u7801\u524d\u6587\u4ef6\u5927\u5c0f\u548c: " + l);
                if ((double)file.length() >= (double)l * 0.8) {
                    Iterator iterator = object.iterator();
                    while (iterator.hasNext()) {
                        file3 = (File)iterator.next();
                        file3.delete();
                    }
                    CmdUtil.deleteAllInactiveCmdTemp();
                    return true;
                }
            }
        } else {
            Logger.println("\u4e0b\u8f7d\u5b8c\u6bd5");
            return true;
        }
        return false;
    }

    public static String[] createConvertCmd(String string, int n) {
        String[] stringArray;
        try {
            stringArray = filePattern.matcher(string);
            stringArray.find();
            String string2 = stringArray.group(1);
            String string3 = stringArray.group(2);
            File file = new File(Global.savePath);
            file.mkdirs();
            File file2 = new File(file, string + ".txt");
            BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file2), "utf-8"));
            for (int i = 1; i <= n; ++i) {
                bufferedWriter.write("file '");
                bufferedWriter.write(string2 + "-part" + i + string3);
                bufferedWriter.write("'\r\n");
            }
            bufferedWriter.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        stringArray = new String[]{FFMPEG_PATH, "-f", "concat", "-safe", "0", "-i", Global.savePath + string + ".txt", "-c", "copy", Global.savePath + string};
        return stringArray;
    }

    public static void deleteAllInactiveCmdTemp() {
        File file = new File(Global.savePath);
        FilenameFilter filenameFilter = new FilenameFilter(){

            @Override
            public boolean accept(File file, String string) {
                Matcher matcher;
                Matcher matcher2 = cmdTxtPattern.matcher(string);
                if (matcher2.find()) {
                    File file2 = new File(file, matcher2.group(1));
                    return file2.exists();
                }
                if (Global.restrictTempMode && (matcher = cmdPartPattern.matcher(string)).find()) {
                    File file3;
                    String string2 = matcher.group(1).replaceFirst("-part[0-9]+", "");
                    return standardFileNamePattern.matcher(string2).matches() && (file3 = new File(file, string2)).exists();
                }
                return false;
            }
        };
        if (file.exists()) {
            for (File file2 : file.listFiles(filenameFilter)) {
                System.out.println("\u5c1d\u8bd5\u5220\u9664" + file2.getName());
                file2.delete();
            }
        }
    }

    private static String replParams(String string, String string2, String string3, String string4) {
        if (string3 == null) {
            string3 = "null";
        }
        if (string2 == null) {
            string2 = "null";
        }
        return string.replace("{FFmpeg}", FFMPEG_PATH).replace("{SavePath}", Global.savePath).replace("{VideoName}", string2).replace("{AudioName}", string3).replace("{DstName}", string4);
    }

    public static String[] createConvertCmd(String string, String string2, String string3) {
        int n;
        Object[] objectArray = null;
        if (string2 == null) {
            objectArray = new String[]{FFMPEG_PATH, "-i", Global.savePath + string, "-c", "copy", Global.savePath + string3};
        } else if (string == null) {
            objectArray = (String[])Global.ffmpegCmd4AudioOnly.clone();
            for (n = 0; n < objectArray.length; ++n) {
                objectArray[n] = CmdUtil.replParams(objectArray[n], string, string2, string3);
            }
        } else {
            objectArray = (String[])Global.ffmpegCmd4Merge.clone();
            for (n = 0; n < objectArray.length; ++n) {
                objectArray[n] = CmdUtil.replParams(objectArray[n], string, string2, string3);
            }
        }
        String string4 = String.format("ffmpeg\u547d\u4ee4\u4e3a: %s", Arrays.toString(objectArray));
        Logger.println(string4);
        return objectArray;
    }

    public static synchronized void convertOrAppendCmdToRenameBat(String string, String string2, int n) {
        block6: {
            try {
                File file = CmdUtil.getFileByAvQnP(string, n);
                String string3 = file.getName();
                Matcher matcher = suffixPattern.matcher(string3);
                matcher.find();
                String string4 = matcher.group();
                if (Global.doRenameAfterComplete) {
                    File file2 = new File(Global.savePath, string2 + string4);
                    File file3 = file2.getParentFile();
                    if (!file3.exists()) {
                        file3.mkdirs();
                    }
                    if (file.renameTo(file2) || !Global.autoNumberWhenFileExists) break block6;
                    for (int i = 1; i < 100; ++i) {
                        File file4 = new File(Global.savePath, String.format("%s(%02d)%s", string2, i, string4));
                        Logger.println(file4.getAbsolutePath());
                        if (file4.exists()) continue;
                        file.renameTo(file4);
                        break block6;
                    }
                    break block6;
                }
                File file5 = new File(Global.savePath, "rename.bat");
                boolean bl = file5.exists();
                System.out.println(file5.getAbsolutePath() + "\u662f\u5426\u5b58\u5728? " + file5.exists());
                FileWriter fileWriter = new FileWriter(file5, true);
                if (!bl) {
                    fileWriter.write("@echo off\r\nchcp 65001\r\n");
                }
                String string5 = String.format("rename \"%s\" \"%s%s\"\r\n", string3, string2, string4);
                fileWriter.write(string5);
                fileWriter.close();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    public static File getFileByAvQnP(String string, int n) {
        String string2 = string + "-p" + n;
        Logger.println(string2);
        for (String string3 : suffixs) {
            File file = new File(Global.savePath, string2 + string3);
            if (!file.exists()) continue;
            return file;
        }
        File file = new File(Global.savePath, string2 + Global.suffix4AudioOnly);
        if (file.exists()) {
            return file;
        }
        return null;
    }

    public static String genFormatedName(String string, String string2, String string3, int n, String string4, String string5, String string6, String string7) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("avId", string);
        hashMap.put("pAv", string2);
        hashMap.put("pDisplay", string3);
        hashMap.put("qn", "" + n);
        hashMap.put("avTitle", string4.replaceAll("[/\\\\]", "_"));
        hashMap.put("clipTitle", string5.replaceAll("[/\\\\]", "_"));
        hashMap.put("listName", string6);
        hashMap.put("listOwnerName", string7);
        return CmdUtil.genFormatedName(hashMap, Global.formatStr);
    }

    public static String genFormatedName(VideoInfo videoInfo, ClipInfo clipInfo, int n) {
        long l;
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("avId", clipInfo.getAvId());
        hashMap.put("pAv", "" + clipInfo.getPage());
        hashMap.put("pDisplay", "" + clipInfo.getRemark());
        hashMap.put("qn", "" + n);
        String string = clipInfo.getAvTitle().replaceAll("[/\\\\]", "_");
        String string2 = clipInfo.getTitle().replaceAll("[/\\\\]", "_");
        hashMap.put("avTitle", string);
        if (!Global.ctFormatAllowNull || !string.equals(string2)) {
            hashMap.put("clipTitle", string2);
        }
        hashMap.put("listName", clipInfo.getListName());
        hashMap.put("listOwnerName", clipInfo.getListOwnerName());
        hashMap.put("UpName", clipInfo.getUpName().replaceAll("[/\\\\]", "_"));
        hashMap.put("UpId", clipInfo.getUpId());
        long l2 = clipInfo.getFavTime();
        if (l2 > 0L) {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat(Global.favTimeFormat);
            hashMap.put("favTime", simpleDateFormat.format(new Date(l2)));
        }
        if ((l = clipInfo.getcTime()) > 0L) {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat(Global.cTimeFormat);
            hashMap.put("cTime", simpleDateFormat.format(new Date(l)));
        }
        return CmdUtil.genFormatedName(hashMap, Global.formatStr);
    }

    private static String genFormatedName(HashMap<String, String> hashMap, String string) {
        StringBuilder stringBuilder = new StringBuilder();
        Matcher matcher = splitUnit.matcher(string);
        int n = 0;
        while (matcher.find()) {
            String string2;
            String string3;
            stringBuilder.append(string.substring(n, matcher.start()));
            int n2 = 0;
            String string4 = matcher.group("ifOrUnless" + n2);
            String string5 = string4 = string4 != null ? string4 : matcher.group("ifOrUnless" + ++n2);
            if (string4 != null) {
                string3 = matcher.group("condition" + n2);
                String string6 = matcher.group("format" + n2);
                if (":".equals(string4) && hashMap.get(string3) != null) {
                    stringBuilder.append(CmdUtil.genFormatedName(hashMap, string6));
                } else if ("!".equals(string4) && hashMap.get(string3) == null) {
                    stringBuilder.append(CmdUtil.genFormatedName(hashMap, string6));
                }
            } else if (matcher.group().startsWith("pAv")) {
                string3 = matcher.group().substring(3);
                String string7 = hashMap.get("pAv");
                string2 = CmdUtil.formatNumber(string7, string3);
                stringBuilder.append("p" + string2);
            } else if (matcher.group().startsWith("pDisplay")) {
                string3 = matcher.group().substring(8);
                String string8 = hashMap.get("pDisplay");
                string2 = CmdUtil.formatNumber(string8, string3);
                stringBuilder.append("pn" + string2);
            } else if ("numAvId".equals(matcher.group())) {
                try {
                    string3 = hashMap.get("avId");
                    long l = ConvertUtil.Bv2Av(string3);
                    stringBuilder.append(l);
                }
                catch (Exception exception) {
                    Logger.println("\u60a8\u5f53\u524d\u4e0b\u8f7d\u7684\u5e76\u4e0d\u80fd\u627e\u5230\u5bf9\u5e94\u7684\u6570\u5b57av\u53f7\uff0c\u8bf7\u6b63\u786e\u8bbe\u7f6e");
                    stringBuilder.append(0);
                }
            } else {
                stringBuilder.append(hashMap.getOrDefault(matcher.group(), "null"));
            }
            n = matcher.end();
        }
        stringBuilder.append(string.substring(n));
        String string9 = stringBuilder.toString().replaceAll("[\t\b\\r\\n|:*?<>\"$]", "_").replaceAll("[/\\\\]", Matcher.quoteReplacement(File.separator));
        return string9;
    }

    private static String formatNumber(String string, String string2) {
        int n;
        if (!string2.isEmpty() && (n = Integer.parseInt(string2) - string.length()) > 0) {
            String string3 = "%0" + n + "d%s";
            return String.format(string3, 0, string);
        }
        return string;
    }
}

