/*
 * Decompiled with CFR 0.152.
 */
package nicelee.bilibili.pushers.impl;

import com.sun.mail.util.MailSSLSocketFactory;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Map;
import java.util.Properties;
import javax.mail.Authenticator;
import javax.mail.MessagingException;
import javax.mail.PasswordAuthentication;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import nicelee.bilibili.annotations.Bilibili;
import nicelee.bilibili.model.ClipInfo;
import nicelee.bilibili.model.TaskInfo;
import nicelee.bilibili.pushers.IPush;
import nicelee.bilibili.util.custom.System;
import nicelee.ui.Global;

@Bilibili(name="MailPush", type="pusher", note="\u5c06\u7ed3\u679c\u901a\u8fc7\u90ae\u4ef6\u53d1\u9001")
public class MailPush
implements IPush {
    static final String SMTP_HOST_KEY = "mail.smtp.host";
    static final String SMTP_PORT_KEY = "mail.smtp.port";
    static final String SMTP_SSL_ENABLE_KEY = "mail.smtp.ssl.enable";
    static final String SMTP_STARTTLS_KEY = "mail.smtp.starttls.enale";
    static final String SMTP_DEBUG_KEY = "mail.smtp.debug";
    static final String SMTP_TO_EMAIL_KEY = "mail.smtp.to.addr";

    @Override
    public String type() {
        return "Mail";
    }

    @Override
    public IPush newInstance() {
        return new MailPush();
    }

    @Override
    public void push(Map<ClipInfo, TaskInfo> map, long l, long l2) {
        Object object;
        int n = 0;
        int n2 = 0;
        ArrayList<TaskInfo> arrayList = new ArrayList<TaskInfo>();
        ArrayList<TaskInfo> arrayList2 = new ArrayList<TaskInfo>();
        for (TaskInfo object22 : map.values()) {
            if ("success".equals(object22.getStatus())) {
                ++n;
                arrayList.add(object22);
                continue;
            }
            ++n2;
            arrayList2.add(object22);
        }
        String string = String.format("%1$tF %1$tR \u65b0\u589e\u89c6\u9891:%2$d\u4e2a, \u6210\u529f:%3$d\u4e2a\uff0c\u5931\u8d25:%4$d\u4e2a", new Date(System.currentTimeMillis()), n + n2, n, n2);
        StringBuilder stringBuilder = new StringBuilder();
        String string2 = "<th style='border-bottom:1px solid black; border-right:1px solid black;'>";
        String string3 = "</th>";
        String string4 = "<td style='border-bottom:1px solid black; border-right:1px solid black;'>";
        String string5 = "</td>";
        String string6 = "<table align='center' cellpadding='0' cellspacing='0' width='900' style='border-top:1px solid black; border-left:1px solid black; margin:0 auto; font-size: 12px; font-family: Microsoft YaHei;'><thead><tr>";
        stringBuilder.append("<html><body>");
        if (arrayList.size() > 0) {
            stringBuilder.append("<div style='margin:0 auto; width: 900px; font-size: 14px;'><p>\u6210\u529f\u5217\u8868</p></div>");
            stringBuilder.append(string6);
            stringBuilder.append(string2).append("\u6587\u4ef6\u540d\u79f0").append(string3);
            stringBuilder.append(string2).append("\u6587\u4ef6\u5927\u5c0f").append(string3);
            stringBuilder.append(string2).append("BV\u53f7").append(string3);
            stringBuilder.append(string2).append("\u6e05\u6670\u5ea6").append(string3);
            stringBuilder.append("</tr></thead><tbody>");
            for (TaskInfo taskInfo : arrayList) {
                stringBuilder.append("<tr>");
                stringBuilder.append(string4).append(taskInfo.getFileName()).append(string5);
                stringBuilder.append(string4).append(taskInfo.getFileSize()).append(string5);
                object = String.format("<a href='https://b23.tv/%1$s'>%1$s</a>", taskInfo.getClip().getAvId());
                stringBuilder.append(string4).append((String)object).append(string5);
                stringBuilder.append(string4).append(taskInfo.getQn()).append(string5);
                stringBuilder.append("</tr>");
            }
            stringBuilder.append("</tbody></table><br/>");
        }
        if (arrayList2.size() > 0) {
            stringBuilder.append("<div style='margin:0 auto; width: 900px; font-size: 14px;'><p>\u5931\u8d25\u5217\u8868</p></div>");
            stringBuilder.append(string6);
            stringBuilder.append(string2).append("\u89c6\u9891\u6807\u9898").append(string3);
            stringBuilder.append(string2).append("\u526f\u6807\u9898").append(string3);
            stringBuilder.append(string2).append("BV\u53f7").append(string3);
            stringBuilder.append(string2).append("\u5931\u8d25\u539f\u56e0").append(string3);
            stringBuilder.append("</tr></thead><tbody>");
            for (TaskInfo taskInfo : arrayList2) {
                object = taskInfo.getClip();
                stringBuilder.append("<tr>");
                stringBuilder.append(string4).append(((ClipInfo)object).getAvTitle()).append(string5);
                stringBuilder.append(string4).append(((ClipInfo)object).getTitle()).append(string5);
                String string7 = String.format("<a href='https://b23.tv/%1$s'>%1$s</a>", ((ClipInfo)object).getAvId());
                stringBuilder.append(string4).append(string7).append(string5);
                stringBuilder.append(string4).append(taskInfo.getStatus()).append(string5);
                stringBuilder.append("</tr>");
            }
            stringBuilder.append("</tbody></table><br/>");
        }
        stringBuilder.append("</body></html>");
        try {
            MailPush.sendEmail(string, stringBuilder.toString());
        }
        catch (MessagingException messagingException) {
            messagingException.printStackTrace();
        }
    }

    public static Properties getProps(String string) {
        string = string.toLowerCase();
        Properties properties = new Properties();
        properties.put("mail.smtp.auth", "true");
        if (string.endsWith("@sina.com")) {
            properties.put(SMTP_HOST_KEY, "smtp.sina.com");
            properties.put(SMTP_PORT_KEY, "465");
            properties.put(SMTP_SSL_ENABLE_KEY, "true");
        } else if (string.endsWith("@163.com")) {
            properties.put(SMTP_HOST_KEY, "smtp.163.com");
            properties.put(SMTP_PORT_KEY, "465");
            properties.put(SMTP_SSL_ENABLE_KEY, "true");
        } else if (string.endsWith("@qq.com")) {
            properties.put(SMTP_HOST_KEY, "smtp.qq.com");
            properties.put(SMTP_PORT_KEY, "465");
            properties.put(SMTP_SSL_ENABLE_KEY, "true");
            try {
                MailSSLSocketFactory mailSSLSocketFactory = new MailSSLSocketFactory();
                mailSSLSocketFactory.setTrustAllHosts(true);
                properties.put("mail.smtp.ssl.socketFactory", mailSSLSocketFactory);
            }
            catch (GeneralSecurityException generalSecurityException) {
                generalSecurityException.printStackTrace();
            }
        } else {
            properties.put(SMTP_HOST_KEY, Global.settings.get(SMTP_HOST_KEY));
            String string2 = Global.settings.getOrDefault(SMTP_PORT_KEY, "465");
            properties.put(SMTP_PORT_KEY, string2);
            String string3 = "25".equals(string2) ? "false" : "true";
            String string4 = Global.settings.getOrDefault(SMTP_SSL_ENABLE_KEY, string3);
            properties.put(SMTP_SSL_ENABLE_KEY, string4);
            String string5 = Global.settings.get(SMTP_STARTTLS_KEY);
            if (string5 != null) {
                properties.put(SMTP_STARTTLS_KEY, string5);
            }
        }
        return properties;
    }

    public static void main(String[] stringArray) throws MessagingException {
        String string = String.format("<a href='https://b23.tv/%1$s'>%1$s</a>", "BVw13");
        System.out.println(string);
        String string2 = String.format("%1$tF %1$tR%1$tz ", new Date(System.currentTimeMillis()));
        System.out.println(string2);
    }

    public static void sendEmail(String string, String string2) throws MessagingException {
        final String string3 = Global.msgPushAccount;
        final String string4 = Global.msgPushToken;
        String string5 = Global.settings.getOrDefault(SMTP_TO_EMAIL_KEY, Global.msgPushAccount);
        Properties properties = MailPush.getProps(string3);
        Session session = Session.getInstance(properties, new Authenticator(){

            @Override
            protected PasswordAuthentication getPasswordAuthentication() {
                return new PasswordAuthentication(string3, string4);
            }
        });
        session.setDebug("true".equalsIgnoreCase(Global.settings.get(SMTP_DEBUG_KEY)));
        MimeMessage mimeMessage = new MimeMessage(session);
        mimeMessage.setSubject(string, "utf-8");
        mimeMessage.setContent(string2, "text/html;charset=utf-8");
        mimeMessage.setFrom(new InternetAddress(string3));
        mimeMessage.setRecipient(MimeMessage.RecipientType.TO, new InternetAddress(string5));
        Transport.send(mimeMessage);
    }
}

