/*
 * Decompiled with CFR 0.152.
 */
package nicelee.bilibili.parsers.impl;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.regex.Pattern;
import nicelee.bilibili.annotations.Bilibili;
import nicelee.bilibili.model.ClipInfo;
import nicelee.bilibili.model.VideoInfo;
import nicelee.bilibili.parsers.impl.AbstractBaseParser;
import nicelee.bilibili.util.HttpCookies;
import nicelee.bilibili.util.HttpHeaders;
import nicelee.bilibili.util.Logger;
import org.json.JSONObject;

@Bilibili(name="AudioAuParser", note="\u5355\u4e2a\u97f3\u9891\u89e3\u6790", weight=22)
public class AudioAuParser
extends AbstractBaseParser {
    private static final Pattern pattern = Pattern.compile("au([0-9]+)");
    private String auId;
    private long auIdNum;

    public AudioAuParser(Object ... objectArray) {
        super(objectArray);
    }

    @Override
    public boolean matches(String string) {
        this.matcher = pattern.matcher(string);
        boolean bl = this.matcher.find();
        if (bl) {
            this.auId = this.matcher.group();
            this.auIdNum = Long.parseLong(this.matcher.group(1));
        }
        return bl;
    }

    @Override
    public String validStr(String string) {
        return this.auId;
    }

    @Override
    public VideoInfo result(String string, int n, boolean bl) {
        int[] nArray;
        VideoInfo videoInfo = new VideoInfo();
        videoInfo.setVideoId(this.auId);
        HashMap<String, String> hashMap = new HttpHeaders().getCommonHeaders();
        String string2 = "https://www.bilibili.com/audio/music-service-c/web/song/info?sid=" + this.auIdNum;
        String string3 = this.util.getContent(string2, hashMap, HttpCookies.getGlobalCookies());
        Logger.println(string2);
        Logger.println(string3);
        JSONObject jSONObject = new JSONObject(string3).getJSONObject("data");
        long l = jSONObject.optLong("passtime") * 1000L;
        videoInfo.setVideoName(jSONObject.getString("title"));
        videoInfo.setBrief(jSONObject.getString("intro"));
        videoInfo.setAuthor(jSONObject.getString("author"));
        videoInfo.setAuthorId(jSONObject.optString("uid"));
        videoInfo.setVideoPreview(jSONObject.getString("cover"));
        LinkedHashMap<Long, ClipInfo> linkedHashMap = new LinkedHashMap<Long, ClipInfo>();
        ClipInfo clipInfo = new ClipInfo();
        clipInfo.setAvTitle(videoInfo.getVideoName());
        clipInfo.setAvId(this.auId);
        clipInfo.setcId(this.auIdNum);
        clipInfo.setPage(1);
        clipInfo.setTitle(videoInfo.getVideoName());
        clipInfo.setPicPreview(videoInfo.getVideoPreview());
        clipInfo.setUpName(videoInfo.getAuthor());
        clipInfo.setUpId(videoInfo.getAuthorId());
        clipInfo.setcTime(l);
        LinkedHashMap<Integer, String> linkedHashMap2 = new LinkedHashMap<Integer, String>();
        for (int n2 : nArray = new int[]{3, 2, 1, 0}) {
            linkedHashMap2.put(n2, "");
        }
        clipInfo.setLinks(linkedHashMap2);
        linkedHashMap.put(clipInfo.getcId(), clipInfo);
        videoInfo.setClips(linkedHashMap);
        videoInfo.print();
        return videoInfo;
    }
}

