/*
 * Decompiled with CFR 0.152.
 */
package nicelee.bilibili.parsers.impl;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.regex.Pattern;
import nicelee.bilibili.annotations.Bilibili;
import nicelee.bilibili.model.ClipInfo;
import nicelee.bilibili.model.VideoInfo;
import nicelee.bilibili.parsers.impl.AbstractPageQueryParser;
import nicelee.bilibili.util.HttpCookies;
import nicelee.bilibili.util.HttpHeaders;
import nicelee.bilibili.util.Logger;
import org.json.JSONArray;
import org.json.JSONObject;

@Bilibili(name="AudioAmParser", note="\u97f3\u9891\u6b4c\u5355", weight=22)
public class AudioAmParser
extends AbstractPageQueryParser<VideoInfo> {
    private static final Pattern pattern = Pattern.compile("am([0-9]+)");
    private String amID;
    private long amIdNum;

    public AudioAmParser(Object ... objectArray) {
        super(objectArray);
    }

    @Override
    public boolean matches(String string) {
        this.matcher = pattern.matcher(string);
        if (this.matcher.find()) {
            this.amID = this.matcher.group();
            this.amIdNum = Long.parseLong(this.matcher.group(1));
            return true;
        }
        return false;
    }

    @Override
    public String validStr(String string) {
        return this.amID + "p=" + this.paramSetter.getPage();
    }

    @Override
    public VideoInfo result(String string, int n, boolean bl) {
        Logger.println(this.paramSetter.getPage());
        return (VideoInfo)this.result(this.pageSize, this.paramSetter.getPage(), n, bl);
    }

    @Override
    public void initPageQueryParam() {
        this.API_PMAX = 20;
        this.pageQueryResult = new VideoInfo();
        ((VideoInfo)this.pageQueryResult).setClips(new LinkedHashMap<Long, ClipInfo>());
    }

    @Override
    protected boolean query(int n, int n2, int n3, Object ... objectArray) {
        try {
            Object object;
            String string;
            String string2;
            HashMap<String, String> hashMap = new HttpHeaders().getCommonHeaders();
            if (((VideoInfo)this.pageQueryResult).getVideoName() == null) {
                string2 = "https://www.bilibili.com/audio/music-service-c/web/menu/info?sid=" + this.amIdNum;
                string = this.util.getContent(string2, hashMap, HttpCookies.getGlobalCookies());
                Logger.println(string2);
                Logger.println(string);
                object = new JSONObject(string).getJSONObject("data");
                ((VideoInfo)this.pageQueryResult).setVideoId(this.amID);
                ((VideoInfo)this.pageQueryResult).setAuthor(((JSONObject)object).getString("uname"));
                ((VideoInfo)this.pageQueryResult).setVideoName(((JSONObject)object).getString("title"));
                ((VideoInfo)this.pageQueryResult).setVideoPreview(((JSONObject)object).getString("cover"));
                ((VideoInfo)this.pageQueryResult).setAuthorId(((JSONObject)object).optString("uid"));
                ((VideoInfo)this.pageQueryResult).setBrief(((JSONObject)object).getString("intro"));
            }
            string2 = "https://www.bilibili.com/audio/music-service-c/web/song/of-menu?sid=%d&pn=%d&ps=%d";
            string = String.format(string2, this.amIdNum, n, this.API_PMAX);
            object = this.util.getContent(string, hashMap, HttpCookies.getGlobalCookies());
            Logger.println(string);
            Logger.println((String)object);
            JSONObject jSONObject = new JSONObject((String)object);
            JSONArray jSONArray = jSONObject.getJSONObject("data").getJSONArray("data");
            LinkedHashMap<Long, ClipInfo> linkedHashMap = ((VideoInfo)this.pageQueryResult).getClips();
            for (int i = n2 - 1; i < jSONArray.length() && i < n3; ++i) {
                int[] nArray;
                JSONObject jSONObject2 = jSONArray.getJSONObject(i);
                ClipInfo clipInfo = new ClipInfo();
                long l = jSONObject2.optLong("passtime") * 1000L;
                long l2 = jSONObject2.optLong("id");
                clipInfo.setAvTitle(jSONObject2.getString("title"));
                clipInfo.setAvId("au" + l2);
                clipInfo.setcId(l2);
                clipInfo.setPage(1);
                clipInfo.setTitle(jSONObject2.getString("title"));
                clipInfo.setPicPreview(jSONObject2.getString("cover"));
                clipInfo.setRemark((n - 1) * this.API_PMAX + i + 1);
                clipInfo.setUpName(jSONObject2.getString("uname"));
                clipInfo.setUpId(jSONObject2.optString("uid"));
                clipInfo.setListName(((VideoInfo)this.pageQueryResult).getVideoName().replaceAll("[/\\\\]", "_"));
                clipInfo.setListOwnerName(((VideoInfo)this.pageQueryResult).getAuthor().replaceAll("[/\\\\]", "_"));
                clipInfo.setcTime(l);
                LinkedHashMap<Integer, String> linkedHashMap2 = new LinkedHashMap<Integer, String>();
                for (int n4 : nArray = new int[]{3, 2, 1, 0}) {
                    linkedHashMap2.put(n4, "");
                }
                clipInfo.setLinks(linkedHashMap2);
                linkedHashMap.put(clipInfo.getcId(), clipInfo);
            }
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }
}

