/*
 * Decompiled with CFR 0.152.
 */
package nicelee.bilibili.parsers;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import nicelee.bilibili.PackageScanLoader;
import nicelee.bilibili.annotations.Bilibili;
import nicelee.bilibili.model.VideoInfo;
import nicelee.bilibili.parsers.IInputParser;
import nicelee.bilibili.parsers.IParamSetter;
import nicelee.bilibili.util.HttpRequestUtil;
import nicelee.bilibili.util.Logger;

public class InputParser
implements IInputParser,
IParamSetter {
    protected static final Pattern paramPattern = Pattern.compile("^(.*)p=([0-9]+)$");
    private static List<IInputParser> parsers = null;
    private IInputParser parser = null;
    private int page = 1;
    private int realQN = 1;
    private HttpRequestUtil util;
    private int pageSize;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public InputParser(HttpRequestUtil httpRequestUtil, int n, String string) {
        this.util = httpRequestUtil;
        this.pageSize = n;
        if (parsers != null) return;
        Class<InputParser> clazz = InputParser.class;
        synchronized (InputParser.class) {
            if (parsers != null) return;
            parsers = new ArrayList<IInputParser>();
            try {
                for (Class<?> clazz2 : PackageScanLoader.validParserClasses) {
                    Bilibili bilibili = clazz2.getAnnotation(Bilibili.class);
                    if (!bilibili.ifLoad().isEmpty() && !bilibili.ifLoad().equals("listAll")) continue;
                    Constructor<?> constructor = clazz2.getConstructors()[0];
                    IInputParser iInputParser = (IInputParser)constructor.newInstance(new Object[]{new Object[]{null, null, 0}});
                    parsers.add(iInputParser);
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            return;
        }
    }

    public IInputParser selectParser(String string) {
        if (this.parser != null && this.parser.matches(string)) {
            return this.parser;
        }
        this.parser = null;
        for (IInputParser iInputParser : parsers) {
            if (!iInputParser.matches(string)) continue;
            try {
                Logger.println(string);
                Object[] objectArray = new Object[]{new Object[]{this.util, this, this.pageSize}};
                this.parser = (IInputParser)iInputParser.getClass().getConstructors()[0].newInstance(objectArray);
                this.parser.matches(string);
            }
            catch (IllegalAccessException | IllegalArgumentException | InstantiationException | SecurityException | InvocationTargetException exception) {}
            break;
        }
        return this.parser;
    }

    @Override
    public boolean matches(String string) {
        return true;
    }

    @Override
    public String validStr(String string) {
        Matcher matcher = paramPattern.matcher(string);
        if (matcher.find()) {
            int n;
            this.page = n = Integer.parseInt(matcher.group(2));
            string = matcher.group(1);
        }
        this.selectParser(string);
        if (this.parser != null) {
            return this.parser.validStr(string);
        }
        Logger.println("\u5f53\u524d\u6ca1\u6709parser\u5339\u914d");
        return "";
    }

    @Override
    public VideoInfo result(String string, int n, boolean bl) {
        Matcher matcher = paramPattern.matcher(string);
        if (matcher.find()) {
            int n2;
            this.page = n2 = Integer.parseInt(matcher.group(2));
            string = matcher.group(1);
        }
        this.selectParser(string);
        if (this.parser != null) {
            return this.parser.result(string, n, bl);
        }
        return null;
    }

    @Override
    public String getVideoLink(String string, String string2, int n, int n2) {
        this.selectParser(string);
        if (this.parser != null) {
            return this.parser.getVideoLink(string, string2, n, n2);
        }
        return null;
    }

    @Override
    public int getVideoLinkQN() {
        if (this.parser != null) {
            return this.parser.getVideoLinkQN();
        }
        return 0;
    }

    @Override
    public void setPage(int n) {
        this.page = n;
    }

    @Override
    public int getPage() {
        return this.page;
    }

    @Override
    public void setRealQN(int n) {
        this.realQN = n;
    }

    @Override
    public int getRealQN() {
        return this.realQN;
    }

    public IInputParser getParser() {
        return this.parser;
    }
}

