/*
 * Decompiled with CFR 0.152.
 */
package nicelee.bilibili.downloaders.impl;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.util.List;
import nicelee.bilibili.annotations.Bilibili;
import nicelee.bilibili.downloaders.IDownloader;
import nicelee.bilibili.enums.StatusEnum;
import nicelee.bilibili.util.HttpHeaders;
import nicelee.bilibili.util.HttpRequestUtil;
import nicelee.bilibili.util.ResourcesUtil;
import nicelee.bilibili.util.danmuku.Danmuku;
import nicelee.bilibili.util.danmuku.Xml2Ass;
import nicelee.ui.Global;

@Bilibili(name="danmuku-downloader", type="downloader", note="\u5f39\u5e55\u4e0b\u8f7d")
public class DanmuDownloader
implements IDownloader {
    protected HttpRequestUtil util;
    protected File file = null;
    protected StatusEnum status = StatusEnum.NONE;

    @Override
    public boolean matches(String string) {
        return string.contains("dm/list.so") || string.contains(".xml");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public boolean download(String string, String string2, int n, int n2) {
        this.status = StatusEnum.DOWNLOADING;
        String string3 = this.util.getContent(string, new HttpHeaders().getDanmuHeaders());
        String string4 = String.format("%s-%d-p%d", string2, n, n2);
        File file = new File(Global.savePath, string4 + ".xml");
        if (this.file == null) {
            this.file = new File(Global.savePath, string4 + ".ass");
        }
        if ("".equals(string3)) {
            this.status = StatusEnum.FAIL;
            return false;
        }
        OutputStreamWriter outputStreamWriter = null;
        outputStreamWriter = new OutputStreamWriter((OutputStream)new FileOutputStream(file), Charset.forName("UTF-8"));
        outputStreamWriter.write(string3);
        this.status = StatusEnum.SUCCESS;
        boolean bl = true;
        ResourcesUtil.closeQuietly(outputStreamWriter);
        Xml2Ass xml2Ass = new Xml2Ass();
        try {
            List<Danmuku> list = xml2Ass.readXml(file);
            xml2Ass.writeAss(list, this.file);
            file.delete();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return bl;
        catch (IOException iOException) {
            boolean bl2;
            try {
                iOException.printStackTrace();
                this.status = StatusEnum.FAIL;
                bl2 = false;
            }
            catch (Throwable throwable) {
                ResourcesUtil.closeQuietly(outputStreamWriter);
                Xml2Ass xml2Ass2 = new Xml2Ass();
                try {
                    List<Danmuku> list = xml2Ass2.readXml(file);
                    xml2Ass2.writeAss(list, this.file);
                    file.delete();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                throw throwable;
            }
            ResourcesUtil.closeQuietly(outputStreamWriter);
            Xml2Ass xml2Ass3 = new Xml2Ass();
            try {
                List<Danmuku> list = xml2Ass3.readXml(file);
                xml2Ass3.writeAss(list, this.file);
                file.delete();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            return bl2;
        }
    }

    @Override
    public void init(HttpRequestUtil httpRequestUtil) {
        this.util = httpRequestUtil;
    }

    @Override
    public void startTask() {
    }

    @Override
    public void stopTask() {
    }

    @Override
    public File file() {
        return this.file;
    }

    @Override
    public StatusEnum currentStatus() {
        return this.status;
    }

    @Override
    public int totalTaskCount() {
        return 1;
    }

    @Override
    public int currentTask() {
        return 1;
    }

    @Override
    public long sumTotalFileSize() {
        if (this.file != null && this.file.exists()) {
            return this.file.length();
        }
        return 0L;
    }

    @Override
    public long sumDownloadedFileSize() {
        if (this.file != null && this.file.exists()) {
            return this.file.length();
        }
        return 0L;
    }

    @Override
    public long currentFileDownloadedSize() {
        if (this.file != null && this.file.exists()) {
            return this.file.length();
        }
        return 0L;
    }

    @Override
    public long currentFileTotalSize() {
        if (this.file != null && this.file.exists()) {
            return this.file.length();
        }
        return 0L;
    }
}

