/*
 * Decompiled with CFR 0.152.
 */
package nicelee.bilibili;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.net.HttpCookie;
import java.net.URLEncoder;
import java.security.KeyFactory;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.X509EncodedKeySpec;
import java.util.Base64;
import java.util.HashMap;
import java.util.List;
import javax.crypto.Cipher;
import nicelee.bilibili.API;
import nicelee.bilibili.model.UserInfo;
import nicelee.bilibili.util.HttpCookies;
import nicelee.bilibili.util.HttpHeaders;
import nicelee.bilibili.util.HttpRequestUtil;
import nicelee.bilibili.util.Logger;
import nicelee.bilibili.util.ResourcesUtil;
import nicelee.bilibili.util.custom.System;
import org.json.JSONObject;

public class INeedLogin {
    HttpRequestUtil util = new HttpRequestUtil();
    public List<HttpCookie> iCookies;
    public String refreshToken;
    public String qrCodeStr = "";
    public UserInfo user;
    HashMap<String, String> loginHeader = null;

    public boolean getLoginStatus(List<HttpCookie> list) {
        boolean bl;
        HttpHeaders httpHeaders = new HttpHeaders();
        try {
            String string = "https://api.bilibili.com/x/web-interface/nav?build=0&mobi_app=web";
            String string2 = this.util.getContent(string, httpHeaders.getBiliUserInfoHeaders(), list);
            JSONObject jSONObject = new JSONObject(string2).getJSONObject("data");
            bl = jSONObject.getBoolean("isLogin");
            if (bl) {
                this.user = new UserInfo();
                this.user.setName(jSONObject.getString("uname"));
                this.user.setPoster(jSONObject.getString("face"));
                this.user.setUid(jSONObject.getJSONObject("wallet").getLong("mid"));
                this.iCookies = list;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            bl = false;
        }
        return bl;
    }

    public String getAuthKey() {
        String string = "https://passport.bilibili.com/x/passport-login/web/qrcode/generate?source=main-web";
        String string2 = this.util.getContent(string, this.genLoginHeader());
        JSONObject jSONObject = new JSONObject(string2).getJSONObject("data");
        this.qrCodeStr = jSONObject.getString("url");
        return jSONObject.getString("qrcode_key");
    }

    public boolean getAuthStatus(String string) throws UnsupportedEncodingException {
        String string2 = "https://passport.bilibili.com/x/passport-login/web/qrcode/poll?source=main-web&qrcode_key=" + string;
        try {
            boolean bl;
            String string3 = this.util.getContent(string2, this.genLoginHeader());
            System.out.println(string3);
            JSONObject jSONObject = new JSONObject(string3).getJSONObject("data");
            boolean bl2 = bl = jSONObject.getInt("code") == 0;
            if (bl) {
                this.iCookies = HttpRequestUtil.DefaultCookieManager().getCookieStore().getCookies();
                this.refreshToken = jSONObject.getString("refresh_token");
            }
            return bl;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.out.println("\u9a8c\u8bc1Auth\u8fd4\u56de\u8d85\u65f6, \u6216json\u89e3\u6790\u9519\u8bef");
            return false;
        }
    }

    public void saveCookiesAndToken() {
        File file = ResourcesUtil.sourceOf("./config/cookies.config");
        try {
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)new FileOutputStream(file), "utf-8");
            BufferedWriter bufferedWriter = new BufferedWriter(outputStreamWriter);
            bufferedWriter.write(this.iCookies.toString());
            if (this.refreshToken != null) {
                HttpCookies.setRefreshToken(this.refreshToken);
                bufferedWriter.newLine();
                bufferedWriter.write(this.refreshToken);
            }
            bufferedWriter.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public String readCookies() {
        File file = ResourcesUtil.sourceOf("./config/cookies.config");
        return ResourcesUtil.readAll(file);
    }

    public HttpRequestUtil getUtil() {
        return this.util;
    }

    public void setUtil(HttpRequestUtil httpRequestUtil) {
        this.util = httpRequestUtil;
    }

    public JSONObject getGeetest() throws IOException {
        String string = "https://passport.bilibili.com/x/passport-login/captcha?source=main_mini";
        String string2 = this.util.getContent(string, this.genLoginHeader());
        JSONObject jSONObject = new JSONObject(string2).getJSONObject("data");
        return jSONObject;
    }

    public HashMap<String, String> genLoginHeader() {
        if (this.loginHeader != null) {
            return this.loginHeader;
        }
        HashMap<String, String> hashMap = new HttpHeaders().getBiliLoginAuthHeaders();
        String string = API.getFingerprint();
        hashMap.put("Cookie", string);
        this.loginHeader = hashMap;
        return hashMap;
    }

    public String login(String string, String string2, String string3, String string4, String string5, String string6) {
        try {
            if (!string.contains("%40")) {
                string = URLEncoder.encode(string, "UTF-8");
            }
            String string7 = "https://passport.bilibili.com/x/passport-login/web/key?_=" + System.currentTimeMillis();
            HashMap<String, String> hashMap = this.genLoginHeader();
            String string8 = this.util.getContent(string7, hashMap);
            Logger.println(string8);
            JSONObject jSONObject = new JSONObject(string8).getJSONObject("data");
            String string9 = jSONObject.optString("hash", "");
            if (string9.isEmpty()) {
                return "\u670d\u52a1\u5668\u7e41\u5fd9\uff0c\u767b\u5f55\u5931\u8d25";
            }
            String string10 = jSONObject.getString("key").replace("-----BEGIN PUBLIC KEY-----", "").replace("-----END PUBLIC KEY-----", "").replace("\n", "");
            String string11 = INeedLogin.encrypt(string9 + string2, string10);
            string11 = URLEncoder.encode(string11, "UTF-8");
            string7 = "https://passport.bilibili.com/x/passport-login/web/login";
            String string12 = String.format("username=%s&password=%s&keep=0&source=main_mini&token=%s&go_url=https://www.bilibili.com&challenge=%s&validate=%s&seccode=%s", string, string11, string3, string4, string5, string6);
            string8 = this.util.postContent(string7, hashMap, string12);
            Logger.println(string8);
            JSONObject jSONObject2 = new JSONObject(string8);
            if (jSONObject2.optInt("code") == 0) {
                JSONObject jSONObject3 = jSONObject2.getJSONObject("data");
                if (jSONObject3.optInt("status") == 2) {
                    return jSONObject3.optString("message", "\u672a\u77e5\u9519\u8bef\uff0c\u8fd4\u56de\u4fe1\u606f\u4e2d\u6ca1\u6709\u9519\u8bef\u63cf\u8ff0");
                }
                this.iCookies = HttpRequestUtil.DefaultCookieManager().getCookieStore().getCookies();
                this.refreshToken = jSONObject2.getJSONObject("data").getString("refresh_token");
                return null;
            }
            return jSONObject2.optString("message", "\u672a\u77e5\u9519\u8bef\uff0c\u8fd4\u56de\u4fe1\u606f\u4e2d\u6ca1\u6709\u9519\u8bef\u63cf\u8ff0");
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return "\u672a\u77e5\u9519\u8bef\uff0c\u53ef\u80fd\u7531\u7f51\u7edc\u5f15\u8d77";
        }
    }

    public JSONObject sendSMS(String string, String string2, String string3, String string4, String string5, String string6) {
        try {
            String string7 = "https://passport.bilibili.com/x/passport-login/web/sms/send";
            HashMap<String, String> hashMap = this.genLoginHeader();
            String string8 = String.format("cid=%s&tel=%s&source=main_mini&token=%s&challenge=%s&validate=%s&seccode=%s", string, string2, string3, string4, string5, string6);
            String string9 = this.util.postContent(string7, hashMap, string8);
            Logger.println(string9);
            return new JSONObject(string9);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public String loginSMS(String string, String string2, String string3, String string4) {
        try {
            String string5 = "https://passport.bilibili.com/x/passport-login/web/login/sms";
            HashMap<String, String> hashMap = this.genLoginHeader();
            String string6 = String.format("cid=%s&tel=%s&code=%s&captcha_key=%s&source=main_mini&go_url=&keep=true", string, string2, string3, string4);
            String string7 = this.util.postContent(string5, hashMap, string6);
            Logger.println(string7);
            JSONObject jSONObject = new JSONObject(string7);
            if (jSONObject.optInt("code") == 0) {
                JSONObject jSONObject2 = jSONObject.getJSONObject("data");
                if (jSONObject2.optInt("status") == 2) {
                    return jSONObject2.optString("message", "\u672a\u77e5\u9519\u8bef\uff0c\u8fd4\u56de\u4fe1\u606f\u4e2d\u6ca1\u6709\u9519\u8bef\u63cf\u8ff0");
                }
                this.iCookies = HttpRequestUtil.DefaultCookieManager().getCookieStore().getCookies();
                this.refreshToken = jSONObject.getJSONObject("data").getString("refresh_token");
                return null;
            }
            return jSONObject.optString("message", "\u672a\u77e5\u9519\u8bef\uff0c\u8fd4\u56de\u4fe1\u606f\u4e2d\u6ca1\u6709\u9519\u8bef\u63cf\u8ff0");
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return "\u672a\u77e5\u9519\u8bef\uff0c\u53ef\u80fd\u7531\u7f51\u7edc\u5f15\u8d77";
        }
    }

    public String refreshCookie(String string, String string2, String string3) {
        HttpHeaders httpHeaders = new HttpHeaders();
        String string4 = "https://passport.bilibili.com/x/passport-login/web/cookie/refresh?csrf=%s&refresh_csrf=%s&source=main_web&refresh_token=%s";
        string4 = String.format(string4, string, string2, string3);
        String string5 = this.util.postContent(string4, httpHeaders.getCommonHeaders(), "", HttpCookies.getGlobalCookies());
        Logger.println(string5);
        JSONObject jSONObject = new JSONObject(string5);
        if (jSONObject.getInt("code") == 0) {
            JSONObject jSONObject2 = jSONObject.optJSONObject("data");
            if (jSONObject2 != null) {
                this.iCookies = HttpRequestUtil.DefaultCookieManager().getCookieStore().getCookies();
                this.refreshToken = jSONObject2.getString("refresh_token");
                HttpCookies.setGlobalCookies(this.iCookies);
                this.saveCookiesAndToken();
                string4 = "https://passport.bilibili.com/x/passport-login/web/confirm/refresh?csrf=%s&refresh_token=%s";
                string4 = String.format(string4, HttpCookies.getCsrf(), string3);
                string5 = this.util.postContent(string4, httpHeaders.getCommonHeaders(), "", HttpCookies.getGlobalCookies());
                Logger.println("\u5c06\u539f\u6765\u7684Cookie\u6ce8\u9500\u6389");
                Logger.println(string5);
            }
            return null;
        }
        return jSONObject.optString("message", "\u672a\u77e5\u9519\u8bef\uff0c\u8fd4\u56de\u4fe1\u606f\u4e2d\u6ca1\u6709\u9519\u8bef\u63cf\u8ff0");
    }

    private static String encrypt(String string, String string2) {
        try {
            byte[] byArray = Base64.getDecoder().decode(string2);
            X509EncodedKeySpec x509EncodedKeySpec = new X509EncodedKeySpec(byArray);
            KeyFactory keyFactory = KeyFactory.getInstance("RSA");
            RSAPublicKey rSAPublicKey = (RSAPublicKey)keyFactory.generatePublic(x509EncodedKeySpec);
            Cipher cipher = Cipher.getInstance("RSA");
            cipher.init(1, rSAPublicKey);
            String string3 = Base64.getEncoder().encodeToString(cipher.doFinal(string.getBytes("UTF-8")));
            return string3;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }
}

