# API配置重构计划

## 目标
重构Claude Code初始化和API配置菜单逻辑，改为类似Codex的API配置模式

## 需求分析
当前 `configureApiFeature` 存在以下问题：
1. 复杂的判断逻辑：先检查现有配置，然后显示不同的操作选择
2. 用户体验不一致：与 Codex 的简洁 API 配置模式差异很大
3. 逻辑分散：官方登录、自定义配置、CCR代理的逻辑混在一起

## 解决方案
采用方案1：完全重构为Codex模式
- 直接提供4个选项：官方登录、自定义API、CCR代理、跳过
- 移除复杂的现有配置检查逻辑
- 每个选项对应独立的处理函数

## 实施步骤
1. 更新翻译文件支持新的配置模式
2. 重构 configureApiFeature 函数
3. 创建独立的模式处理函数
4. 测试和验证

## 预期结果
- 用户体验统一且简洁
- 逻辑清晰，易于维护
- 与项目整体设计保持一致