# 测试覆盖率提升执行计划

## 任务背景
- **PR**: #88 - feat(codex): add comprehensive codex tool integration
- **当前覆盖率**: 94.7% (54/57 模块已测试)
- **目标**: 提升测试覆盖率至100%，确保80%+行覆盖率
- **策略**: 混合优化 - 补全缺失模块 + 深化codex功能测试

## 缺失测试模块分析
1. **constants.ts** - 常量定义和类型检查函数
2. **utils/claude-config.ts** - Claude配置管理和API密钥处理
3. **utils/cometix/common.ts** - Cometix公共常量和命令
4. **utils/cometix/errors.ts** - Cometix错误类和工具函数

## 第一阶段：缺失模块基础测试补全

### 1.1 constants.test.ts
- **路径**: `tests/unit/utils/constants.test.ts`
- **覆盖**: 常量验证、`isCodeToolType()`、`getAiOutputLanguageLabel()`、i18n集成
- **重点**: 类型检查函数和i18n动态标签

### 1.2 claude-config.test.ts
- **路径**: `tests/unit/utils/claude-config.test.ts`
- **覆盖**: MCP配置读写、备份恢复、API密钥管理、Windows处理、错误处理
- **重点**: 11个导出函数的完整测试，85%+行覆盖率

### 1.3 cometix/common.test.ts
- **路径**: `tests/unit/utils/cometix/common.test.ts`
- **覆盖**: 常量定义验证、命令构建逻辑
- **重点**: 简单但完整的常量验证

### 1.4 cometix/errors.test.ts
- **路径**: `tests/unit/utils/cometix/errors.test.ts`
- **覆盖**: 4个错误类、2个工具函数、错误继承链
- **重点**: 100%分支覆盖率

## 第二阶段：Codex功能测试深化

### 2.1 增强codex核心测试
- **目标**: 现有codex相关测试文件
- **内容**: 配置切换边缘案例、提供商管理失败、备份恢复异常、跨平台兼容性

### 2.2 扩展配置管理测试
- **目标**: codex配置相关测试
- **内容**: 配置文件损坏恢复、并发访问、权限错误

## 实施步骤

### 步骤1: 准备测试环境
```bash
pnpm test:run --reporter=verbose
```

### 步骤2: 创建基础测试文件（高优先级）
1. constants.test.ts - 类型检查和i18n集成
2. claude-config.test.ts - 配置管理的11个函数
3. cometix/common.test.ts - 常量验证
4. cometix/errors.test.ts - 错误类测试

### 步骤3: 深化Codex功能测试（中优先级）
1. 增强edge case测试
2. 扩展现有codex.test.ts

### 步骤4: 验证和优化
```bash
pnpm test:coverage
```

## 成功标准
- **模块覆盖率**: 100% (57/57)
- **行覆盖率**: ≥80%
- **分支覆盖率**: ≥80%
- **函数覆盖率**: ≥80%

## 风险与应对
1. **i18n依赖复杂性** → 使用现有i18n测试模式
2. **文件系统Mock复杂性** → 参考现有config.test.ts模式
3. **异步操作测试** → 使用async/await和现有辅助函数

## Mock策略
- 文件系统操作: `vi.mock('node:fs')`
- 命令执行: `vi.mock('tinyexec')`
- 用户交互: `vi.mock('inquirer')`
- 平台检测: `vi.mock('../platform')`
- i18n系统: `vi.mock('../i18n')`

---
*执行计划创建时间: $(date)*
*关联PR: https://github.com/UfoMiao/zcf/pull/88*