# 测试文件合并计划

## 背景
项目中存在多个源文件对应多个测试文件的情况，导致维护困难。需要按照测试深度分层的方案重新组织测试文件。

## 目标
- 保持测试规范性和可读性
- 维持高测试覆盖率（98%+）
- 每个源文件最多对应 2-3 个测试文件

## 组织原则
1. `*.test.ts` - 核心功能测试（必需）
2. `*.edge.test.ts` - 边界案例和错误处理（可选）
3. `*.integration.test.ts` - 集成场景测试（可选）

## 合并映射关系

### 需要合并的文件列表
1. config-operations (5个文件)
2. features (4个文件) 
3. ai-personality (2个文件)
4. config (2个文件)
5. json-config (2个文件)
6. mcp (2个文件)
7. zcf-config (2个文件)
8. init (2个文件)
9. menu (2个文件)

## 执行步骤
1. 创建合并脚本
2. 按模块逐个合并
3. 验证测试覆盖率
4. 清理旧文件
5. 更新配置