# MCP 自动配置功能实现计划

## 任务背景
当前 CCC 工具在初始化时只显示 MCP 配置成功的提示，但实际上并未实现自动配置功能。用户需要手动编辑 `~/.claude.json` 文件来配置 MCP 服务。

## 解决方案
采用混合方式（方案3）：基于预定义模板，允许用户交互式选择需要的 MCP 服务，并自动配置到 `~/.claude.json` 文件中。

## 实现步骤

### 1. 定义 MCP 服务配置结构
- 创建 TypeScript 类型定义
- 预定义常用 MCP 服务列表
- 支持 API Key 配置

### 2. 实现 MCP 配置工具函数
- 读取/写入 ~/.claude.json
- 合并配置逻辑
- 构建服务配置

### 3. 更新初始化流程
- 添加 MCP 服务选择步骤
- 实现"全部安装"选项
- 处理 API Key 输入

### 4. 测试验证
- 全新安装场景
- 已有配置合并
- 跳过配置选项

## 预期效果
用户在运行 `npx ccc` 时可以：
1. 看到可用的 MCP 服务列表
2. 选择需要的服务（包括全选）
3. 输入必要的 API Key
4. 自动生成并保存配置