# API 修改流程优化任务计划

## 任务背景
用户需求：API 部分修改的逻辑里"完成修改"和其他选项在一起，感觉有点反直觉。改成修改一个后提示需不需要继续修改其他 API 配置会好些，直接去掉"完成修改"的选项，每次改完直接生效。

## 解决方案
采用即时保存 + 继续询问的方案，提升用户体验。

## 实施细节

### 1. ✅ 重构 modifyApiConfigPartially 函数
- 修改返回类型为 `Promise<void>`（不再返回配置对象）
- 移除"完成修改"选项
- 添加配置重读逻辑，确保显示最新值

### 2. ✅ 实现即时保存
- 每个修改分支后立即调用 `configureApi()` 保存
- 保存成功后显示确认信息
- 显示修改后的具体值

### 3. ✅ 添加继续修改询问
- 每次修改并保存后，询问是否继续
- 默认选择"是"，方便连续修改
- 选择"否"退出循环

### 4. ✅ 更新国际化文本
- 添加 `continueModification`："是否继续修改其他配置？"
- 添加 `modificationSaved`："配置已保存"
- 移除 `finishModification` 相关文本

### 5. ✅ 更新调用方
- `init.ts` 中调整调用，不再处理返回值
- `features.ts` 中同步更新

## 新的交互流程

```
请选择要修改的项
> 修改 API URL
> 修改 API Key  
> 修改认证类型

[用户选择修改 URL]
请输入新的 API URL（当前：https://api.example.com）
> https://new-api.example.com

✔ 配置已保存
  URL: https://new-api.example.com

是否继续修改其他配置？ (Y/n)
> Y

[继续显示修改选项...]
```

## 优势

1. **更直观**：去掉了容易混淆的"完成修改"选项
2. **即时反馈**：每次修改立即生效，用户能看到保存结果
3. **更安全**：避免累积修改可能导致的数据丢失
4. **更灵活**：用户可以随时停止，已修改的内容都已保存

## 测试验证

- ✅ 类型检查通过
- ✅ 构建成功
- 待实际运行测试验证用户体验