/*
 * Copyright 1999-2021 Alibaba Group Holding Ltd.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.alibaba.nacos.plugin.auth.spi.mock;

import com.alibaba.nacos.plugin.auth.api.AuthResult;
import com.alibaba.nacos.plugin.auth.api.IdentityContext;
import com.alibaba.nacos.plugin.auth.api.Permission;
import com.alibaba.nacos.plugin.auth.api.Resource;
import com.alibaba.nacos.plugin.auth.constant.ActionTypes;
import com.alibaba.nacos.plugin.auth.exception.AccessException;
import com.alibaba.nacos.plugin.auth.spi.server.AuthPluginService;

import java.util.Collection;

/**
 * Mock Server Auth Plugin Service.
 *
 * @author xiweng.yy
 */
public class MockEmptyNameAuthPluginService implements AuthPluginService {
    
    @Override
    public Collection<String> identityNames() {
        return null;
    }
    
    @Override
    public boolean enableAuth(ActionTypes action, String type) {
        return false;
    }
    
    @Override
    public String getAuthServiceName() {
        return null;
    }
    
    @Override
    public AuthResult validateAuthority(IdentityContext identityContext, Permission permission)
            throws AccessException {
        return AuthResult.failureResult(401, "mock auth failed");
    }
    
    @Override
    public AuthResult validateIdentity(IdentityContext identityContext, Resource resource)
            throws AccessException {
        return AuthResult.failureResult(403, "mock auth failed");
    }
}
